#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include <vector>
#include <cmath>

class MEM_mov2_update {
private:
   std::vector<double> o_U2q;           //
public:
   MEM_mov2_update(int o):
      o_U2q(o)
   {
   }
   double& U2q(int i){
      return o_U2q.at( i);  }
};

void Local_Minimization2::update(const DAT_PHYSICS_CONSTS& physics_consts,
                                 const Mechanical_System& mol,
                                 const Subset_Contracted_System::tM3& con,
                                 const Lagrange_Multiplier& lag,
                                 Energy_Surface2& ene){
   int oU2=ene.nU2;
   MEM_mov2_update vv(oU2);
   int oZ0=mol.nZ0;
   double Cbet,Sbet,bet, Calp,Salp,alp, Cgam,Sgam,gam;
//
//
// conformation of macrostep energy surface evaluation
//
   if( ene.MICRO ){
      for(int iU2= 0;iU2<oU2;iU2++){
         vv.U2q(iU2)=( ene.U2chi(iU2) -ene.U2d(iU2));
      }
   }else{
      for(int iU2= 0;iU2<oU2;iU2++){
         vv.U2q(iU2)= ene.U2chi(iU2);
      }
   }
//
//
// update conformation and displacement
//
   int iU2=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      if( !con.Z0[iZ0].sub )continue;
      for(int i=0;i<3;i++){
         ene.U2chi(iU2+i)+=(ene.U2uca(iU2+i)*lag.U2x(iU2+i));
         ene.U2d(iU2+i)=( ene.U2chi(iU2+i) -vv.U2q(iU2+i));
      }
      alp= ene.U2chi(iU2+3);
      bet= ene.U2chi(iU2+4);
      gam= ene.U2chi(iU2+5);
      Rotation_Matrix ROT1(alp,bet,gam);
      alp= ene.U2uca(iU2+3)*lag.U2x(iU2+3);
      Calp= std::cos( alp);
      Salp= std::sin( alp);
      bet= ene.U2uca(iU2+4)*lag.U2x(iU2+4);
      Cbet= std::cos( bet);
      Sbet= std::sin( bet);
      gam= ene.U2uca(iU2+5)*lag.U2x(iU2+5);
      Cgam= std::cos( gam);
      Sgam= std::sin( gam);
      Rotation_Matrix ROT2;
      ROT2(0,0)= Cbet*Cgam;
      ROT2(1,0)=-Cbet*Sgam;
      ROT2(2,0)= Sbet;
      ROT2(0,1)= Salp*Sbet*Cgam +Calp*Sgam;
      ROT2(1,1)=-Salp*Sbet*Sgam +Calp*Cgam;
      ROT2(2,1)=-Salp*Cbet;
      ROT2(0,2)=-Calp*Sbet*Cgam +Salp*Sgam;
      ROT2(1,2)= Calp*Sbet*Sgam +Salp*Cgam;
      ROT2(2,2)= Calp*Cbet;
      Rotation_Matrix ROT;
      for(int i=0;i<3;i++){
         for(int j=0;j<3;j++){
            ROT(i,j)= ROT2(i,0)*ROT1(0,j)
                     +ROT2(i,1)*ROT1(1,j)
                     +ROT2(i,2)*ROT1(2,j);
         }
      }
      Cbet= ROT(2,2);
      Sbet= std::sqrt( (1.00) -Cbet*Cbet);
      bet= std::atan2(Sbet,Cbet);
      if( Sbet<(1.00e-12) ){
         gam= (0.00);
         if( Cbet>(0.00) ){
            Calp= ROT(0,0);
            Salp= ROT(0,1);
         }else{
            Calp=-ROT(0,0);
            Salp=-ROT(0,1);
         }
         alp= std::atan2(Salp,Calp);
      }else{
         Calp= (ROT(2,0)/Sbet);
         Salp= (ROT(2,1)/Sbet);
         alp= std::atan2(Salp,Calp);
         Cgam=-(ROT(0,2)/Sbet);
         Sgam= (ROT(1,2)/Sbet);
         gam= std::atan2(Sgam,Cgam);
      }
      ene.U2chi(iU2+3)= alp;
      ene.U2chi(iU2+4)= bet;
      ene.U2chi(iU2+5)= gam;
      ene.U2d(iU2+3)=( ene.U2chi(iU2+3) -vv.U2q(iU2+3));
      ene.U2d(iU2+4)=( ene.U2chi(iU2+4) -vv.U2q(iU2+4));
      ene.U2d(iU2+5)=( ene.U2chi(iU2+5) -vv.U2q(iU2+5));
      if      ( ene.U2d(iU2+3)<-physics_consts.PI ){
         ene.U2d(iU2+3)+=(2.00)*physics_consts.PI;
      }else if( ene.U2d(iU2+3)> physics_consts.PI ){
         ene.U2d(iU2+3)-=(2.00)*physics_consts.PI;
      }
      if      ( ene.U2d(iU2+5)<-physics_consts.PI ){
         ene.U2d(iU2+5)+=(2.00)*physics_consts.PI;
      }else if( ene.U2d(iU2+5)> physics_consts.PI ){
         ene.U2d(iU2+5)-=(2.00)*physics_consts.PI;
      }
      iU2+=6;
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ2>mQ2 ){
         for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
            ene.U2chi(iU2)+=(ene.U2uca(iU2)*lag.U2x(iU2));
            ene.U2d(iU2)=( ene.U2chi(iU2) -vv.U2q(iU2));
            if      ( ene.U2chi(iU2)<-physics_consts.PI ){
               ene.U2chi(iU2)+=(2.00)*physics_consts.PI;
            }else if( ene.U2chi(iU2)> physics_consts.PI ){
               ene.U2chi(iU2)-=(2.00)*physics_consts.PI;
            }
            if      ( ene.U2d(iU2)<-physics_consts.PI ){
               ene.U2d(iU2)+=(2.00)*physics_consts.PI;
            }else if( ene.U2d(iU2)> physics_consts.PI ){
               ene.U2d(iU2)-=(2.00)*physics_consts.PI;
            }
            iU2++;
         }
      }
   }

   return;
}
