#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Phi_Automatic.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <iostream>
#include <iomanip>
#include <cmath>
////#include <cstdlib>

int Local_Minimization2::MOV(Phi_Automatic& ph2,
                             const DAT_PHYSICS_CONSTS& physics_consts,
                             const DAT_ARRAY_CONSTS& array_consts,
                             const DAT_ENERGY_PARAMS& energy_params,
                             const DAT_REGION_MAPS& region_maps,
                             const Thread_Options& opt,
                             Output_Streams& out,
                             const Mechanical_System& mol,
                             const Subset_Contracted_System::tM3& con,
                             Conf_Dependent_System& dep,
                             Energy_Surface2& ene){
//
//
// minimization traj
//
   Lagrange_Multiplier macrolag(ene.nU2);
   Lagrange_Multiplier microlag(ene.nU2);
   int ck0,ck1,ck2,ck3,ck4,ck5;         //loop counters
   for(int iU2=(ene.nU2-1);iU2>= 0;iU2--){
      if( ene.U2uca(iU2)>(0.00) )break;
      macrolag.bU2--;
      microlag.bU2--;
   }
   for(int iU2= 0;iU2<=(ene.nU2-1);iU2++){
      if( ene.U2uca(iU2)>(0.00) )break;
      macrolag.aU2++;
      microlag.aU2++;
   }
// double zF= (1.00)/std::sqrt( ene.nU2);
   ene.ethresh= (2.00e-6);
// ene.ethresh= (2.00e-12);
   bool PRE=false;                      //
   ene.MICRO=false;
   ene.E4RESET=true;
   for(iM2=0;;iM2++){
//    std::cout<<" iM2="<< std::setw( 4)<<iM2<< std::endl;
//
//
// micro step, computation time (micro surface/macro surface)= ~.2
//
      if( ene.MICRO ){
         M2[iM2].type="MICRO";
////  std::cerr<<" micro"<< std::endl;
         ene.PHI2(ph2,
                  physics_consts,array_consts,energy_params,
                  region_maps,
                  opt,out,mol,con,dep);
////  std::cerr<<" micro_phi2"<< std::endl;
         ene.SURFACE=true;
         ene.PHI3(ph2,
                  physics_consts,array_consts,energy_params,
                  opt,out,mol,con,dep);
////  std::cerr<<" micro_phi3"<< std::endl;
         backup(microlag,ene,PRE);
         M2[iM2].tot= microlag.TOT;
         double zz= microlag.gradient();
         M2[iM2].z= zz;
         if( zz<EPS1 ){
            ene.MICRO=false;
            iM2--;
            continue;
         }
         double beta1=target_beta(ene.MICRO);
//
//
// adapt step length to region of convergence
//
         double eOPT= M2[iM2].tot;
         double bOPT= BMIN;
         double bet1;
         bool EXIT=false;
         for(ck0=8;ck0>0;ck0--){
            M2[iM2].bet= beta1;
            for(int iU2= 0;iU2<ene.nU2;iU2++){
               ene.U2d(iU2)+=( microlag.U2chi(iU2) -ene.U2chi(iU2));
               ene.U2chi(iU2)= microlag.U2chi(iU2);
            }
            int ncholesky=0;

            for(ck1=6;ck1>0;ck1--){
               initial_lamda(microlag,ck1,beta1);
               M2[iM2].lam0= microlag.lamda;
               microlag.diagonal();
               bool pd=microlag.lower();
               ncholesky++;
               if( pd )break;
            }
            if( ck1==0 )return ENDSTATE=1;

            M2[iM2].k1=(iM2>0)? (6-ck1): (3-ck1);
            microlag.step(microlag.o_U2x,(-1.00),microlag.o_U2g);
            microlag.step(microlag.o_U2dx,(-2.00),microlag.o_U2x);
            double dxx;
            double xx=microlag.length(dxx);
            M2[iM2].s0= xx;
            M2[iM2].ds0= dxx;

            int k2=0;
            for(ck2=4;ck2>0;ck2--){
               if( xx>(beta1*beta1*( (1.00) -EPS2)) )break;
               if( microlag.lamda<=(0.00) )break;

               M2[iM2].k4[k2]=100;
               for(ck4=10;ck4>0;ck4--){
                  for(int ii=0;ii<10;ii++){
                     microlag.step(microlag.o_U2x,microlag.lamda,
                                   microlag.o_U2x);
                  }
                  microlag.normalize();
               }

               double dlamda= microlag.lamdastep(beta1);
               M2[iM2].lam1[k2]= microlag.lamda;

               for(ck5=30;ck5>0;ck5--){
                  microlag.diagonal();
                  bool pd=microlag.lower();
                  ncholesky++;
                  if( pd )break;
                  microlag.lamda+=dlamda;
                  M2[iM2].lam1[k2]= microlag.lamda;
                  dlamda*=(2.00);
               }
               if( ck5==0 )return ENDSTATE=2;

               M2[iM2].k5[k2]=(30-ck5);
               microlag.step(microlag.o_U2x,(-1.00),microlag.o_U2g);
               microlag.step(microlag.o_U2dx,(-2.00),microlag.o_U2x);
               xx=microlag.length(dxx);
               M2[iM2].s1[k2]= xx;
               M2[iM2].ds1[k2]= dxx;
               k2++;
            }

            M2[iM2].k2=(4-ck2);
            for(ck3=32;ck3>0;ck3--){
               if( xx<=(beta1*beta1*( (1.00) +EPS2)) )break;
               microlag.lamdastep(beta1,xx,dxx);
               microlag.diagonal();
               bool pd=microlag.lower();
               ncholesky++;
               if( !pd )return ENDSTATE=3;
               microlag.step(microlag.o_U2x,(-1.00),microlag.o_U2g);
               microlag.step(microlag.o_U2dx,(-2.00),microlag.o_U2x);
               xx=microlag.length(dxx);
            }

            M2[iM2].k3=(32-ck3);
            update(physics_consts,mol,con,microlag,ene);
            M2[iM2].lam2= microlag.lamda;
            M2[iM2].s2= xx;
            M2[iM2].ds2= dxx;
            M2[iM2].delF=( M2[iM2].tot -M2[iM2macro].tot +microlag.deltaf());
//
//
// line search, computation time (micro energy/micro surface)= ~.2
//
            xx= (0.00);
            for(int iU2= 0;iU2<ene.nU2;iU2++){
               if( ene.U2uca(iU2)<=(0.00) )continue;
               xx+=std::pow((ene.U2d(iU2)/ene.U2uca(iU2)), 2);
            }
            M2[iM2].d2= xx;
            double bet2= std::sqrt( xx);
            double bet0= std::sqrt( M2[iM2-1].d2);
            bet1=( bet2 -bet0);
////  std::cerr<<" micro_line"<< std::endl;
            ene.PHIE(ph2,
                     physics_consts,array_consts,energy_params,
                     region_maps,
                     opt,out,mol,con,dep);
////  std::cerr<<" micro_line_phie"<< std::endl;
            ene.SURFACE=false;
            ene.PHI3(ph2,
                     physics_consts,array_consts,energy_params,
                     opt,out,mol,con,dep);
////  std::cerr<<" micro_line_phi3"<< std::endl;
// out.FILE3<<" k0="<< std::setw( 1)<<(8-ck0)
//          <<" cho="<< std::setw( 2)<<ncholesky
//          << std::scientific<< std::setprecision(3)
//          <<" bet="<< std::setw(10)<<(zF*M2[iM2].bet)
//          <<" lam2="<< std::setw(10)<<M2[iM2].lam2
//          <<" s2="<< std::setw(10)<<(zF*std::sqrt( M2[iM2].s2))
//          <<" b2="<< std::setw(10)<<(zF*bet2)
//          <<" b0="<< std::setw(10)<<(zF*bet0)
//          <<" b1="<< std::setw(10)<<(zF*bet1)
//          << std::endl
//          << std::setprecision(5)
//          <<" TOT="<< std::setw(12)<<M2[iM2].tot
//          <<" delF="<< std::setw(12)<<( M2[iM2macro].tot +M2[iM2].delF)
//          <<" e="<< std::setw(12)<<ene.TOT
//          << std::endl;
            double deltaf=( ene.TOT -M2[iM2].tot);
            double delF=( M2[iM2].delF +M2[iM2macro].tot -M2[iM2].tot);
            if( deltaf>(0.00) ){
               M2[iM2].type="MICRO|inc";
               if( beta1<=BMIN )break;
               beta1*=(.60);
               if( beta1<BMIN )beta1= BMIN;
               continue;
            }
            if( EXIT )break;
            if( ene.TOT>eOPT ){
               EXIT=true;
               beta1=( (0.20)*beta1 +(0.80)*bOPT);
               continue;
            }else{
               eOPT= ene.TOT;
               bOPT= beta1;
            }
            if      ( deltaf>((0.60)*delF) ){
               if( beta1<=BMIN )break;
               beta1*=(0.70);
               if( beta1<BMIN )beta1= BMIN;
            }else if( deltaf>((0.75)*delF) ){
               if( beta1<=BMIN )break;
               beta1*=(0.80);
               if( beta1<BMIN )beta1= BMIN;
            }else if( deltaf<((0.90)*delF) ){
               if( M2[iM2].lam2<=(0.00) )break;
               if( beta1>=BMAX )break;
               beta1*=(1.25);
               if( beta1>BMAX )beta1= BMAX;
            }else{
               break;
            }
         }
         M2[iM2].k0=(8-ck0);

         if( M2[iM2].lam2<=(0.00) )ene.MICRO=false;
         if( M2[iM2].bet<((.125)*M2[iM2macro].bet) )ene.MICRO=false;
         if( (M2[iM2].lam2>(0.00))&&(bet1<(.10)*beta1) ){
            M2[iM2].type="MICRO|osc";
            ene.MICRO=false;
         }
         if( (iM2-iM2macro)==cM2macro )ene.MICRO=false;
//
//
// macro step
//
      }else{
         M2[iM2].type="MACRO";
////  std::cerr<<" macro"<< std::endl;
         ene.PHI2(ph2,
                  physics_consts,array_consts,energy_params,
                  region_maps,
                  opt,out,mol,con,dep);
////  std::cerr<<" macro_phi2"<< std::endl;
         ene.RECYCLE=true;
         M2[iM2].ethresh= ene.ethresh;
         for(int L=0;L<8;L++){
             M2[iM2].Lprof[L]=ene.Lprof[L];
         }
         backup(macrolag,ene,PRE);
         M2[iM2].tot= macrolag.TOT;
         double zz= macrolag.gradient();
         M2[iM2].z= zz;
         if( (nM2<=0)||(zz<EPS1) ){
            return ENDSTATE=0;
         }
         double beta1= target_beta(ene.MICRO);
         if( PRE&&(ene.TOT>M2[iM2macro].tot) ){
            beta1*=(.50);
            if( beta1<BMIN )beta1= BMIN;
         }
         if( beta1<=BMIN ){
            return ENDSTATE=0;
         }
         if( (iM2>0)&&M2[iM2-1].bet<=BMIN ){
            return ENDSTATE=0;
         }
//
//
// adapt step length to region of convergence
//
         double eOPT= M2[iM2].tot;
         double bOPT= BMIN;
         bool EXIT=false;
         for(ck0=5;ck0>0;ck0--){
            M2[iM2].bet= beta1;
            for(int iU2= 0;iU2<ene.nU2;iU2++){
               ene.U2d(iU2)= (0.00);
               ene.U2chi(iU2)= macrolag.U2chi(iU2);
            }
            int ncholesky=0;

            for(ck1=(iM2>0)? 6: 3;ck1>0;ck1--){
               initial_lamda(macrolag,ck1,beta1);
               M2[iM2].lam0= macrolag.lamda;
               macrolag.diagonal();
               bool pd=macrolag.lower();
               ncholesky++;
               if( pd )break;
            }
            if( ck1==0 )return ENDSTATE=1;

            M2[iM2].k1=(iM2>0)? (6-ck1): (3-ck1);
            macrolag.step(macrolag.o_U2x,(-1.00),macrolag.o_U2g);
            macrolag.step(macrolag.o_U2dx,(-2.00),macrolag.o_U2x);
            double dxx;
            double xx=macrolag.length(dxx);
            M2[iM2].s0= xx;
            M2[iM2].ds0= dxx;

            int k2=0;
            for(ck2=4;ck2>0;ck2--){
               if( xx>(beta1*beta1*( (1.00) -EPS2)) )break;
               if( macrolag.lamda<=(0.00) )break;

               M2[iM2].k4[k2]=100;
               for(ck4=10;ck4>0;ck4--){
                  for(int ii=0;ii<10;ii++){
                     macrolag.step(macrolag.o_U2x,macrolag.lamda,
                                   macrolag.o_U2x);
                  }
                  macrolag.normalize();
               }

               double dlamda= macrolag.lamdastep(beta1);
               M2[iM2].lam1[k2]= macrolag.lamda;

               for(ck5=30;ck5>0;ck5--){
                  macrolag.diagonal();
                  bool pd=macrolag.lower();
                  ncholesky++;
                  if( pd )break;
                  macrolag.lamda+=dlamda;
                  M2[iM2].lam1[k2]= macrolag.lamda;
                  dlamda*=(2.00);
               }
               if( ck5==0 )return ENDSTATE=2;

               M2[iM2].k5[k2]=(30-ck5);
               macrolag.step(macrolag.o_U2x,(-1.00),macrolag.o_U2g);
               macrolag.step(macrolag.o_U2dx,(-2.00),macrolag.o_U2x);
               xx=macrolag.length(dxx);
               M2[iM2].s1[k2]= xx;
               M2[iM2].ds1[k2]= dxx;
               k2++;
            }

            M2[iM2].k2=(4-ck2);
            for(ck3=32;ck3>0;ck3--){
               if( xx<=(beta1*beta1*( (1.00) +EPS2)) )break;
               macrolag.lamdastep(beta1,xx,dxx);
               macrolag.diagonal();
               bool pd=macrolag.lower();
               ncholesky++;
               if( !pd )return ENDSTATE=3;
               macrolag.step(macrolag.o_U2x,(-1.00),macrolag.o_U2g);
               macrolag.step(macrolag.o_U2dx,(-2.00),macrolag.o_U2x);
               xx=macrolag.length(dxx);
            }

            M2[iM2].k3=(32-ck3);
            update(physics_consts,mol,con,macrolag,ene);
            M2[iM2].lam2= macrolag.lamda;
            M2[iM2].s2= xx;
            M2[iM2].ds2= dxx;
            M2[iM2].delF= macrolag.deltaf();
//
//
// line search, computation time (micro energy/micro surface)= ~.2
//
////  std::cerr<<" macro_line"<< std::endl;
            ene.PHIE(ph2,
                     physics_consts,array_consts,energy_params,
                     region_maps,
                     opt,out,mol,con,dep);
////  std::cerr<<" macro_line_phie"<< std::endl;
            ene.SURFACE=false;
            ene.PHI3(ph2,
                     physics_consts,array_consts,energy_params,
                     opt,out,mol,con,dep);
////  std::cerr<<" macro_line_phi3"<< std::endl;
// out.FILE3<<" k0="<< std::setw( 1)<<(5-ck0)
//          <<" cho="<< std::setw( 2)<<ncholesky
//          << std::scientific<< std::setprecision(3)
//          <<" bet="<< std::setw(10)<<(zF*M2[iM2].bet)
//          <<" lam2="<< std::setw(10)<<M2[iM2].lam2
//          <<" s2="<< std::setw(10)<<(zF*std::sqrt( M2[iM2].s2))
//          << std::endl
//          << std::setprecision(5)
//          <<" TOT="<< std::setw(12)<<M2[iM2].tot
//          <<" delF="<< std::setw(12)<<( M2[iM2].tot +M2[iM2].delF)
//          <<" e="<< std::setw(12)<<ene.TOT
//          << std::endl;
            double deltaf=( ene.TOT -M2[iM2].tot);
            if( deltaf>(0.00) ){
               if( beta1<=BMIN )break;
               beta1*=(.60);
               if( beta1<BMIN )beta1= BMIN;
               continue;
            }
            if( EXIT )break;
            if( ene.TOT>eOPT ){
               EXIT=true;
               beta1=( (0.25)*beta1 +(0.75)*bOPT);
               continue;
            }else{
               eOPT= ene.TOT;
               bOPT= beta1;
            }
            if      ( deltaf>((0.50)*M2[iM2].delF) ){
               if( beta1<=BMIN )break;
               beta1*=(0.75);
               if( beta1<BMIN )beta1= BMIN;
            }else if( deltaf>((0.70)*M2[iM2].delF) ){
               if( beta1<=BMIN )break;
               beta1*=(0.85);
               if( beta1<BMIN )beta1= BMIN;
            }else if( deltaf<((0.90)*M2[iM2].delF) ){
               if( M2[iM2].lam2<=(0.00) )break;
               if( beta1>=BMAX )break;
               beta1*=(1.40);
               if( beta1>BMAX )beta1= BMAX;
            }else{
               break;
            }
         }
         M2[iM2].k0=(5-ck0);
         M2[iM2].d2= M2[iM2].s2;

         PRE=true;
         double e=-M2[iM2].delF;
         if( e>(1.00e+3) )e= (1.00e+3);
         e= (1.00e-5)*e;
////     if( (iM2==0)||(e<ene.ethresh) ){
/**/        ene.ethresh= e;
/**/        if( ene.ethresh<(1.00e-10) )PRE=false;
////     }
         ene.MICRO=true;
         iM2macro=iM2;
      }

      nM2--;
   }
}
