#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"

void Local_Minimization4::MOV_OSTEP(const DAT_PHYSICS_CONSTS& physics_consts,
                                    const Mechanical_System& mol,
                                    const Subset_Contracted_System::tM3& con,
                                    Energy_Surface4& ene){
   ene.PHI1_DCHI(physics_consts,mol,con);
   double z= (0.00);
   for(int iU2= 0;iU2<ene.nU2;iU2++){
      z+=(ene.U2dchi(iU2)*ene.U2dchi(iU2));
   }
   M4[iM4].step= z;
   return;
}
