#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Search_Subspace.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi1_Automatic.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <cmath>

int Local_Minimization4::MOV1(Phi1_Automatic& ph1,
                              Phi_Automatic& ph2,
                              const DAT_PHYSICS_CONSTS& physics_consts,
                              const DAT_ARRAY_CONSTS& array_consts,
                              const DAT_ENERGY_PARAMS& energy_params,
                              const Thread_Options& opt,
                              Output_Streams& out,
                              const Search_Subspace& sub,
                              const Mechanical_System& mol,
                              const Subset_Contracted_System::tM3& con,
                              Conf_Dependent_System& dep,
                              Energy_Surface4& ene){

   Lagrange_Multiplier lag(ene.nU2);
   double backup_BMAX= BMAX;
   BMAX= (2.00e+0);
   BMAX= std::sqrt( ene.nU2)*BMAX;


   lag.bU2=(ene.nU2-1);
   for(int iU2=(ene.nU2-1);iU2>= 0;iU2--){
      if( ene.U2uca(iU2)>(0.00) ){
         lag.bU2=iU2;
         break;
      }else{
         lag.U2x(iU2)= (0.00);
      }
   }
   lag.aU2= 0;
   for(int iU2= 0;iU2<=(ene.nU2-1);iU2++){
      if( ene.U2uca(iU2)>(0.00) ){
         lag.aU2=iU2;
         break;
      }else{
         lag.U2x(iU2)= (0.00);
      }
   }
   ene.PHI1_HBND(physics_consts,energy_params,
                 out,sub,mol,con,dep);

   cM2=cM2_1;
   iM2=0;

   int cM4=cM4_1;
   for(iM4=0;;iM4++,(cM4--)){
      ene.PHI1_REXP(ph1,
                    physics_consts,energy_params,
                    mol,con,dep);
      ene.PHID(ph2,
               physics_consts,array_consts,energy_params,
               opt,mol,con,dep);
      o1backup(ene);
      ene.RECYCLE=true;
      M4[iM4].nE2=ene.nE2;
      M4[iM4].nO2=ene.nO2;
      M4[iM4].nE3=ene.nE3;
      M4[iM4].Ftot= ene.TOT;
      M4[iM4].Fr= ene.Fr;
      M4[iM4].Ft= ene.Ft;
      M4[iM4].Fc= ene.Fc;
      M4[iM4].Fb= ene.Fb;
      if( cM4==0 )break;
      if( ene.nE3==0 )break;
      if( iM4>1 ){
         if( M4[iM4-1].M2pt==(M4[iM4-2].M2pt+1) )break;
      }
      if( iM4>0 ){
         BETA= M2[iM2-2].bet;
         MOV_OBETA();
      }else{
         BETA= BET1;
      }
      MOV1_MOV(ph2,
               physics_consts,array_consts,energy_params,
               opt,mol,con,dep,ene,lag);
//    if( ENDSTATE>0 )break;
      M4[iM4].M2pt=iM2;
      M4[iM4].end=ENDSTATE;
      MOV_OSTEP(physics_consts,mol,con,ene);
      MOV_ODELF(ene);
   }

   BMAX= backup_BMAX;
   return ENDSTATE=0;
}
