#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Search_Subspace.hh"
#include "../mov/Lagrange_Multiplier.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <cmath>

int Local_Minimization4::MOV0(const DAT_PHYSICS_CONSTS& physics_consts,
                              Output_Streams& out,
                              const Search_Subspace& sub,
                              const Mechanical_System& mol,
                              const Subset_Contracted_System::tM3& con,
                              Conf_Dependent_System& dep,
                              Energy_Surface4& ene,
                              int iCYC,
                              int shf1,int shf2){

   Lagrange_Multiplier lag(ene.nU2);
   double backup_BMAX= BMAX;
   BMAX= (2.00e+0);
   BMAX= std::sqrt( ene.nU2)*BMAX;

   lag.bU2=(ene.nU2-1);
   for(int iU2=(ene.nU2-1);iU2>= 0;iU2--){
      if( ene.U2uca(iU2)>(0.00) ){
         lag.bU2=iU2;
         break;
      }else{
         lag.U2x(iU2)= (0.00);
      }
   }
   lag.aU2= 0;
   for(int iU2= 0;iU2<=(ene.nU2-1);iU2++){
      if( ene.U2uca(iU2)>(0.00) ){
         lag.aU2=iU2;
         break;
      }else{
         lag.U2x(iU2)= (0.00);
      }
   }
   ene.PHI0_HBND(physics_consts,
                 out,sub,mol,con,dep,
                 iCYC,shf1,shf2);

   cM2=(cM2_1/2);
   iM2=0;

   int cM4=cM4_1;
   for(iM4=0;;iM4++,(cM4--)){
      ene.PHI0_REXP(physics_consts,
                    sub,mol,con,dep,
                    iCYC);
      o0backup(ene);
      M4[iM4].nE2=ene.nE2;
      M4[iM4].nO2=ene.nO2;
      M4[iM4].Ftot= ene.TOT;
      M4[iM4].Fr= ene.Fr;
      if( cM4==0 )break;
      if( ene.Fr<(1.00e-8) )break;
      if( iM4>1 ){
         if( M4[iM4-1].M2pt==(M4[iM4-2].M2pt+1) )break;
      }
      if( iM4>0 ){
         BETA= M2[iM2-2].bet;
         MOV_OBETA();
      }else{
         BETA= BET1;
      }
      MOV0_MOV(physics_consts,mol,con,ene,lag);
//    if( ENDSTATE>0 )break;
      M4[iM4].M2pt=iM2;
      M4[iM4].end=ENDSTATE;
      MOV_OSTEP(physics_consts,mol,con,ene);
      MOV_ODELF(ene);
   }

   BMAX= backup_BMAX;
   return ENDSTATE=0;
}
