#include "../mov/Lagrange_Multiplier.hh"
#include <vector>

void Lagrange_Multiplier::step(std::vector<double>& U2p,
                               double c,
                               std::vector<double>& U2o){
//
//
// U2U2a*U2p=c*U2o
//
   for(int iU2=aU2;iU2<=bU2;iU2++){
      int cU2=(iU2-aU2);
      double z= (0.00);
      for(int kU2= 1;kU2<=cU2;kU2++){
         z+=U2U2a(iU2,iU2-kU2)*U2y(iU2-kU2);
      }
      U2y(iU2)=( c*U2o[iU2] -z)/U2U2a(iU2,iU2);
   }
   for(int iU2=bU2;iU2>=aU2;iU2--){
      int cU2=(bU2-iU2);
      double z= (0.00);
      for(int kU2= 1;kU2<=cU2;kU2++){
         z+=U2U2a(iU2+kU2,iU2)*U2p[iU2+kU2];
      }
      U2p[iU2]=( U2y(iU2) -z)/U2U2a(iU2,iU2);
   }
   return;
}
