#include "../mov/Lagrange_Multiplier.hh"
#include <cmath>

void Lagrange_Multiplier::lamdastep(double beta1,
                                    double xx,
                                    double dxx,
                                    bool INFLATE){
   double h0= (-2.00)*xx/dxx;
   double g0= h0*std::sqrt(xx);
   lamda+=( (g0/beta1) -h0);
   if( INFLATE ){
   }else{
      if( lamda<(0.00) )lamda= (0.00);
   }
   return;
}
double Lagrange_Multiplier::lamdastep(double beta1,
                                      bool INFLATE){
   double s0= (1.00);
   step(o_U2x,(1.00),o_U2x);
   double s1= normalize();
   double h0=(s0/s1);
   double g0= (0.00);
   for(int iU2=aU2;iU2<=bU2;iU2++){
      g0+=U2x(iU2)*U2g(iU2);
   }
   g0= std::abs( g0);
   double dlamda=( (g0/beta1) -h0);
   lamda+=dlamda;
   if( INFLATE ){
   }else{
      if( lamda<(0.00) )lamda= (0.00);
   }
   return -dlamda/(64.00);
}
