#include "../mov/Lagrange_Multiplier.hh"
#include <cmath>

double Lagrange_Multiplier::gradient(){

   double z= (0.00);
   double hh= (0.00);
   double h= (0.00);
   for(int iU2=aU2;iU2<=bU2;iU2++){
      z+=U2g(iU2)*U2g(iU2);
      double ag= U2h(iU2)*U2g(iU2);
      if( iU2>aU2 ){
         int cU2=(iU2-aU2);
         for(int jU2= 1;jU2<=cU2;jU2++){
            ag+=U2U2a(iU2-jU2,iU2)*U2g(iU2-jU2);
         }
      }
      if( iU2<bU2 ){
         int cU2=(bU2-iU2);
         for(int jU2= 1;jU2<=cU2;jU2++){
            ag+=U2U2a(iU2,iU2+jU2)*U2g(iU2+jU2);
         }
      }
      hh+=ag*ag;
      h+=U2g(iU2)*ag;
   }
   hh/=z;
   h/=z;
   hmean= h;
   hsigma= std::sqrt( hh -(h*h));

   hbound= U2h(aU2);
   for(int iU2=aU2;iU2<=bU2;iU2++){
      double y= (0.00);
      if( iU2>aU2 ){
         int cU2=(iU2-aU2);
         for(int jU2= 1;jU2<=cU2;jU2++){
            y+=std::abs( U2U2a(iU2-jU2,iU2));
         }
      }
      if( iU2<bU2 ){
         int cU2=(bU2-iU2);
         for(int jU2= 1;jU2<=cU2;jU2++){
            y+=std::abs( U2U2a(iU2,iU2+jU2));
         }
      }
      y=( U2h(iU2) -y);
      if( y<hbound )hbound= y;
   }

   return z;
}
