#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../med/Dielec_Continu.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>

void Dielec_Continu::MED_TORUS(const DAT_PHYSICS_CONSTS& physics_consts,
                               Output_Streams& out){
   int m=10;
   double dthe= (physics_consts.PI/m);
   int n=20;
   double dphi= ((2.)*physics_consts.PI/n);
   double r=( (1.00) +probe);
   double z= std::sin( dthe/(2.00));
//
//
// surface elements of a torus st r=(1+probe)
//
   Coordinates the,Cthe,Sthe;
   the(0)=( -(0.50)*physics_consts.PI -dthe);
   the(1)=( -(0.50)*physics_consts.PI -(0.50)*dthe);
   the(2)=( -(0.50)*physics_consts.PI);
   for(int i0=0;i0<m;i0++){
      int i1=(i0/5);
      int i2=(i0%5);
      for(int i=0;i<3;i++){
         the(i)+=dthe;
         Cthe(i)= std::cos( the(i));
         Sthe(i)= std::sin( the(i));
      }
      Coordinates phi,Cphi,Sphi;
      phi(0)=-dphi;
      phi(1)=-(0.50)*dphi;
      phi(2)= (0.00);
      for(int j0=0;j0<n;j0++){
         int j1=(j0/5);
         int j2=(j0%5);
         for(int j=0;j<3;j++){
            phi(j)+=dphi;
            Cphi(j)= std::cos( phi(j));
            Sphi(j)= std::sin( phi(j));
         }
         int pF=(j1*2+i1);
         int pT=(j2*5+i2);
         FTtorus(pF,pT).x(0)= probe*Sthe(1);
         FTtorus(pF,pT).x(1)= Cphi(1)*( r -probe*Cthe(1));
         FTtorus(pF,pT).x(2)= Sphi(1)*( r -probe*Cthe(1));
         FTtorus(pF,pT).c(0)=-Sthe(1);
         FTtorus(pF,pT).c(1)= Cphi(1)*Cthe(1);
         FTtorus(pF,pT).c(2)= Sphi(1)*Cthe(1);
         FTtorus(pF,pT).r= r;
         FTtorus(pF,pT).a= dphi*probe*( r*dthe -probe*(2.00)*Cthe(1)*z);
         FTtorus(pF,pT).grp=pF;
         FTtorus(pF,pT).typ=0;
         FTtorus(pF,pT).K6.resize(1);
         FTtorus(pF,pT).K6[0].L6.resize(4);
         for(int iL6=0;iL6<4;iL6++){
            int i=( (iL6==0)|| (iL6==3) )? 0: 2;
            int j=( (iL6/2)==0 )? 0: 2;
            FTtorus(pF,pT).K6[0].L6[iL6].v(0)= probe*Sthe(i);
            FTtorus(pF,pT).K6[0].L6[iL6].v(1)= Cphi(j)*( r -probe*Cthe(i));
            FTtorus(pF,pT).K6[0].L6[iL6].v(2)= Sphi(j)*( r -probe*Cthe(i));
            double sgn=( (iL6/2)==0 )? ( 1.00): (-1.00);
            if      ( (iL6%2)==0 ){
               FTtorus(pF,pT).K6[0].L6[iL6].c(0)=( 0.00);
               FTtorus(pF,pT).K6[0].L6[iL6].c(1)= sgn*Sphi(j);
               FTtorus(pF,pT).K6[0].L6[iL6].c(2)=-sgn*Cphi(j);
               FTtorus(pF,pT).K6[0].L6[iL6].del= (0.00);
               FTtorus(pF,pT).K6[0].L6[iL6].phi= dthe;
            }else if( (iL6%2)==1 ){
               FTtorus(pF,pT).K6[0].L6[iL6].c(0)= sgn;
               FTtorus(pF,pT).K6[0].L6[iL6].c(1)=( 0.00);
               FTtorus(pF,pT).K6[0].L6[iL6].c(2)=( 0.00);
               FTtorus(pF,pT).K6[0].L6[iL6].del= sgn*probe*Sthe(i);
               FTtorus(pF,pT).K6[0].L6[iL6].phi= dphi;
            }
            FTtorus(pF,pT).K6[0].L6[iL6].jA5=-1;
         }
      }
   }
//
//
// diagnostic output
//
// out.FILE3<< std::fixed<< std::setprecision(3);
// out.FILE3<<" iF"" iT""            x         ""    a  "" grp\n";
// for(int pF= 0;pF<12;pF++){
//    for(int pT= 0;pT<25;pT++){
//       out.FILE3<< std::setw( 3)<<pF
//                << std::setw( 3)<<pT<<' ';
//       for(int i=0;i<3;i++){
//          out.FILE3<< std::setw( 7)<<FTtorus(pF,pT).x(i);
//       }
//       out.FILE3<< std::setw( 7)<<FTtorus(pF,pT).a
//                << std::setw( 4)<<FTtorus(pF,pT).grp<<'\n';
//    }
// }
// out.FILE3<<" iF"" iT"" iL""            v         ""            c         "
//            "   del ""   phi "<<'\n';
// for(int pF= 0;pF<12;pF++){
//    for(int pT= 0;pT<25;pT++){
//       for(int iL6=0;iL6<4;iL6++){
//          out.FILE3<< std::setw( 3)<<pF
//                   << std::setw( 3)<<pT
//                   << std::setw( 3)<<iL6<<' ';
//          for(int i=0;i<3;i++){
//             out.FILE3<< std::setw( 7)<<FTtorus(pF,pT).K6[0].L6[iL6].v(i);
//          }
//          out.FILE3<<' ';
//          for(int i=0;i<3;i++){
//             out.FILE3<< std::setw( 7)<<FTtorus(pF,pT).K6[0].L6[iL6].c(i);
//          }
//          out.FILE3<< std::setw( 7)<<FTtorus(pF,pT).K6[0].L6[iL6].del
//                   << std::setw( 7)<<FTtorus(pF,pT).K6[0].L6[iL6].phi<<'\n';
//       }
//    }
// }
   return;
}
