#include "../med/Dielec_Continu.hh"
#include <cmath>
//
// switching function
// s( a)=0, s( b)=1
// ds( a)=0, ds( b)=0
// dds( a)=0, dds( b)=0
//
double Dielec_Continu::MED_SWITCH(double r) const {
   double a= (0.40);
   double b= (1.20);
   double s;
   if      ( r<a ){
      s= (0.00);
   }else if( r>b ){
      s= (1.00);
   }else{
      double z= (1.00)/std::pow( b -a, 5);
      double p=( (6.)*r*r
                +(-(15.)*b +(3.)*a)*r
                +( (10.)*b*b -(5.)*b*a +a*a));
      double q= std::pow( r -a, 3);
      s= z*p*q;
   }
   return s;
}
