#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../med/Dielec_Continu.hh"
#include "../phi/Coordinates.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iostream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_med_surf {
public:
   std::vector<bool> o_Z5sub;           //edge incorporated into cycle
   int o_Y6;                            //
   std::vector<bool> o_Y6Y6sub;         //cycle i contains cycle j
   std::vector<bool> o_Y6sub;           //incorporated into face
   MEM_med_surf(){
   }
   void Z5sub(int i,bool a){
      o_Z5sub[ i]=a;  }
   bool Z5sub(int i){
      return o_Z5sub[ i];  }
   void Y6Y6sub(int i,int j,bool a){
      o_Y6Y6sub[ i*o_Y6 +j]=a;  }
   bool Y6Y6sub(int i,int j){
      return o_Y6Y6sub[ i*o_Y6 +j];  }
   void Y6sub(int i,bool a){
      o_Y6sub[ i]=a;  }
   bool Y6sub(int i){
      return o_Y6sub[ i];  }
};

void Dielec_Continu::MED_SURF(const DAT_PHYSICS_CONSTS& physics_consts,
                              Output_Streams& out){
   MEM_med_surf vv;


   for(int iA5= 0;iA5<nA5;iA5++){
      A5[iA5].cI5=( iA5<bse_nA5 )? A5[iA5].bse_cI5: 0;
   }
   for(int iA5= 0;iA5<(nA5-1);iA5++){
      if( A5[iA5].typ== 7 )continue;
      for(int jA5=( iA5<bse_nA5 )? bse_nA5: (iA5+1);jA5<nA5;jA5++){
         if( A5[jA5].typ== 7 )continue;
         double rr=( A5[jA5].x -A5[iA5].x).rr();
         double z=( A5[iA5].r +A5[jA5].r +(2.)*probe);
         if( rr<(z*z) ){
            A5[iA5].I5.push_back( tA5::tA5I5());
            A5[iA5].I5[A5[iA5].cI5++].A5=jA5;
            A5[jA5].I5.push_back( tA5::tA5I5());
            A5[jA5].I5[A5[jA5].cI5++].A5=iA5;
         }
      }
   }


   for(int iA5= 0;iA5<nA5;iA5++){
      if( iA5<bse_nA5 ){
         A5[iA5].free=A5[iA5].bse_free;
      }else{
         if( (A5[iA5].typ== 7)||A5[iA5].bur ){
            A5[iA5].free=false;
         }else{
            A5[iA5].free=true;
         }
      }
   }
   nB5=bse_nB5;
   for(int iA5= 0;iA5<nA5;iA5++){
      for(int iI5=( iA5<bse_nA5 )? A5[iA5].bse_cI5: 0;iI5<A5[iA5].cI5;iI5++){
         int jA5=A5[iA5].I5[iI5].A5;
         if( jA5<iA5 )continue;
         Coordinates d=( A5[jA5].x -A5[iA5].x);
         double rr= d.rr();
         double p=( A5[iA5].r +A5[jA5].r +(2.)*probe);
         double q=( A5[iA5].r -A5[jA5].r);
         double f1=( p*p -rr);
         double f2=( rr -q*q);
         if( f2<=(0.00) ){
            if( A5[iA5].r<A5[jA5].r ){
               A5[iA5].free=false;
            }else{
               A5[jA5].free=false;
            }
         }else{
            if( A5[iA5].bur||A5[jA5].bur ){
            }else{
               A5[iA5].I5[iI5].B5=nB5;
               B5.push_back(tB5());
               B5[nB5].N2A5[0]=iA5;
               B5[nB5].N2A5[1]=jA5;
               B5[nB5].c= d;
               B5[nB5].c.normalize();
               double bi=( A5[iA5].r +probe);
               double bj=( A5[jA5].r +probe);
               double z=( rr +bi*bi -bj*bj)/( (2.)*rr);
               B5[nB5].x=( A5[iA5].x +z*d);
               B5[nB5].r= std::sqrt( f1*f2/rr)/(2.);
               nB5++;
            }
            A5[iA5].free=false;
            A5[jA5].free=false;
         }
      }
   }


   for(int iB5= 0;iB5<nB5;iB5++){
      if( iB5<bse_nB5 ){
         B5[iB5].free=B5[iB5].bse_free;
         B5[iB5].nX5=B5[iB5].bse_nX5;
         for(int iX5= 0;iX5<B5[iB5].nX5;iX5++){
            B5[iB5].X5.push_back( tB5::tB5X5());
            B5[iB5].X5[iX5].E5=B5[iB5].bse_X5[iX5].E5;
         }
      }else{
         B5[iB5].free=true;
         B5[iB5].circ=false;
         B5[iB5].N2H5[0]=-1;
         B5[iB5].N2H5[1]=-1;
         B5[iB5].nX5=0;
      }
   }
   nC5=bse_nC5;
   nF5=bse_nF5;
   nE5=bse_nE5;
   for(int iC5= 0;iC5<nC5;iC5++){
      int iF5=iC5;
      C5[iC5].sub=true;
      int iA5=C5[iC5].N3A5[0];
      for(int iI5=( iA5<bse_nA5 )? A5[iA5].bse_cI5: 0;iI5<A5[iA5].cI5;iI5++){
         int lA5=A5[iA5].I5[iI5].A5;
         double r=( C5[iC5].x -A5[lA5].x).r();
         double bl=( A5[lA5].r +probe);
         if( ( r -bl)<(-1.00e-11) ){
            C5[iC5].sub=false;
            int ijB5=C5[iC5].N3B5[0];
            int ijE1=F5[iF5].N3E5[0];
            int nX5=B5[ijB5].nX5--;
            bool REMOVED=false;
            for(int iX5= 0;iX5<nX5&&(!REMOVED);iX5++){
               if( B5[ijB5].X5[iX5].E5==ijE1 ){
                  REMOVED=true;
                  B5[ijB5].X5.erase(B5[ijB5].X5.begin()+iX5,
                                    B5[ijB5].X5.begin()+iX5+1);
               }
            }
            int jkB5=C5[iC5].N3B5[1];
            int jkE1=F5[iF5].N3E5[1];
            nX5=B5[jkB5].nX5--;
            REMOVED=false;
            for(int iX5= 0;iX5<nX5&&(!REMOVED);iX5++){
               if( B5[jkB5].X5[iX5].E5==jkE1 ){
                  REMOVED=true;
                  B5[jkB5].X5.erase(B5[jkB5].X5.begin()+iX5,
                                    B5[jkB5].X5.begin()+iX5+1);
               }
            }
            int ikB5=C5[iC5].N3B5[2];
            int ikE1=F5[iF5].N3E5[2];
            nX5=B5[ikB5].nX5--;
            REMOVED=false;
            for(int iX5= 0;iX5<nX5&&(!REMOVED);iX5++){
               if( B5[ikB5].X5[iX5].E5==ikE1 ){
                  REMOVED=true;
                  B5[ikB5].X5.erase(B5[ikB5].X5.begin()+iX5,
                                    B5[ikB5].X5.begin()+iX5+1);
               }
            }
            break;
         }
      }
   }
   nV5=bse_nV5;
   nH5=bse_nH5;
   for(int ijB5= 0;ijB5<nB5;ijB5++){
      int iA5=B5[ijB5].N2A5[0];
      int jA5=B5[ijB5].N2A5[1];
      for(int jI5=( jA5<bse_nA5 )? A5[jA5].bse_cI5: 0;jI5<A5[jA5].cI5;jI5++){
         int jkB5=A5[jA5].I5[jI5].B5;
         if( jkB5==-1 )continue;
         int kA5=A5[jA5].I5[jI5].A5;
         int ikB5=-1;
         for(int iI5=( iA5<bse_nA5 )? A5[iA5].bse_cI5: 0;iI5<A5[iA5].cI5;iI5++){
            if( A5[iA5].I5[iI5].A5==kA5 )ikB5=A5[iA5].I5[iI5].B5;
         }
         if( ikB5==-1 )continue;
         Coordinates u= B5[ijB5].c;
         Coordinates c= B5[ikB5].c;
         double Cthe= dot(c,u);
         double Sthe=( (1.00) -Cthe*Cthe);
         if( Sthe<(1.00e-15) )continue;
         Sthe= ((1.00)/std::sqrt( Sthe));
         Coordinates w= Sthe*cross(u,c);
         Coordinates v= cross(w,u);
         double z= Sthe*dot(c,( B5[ikB5].x -B5[ijB5].x));
         Coordinates x=( B5[ijB5].x +z*v);
         double rr=( x -A5[iA5].x).rr();
         double bi=( A5[iA5].r +probe);
         double hh=( bi*bi -rr);
         if( hh<=(0.00) ){
         }else{
            B5[ijB5].free=false;
            B5[jkB5].free=false;
            B5[ikB5].free=false;
            double h= std::sqrt( hh);
            for(double SGN=( 1.00);SGN>=(-1.00);SGN-=( 2.00)){
               Coordinates y=( x +(SGN*h)*w);

               bool EXCLUDED=false;
               for(int iI5= 0;iI5<A5[iA5].cI5&&(!EXCLUDED);iI5++){
                  int lA5=A5[iA5].I5[iI5].A5;
                  if( lA5==jA5 )continue;
                  if( lA5==kA5 )continue;
                  double r=( y -A5[lA5].x).r();
                  double bl=( A5[lA5].r +probe);
                  if      ( ( r -bl)<(-1.00e-11) ){
                     EXCLUDED=true;
                  }else if( ( r -bl)<( 1.00e-11) ){
                     int pN3A5[3];
                     int qN3A5[3];
                     pN3A5[0]=iA5;
                     pN3A5[1]=jA5;
                     pN3A5[2]=kA5;
                     int iSGN=( SGN>(0.00) )? 1:-1;
                     if      ( lA5<iA5 ){
                        qN3A5[0]=lA5;
                        qN3A5[1]=iA5;
                        qN3A5[2]=jA5;
                        bool SHEDGE=false;
                        bool ADJFAC=false;
                        Coordinates d=( A5[iA5].x -A5[lA5].x);
                        Coordinates e=( A5[jA5].x -A5[lA5].x);
                        int jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        bool EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( !C5[iC5].sub )continue;
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(8.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }
                        qN3A5[0]=lA5;
                        qN3A5[1]=iA5;
                        qN3A5[2]=kA5;
                        SHEDGE=false;
                        ADJFAC=false;
                        d=( A5[iA5].x -A5[lA5].x);
                        e=( A5[kA5].x -A5[lA5].x);
                        jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( !C5[iC5].sub )continue;
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(8.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }
                        qN3A5[0]=lA5;
                        qN3A5[1]=jA5;
                        qN3A5[2]=kA5;
                        SHEDGE=false;
                        ADJFAC=false;
                        d=( A5[jA5].x -A5[lA5].x);
                        e=( A5[kA5].x -A5[lA5].x);
                        jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( !C5[iC5].sub )continue;
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(8.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }

                     }else if( lA5<jA5 ){
                        qN3A5[0]=iA5;
                        qN3A5[1]=lA5;
                        qN3A5[2]=jA5;
                        bool SHEDGE=false;
                        bool ADJFAC=false;
                        Coordinates d=( A5[lA5].x -A5[iA5].x);
                        Coordinates e=( A5[jA5].x -A5[iA5].x);
                        int jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        bool EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( !C5[iC5].sub )continue;
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(8.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }
                        qN3A5[0]=iA5;
                        qN3A5[1]=lA5;
                        qN3A5[2]=kA5;
                        SHEDGE=false;
                        ADJFAC=false;
                        d=( A5[lA5].x -A5[iA5].x);
                        e=( A5[kA5].x -A5[iA5].x);
                        jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( !C5[iC5].sub )continue;
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(8.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }

                     }else if( lA5<kA5 ){
                        qN3A5[0]=iA5;
                        qN3A5[1]=jA5;
                        qN3A5[2]=lA5;
                        bool SHEDGE=false;
                        bool ADJFAC=false;
                        Coordinates d=( A5[jA5].x -A5[iA5].x);
                        Coordinates e=( A5[lA5].x -A5[iA5].x);
                        int jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        bool EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( !C5[iC5].sub )continue;
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(8.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }
                     }else{
                        if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                     }

                  }
               }
               if( EXCLUDED )continue;

               C5.push_back(tC5());
               C5[nC5].N3A5[0]=iA5;
               C5[nC5].N3A5[1]=jA5;
               C5[nC5].N3A5[2]=kA5;
               C5[nC5].N3B5[0]=ijB5;
               C5[nC5].N3B5[1]=jkB5;
               C5[nC5].N3B5[2]=ikB5;
               C5[nC5].c= w;
               C5[nC5].e= v;
//             C5[nC5].b= x;
               C5[nC5].h= SGN*h;
               C5[nC5].x= y;
               C5[nC5].sub=true;
               V5.push_back(tV5());
               V5.push_back(tV5());
               V5.push_back(tV5());
               V5[nV5  ].A5=iA5;
               V5[nV5+1].A5=jA5;
               V5[nV5+2].A5=kA5;
               V5[nV5  ].C5=nC5;
               V5[nV5+1].C5=nC5;
               V5[nV5+2].C5=nC5;
               z= (1.00)/( A5[iA5].r +probe);
               V5[nV5  ].x= z*( probe*A5[iA5].x +A5[iA5].r*y);
               z= (1.00)/( A5[jA5].r +probe);
               V5[nV5+1].x= z*( probe*A5[jA5].x +A5[jA5].r*y);
               z= (1.00)/( A5[kA5].r +probe);
               V5[nV5+2].x= z*( probe*A5[kA5].x +A5[kA5].r*y);
               F5.push_back(tF5());
               F5[nF5].N3E5[0]=(nE5  );
               F5[nF5].N3E5[1]=(nE5+1);
               F5[nF5].N3E5[2]=(nE5+2);
               if( h<probe ){
                  F5[nF5].CUSP=true;
               }else{
                  F5[nF5].CUSP=false;
               }
               nF5++;
               E5.push_back(tE5());
               E5.push_back(tE5());
               E5.push_back(tE5());
               if( SGN>(0.00) ){
                  E5[nE5  ].N2V5[0]=(nV5  );
                  E5[nE5  ].N2V5[1]=(nV5+1);
                  E5[nE5+1].N2V5[0]=(nV5+1);
                  E5[nE5+1].N2V5[1]=(nV5+2);
                  E5[nE5+2].N2V5[0]=(nV5+2);
                  E5[nE5+2].N2V5[1]=(nV5  );
               }else{
                  E5[nE5  ].N2V5[0]=(nV5+1);
                  E5[nE5  ].N2V5[1]=(nV5  );
                  E5[nE5+1].N2V5[0]=(nV5+2);
                  E5[nE5+1].N2V5[1]=(nV5+1);
                  E5[nE5+2].N2V5[0]=(nV5  );
                  E5[nE5+2].N2V5[1]=(nV5+2);
               }
               z= (1.00)/B5[ijB5].r;
               Coordinates d= z*( y -B5[ijB5].x);
               E5[nE5  ].c= SGN*cross(d,B5[ijB5].c);
               z= (1.00)/B5[jkB5].r;
               d= z*( y -B5[jkB5].x);
               E5[nE5+1].c= SGN*cross(d,B5[jkB5].c);
               z= (1.00)/B5[ikB5].r;
               d= z*( y -B5[ikB5].x);
               E5[nE5+2].c=-SGN*cross(d,B5[ikB5].c);
               double Calp= dot(E5[nE5+2].c,E5[nE5  ].c);
               V5[nV5  ].alp= std::acos( Calp);
               V5[nV5  ].bet=( physics_consts.PI -V5[nV5  ].alp);
               Calp= dot(E5[nE5  ].c,E5[nE5+1].c);
               V5[nV5+1].alp= std::acos( Calp);
               V5[nV5+1].bet=( physics_consts.PI -V5[nV5+1].alp);
               Calp= dot(E5[nE5+1].c,E5[nE5+2].c);
               V5[nV5+2].alp= std::acos( Calp);
               V5[nV5+2].bet=( physics_consts.PI -V5[nV5+2].alp);
               B5[ijB5].X5.push_back( tB5::tB5X5());
               B5[ijB5].X5[B5[ijB5].nX5++].E5=(nE5  );
               B5[jkB5].X5.push_back( tB5::tB5X5());
               B5[jkB5].X5[B5[jkB5].nX5++].E5=(nE5+1);
               B5[ikB5].X5.push_back( tB5::tB5X5());
               B5[ikB5].X5[B5[ikB5].nX5++].E5=(nE5+2);
               nV5+=3;
               nE5+=3;
               if( !B5[ijB5].circ ){
                  B5[ijB5].circ=true;
                  B5[ijB5].N2H5[0]=nH5  ;
                  B5[ijB5].N2H5[1]=nH5+1;
                  H5.push_back(tH5());
                  H5.push_back(tH5());
                  H5[nH5  ].B5=ijB5;
                  H5[nH5  ].A5=iA5;
                  z= (1.00)/( A5[iA5].r +probe);
                  H5[nH5  ].x= z*( probe*A5[iA5].x +A5[iA5].r*B5[ijB5].x);
                  H5[nH5  ].c= B5[ijB5].c;
                  H5[nH5  ].r= z*B5[ijB5].r*A5[iA5].r;
                  H5[nH5  ].del=dot(( H5[nH5  ].x -A5[iA5].x),H5[nH5  ].c);
                  H5[nH5  ].the= std::atan( H5[nH5  ].del/H5[nH5  ].r);
                  H5[nH5+1].B5=ijB5;
                  H5[nH5+1].A5=jA5;
                  z= (1.00)/( A5[jA5].r +probe);
                  H5[nH5+1].x= z*( probe*A5[jA5].x +A5[jA5].r*B5[ijB5].x);
                  H5[nH5+1].c= (-1.00)*B5[ijB5].c;
                  H5[nH5+1].r= z*B5[ijB5].r*A5[jA5].r;
                  H5[nH5+1].del=dot(( H5[nH5+1].x -A5[jA5].x),H5[nH5+1].c);
                  H5[nH5+1].the= std::atan( H5[nH5+1].del/H5[nH5+1].r);
                  nH5+=2;
               }
               if( !B5[jkB5].circ ){
                  B5[jkB5].circ=true;
                  B5[jkB5].N2H5[0]=nH5  ;
                  B5[jkB5].N2H5[1]=nH5+1;
                  H5.push_back(tH5());
                  H5.push_back(tH5());
                  H5[nH5  ].B5=jkB5;
                  H5[nH5  ].A5=jA5;
                  z= (1.00)/( A5[jA5].r +probe);
                  H5[nH5  ].x= z*( probe*A5[jA5].x +A5[jA5].r*B5[jkB5].x);
                  H5[nH5  ].c= B5[jkB5].c;
                  H5[nH5  ].r= z*B5[jkB5].r*A5[jA5].r;
                  H5[nH5  ].del=dot(( H5[nH5  ].x -A5[jA5].x),H5[nH5  ].c);
                  H5[nH5  ].the= std::atan( H5[nH5  ].del/H5[nH5  ].r);
                  H5[nH5+1].B5=jkB5;
                  H5[nH5+1].A5=kA5;
                  z= (1.00)/( A5[kA5].r +probe);
                  H5[nH5+1].x= z*( probe*A5[kA5].x +A5[kA5].r*B5[jkB5].x);
                  H5[nH5+1].c= (-1.00)*B5[jkB5].c;
                  H5[nH5+1].r= z*B5[jkB5].r*A5[kA5].r;
                  H5[nH5+1].del=dot(( H5[nH5+1].x -A5[kA5].x),H5[nH5+1].c);
                  H5[nH5+1].the= std::atan( H5[nH5+1].del/H5[nH5+1].r);
                  nH5+=2;
               }
               if( !B5[ikB5].circ ){
                  B5[ikB5].circ=true;
                  B5[ikB5].N2H5[0]=nH5  ;
                  B5[ikB5].N2H5[1]=nH5+1;
                  H5.push_back(tH5());
                  H5.push_back(tH5());
                  H5[nH5  ].B5=ikB5;
                  H5[nH5  ].A5=iA5;
                  z= (1.00)/( A5[iA5].r +probe);
                  H5[nH5  ].x= z*( probe*A5[iA5].x +A5[iA5].r*B5[ikB5].x);
                  H5[nH5  ].c= B5[ikB5].c;
                  H5[nH5  ].r= z*B5[ikB5].r*A5[iA5].r;
                  H5[nH5  ].del=dot(( H5[nH5  ].x -A5[iA5].x),H5[nH5  ].c);
                  H5[nH5  ].the= std::atan( H5[nH5  ].del/H5[nH5  ].r);
                  H5[nH5+1].B5=ikB5;
                  H5[nH5+1].A5=kA5;
                  z= (1.00)/( A5[kA5].r +probe);
                  H5[nH5+1].x= z*( probe*A5[kA5].x +A5[kA5].r*B5[ikB5].x);
                  H5[nH5+1].c= (-1.00)*B5[ikB5].c;
                  H5[nH5+1].r= z*B5[ikB5].r*A5[kA5].r;
                  H5[nH5+1].del=dot(( H5[nH5+1].x -A5[kA5].x),H5[nH5+1].c);
                  H5[nH5+1].the= std::atan( H5[nH5+1].del/H5[nH5+1].r);
                  nH5+=2;
               }
               nC5++;
            }
         }
      }
   }
   for(int ijB5= 0;ijB5<nB5;ijB5++){
      if( !B5[ijB5].free )continue;
      int iA5=B5[ijB5].N2A5[0];
      int jA5=B5[ijB5].N2A5[1];
      for(int iI5=( jA5<bse_nA5 )? A5[iA5].bse_cI5: 0;iI5<A5[iA5].cI5;iI5++){
         int kA5=A5[iA5].I5[iI5].A5;
         if( kA5==jA5 )continue;
         double bk=( A5[kA5].r +probe);
         double rr=( A5[kA5].x -B5[ijB5].x).rr();
         double z=( bk*bk -rr -B5[ijB5].r*B5[ijB5].r);
         if( z>(0.00) ){
            B5[ijB5].free=false;
            break;
         }
      }
   }
   for(int ijB5=bse_nB5;ijB5<nB5;ijB5++){
      if( !B5[ijB5].free )continue;
      B5[ijB5].circ=true;
      B5[ijB5].N2H5[0]=nH5  ;
      B5[ijB5].N2H5[1]=nH5+1;
      int iA5=B5[ijB5].N2A5[0];
      int jA5=B5[ijB5].N2A5[1];
      H5.push_back(tH5());
      H5.push_back(tH5());
      H5[nH5  ].B5=ijB5;
      H5[nH5  ].A5=iA5;
      double z= (1.00)/( A5[iA5].r +probe);
      H5[nH5  ].x= z*( probe*A5[iA5].x +A5[iA5].r*B5[ijB5].x);
      H5[nH5  ].c= B5[ijB5].c;
      H5[nH5  ].r= z*B5[ijB5].r*A5[iA5].r;
      H5[nH5  ].del=dot(( H5[nH5  ].x -A5[iA5].x),H5[nH5  ].c);
      H5[nH5  ].the= std::atan( H5[nH5  ].del/H5[nH5  ].r);
      H5[nH5+1].B5=ijB5;
      H5[nH5+1].A5=jA5;
      z= (1.00)/( A5[jA5].r +probe);
      H5[nH5+1].x= z*( probe*A5[jA5].x +A5[jA5].r*B5[ijB5].x);
      H5[nH5+1].c= (-1.00)*B5[ijB5].c;
      H5[nH5+1].r= z*B5[ijB5].r*A5[jA5].r;
      H5[nH5+1].del=dot(( H5[nH5+1].x -A5[jA5].x),H5[nH5+1].c);
      H5[nH5+1].the= std::atan( H5[nH5+1].del/H5[nH5+1].r);
      nH5+=2;
   }


   for(int iA5= 0;iA5<nA5;iA5++){
      A5[iA5].nZ5=0;
   }
   nF6=0;
   nE6=0;
   for(int ijB5= 0;ijB5<nB5;ijB5++){
      int nX5=B5[ijB5].nX5;
      if( nX5==0 )continue;
      int iA5=B5[ijB5].N2A5[0];
      int jA5=B5[ijB5].N2A5[1];
      Coordinates u= B5[ijB5].c;
      Coordinates v=( V5[E5[B5[ijB5].X5[ 0].E5].N2V5[0]].x -B5[ijB5].x);
      double z= dot(v,u);
      v-=(z*u);
      v.normalize();
      Coordinates w= cross(u,v);
      B5[ijB5].X5[ 0].the= (0.00);
      for(int iX5= 1;iX5<nX5;iX5++){
         Coordinates d=( V5[E5[B5[ijB5].X5[iX5].E5].N2V5[0]].x -B5[ijB5].x);
         z= dot(d,u);
         d-=(z*u);
         d.normalize();
         double Cthe= dot(d,v);
         double Sthe= dot(d,w);
         B5[ijB5].X5[iX5].the= std::atan2(Sthe,Cthe);
      }
      for(int iX5max=(nX5-1);iX5max>0;iX5max--){
         bool ORDERED=true;
         double f1= B5[ijB5].X5[ 0].the;
         for(int iX5= 1;iX5<=iX5max;iX5++){
            double f2= B5[ijB5].X5[iX5  ].the;
            if      ( f2<(f1-(1.00e-7)) ){
               double t= B5[ijB5].X5[iX5  ].the;
               B5[ijB5].X5[iX5  ].the= B5[ijB5].X5[iX5-1].the;
               B5[ijB5].X5[iX5-1].the= t;
               int L=B5[ijB5].X5[iX5  ].E5;
               B5[ijB5].X5[iX5  ].E5=B5[ijB5].X5[iX5-1].E5;
               B5[ijB5].X5[iX5-1].E5=L;
               ORDERED=false;
            }else if( f2>(f1+(1.00e-7)) ){
               f1= f2;
            }else{
               if( V5[E5[B5[ijB5].X5[iX5  ].E5].N2V5[0]].A5==iA5 ){
                  int L=B5[ijB5].X5[iX5  ].E5;
                  B5[ijB5].X5[iX5  ].E5=B5[ijB5].X5[iX5-1].E5;
                  B5[ijB5].X5[iX5-1].E5=L;
               }
            }
         }
         if( ORDERED )break;
      }
      B5[ijB5].X5.push_back( tB5::tB5X5());
      B5[ijB5].X5[B5[ijB5].nX5  ].E5=B5[ijB5].X5[ 0].E5;
      B5[ijB5].X5[B5[ijB5].nX5  ].the=( B5[ijB5].X5[ 0].the
                                       +(2.)*physics_consts.PI);
      if( B5[ijB5].X5[nX5  ].the<(B5[ijB5].X5[nX5-1].the+(1.00e-7)) ){
         if( V5[E5[B5[ijB5].X5[nX5  ].E5].N2V5[0]].A5==iA5 ){
            int L=B5[ijB5].X5[nX5  ].E5;
            B5[ijB5].X5[nX5  ].E5=B5[ijB5].X5[nX5-1].E5;
            B5[ijB5].X5[nX5-1].E5=L;
            B5[ijB5].X5[ 0].E5=B5[ijB5].X5[nX5  ].E5;
         }
      }
      for(int iX5= 0;iX5<nX5;iX5++){
         if( V5[E5[B5[ijB5].X5[iX5  ].E5].N2V5[0]].A5==iA5 ){
            F6.push_back(tF6());
            F6[nF6].N2E5[0]=B5[ijB5].X5[iX5  ].E5;
            F6[nF6].N2E5[1]=B5[ijB5].X5[iX5+1].E5;
            F6[nF6].N2E6[0]=nE6  ;
            F6[nF6].N2E6[1]=nE6+1;
            if( B5[ijB5].r<probe ){
               F6[nF6].CUSP=true;
            }else{
               F6[nF6].CUSP=false;
            }
            nF6++;
            E6.push_back(tE6());
            E6.push_back(tE6());
            E6[nE6  ].N2V5[0]=E5[B5[ijB5].X5[iX5  ].E5].N2V5[1];
            E6[nE6  ].N2V5[1]=E5[B5[ijB5].X5[iX5+1].E5].N2V5[0];
            E6[nE6+1].N2V5[0]=E5[B5[ijB5].X5[iX5+1].E5].N2V5[1];
            E6[nE6+1].N2V5[1]=E5[B5[ijB5].X5[iX5  ].E5].N2V5[0];
            E6[nE6  ].H5=B5[ijB5].N2H5[1];
            E6[nE6+1].H5=B5[ijB5].N2H5[0];
            E6[nE6  ].phi=( B5[ijB5].X5[iX5+1].the -B5[ijB5].X5[iX5  ].the);
            E6[nE6+1].phi=( B5[ijB5].X5[iX5+1].the -B5[ijB5].X5[iX5  ].the);
            E6[nE6  ].jA5=iA5;
            E6[nE6+1].jA5=jA5;
            A5[iA5].Z5.push_back( tA5::tA5Z5());
            A5[iA5].Z5[A5[iA5].nZ5++].E6=(nE6+1);
            A5[jA5].Z5.push_back( tA5::tA5Z5());
            A5[jA5].Z5[A5[jA5].nZ5++].E6=(nE6  );
            nE6+=2;
         }
      }
   }


   for(int iA5= 0;iA5<nA5;iA5++){
      A5[iA5].nY6=0;
   }
   for(int iA5= 0;iA5<nA5;iA5++){
      int nZ5=A5[iA5].nZ5;
      if( nZ5==0 )continue;
      vv.o_Z5sub.resize(nZ5,false);
      for(int iY6= 0;;iY6++){
         int iZ5=-1;
         for(int jZ5= 0;jZ5<nZ5;jZ5++){
            if( vv.Z5sub(jZ5) )continue;
            iZ5=jZ5;
            break;
         }
         if( iZ5==-1 )break;
         A5[iA5].Y6.push_back(tA5::tA5Y6());
         int iE6=A5[iA5].Z5[iZ5].E6;
         vv.Z5sub(iZ5, true);
         A5[iA5].Y6[iY6].Z6.push_back(tA5::tA5Y6::tA5Y6Z6());
         A5[iA5].Y6[iY6].Z6[ 0].E6=iE6;
         A5[iA5].Y6[iY6].nZ6=1;
         int iV5alp=E6[iE6].N2V5[0];
         int iV5bet=E6[iE6].N2V5[1];
         bool CYCLECLOSED=false;
         bool EXTENSIBLE=true;
         while( (!CYCLECLOSED)&&EXTENSIBLE ){
            EXTENSIBLE=false;
            for(int jZ5=(iZ5+1);jZ5<nZ5&&(!CYCLECLOSED);jZ5++){
               if( vv.Z5sub(jZ5) )continue;
               int jE6=A5[iA5].Z5[jZ5].E6;
               if( E6[jE6].N2V5[0]==iV5bet ){
                  vv.Z5sub(jZ5, true);
                  A5[iA5].Y6[iY6].Z6.push_back(tA5::tA5Y6::tA5Y6Z6());
                  A5[iA5].Y6[iY6].Z6[A5[iA5].Y6[iY6].nZ6++].E6=jE6;
                  iV5bet=E6[jE6].N2V5[1];
                  EXTENSIBLE=true;
                  if( iV5bet==iV5alp )CYCLECLOSED=true;
               }
            }
         }
         if( !CYCLECLOSED ){
         if( out.VERBOSE&& out.SHELL ){
            std::cerr<<"ERROR: Cycle of edges is incomplete.\n";
            out.FILE3<< std::fixed;
            out.FILE3<<"  iA5 "" atm"" cI5"" nZ5\n";
            out.FILE3<< std::setw( 5)<<iA5<<' '
                     <<A5[iA5].atm
                     << std::setw( 4)<<A5[iA5].cI5
                     << std::setw( 4)<<A5[iA5].nZ5<<'\n';
            out.FILE3<<"   iB5"" cir"" N2A5  atm          "" nX5"
                       "  N2H5      ""           B5x         "
                       "        B5c      ""  B5r \n";
            for(int iB5= 0;iB5<nB5;iB5++){
               if( (B5[iB5].N2A5[0]!=iA5)&&
                   (B5[iB5].N2A5[1]!=iA5) )continue;
               if( B5[iB5].nX5==0 )continue;
               out.FILE3<< std::setw( 6)<<iB5
                        << std::setw( 4)<<int(B5[iB5].circ);
               for(int i=0;i<2;i++){
                  out.FILE3<< std::setw( 5)<<B5[iB5].N2A5[i]
                           <<' '<<A5[B5[iB5].N2A5[i]].atm;
               }
               out.FILE3<< std::setw( 4)<<B5[iB5].nX5;
               for(int i=0;i<2;i++){
                  out.FILE3<< std::setw( 6)<<B5[iB5].N2H5[i];
               }
               out.FILE3<<"  "<< std::setprecision(2);
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 7)<<B5[iB5].x(i);
               }
               out.FILE3<<"  "<< std::setprecision(2);
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 5)<<B5[iB5].c(i);
               }
               out.FILE3<< std::setprecision(2)
                        << std::setw( 6)<<B5[iB5].r<<'\n';
            }
            out.FILE3<<"   iC5"" N3A5          ""        C5c      ""  C5h "
                       "           C5x         \n";
            for(int iC5= 0;iC5<nC5;iC5++){
               if( !C5[iC5].sub )continue;
               if( (C5[iC5].N3A5[0]!=iA5)&&
                   (C5[iC5].N3A5[1]!=iA5)&&
                   (C5[iC5].N3A5[2]!=iA5) )continue;
               out.FILE3<< std::setw( 6)<<iC5;
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 5)<<C5[iC5].N3A5[i];
               }
               out.FILE3<<"  "<< std::setprecision(2);
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 5)<<C5[iC5].c(i);
               }
               out.FILE3<< std::setprecision(2)
                        << std::setw( 6)<<C5[iC5].h;
               out.FILE3<<"  "<< std::setprecision(2);
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 7)<<C5[iC5].x(i);
               }
               out.FILE3<<'\n';
            }
            out.FILE3<<"   iV5""   A5""    C5""          V5x       "
                       "  V5alp ""  V5bet \n";
            for(int iV5= 0;iV5<nV5;iV5++){
               if( (V5[iV5].A5!=iA5) )continue;
               out.FILE3<< std::setw( 6)<<iV5
                        << std::setw( 5)<<V5[iV5].A5
                        << std::setw( 6)<<V5[iV5].C5;
               out.FILE3<<"  "<< std::setprecision(2);
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 6)<<V5[iV5].x(i);
               }
               out.FILE3<< std::setprecision(3)
                        << std::setw( 8)<<V5[iV5].alp
                        << std::setw( 8)<<V5[iV5].bet<<'\n';
            }
            out.FILE3<<"   iE5""  N2V5      ""        E5c      \n";
            for(int iE5= 0;iE5<nE5;iE5++){
               if( (V5[E5[iE5].N2V5[0]].A5!=iA5)&&
                   (V5[E5[iE5].N2V5[1]].A5!=iA5) )continue;
               out.FILE3<< std::setw( 6)<<iE5;
               for(int i=0;i<2;i++){
                  out.FILE3<< std::setw( 6)<<E5[iE5].N2V5[i];
               }
               out.FILE3<<"  "<< std::setprecision(2);
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 5)<<E5[iE5].c(i);
               }
               out.FILE3<<'\n';
            }
            out.FILE3<<"   iB5"" iX5""  X5E5""  X5the \n";
            for(int iB5= 0;iB5<nB5;iB5++){
               if( (B5[iB5].N2A5[0]!=iA5)&&
                   (B5[iB5].N2A5[1]!=iA5) )continue;
               for(int iX5= 0;iX5<B5[iB5].nX5;iX5++){
                  out.FILE3<< std::setw( 6)<<iB5
                           << std::setw( 4)<<iX5
                           << std::setw( 6)<<B5[iB5].X5[iX5].E5
                           << std::setprecision(5)
                           << std::setw( 8)<<B5[iB5].X5[iX5].the<<'\n';
               }
            }
            out.FILE3<<"  iA5"" iZ5""  Z5E6\n";
            for(int iZ5= 0;iZ5<A5[iA5].nZ5;iZ5++){
               out.FILE3<< std::setw( 5)<<iA5
                        << std::setw( 4)<<iZ5
                        << std::setw( 6)<<A5[iA5].Z5[iZ5].E6<<'\n';
            }
            out.FILE3<<"   iE6""  N2V5      ""    H5""    phi \n";
            for(int iE6= 0;iE6<nE6;iE6++){
               if( H5[E6[iE6].H5].A5!=iA5 )continue;
               out.FILE3<< std::setw( 6)<<iE6;
               for(int i=0;i<2;i++){
                  out.FILE3<< std::setw( 6)<<E6[iE6].N2V5[i];
               }
               out.FILE3<< std::setw( 6)<<E6[iE6].H5
                        << std::setprecision(3)
                        << std::setw( 8)<<E6[iE6].phi<<'\n';
            }
            out.FILE3<<"   iH5""    B5""   A5""           H5x         "
                       "        H5c      ""    r ""  del ""    the \n";
            for(int iH5= 0;iH5<nH5;iH5++){
               if( (H5[iH5].A5!=iA5) )continue;
               out.FILE3<< std::setw( 6)<<iH5
                        << std::setw( 6)<<H5[iH5].B5
                        << std::setw( 5)<<H5[iH5].A5;
               out.FILE3<<"  "<< std::setprecision(2);
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 7)<<H5[iH5].x(i);
               }
               out.FILE3<<"  "<< std::setprecision(2);
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 5)<<H5[iH5].c(i);
               }
               out.FILE3<< std::setprecision(2)
                        << std::setw( 6)<<H5[iH5].r
                        << std::setw( 6)<<H5[iH5].del
                        << std::setprecision(3)
                        << std::setw( 8)<<H5[iH5].the<<'\n';
            }
//
//
// full C5
//
            out.FILE3<<"   iC5"" N3A5          ""        C5c      ""  C5h "
                       "           C5x         \n";
            for(int iC5= 0;iC5<nC5;iC5++){
               if( !C5[iC5].sub )continue;
               out.FILE3<< std::setw( 6)<<iC5;
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 5)<<C5[iC5].N3A5[i];
               }
               out.FILE3<<"  "<< std::setprecision(2);
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 5)<<C5[iC5].c(i);
               }
               out.FILE3<< std::setprecision(2)
                        << std::setw( 6)<<C5[iC5].h;
               out.FILE3<<"  "<< std::setprecision(2);
               for(int i=0;i<3;i++){
                  out.FILE3<< std::setw( 7)<<C5[iC5].x(i);
               }
               out.FILE3<<'\n';
            }
//
//
// exclusion path
//
            int pC5=0;
            for(int ijB5= 0;ijB5<nB5;ijB5++){
               int iA5=B5[ijB5].N2A5[0];
               int jA5=B5[ijB5].N2A5[1];
               for(int jI5= 0;jI5<A5[jA5].cI5;jI5++){
                  int jkB5=A5[jA5].I5[jI5].B5;
                  if( jkB5==-1 )continue;
                  int kA5=A5[jA5].I5[jI5].A5;
                  int ikB5=-1;
                  for(int iI5= 0;iI5<A5[iA5].cI5;iI5++){
                     if( A5[iA5].I5[iI5].A5==kA5 )ikB5=A5[iA5].I5[iI5].B5;
                  }
                  if( ikB5==-1 )continue;
                  Coordinates u= B5[ijB5].c;
                  Coordinates c= B5[ikB5].c;
                  double Cthe= dot(c,u);
                  double Sthe=( (1.00) -Cthe*Cthe);
                  if( Sthe<(1.00e-15) )continue;
                  Sthe= ((1.00)/std::sqrt( Sthe));
                  Coordinates w= Sthe*cross(u,c);
                  Coordinates v= cross(w,u);
                  double z= Sthe*dot(c,( B5[ikB5].x -B5[ijB5].x));
                  Coordinates x=( B5[ijB5].x +z*v);
                  double rr=( x -A5[iA5].x).rr();
                  double bi=( A5[iA5].r +probe);
                  double hh=( bi*bi -rr);
                  if( hh<=(0.00) ){
                  }else{
                     double h= std::sqrt( hh);
                     for(double SGN=( 1.00);SGN>=(-1.00);SGN-=( 2.00)){
                        Coordinates y=( x +(SGN*h)*w);
                        bool EXCLUDED=false;
                        int lA5=-1;
                        double r=( 0.00);
                        double bl=( 0.00);
                        bool EQPROB=false;
                        bool SHEDGE=false;
                        bool ADJFAC=false;
                        int qN3A5[3];
                        for(int iI5= 0;iI5<A5[iA5].cI5&&(!EXCLUDED);iI5++){
                           lA5=A5[iA5].I5[iI5].A5;
                           if( lA5==jA5 )continue;
                           if( lA5==kA5 )continue;
                           r=( y -A5[lA5].x).r();
                           bl=( A5[lA5].r +probe);
                           if      ( ( r -bl)<(-1.00e-11) ){
                              EXCLUDED=true;
                           }else if( ( r -bl)<( 1.00e-11) ){
                              int pN3A5[3];
                              pN3A5[0]=iA5;
                              pN3A5[1]=jA5;
                              pN3A5[2]=kA5;
                              int iSGN=( SGN>(0.00) )? 1:-1;
                              if      ( lA5<iA5 ){
                                 qN3A5[0]=lA5;
                                 qN3A5[1]=iA5;
                                 qN3A5[2]=jA5;
                                 SHEDGE=false;
                                 ADJFAC=false;
                                 Coordinates d=( A5[iA5].x -A5[lA5].x);
                                 Coordinates e=( A5[jA5].x -A5[lA5].x);
                                 int jSGN=iSGN
                                       *(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                                 for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                                    int i1=( 3+i0+iSGN)%3;
                                    for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);
                                        j0++){
                                       int j1=( 3+j0+jSGN)%3;
                                       if( (pN3A5[i0]==qN3A5[j0])&&
                                           (pN3A5[i1]==qN3A5[j1]) ){
                                          SHEDGE=true;
                                       }
                                       if( (pN3A5[i0]==qN3A5[j1])&&
                                           (pN3A5[i1]==qN3A5[j0]) ){
                                          ADJFAC=true;
                                       }
                                    }
                                 }
                                 EQPROB=false;
                                 for(int iC5= 0;iC5<pC5&&(!EQPROB);iC5++){
                                    if( !C5[iC5].sub )continue;
                                    if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                                    if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                                    if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                                    rr=( C5[iC5].x -y).rr();
                                    if( rr>(8.00e-22) )continue;
                                    EQPROB=true;
                                 }
                                 if( EQPROB ){
                                    if      ( SHEDGE ){
                                       EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=false;
                                    }else{
                                       EXCLUDED=true;
                                    }
                                    continue;
                                 }else{
                                    if      ( SHEDGE ){
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=true;
                                       continue;
                                    }else{
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }
                                 }
                                 qN3A5[0]=lA5;
                                 qN3A5[1]=iA5;
                                 qN3A5[2]=kA5;
                                 SHEDGE=false;
                                 ADJFAC=false;
                                 d=( A5[iA5].x -A5[lA5].x);
                                 e=( A5[kA5].x -A5[lA5].x);
                                 jSGN=iSGN
                                   *(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                                 for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                                    int i1=( 3+i0+iSGN)%3;
                                    for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);
                                        j0++){
                                       int j1=( 3+j0+jSGN)%3;
                                       if( (pN3A5[i0]==qN3A5[j0])&&
                                           (pN3A5[i1]==qN3A5[j1]) ){
                                          SHEDGE=true;
                                       }
                                       if( (pN3A5[i0]==qN3A5[j1])&&
                                           (pN3A5[i1]==qN3A5[j0]) ){
                                          ADJFAC=true;
                                       }
                                    }
                                 }
                                 EQPROB=false;
                                 for(int iC5= 0;iC5<pC5&&(!EQPROB);iC5++){
                                    if( !C5[iC5].sub )continue;
                                    if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                                    if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                                    if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                                    rr=( C5[iC5].x -y).rr();
                                    if( rr>(8.00e-22) )continue;
                                    EQPROB=true;
                                 }
                                 if( EQPROB ){
                                    if      ( SHEDGE ){
                                       EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=false;
                                    }else{
                                       EXCLUDED=true;
                                    }
                                    continue;
                                 }else{
                                    if      ( SHEDGE ){
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=true;
                                       continue;
                                    }else{
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }
                                 }
                                 qN3A5[0]=lA5;
                                 qN3A5[1]=jA5;
                                 qN3A5[2]=kA5;
                                 SHEDGE=false;
                                 ADJFAC=false;
                                 d=( A5[jA5].x -A5[lA5].x);
                                 e=( A5[kA5].x -A5[lA5].x);
                                 jSGN=iSGN
                                   *(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                                 for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                                    int i1=( 3+i0+iSGN)%3;
                                    for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);
                                        j0++){
                                       int j1=( 3+j0+jSGN)%3;
                                       if( (pN3A5[i0]==qN3A5[j0])&&
                                           (pN3A5[i1]==qN3A5[j1]) ){
                                          SHEDGE=true;
                                       }
                                       if( (pN3A5[i0]==qN3A5[j1])&&
                                           (pN3A5[i1]==qN3A5[j0]) ){
                                          ADJFAC=true;
                                       }
                                    }
                                 }
                                 EQPROB=false;
                                 for(int iC5= 0;iC5<pC5&&(!EQPROB);iC5++){
                                    if( !C5[iC5].sub )continue;
                                    if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                                    if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                                    if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                                    rr=( C5[iC5].x -y).rr();
                                    if( rr>(8.00e-22) )continue;
                                    EQPROB=true;
                                 }
                                 if( EQPROB ){
                                    if      ( SHEDGE ){
                                       EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=false;
                                    }else{
                                       EXCLUDED=true;
                                    }
                                    continue;
                                 }else{
                                    if      ( SHEDGE ){
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=true;
                                       continue;
                                    }else{
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }
                                 }

                              }else if( lA5<jA5 ){
                                 qN3A5[0]=iA5;
                                 qN3A5[1]=lA5;
                                 qN3A5[2]=jA5;
                                 SHEDGE=false;
                                 ADJFAC=false;
                                 Coordinates d=( A5[lA5].x -A5[iA5].x);
                                 Coordinates e=( A5[jA5].x -A5[iA5].x);
                                 int jSGN=iSGN
                                       *(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                                 for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                                    int i1=( 3+i0+iSGN)%3;
                                    for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);
                                        j0++){
                                       int j1=( 3+j0+jSGN)%3;
                                       if( (pN3A5[i0]==qN3A5[j0])&&
                                           (pN3A5[i1]==qN3A5[j1]) ){
                                          SHEDGE=true;
                                       }
                                       if( (pN3A5[i0]==qN3A5[j1])&&
                                           (pN3A5[i1]==qN3A5[j0]) ){
                                          ADJFAC=true;
                                       }
                                    }
                                 }
                                 EQPROB=false;
                                 for(int iC5= 0;iC5<pC5&&(!EQPROB);iC5++){
                                    if( !C5[iC5].sub )continue;
                                    if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                                    if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                                    if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                                    rr=( C5[iC5].x -y).rr();
                                    if( rr>(8.00e-22) )continue;
                                    EQPROB=true;
                                 }
                                 if( EQPROB ){
                                    if      ( SHEDGE ){
                                       EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=false;
                                    }else{
                                       EXCLUDED=true;
                                    }
                                    continue;
                                 }else{
                                    if      ( SHEDGE ){
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=true;
                                       continue;
                                    }else{
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }
                                 }
                                 qN3A5[0]=iA5;
                                 qN3A5[1]=lA5;
                                 qN3A5[2]=kA5;
                                 SHEDGE=false;
                                 ADJFAC=false;
                                 d=( A5[lA5].x -A5[iA5].x);
                                 e=( A5[kA5].x -A5[iA5].x);
                                 jSGN=iSGN
                                   *(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                                 for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                                    int i1=( 3+i0+iSGN)%3;
                                    for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);
                                        j0++){
                                       int j1=( 3+j0+jSGN)%3;
                                       if( (pN3A5[i0]==qN3A5[j0])&&
                                           (pN3A5[i1]==qN3A5[j1]) ){
                                          SHEDGE=true;
                                       }
                                       if( (pN3A5[i0]==qN3A5[j1])&&
                                           (pN3A5[i1]==qN3A5[j0]) ){
                                          ADJFAC=true;
                                       }
                                    }
                                 }
                                 EQPROB=false;
                                 for(int iC5= 0;iC5<pC5&&(!EQPROB);iC5++){
                                    if( !C5[iC5].sub )continue;
                                    if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                                    if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                                    if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                                    rr=( C5[iC5].x -y).rr();
                                    if( rr>(8.00e-22) )continue;
                                    EQPROB=true;
                                 }
                                 if( EQPROB ){
                                    if      ( SHEDGE ){
                                       EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=false;
                                    }else{
                                       EXCLUDED=true;
                                    }
                                    continue;
                                 }else{
                                    if      ( SHEDGE ){
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=true;
                                       continue;
                                    }else{
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }
                                 }

                              }else if( lA5<kA5 ){
                                 qN3A5[0]=iA5;
                                 qN3A5[1]=jA5;
                                 qN3A5[2]=lA5;
                                 SHEDGE=false;
                                 ADJFAC=false;
                                 Coordinates d=( A5[jA5].x -A5[iA5].x);
                                 Coordinates e=( A5[lA5].x -A5[iA5].x);
                                 int jSGN=iSGN
                                       *(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                                 for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                                    int i1=( 3+i0+iSGN)%3;
                                    for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);
                                        j0++){
                                       int j1=( 3+j0+jSGN)%3;
                                       if( (pN3A5[i0]==qN3A5[j0])&&
                                           (pN3A5[i1]==qN3A5[j1]) ){
                                          SHEDGE=true;
                                       }
                                       if( (pN3A5[i0]==qN3A5[j1])&&
                                           (pN3A5[i1]==qN3A5[j0]) ){
                                          ADJFAC=true;
                                       }
                                    }
                                 }
                                 EQPROB=false;
                                 for(int iC5= 0;iC5<pC5&&(!EQPROB);iC5++){
                                    if( !C5[iC5].sub )continue;
                                    if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                                    if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                                    if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                                    rr=( C5[iC5].x -y).rr();
                                    if( rr>(8.00e-22) )continue;
                                    EQPROB=true;
                                 }
                                 if( EQPROB ){
                                    if      ( SHEDGE ){
                                       EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=false;
                                    }else{
                                       EXCLUDED=true;
                                    }
                                    continue;
                                 }else{
                                    if      ( SHEDGE ){
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }else if( ADJFAC ){
                                       EXCLUDED=true;
                                       continue;
                                    }else{
                                       if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                                    }
                                 }
                              }else{
                                 if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                              }

                           }
                        }
                        out.FILE3<<" iA5="<< std::setw( 4)<<iA5
                                 <<" jA5="<< std::setw( 4)<<jA5
                                 <<" kA5="<< std::setw( 4)<<kA5
                                 << std::fixed<< std::setprecision( 0)
                                 <<" SGN="<< std::setw( 3)<<SGN
                                 <<' '<<A5[iA5].atm
                                 <<' '<<A5[jA5].atm
                                 <<' '<<A5[kA5].atm
                                 << std::setprecision( 3)
                                 <<" h="<< std::setw( 6)<<h
                                 << std::setprecision(13)
                                 <<" y=";
                              for(int i=0;i<3;i++){
                                 out.FILE3<< std::setw(18)<<y(i);
                              }
                        if( EXCLUDED ){
                           out.FILE3<<" EXC"
                                    <<" lA5="<< std::setw( 4)<<lA5
                                    << std::setprecision(13)
                                    <<" r="<< std::setw(16)<<r
                                    <<" b="<< std::setw(16)<<bl;
                           if      ( ( r -bl)<(-1.00e-11) ){
                           }else if( ( r -bl)<( 1.00e-11) ){
                              if( lA5<kA5 ){
                                 out.FILE3<<" iC5=";
                                 for(int i=0;i<3;i++){
                                    out.FILE3<< std::setw( 4)<<qN3A5[i];
                                 }
                                 out.FILE3<<" EQPROB="
                                          << std::setw( 1)<<int(EQPROB)
                                          <<" SHEDGE="
                                          << std::setw( 1)<<int(SHEDGE)
                                          <<" ADJFAC="
                                          << std::setw( 1)<<int(ADJFAC);
                              }else{
                              }
                           }
                        }else{
                           pC5++;
                        }
                        out.FILE3<< std::endl;
                     }
                  }
               }
            }
            vv.o_Z5sub.clear();
            out.FILE3.flush();
         }
            ENDSTATE=5;
            return;
//          std::exit( 2);
         }
         A5[iA5].nY6++;
      }
      vv.o_Z5sub.clear();
   }


   for(int ijB5= 0;ijB5<nB5;ijB5++){
      if( !B5[ijB5].free )continue;
      int iA5=B5[ijB5].N2A5[0];
      int jA5=B5[ijB5].N2A5[1];
      V5.push_back(tV5());
      V5.push_back(tV5());
      V5[nV5  ].A5=iA5;
      V5[nV5+1].A5=jA5;
      V5[nV5  ].C5=-1;
      V5[nV5+1].C5=-1;
      Coordinates u= B5[ijB5].c;
      Coordinates w;
      double Sthe=( (1.00) -u(2)*u(2));
      if( Sthe>(1.00e-6) ){
         Sthe= std::sqrt( Sthe);
         w(0)= u(1)/Sthe;
         w(1)=-u(0)/Sthe;
         w(2)= (0.00);
      }else{
         Sthe= std::sqrt( (1.00) -u(0)*u(0));
         w(0)= (0.00);
         w(1)= u(2)/Sthe;
         w(2)=-u(1)/Sthe;
      }
      Coordinates y=( B5[ijB5].x +B5[ijB5].r*w);
      double z= (1.00)/( A5[iA5].r +probe);
      V5[nV5  ].x= z*( probe*A5[iA5].x +A5[iA5].r*y);
      z= (1.00)/( A5[jA5].r +probe);
      V5[nV5+1].x= z*( probe*A5[jA5].x +A5[jA5].r*y);
      V5[nV5  ].alp= physics_consts.PI;
      V5[nV5+1].alp= physics_consts.PI;
      V5[nV5  ].bet= (0.00);
      V5[nV5+1].bet= (0.00);
      E6.push_back(tE6());
      E6.push_back(tE6());
      E6[nE6  ].N2V5[0]=(nV5+1);
      E6[nE6  ].N2V5[1]=(nV5+1);
      E6[nE6+1].N2V5[0]=(nV5  );
      E6[nE6+1].N2V5[1]=(nV5  );
      E6[nE6  ].H5=B5[ijB5].N2H5[1];
      E6[nE6+1].H5=B5[ijB5].N2H5[0];
      E6[nE6  ].phi= ((2.)*physics_consts.PI);
      E6[nE6+1].phi= ((2.)*physics_consts.PI);
      E6[nE6  ].jA5=iA5;
      E6[nE6+1].jA5=jA5;
      A5[iA5].Y6.push_back(tA5::tA5Y6());
      A5[iA5].Y6[A5[iA5].nY6].Z6.push_back(tA5::tA5Y6::tA5Y6Z6());
      A5[iA5].Y6[A5[iA5].nY6].Z6[ 0].E6=(nE6+1);
      A5[iA5].Y6[A5[iA5].nY6].nZ6=1;
      A5[iA5].nY6++;
      A5[jA5].Y6.push_back(tA5::tA5Y6());
      A5[jA5].Y6[A5[jA5].nY6].Z6.push_back(tA5::tA5Y6::tA5Y6Z6());
      A5[jA5].Y6[A5[jA5].nY6].Z6[ 0].E6=(nE6  );
      A5[jA5].Y6[A5[jA5].nY6].nZ6=1;
      A5[jA5].nY6++;
      nV5+=2;
      nE6+=2;
   }


   nF7=0;
   for(int iA5= 0;iA5<nA5;iA5++){
      int nY6=A5[iA5].nY6;
      for(int iY6= 0;iY6<nY6;iY6++){
         int nZ6=A5[iA5].Y6[iY6].nZ6;
         if( nZ6<=2 ){
            for(int iZ6= 0;iZ6<nZ6;iZ6++){
               int iE6=A5[iA5].Y6[iY6].Z6[iZ6].E6;
               int iH5=E6[iE6].H5;
               A5[iA5].Y6[iY6].Z6[iZ6].c=H5[iH5].c;
               A5[iA5].Y6[iY6].Z6[iZ6].del= H5[iH5].del;
            }
         }else{
            for(int iZ6= 0;iZ6<nZ6;iZ6++){
               int iE6=A5[iA5].Y6[iY6].Z6[iZ6].E6;
               int iH5=E6[iE6].H5;
               A5[iA5].Y6[iY6].Z6[iZ6].c=H5[iH5].c;
               A5[iA5].Y6[iY6].Z6[iZ6].del= H5[iH5].del;
               int iV5=E6[iE6].N2V5[0];
               int jV5=E6[iE6].N2V5[1];
               Coordinates u=( V5[jV5].x -V5[iV5].x);
               double r= u.r();
               if( r<(1.00e-7) )continue;
               u/=r;
               for(int kZ6= 0;kZ6<nZ6;kZ6++){
                  int kV5=E6[A5[iA5].Y6[iY6].Z6[kZ6].E6].N2V5[0];
                  if( kV5==iV5 )continue;
                  if( kV5==jV5 )continue;
                  Coordinates v=( V5[kV5].x -V5[iV5].x);
                  r= v.r();
                  if( r<(1.00e-7) )continue;
                  v/=r;
                  Coordinates w= cross(v,u);
                  r= w.r();
                  if( r<(1.00e-7) )continue;
                  w/=r;
                  Coordinates d=( V5[iV5].x -A5[iA5].x);
                  double z= dot(d,w);
                  bool MAXIMUMZ=true;
                  for(int lZ6= 0;lZ6<nZ6&&(MAXIMUMZ);lZ6++){
                     int lV5=E6[A5[iA5].Y6[iY6].Z6[lZ6].E6].N2V5[0];
                     if( lV5==iV5 )continue;
                     if( lV5==jV5 )continue;
                     if( lV5==kV5 )continue;
                     d=( V5[lV5].x -A5[iA5].x);
                     double f=( dot(d,w) -z);
                     if( f>(1.00e-8) )MAXIMUMZ=false;
                  }
                  if( !MAXIMUMZ )continue;
                  A5[iA5].Y6[iY6].Z6[iZ6].c=w;
                  A5[iA5].Y6[iY6].Z6[iZ6].del= z;
                  break;
               }
            }
         }
      }
      if      ( nY6==0 ){
      }else if( nY6==1 ){
         F7.push_back(tF7());
         F7[nF7].A5=iA5;
         F7[nF7].X6.push_back( tF7::tF7X6());
         F7[nF7].X6[ 0].Y6=0;
         F7[nF7].nX6=1;
         nF7++;
      }else{
         vv.o_Y6=nY6;
         vv.o_Y6Y6sub.resize(nY6*nY6,false);
         for(int iY6= 0;iY6<(nY6-1);iY6++){
            Coordinates x=( V5[E6[A5[iA5].Y6[iY6].Z6[0].E6].N2V5[0]].x
                           -A5[iA5].x);
            for(int jY6=(iY6+1);jY6<nY6;jY6++){
               Coordinates y=( V5[E6[A5[iA5].Y6[jY6].Z6[0].E6].N2V5[0]].x
                              -A5[iA5].x);
               bool JCONTAINSI=true;
               for(int jZ6= 0;jZ6<A5[iA5].Y6[jY6].nZ6&&(JCONTAINSI);jZ6++){
                  double z= dot(x,A5[iA5].Y6[jY6].Z6[jZ6].c)
                           -A5[iA5].Y6[jY6].Z6[jZ6].del;
                  if( z>(1.00e-7) )JCONTAINSI=false;
               }
               vv.Y6Y6sub(jY6,iY6,JCONTAINSI);
               bool ICONTAINSJ=true;
               for(int iZ6= 0;iZ6<A5[iA5].Y6[iY6].nZ6&&(ICONTAINSJ);iZ6++){
                  double z= dot(y,A5[iA5].Y6[iY6].Z6[iZ6].c)
                           -A5[iA5].Y6[iY6].Z6[iZ6].del;
                  if( z>(1.00e-7) )ICONTAINSJ=false;
               }
               vv.Y6Y6sub(iY6,jY6,ICONTAINSJ);
            }
         }
         vv.o_Y6sub.resize(nY6,false);
         for(int pY6= 0;pY6<nY6;pY6++){
            int iY6=-1;
            for(int jY6= 0;jY6<nY6;jY6++){
               if( vv.Y6sub(jY6) )continue;
               iY6=jY6;
               break;
            }
            if( iY6==-1 )break;
            vv.Y6sub(iY6, true);
            F7.push_back(tF7());
            F7[nF7].A5=iA5;
            F7[nF7].X6.push_back( tF7::tF7X6());
            F7[nF7].X6[ 0].Y6=iY6;
            F7[nF7].nX6=1;
            for(int jY6=(iY6+1);jY6<nY6;jY6++){
               if( vv.Y6sub(jY6) )continue;
               if( vv.Y6Y6sub(iY6,jY6)&&vv.Y6Y6sub(jY6,iY6) ){
                  bool BOUNDARY=true;
                  for(int kY6=(iY6+1);kY6<nY6&&(BOUNDARY);kY6++){
                     if( vv.Y6sub(kY6) )continue;
                     if( kY6==jY6 )continue;
                     if( vv.Y6Y6sub(jY6,kY6)&&vv.Y6Y6sub(kY6,jY6) ){
                        if( !vv.Y6Y6sub(kY6,iY6) )BOUNDARY=false;
                     }
                  }
                  if( !BOUNDARY )continue;
                  vv.Y6sub(jY6, true);
                  F7[nF7].X6.push_back( tF7::tF7X6());
                  F7[nF7].X6[F7[nF7].nX6++].Y6=jY6;
               }
            }
            nF7++;
         }
         vv.o_Y6Y6sub.clear();
         vv.o_Y6sub.clear();
      }
   }


   for(int iA5= 0;iA5<nA5;iA5++){
      A5[iA5].sa= (0.00);
      if( A5[iA5].free ){
         A5[iA5].sa= (4.)*physics_consts.PI*std::pow(A5[iA5].r,2);
      }
   }
   for(int iF5= 0;iF5<nF5;iF5++){
      int iC5=iF5;
      if( !C5[iC5].sub )continue;
      int iV5=E5[F5[iF5].N3E5[0]].N2V5[0];
      int jV5=E5[F5[iF5].N3E5[1]].N2V5[0];
      int kV5=E5[F5[iF5].N3E5[2]].N2V5[0];
      double z=( V5[iV5].bet +V5[jV5].bet +V5[kV5].bet);
      F5[iF5].sa= (probe*probe)*( z -physics_consts.PI);
      double a= (F5[iF5].sa/(3.00));
      int iA5=C5[iC5].N3A5[0];
      int jA5=C5[iC5].N3A5[1];
      int kA5=C5[iC5].N3A5[2];
      A5[iA5].sa+=a;
      A5[jA5].sa+=a;
      A5[kA5].sa+=a;
   }
   for(int iF6= 0;iF6<nF6;iF6++){
      int iE6=F6[iF6].N2E6[0];
      int jE6=F6[iF6].N2E6[1];
      int iH5=E6[iE6].H5;
      int jH5=E6[jE6].H5;
      int iB5=H5[iH5].B5;
      F6[iF6].sa= E6[iE6].phi*( B5[iB5].r*probe*( H5[iH5].the +H5[jH5].the)
                               -(probe*probe)*( std::sin( H5[iH5].the)
                                               +std::sin( H5[jH5].the))
                                );
      double a= (F6[iF6].sa/(2.00));
      int iA5=B5[iB5].N2A5[0];
      int jA5=B5[iB5].N2A5[1];
      A5[iA5].sa+=a;
      A5[jA5].sa+=a;
   }
   for(int iF7= 0;iF7<nF7;iF7++){
      int iA5=F7[iF7].A5;
      int nX6=F7[iF7].nX6;
      double z1= (2.)*physics_consts.PI*( (2.) -nX6);
      double z2= (0.00);
      double z3= (0.00);
      for(int iX6= 0;iX6<nX6;iX6++){
         int iY6=F7[iF7].X6[iX6].Y6;
         int nZ6=A5[iA5].Y6[iY6].nZ6;
         for(int iZ6= 0;iZ6<nZ6;iZ6++){
            int iE6=A5[iA5].Y6[iY6].Z6[iZ6].E6;
            z2+=E6[iE6].phi*std::sin( H5[E6[iE6].H5].the);
            z3+=V5[E6[iE6].N2V5[0]].bet;
         }
      }
      F7[iF7].sa= std::pow(A5[iA5].r,2)*( z1 +z2 -z3);
      double a= F7[iF7].sa;
      A5[iA5].sa+=a;
   }
   for(int ijB5= 0;ijB5<nB5;ijB5++){
      B5[ijB5].sa= (0.00);
      if( B5[ijB5].free ){
         int iH5=B5[ijB5].N2H5[0];
         int jH5=B5[ijB5].N2H5[1];
         B5[ijB5].sa= (2.)*physics_consts.PI*(
            B5[ijB5].r*probe*( H5[iH5].the +H5[jH5].the)
           -(probe*probe)*( std::sin( H5[iH5].the)
                           +std::sin( H5[jH5].the))
            );
         double a= (B5[ijB5].sa/(2.00));
         int iA5=B5[ijB5].N2A5[0];
         int jA5=B5[ijB5].N2A5[1];
         A5[iA5].sa+=a;
         A5[jA5].sa+=a;
      }
   }


   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<"   nA5""   nB5""   nC5""   nH5""   nV5"
                 "   nE5""   nE6""   nF5""   nF6""   nF7\n";
      out.FILE3<< std::setw( 6)<<nA5
               << std::setw( 6)<<nB5
               << std::setw( 6)<<nC5
               << std::setw( 6)<<nH5
               << std::setw( 6)<<nV5
               << std::setw( 6)<<nE5
               << std::setw( 6)<<nE6
               << std::setw( 6)<<nF5
               << std::setw( 6)<<nF6
               << std::setw( 6)<<nF7<<'\n';
   }


   for(int iF5= 0;iF5<nF5;iF5++){
      int iC5=iF5;
      if( !C5[iC5].sub )continue;
      int iE5=F5[iF5].N3E5[0];
      int jE5=F5[iF5].N3E5[1];
      int kE5=F5[iF5].N3E5[2];
      E5[iE5].F5=iF5;
      E5[jE5].F5=iF5;
      E5[kE5].F5=iF5;
   }
   for(int iF6= 0;iF6<nF6;iF6++){
      int iE5=F6[iF6].N2E5[0];
      int jE5=F6[iF6].N2E5[1];
      E5[iE5].F6=iF6;
      E5[jE5].F6=iF6;
      int iE6=F6[iF6].N2E6[0];
      int jE6=F6[iF6].N2E6[1];
      E6[iE6].F6=iF6;
      E6[jE6].F6=iF6;
   }
   for(int iF7= 0;iF7<nF7;iF7++){
      int iA5=F7[iF7].A5;
      int nX6=F7[iF7].nX6;
      for(int iX6= 0;iX6<nX6;iX6++){
         int iY6=F7[iF7].X6[iX6].Y6;
         int nZ6=A5[iA5].Y6[iY6].nZ6;
         for(int iZ6= 0;iZ6<nZ6;iZ6++){
            int iE6=A5[iA5].Y6[iY6].Z6[iZ6].E6;
            E6[iE6].F7=iF7;
         }
      }
   }


// out.FILE3<< std::fixed;
// out.FILE3<<"  iA5"" atm"" typ"" lte"" bur""    F2""   Q2""   A5"
//            " cI5"" nZ5"" nY6"" fre""     sa \n";
// for(int iA5= 0;iA5<nA5;iA5++){
//    out.FILE3<< std::setw( 5)<<iA5
//             <<A5[iA5].atm
//             << std::setw( 4)<<A5[iA5].typ
//             << std::setw( 4)<<A5[iA5].lte
//             << std::setw( 4)<<int(A5[iA5].bur)
//             << std::setw( 6)<<A5[iA5].F2
//             << std::setw( 5)<<A5[iA5].Q2
//             << std::setw( 5)<<A5[iA5].A5
//             << std::setw( 4)<<A5[iA5].cI5
//             << std::setw( 4)<<A5[iA5].nZ5
//             << std::setw( 4)<<A5[iA5].nY6
//             << std::setw( 4)<<int(A5[iA5].free)
//             << std::setprecision(3)<< std::setw( 8)<<A5[iA5].sa<<'\n';
// }
// out.FILE3<<"  iA5"" iZ5""  Z5E6\n";
// for(int iA5= 0;iA5<nA5;iA5++){
//    int nZ5=A5[iA5].nZ5;
//    for(int iZ5= 0;iZ5<nZ5;iZ5++){
//       out.FILE3<< std::setw( 5)<<iA5
//                << std::setw( 4)<<iZ5
//                << std::setw( 6)<<A5[iA5].Z5[iZ5].E6<<'\n';
//    }
// }
// out.FILE3<<"  iA5"" iY6"" nZ6\n";
// for(int iA5= 0;iA5<nA5;iA5++){
//    int nY6=A5[iA5].nY6;
//    for(int iY6= 0;iY6<nY6;iY6++){
//       out.FILE3<< std::setw( 5)<<iA5
//                << std::setw( 4)<<iY6
//                << std::setw( 4)<<A5[iA5].Y6[iY6].nZ6<<'\n';
//    }
// }
// out.FILE3<<"  iA5"" iY6"" iZ6""    E6\n";
// for(int iA5= 0;iA5<nA5;iA5++){
//    int nY6=A5[iA5].nY6;
//    for(int iY6= 0;iY6<nY6;iY6++){
//       int nZ6=A5[iA5].Y6[iY6].nZ6;
//       for(int iZ6= 0;iZ6<nZ6;iZ6++){
//          out.FILE3<< std::setw( 5)<<iA5
//                   << std::setw( 4)<<iY6
//                   << std::setw( 4)<<iZ6
//                   << std::setw( 6)<<A5[iA5].Y6[iY6].Z6[iZ6].E6<<'\n';
//       }
//    }
// }
// out.FILE3<<"   iB5"" fre"" cir"" N2A5     "" nX5"
//            "  N2H5      ""           B5x         "
//            "        B5c      ""  B5r ""   B5sa \n";
// for(int iB5= 0;iB5<nB5;iB5++){
//    out.FILE3<< std::setw( 6)<<iB5
//             << std::setw( 4)<<int(B5[iB5].free)
//             << std::setw( 4)<<int(B5[iB5].circ);
//    for(int i=0;i<2;i++){
//       out.FILE3<< std::setw( 5)<<B5[iB5].N2A5[i];
//    }
//    out.FILE3<< std::setw( 4)<<B5[iB5].nX5;
//    for(int i=0;i<2;i++){
//       out.FILE3<< std::setw( 6)<<B5[iB5].N2H5[i];
//    }
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 7)<<B5[iB5].x(i);
//    }
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 5)<<B5[iB5].c(i);
//    }
//    out.FILE3<< std::setprecision(2)
//             << std::setw( 6)<<B5[iB5].r
//             << std::setprecision(3)
//             << std::setw( 8)<<B5[iB5].sa<<'\n';
// }
// out.FILE3<<"   iB5"" iX5""  X5E5""  X5the \n";
// for(int iB5= 0;iB5<nB5;iB5++){
//    int nX5=B5[iB5].nX5;
//    for(int iX5= 0;iX5<nX5;iX5++){
//       out.FILE3<< std::setw( 6)<<iB5
//                << std::setw( 4)<<iX5
//                << std::setw( 6)<<B5[iB5].X5[iX5].E5
//                << std::setprecision(5)
//                << std::setw( 8)<<B5[iB5].X5[iX5].the<<'\n';
//    }
// }
// out.FILE3<<"   iC5"" N3A5          "
//            "        C5c      ""        C5e      ""  C5h "
//            "           C5x         \n";
// for(int iC5= 0;iC5<nC5;iC5++){
//    if( !C5[iC5].sub )continue;
//    out.FILE3<< std::setw( 6)<<iC5;
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 5)<<C5[iC5].N3A5[i];
//    }
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 5)<<C5[iC5].c(i);
//    }
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 5)<<C5[iC5].e(i);
//    }
//    out.FILE3<< std::setprecision(2);
//    out.FILE3<< std::setw( 6)<<C5[iC5].h;
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 7)<<C5[iC5].x(i);
//    }
//    out.FILE3<<'\n';
// }
// out.FILE3<<"   iH5""    B5""   A5""           H5x         "
//            "        H5c      ""    r ""  del ""    the \n";
// for(int iH5= 0;iH5<nH5;iH5++){
//    out.FILE3<< std::setw( 6)<<iH5
//             << std::setw( 6)<<H5[iH5].B5
//             << std::setw( 5)<<H5[iH5].A5;
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 7)<<H5[iH5].x(i);
//    }
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 5)<<H5[iH5].c(i);
//    }
//    out.FILE3<< std::setprecision(2)
//             << std::setw( 6)<<H5[iH5].r
//             << std::setw( 6)<<H5[iH5].del
//             << std::setprecision(3)
//             << std::setw( 8)<<H5[iH5].the<<'\n';
// }
// out.FILE3<<"   iV5""   A5""    C5""          V5x       "
//            "  V5alp ""  V5bet \n";
// for(int iV5= 0;iV5<nV5;iV5++){
//    out.FILE3<< std::setw( 6)<<iV5
//             << std::setw( 5)<<V5[iV5].A5
//             << std::setw( 6)<<V5[iV5].C5;
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 6)<<V5[iV5].x(i);
//    }
//    out.FILE3<< std::setprecision(3)
//             << std::setw( 8)<<V5[iV5].alp
//             << std::setw( 8)<<V5[iV5].bet<<'\n';
// }
// out.FILE3<<"   iE5""  N2V5      ""       E5c       ""    F5""    F6\n";
// for(int iE5= 0;iE5<nE5;iE5++){
//    out.FILE3<< std::setw( 6)<<iE5;
//    for(int i=0;i<2;i++){
//       out.FILE3<< std::setw( 6)<<E5[iE5].N2V5[i];
//    }
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 5)<<E5[iE5].c(i);
//    }
//    out.FILE3<< std::setw( 6)<<E5[iE5].F5
//             << std::setw( 6)<<E5[iE5].F6<<'\n';
// }
// out.FILE3<<"   iE6""  N2V5      ""    H5""    phi ""    F6""    F7\n";
// for(int iE6= 0;iE6<nE6;iE6++){
//    out.FILE3<< std::setw( 6)<<iE6;
//    for(int i=0;i<2;i++){
//       out.FILE3<< std::setw( 6)<<E6[iE6].N2V5[i];
//    }
//    out.FILE3<< std::setw( 6)<<E6[iE6].H5
//             << std::setprecision(3)
//             << std::setw( 8)<<E6[iE6].phi
//             << std::setw( 6)<<E6[iE6].F6
//             << std::setw( 6)<<E6[iE6].F7<<'\n';
// }
// out.FILE3<<"   iF5""  N3E5            ""CUSP""   F5sa \n";
// for(int iF5= 0;iF5<nF5;iF5++){
//    int iC5=iF5;
//    if( !C5[iC5].sub )continue;
//    out.FILE3<< std::setw( 6)<<iF5;
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 6)<<F5[iF5].N3E5[i];
//    }
//    out.FILE3<< std::setw( 4)<<int(F5[iF5].CUSP)
//             << std::setprecision(3)
//             << std::setw( 8)<<F5[iF5].sa<<'\n';
// }
// out.FILE3<<"   iF6""  N2E5      ""  N2E6      ""CUSP""   F6sa \n";
// for(int iF6= 0;iF6<nF6;iF6++){
//    out.FILE3<< std::setw( 6)<<iF6;
//    for(int i=0;i<2;i++){
//       out.FILE3<< std::setw( 6)<<F6[iF6].N2E5[i];
//    }
//    for(int i=0;i<2;i++){
//       out.FILE3<< std::setw( 6)<<F6[iF6].N2E6[i];
//    }
//    out.FILE3<< std::setw( 4)<<int(F6[iF6].CUSP)
//             << std::setprecision(3)
//             << std::setw( 8)<<F6[iF6].sa<<'\n';
// }
// out.FILE3<<"   iF7""   A5"" nX6""   F7sa \n";
// for(int iF7= 0;iF7<nF7;iF7++){
//    out.FILE3<< std::setw( 6)<<iF7
//             << std::setw( 5)<<F7[iF7].A5
//             << std::setw( 4)<<F7[iF7].nX6
//             << std::setprecision(3)
//             << std::setw( 8)<<F7[iF7].sa<<'\n';
// }
// out.FILE3<<"   iF7"" iX6"" X6Y6\n";
// for(int iF7= 0;iF7<nF7;iF7++){
//    int nX6=F7[iF7].nX6;
//    for(int iX6= 0;iX6<nX6;iX6++){
//       out.FILE3<< std::setw( 6)<<iF7
//                << std::setw( 4)<<iX6
//                << std::setw( 5)<<F7[iF7].X6[iX6].Y6<<'\n';
//    }
// }
// out.FILE3.flush();
   return;
}
