#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../med/Dielec_Continu.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_med_sphere {
private:
   std::vector<Coordinates> o_Vn;       //
   std::vector<Rotation_Matrix> o_FP;   //triple of vertices
   std::vector<Coordinates> o_Tq;       //triple of coeffs for dot
   std::vector<double> o_Tsgn;          //sign for offsets to vertices
public:
   MEM_med_sphere():
      o_Vn(12),
      o_FP(20),
      o_Tq(16),
      o_Tsgn(16)
   {
   }
   Coordinates& Vn(int i){
      return o_Vn.at( i);  }
   Rotation_Matrix& FP(int i){
      return o_FP.at( i);  }
   Coordinates& Tq(int i){
      return o_Tq.at( i);  }
   double& Tsgn(int i){
      return o_Tsgn.at( i);  }
};

void Dielec_Continu::MED_SPHERE(const DAT_PHYSICS_CONSTS& physics_consts,
                                Output_Streams& out){
   MEM_med_sphere vv;
//
//
// vertices on a unit sphere
//
   double Sz= std::sqrt( (2.00)/( (5.00) +std::sqrt( 5.00)));
   double the= (2.00)*std::asin( Sz);
   double Cthe= std::cos( the);
   double Sthe= std::sin( the);
   double dphi= (2.00)*physics_consts.PI/(5.00);
   vv.Vn( 0)(0)=( 0.00);
   vv.Vn( 0)(1)=( 0.00);
   vv.Vn( 0)(2)=( 1.00);
   double phi= (0.00);
   for(int iV= 1;iV< 6;iV++){
      double Cphi= std::cos( phi);
      double Sphi= std::sin( phi);
      vv.Vn(iV)(0)= Sthe*Cphi;
      vv.Vn(iV)(1)= Sthe*Sphi;
      vv.Vn(iV)(2)= Cthe;
      phi+=dphi;
   }
   phi= (dphi/(2.00));
   for(int iV= 6;iV<11;iV++){
      double Cphi= std::cos( phi);
      double Sphi= std::sin( phi);
      vv.Vn(iV)(0)= Sthe*Cphi;
      vv.Vn(iV)(1)= Sthe*Sphi;
      vv.Vn(iV)(2)=-Cthe;
      phi+=dphi;
   }
   vv.Vn(11)(0)=( 0.00);
   vv.Vn(11)(1)=( 0.00);
   vv.Vn(11)(2)=(-1.00);
//
//
// faces of an icosohedren
//
   for(int i=0;i<3;i++){
      vv.FP( 0)(i,0)= vv.Vn( 0)(i);
      vv.FP( 0)(i,1)= vv.Vn( 1)(i);
      vv.FP( 0)(i,2)= vv.Vn( 2)(i);
      vv.FP( 1)(i,0)= vv.Vn( 1)(i);
      vv.FP( 1)(i,1)= vv.Vn( 6)(i);
      vv.FP( 1)(i,2)= vv.Vn( 2)(i);
      vv.FP( 2)(i,0)= vv.Vn( 0)(i);
      vv.FP( 2)(i,1)= vv.Vn( 2)(i);
      vv.FP( 2)(i,2)= vv.Vn( 3)(i);
      vv.FP( 3)(i,0)= vv.Vn( 2)(i);
      vv.FP( 3)(i,1)= vv.Vn( 7)(i);
      vv.FP( 3)(i,2)= vv.Vn( 3)(i);
      vv.FP( 4)(i,0)= vv.Vn( 0)(i);
      vv.FP( 4)(i,1)= vv.Vn( 3)(i);
      vv.FP( 4)(i,2)= vv.Vn( 4)(i);
      vv.FP( 5)(i,0)= vv.Vn( 3)(i);
      vv.FP( 5)(i,1)= vv.Vn( 8)(i);
      vv.FP( 5)(i,2)= vv.Vn( 4)(i);
      vv.FP( 6)(i,0)= vv.Vn( 0)(i);
      vv.FP( 6)(i,1)= vv.Vn( 4)(i);
      vv.FP( 6)(i,2)= vv.Vn( 5)(i);
      vv.FP( 7)(i,0)= vv.Vn( 4)(i);
      vv.FP( 7)(i,1)= vv.Vn( 9)(i);
      vv.FP( 7)(i,2)= vv.Vn( 5)(i);
      vv.FP( 8)(i,0)= vv.Vn( 0)(i);
      vv.FP( 8)(i,1)= vv.Vn( 5)(i);
      vv.FP( 8)(i,2)= vv.Vn( 1)(i);
      vv.FP( 9)(i,0)= vv.Vn( 5)(i);
      vv.FP( 9)(i,1)= vv.Vn(10)(i);
      vv.FP( 9)(i,2)= vv.Vn( 1)(i);
      vv.FP(10)(i,0)= vv.Vn( 2)(i);
      vv.FP(10)(i,1)= vv.Vn( 6)(i);
      vv.FP(10)(i,2)= vv.Vn( 7)(i);
      vv.FP(11)(i,0)= vv.Vn( 7)(i);
      vv.FP(11)(i,1)= vv.Vn( 6)(i);
      vv.FP(11)(i,2)= vv.Vn(11)(i);
      vv.FP(12)(i,0)= vv.Vn( 3)(i);
      vv.FP(12)(i,1)= vv.Vn( 7)(i);
      vv.FP(12)(i,2)= vv.Vn( 8)(i);
      vv.FP(13)(i,0)= vv.Vn( 8)(i);
      vv.FP(13)(i,1)= vv.Vn( 7)(i);
      vv.FP(13)(i,2)= vv.Vn(11)(i);
      vv.FP(14)(i,0)= vv.Vn( 4)(i);
      vv.FP(14)(i,1)= vv.Vn( 8)(i);
      vv.FP(14)(i,2)= vv.Vn( 9)(i);
      vv.FP(15)(i,0)= vv.Vn( 9)(i);
      vv.FP(15)(i,1)= vv.Vn( 8)(i);
      vv.FP(15)(i,2)= vv.Vn(11)(i);
      vv.FP(16)(i,0)= vv.Vn( 5)(i);
      vv.FP(16)(i,1)= vv.Vn( 9)(i);
      vv.FP(16)(i,2)= vv.Vn(10)(i);
      vv.FP(17)(i,0)= vv.Vn(10)(i);
      vv.FP(17)(i,1)= vv.Vn( 9)(i);
      vv.FP(17)(i,2)= vv.Vn(11)(i);
      vv.FP(18)(i,0)= vv.Vn( 1)(i);
      vv.FP(18)(i,1)= vv.Vn(10)(i);
      vv.FP(18)(i,2)= vv.Vn( 6)(i);
      vv.FP(19)(i,0)= vv.Vn( 6)(i);
      vv.FP(19)(i,1)= vv.Vn(10)(i);
      vv.FP(19)(i,2)= vv.Vn(11)(i);
   }
//
//
// surface elements on a face
//
   vv.Tq( 0)(0)= (10.00);
   vv.Tq( 0)(1)= ( 1.00);
   vv.Tq( 0)(2)= ( 1.00);
   vv.Tq( 1)(0)= ( 8.00);
   vv.Tq( 1)(1)= ( 2.00);
   vv.Tq( 1)(2)= ( 2.00);
   vv.Tq( 2)(0)= ( 7.00);
   vv.Tq( 2)(1)= ( 4.00);
   vv.Tq( 2)(2)= ( 1.00);
   vv.Tq( 3)(0)= ( 5.00);
   vv.Tq( 3)(1)= ( 5.00);
   vv.Tq( 3)(2)= ( 2.00);
   vv.Tq( 4)(0)= ( 4.00);
   vv.Tq( 4)(1)= ( 7.00);
   vv.Tq( 4)(2)= ( 1.00);
   vv.Tq( 5)(0)= ( 2.00);
   vv.Tq( 5)(1)= ( 8.00);
   vv.Tq( 5)(2)= ( 2.00);
   vv.Tq( 6)(0)= ( 1.00);
   vv.Tq( 6)(1)= (10.00);
   vv.Tq( 6)(2)= ( 1.00);
   vv.Tq( 7)(0)= ( 7.00);
   vv.Tq( 7)(1)= ( 1.00);
   vv.Tq( 7)(2)= ( 4.00);
   vv.Tq( 8)(0)= ( 5.00);
   vv.Tq( 8)(1)= ( 2.00);
   vv.Tq( 8)(2)= ( 5.00);
   vv.Tq( 9)(0)= ( 4.00);
   vv.Tq( 9)(1)= ( 4.00);
   vv.Tq( 9)(2)= ( 4.00);
   vv.Tq(10)(0)= ( 2.00);
   vv.Tq(10)(1)= ( 5.00);
   vv.Tq(10)(2)= ( 5.00);
   vv.Tq(11)(0)= ( 1.00);
   vv.Tq(11)(1)= ( 7.00);
   vv.Tq(11)(2)= ( 4.00);
   vv.Tq(12)(0)= ( 4.00);
   vv.Tq(12)(1)= ( 1.00);
   vv.Tq(12)(2)= ( 7.00);
   vv.Tq(13)(0)= ( 2.00);
   vv.Tq(13)(1)= ( 2.00);
   vv.Tq(13)(2)= ( 8.00);
   vv.Tq(14)(0)= ( 1.00);
   vv.Tq(14)(1)= ( 4.00);
   vv.Tq(14)(2)= ( 7.00);
   vv.Tq(15)(0)= ( 1.00);
   vv.Tq(15)(1)= ( 1.00);
   vv.Tq(15)(2)= (10.00);
   vv.Tsgn( 0)=( 1.00);
   vv.Tsgn( 1)=(-1.00);
   vv.Tsgn( 2)=( 1.00);
   vv.Tsgn( 3)=(-1.00);
   vv.Tsgn( 4)=( 1.00);
   vv.Tsgn( 5)=(-1.00);
   vv.Tsgn( 6)=( 1.00);
   vv.Tsgn( 7)=( 1.00);
   vv.Tsgn( 8)=(-1.00);
   vv.Tsgn( 9)=( 1.00);
   vv.Tsgn(10)=(-1.00);
   vv.Tsgn(11)=( 1.00);
   vv.Tsgn(12)=( 1.00);
   vv.Tsgn(13)=(-1.00);
   vv.Tsgn(14)=( 1.00);
   vv.Tsgn(15)=( 1.00);
//
//
// surface elements on a unit sphere
//
   for(int pF= 0;pF<20;pF++){
      for(int pT= 0;pT<16;pT++){
         FTspher(pF,pT).x=(vv.FP(pF)*vv.Tq(pT)).normalize();
         FTspher(pF,pT).c=FTspher(pF,pT).x;
         FTspher(pF,pT).r= (1.00);
         FTspher(pF,pT).K6.resize(1);
         FTspher(pF,pT).K6[0].L6.resize(3);
         for(int iL6=0;iL6<3;iL6++){
            Coordinates q=vv.Tq(pT);
            for(int j=0;j<3;j++){
               if( j==iL6 ){
                  q(j)+=((2.00)*vv.Tsgn(pT));
               }else{
                  q(j)-=vv.Tsgn(pT);
               }
            }
            FTspher(pF,pT).K6[0].L6[iL6].v=(vv.FP(pF)*q).normalize();
         }
         for(int iL6=0;iL6<3;iL6++){
            int jL6=(iL6+1)%3;
            FTspher(pF,pT).K6[0].L6[iL6].c=
                cross(FTspher(pF,pT).K6[0].L6[jL6].v,
                      FTspher(pF,pT).K6[0].L6[iL6].v).normalize();
            FTspher(pF,pT).K6[0].L6[iL6].del= (0.00);
            FTspher(pF,pT).K6[0].L6[iL6].phi=
                std::acos( dot(FTspher(pF,pT).K6[0].L6[jL6].v,
                               FTspher(pF,pT).K6[0].L6[iL6].v));
            FTspher(pF,pT).K6[0].L6[iL6].the= (0.00);
            FTspher(pF,pT).K6[0].L6[iL6].jA5=-1;
         }
         FTspher(pF,pT).a= (2.00)*physics_consts.PI;
         for(int iL6=0;iL6<3;iL6++){
            int jL6=(iL6+1)%3;
            FTspher(pF,pT).K6[0].L6[jL6].bet=
                std::acos( dot(FTspher(pF,pT).K6[0].L6[jL6].c,
                               FTspher(pF,pT).K6[0].L6[iL6].c));
            FTspher(pF,pT).a-=FTspher(pF,pT).K6[0].L6[jL6].bet;
         }
         FTspher(pF,pT).grp=pF;
         FTspher(pF,pT).typ=1;
      }
   }
//
//
// surface elements on a probe sphere
//
   for(int pF= 0;pF<20;pF++){
      for(int pT= 0;pT<16;pT++){
         FTprobe(pF,pT)=FTspher(pF,pT);
         FTprobe(pF,pT).x*=probe;
         FTprobe(pF,pT).c*=(-1.00);
         FTprobe(pF,pT).r*=probe;
         FTprobe(pF,pT).a*=(probe*probe);
         FTprobe(pF,pT).grp=0;
         FTprobe(pF,pT).typ=-1;
         for(int iL6=0;iL6<3;iL6++){
            FTprobe(pF,pT).K6[0].L6[iL6].v*=probe;
         }
      }
   }
//
//
// diagnostic output
//
// out.FILE3<< std::fixed<< std::setprecision(3);
// out.FILE3<<" iF"" iT""            x         ""    a  "" grp\n";
// for(int pF= 0;pF<20;pF++){
//    for(int pT= 0;pT<16;pT++){
//       out.FILE3<< std::setw( 3)<<pF
//                << std::setw( 3)<<pT<<' ';
//       for(int i=0;i<3;i++){
//          out.FILE3<< std::setw( 7)<<FTspher(pF,pT).x(i);
//       }
//       out.FILE3<< std::setw( 7)<<FTspher(pF,pT).a
//                << std::setw( 4)<<FTspher(pF,pT).grp<<'\n';
//    }
// }
// out.FILE3<<" iF"" iT"" iL""            v         ""            c         "
//            "   phi ""   bet \n";
// for(int pF= 0;pF<20;pF++){
//    for(int pT= 0;pT<16;pT++){
//       for(int iL6=0;iL6<3;iL6++){
//          out.FILE3<< std::setw( 3)<<pF
//                   << std::setw( 3)<<pT
//                   << std::setw( 3)<<iL6<<' ';
//          for(int i=0;i<3;i++){
//             out.FILE3<< std::setw( 7)<<FTspher(pF,pT).K6[0].L6[iL6].v(i);
//          }
//          out.FILE3<<' ';
//          for(int i=0;i<3;i++){
//             out.FILE3<< std::setw( 7)<<FTspher(pF,pT).K6[0].L6[iL6].c(i);
//          }
//          out.FILE3<< std::setw( 7)<<FTspher(pF,pT).K6[0].L6[iL6].phi
//                   << std::setw( 7)<<FTspher(pF,pT).K6[0].L6[iL6].bet<<'\n';
//       }
//    }
// }
   return;
}
