#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../med/Dielec_Continu.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <iomanip>

void Dielec_Continu::MED_MOL(Phi_Automatic& aut,
                             const DAT_PHYSICS_CONSTS& physics_consts,
                             const DAT_ENERGY_PARAMS& energy_params,
                             Output_Streams& out,
                             const Mechanical_System& mol,
                             const Subset_Contracted_System::tM3& con,
                             Conf_Dependent_System& dep){
//
//
// initiate A5
//
   nA5=bse_nA5;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( bse_nA5==0 ){
         if( !con.Z0[iZ0].sub ){
            int mB3=con.Z0[iZ0].B3a;
            int nB3=(mB3-1+con.Z0[iZ0].cB3);
            for(int iB3=mB3;iB3<=nB3;iB3++){
               int iF2=con.B3[iB3].F2;
               int lte=con.F2[iF2].lte;
               int iT2=con.F2[iF2].typ;
               if( (lte<0)||(iT2>17) ){
               }else{
                  std::string atm=con.F2[iF2].atm;
                  A5[nA5].atm=atm;
                  if( atm[0]=='+' )atm=' '+atm.substr(1,3);
                  A5[nA5].lte=lte;
                  A5[nA5].typ=iT2;
                  A5[nA5].x=aut.F2[iF2].x;
                  A5[nA5].q=aut.F2[iF2].q;
                  A5[nA5].r= energy_params.T2[iT2].Rsph;
                  A5[nA5].CHG=false;
                  int iR0=con.F2[iF2].R0;
                  char c1=mol.R0[iR0].c1;
                  std::string aa=mol.R0[iR0].aa;
                  A5[nA5].R0=iR0;
                  A5[nA5].N2=1;
                  A5[nA5].aa=aa;
                  A5[nA5].sgn=0;
                  A5[nA5].MED_MOL_CHG(physics_consts,c1,aa,atm);
                  A5[nA5].bur=dep.F2[iF2].bur;
                  if( iT2== 7 ){
                     bool MATCHED=false;
                     for(int jB3=mB3;jB3<iB3;jB3++){
                        int jF2=con.B3[jB3].F2;
                        double zz=( aut.F2[jF2].x -aut.F2[iF2].x).rr();
                        if( zz<( 1.00e-8) ){
                           int jA5=F2[jF2].A5;
                           A5[nA5].F2=jF2;
                           A5[nA5].A5=jA5;
                           F2[iF2].A5=jA5;
                           A5[jA5].F2=iF2;
                           A5[jA5].A5=nA5;
                           F2[jF2].A5=nA5;
                           MATCHED=true;
                           break;
                        }
                     }
                     if( !MATCHED ){
                        std::cerr<<"ERROR: No match for satellite "
                                   "interaction site to physical atom.\n";
                        std::exit( 2);
                     }
                  }else{
                     A5[nA5].F2=iF2;
                     A5[nA5].A5=nA5;
                     F2[iF2].A5=nA5;
                  }
                  A5[nA5].Q2=mQ2;
                  nA5++;
               }
            }
         }

      }else{
         if( con.Z0[iZ0].sub ){
            int mB3=con.Z0[iZ0].B3a;
            int nB3=(mB3-1+con.Z0[iZ0].cB3);
            for(int iB3=mB3;iB3<=nB3;iB3++){
               int iF2=con.B3[iB3].F2;
               int lte=con.F2[iF2].lte;
               int iT2=con.F2[iF2].typ;
               if( (lte<0)||(iT2>17) ){
               }else{
                  std::string atm=con.F2[iF2].atm;
                  A5[nA5].atm=atm;
                  if( atm[0]=='+' )atm=' '+atm.substr(1,3);
                  A5[nA5].lte=lte;
                  A5[nA5].typ=iT2;
                  A5[nA5].x=aut.F2[iF2].x;
                  A5[nA5].q=aut.F2[iF2].q;
                  A5[nA5].r= energy_params.T2[iT2].Rsph;
                  A5[nA5].CHG=false;
                  int iR0=con.F2[iF2].R0;
                  char c1=mol.R0[iR0].c1;
                  std::string aa=mol.R0[iR0].aa;
                  A5[nA5].R0=iR0;
                  A5[nA5].N2=1;
                  A5[nA5].aa=aa;
                  A5[nA5].sgn=0;
                  A5[nA5].MED_MOL_CHG(physics_consts,c1,aa,atm);
                  A5[nA5].bur=dep.F2[iF2].bur;
                  if( iT2== 7 ){
                     bool MATCHED=false;
                     for(int jB3=mB3;jB3<iB3;jB3++){
                        int jF2=con.B3[jB3].F2;
                        double zz=( aut.F2[jF2].x -aut.F2[iF2].x).rr();
                        if( zz<( 1.00e-8) ){
                           int jA5=F2[jF2].A5;
                           A5[nA5].F2=jF2;
                           A5[nA5].A5=jA5;
                           F2[iF2].A5=jA5;
                           A5[jA5].F2=iF2;
                           A5[jA5].A5=nA5;
                           F2[jF2].A5=nA5;
                           MATCHED=true;
                           break;
                        }
                     }
                     if( !MATCHED ){
                        std::cerr<<"ERROR: No match for satellite "
                                   "interaction site to physical atom.\n";
                        std::exit( 2);
                     }
                  }else{
                     A5[nA5].F2=iF2;
                     A5[nA5].A5=nA5;
                     F2[iF2].A5=nA5;
                  }
                  A5[nA5].Q2=mQ2;
                  nA5++;
               }
            }
         }

         if( nQ2>mQ2 ){
            int iQ2=mQ2;
            int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
            for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
               if( con.Q2[iQ2].omg==1 ){
                  int L=iQ2hold;
                  iQ2hold=(iQ2+1);
                  iQ2=L;
               }else{
                  iQ2++;
               }
               if( Q2[iQ2].cut )continue;
               int pF2=con.Q2[iQ2].bseF2;
               int pA5=F2[pF2].A5;
               std::string sat='+'+con.F2[pF2].atm.substr(1,3);
               int mG3=con.Q2[iQ2].G3a;
               int nG3=(mG3-1+con.Q2[iQ2].cG3);
               for(int iG3=mG3;iG3<=nG3;iG3++){
                  int iF2=con.G3[iG3].F2;
                  int lte=con.F2[iF2].lte;
                  int iT2=con.F2[iF2].typ;
                  if( (lte<0)||(iT2>17) ){
                  }else{
                     std::string atm=con.F2[iF2].atm;
                     A5[nA5].atm=atm;
                     if( atm[0]=='+' )atm=' '+atm.substr(1,3);
                     A5[nA5].lte=lte;
                     A5[nA5].typ=iT2;
                     A5[nA5].x=aut.F2[iF2].x;
                     A5[nA5].q=aut.F2[iF2].q;
                     A5[nA5].r= energy_params.T2[iT2].Rsph;
                     A5[nA5].CHG=false;
                     int iR0=con.F2[iF2].R0;
                     char c1=mol.R0[iR0].c1;
                     std::string aa=mol.R0[iR0].aa;
                     A5[nA5].R0=iR0;
                     A5[nA5].N2=1;
                     A5[nA5].aa=aa;
                     A5[nA5].sgn=0;
                     A5[nA5].MED_MOL_CHG(physics_consts,c1,aa,atm);
                     A5[nA5].bur=dep.F2[iF2].bur;
                     if( iT2== 7 ){
                        if( con.F2[iF2].atm==sat ){
                           A5[nA5].F2=pF2;
                           A5[nA5].A5=pA5;
                           F2[iF2].A5=pA5;
                           A5[nA5].Q2=A5[pA5].Q2;
                           A5[pA5].F2=iF2;
                           A5[pA5].A5=nA5;
                           F2[pF2].A5=nA5;
                           A5[pA5].Q2=iQ2;
                           sat="    ";
                        }else{
                           bool MATCHED=false;
                           for(int jG3=mG3;jG3<=nG3;jG3++){
                              int jF2=con.G3[jG3].F2;
                              double zz=( aut.F2[jF2].x -aut.F2[iF2].x).rr();
                              if( zz<( 1.00e-8) ){
                                 int jA5=F2[jF2].A5;
                                 A5[nA5].F2=jF2;
                                 A5[nA5].A5=jA5;
                                 F2[iF2].A5=jA5;
                                 A5[nA5].Q2=iQ2;
                                 A5[jA5].F2=iF2;
                                 A5[jA5].A5=nA5;
                                 F2[jF2].A5=nA5;
                                 MATCHED=true;
                                 break;
                              }
                           }
                           if( !MATCHED ){
                              std::cerr<<"ERROR: No match for satellite "
                                         "interaction site to physical atom.\n";
                              std::exit( 2);
                           }
                        }
                     }else{
                        A5[nA5].F2=iF2;
                        A5[nA5].A5=nA5;
                        A5[nA5].Q2=iQ2;
                        F2[iF2].A5=nA5;
                     }
                     nA5++;
                  }
               }
            }
         }
      }
   }

   probe= energy_params.Rprobe;

// if( bse_nA5==0 ){
// }else{
//    out.FILE3<< std::fixed;
//    out.FILE3<<" nA5\n";
//    out.FILE3<< std::setw( 4)<<nA5<<'\n';
//    out.FILE3<<" iA5 "" atm"" iR0 "" aa ""           A5x          "
//               " typ"" lte"" bur""   A5r  ""   F2 ""  Q2 ""  A5 "
//               " CHG"" sgn"<<'\n';
//    for(int iA5= 0;iA5<nA5;iA5++){
//       out.FILE3<< std::setw( 4)<<iA5<<' '
//                <<A5[iA5].atm
//                << std::setw( 4)<<(A5[iA5].R0+ 1)<<' '
//                <<A5[iA5].aa;
//       out.FILE3<< std::setprecision(2);
//       for(int i=0;i<3;i++){
//          out.FILE3<< std::setw( 8)<<A5[iA5].x(i);
//       }
//       out.FILE3<< std::setprecision(3);
//       out.FILE3<< std::setw( 4)<<A5[iA5].typ
//                << std::setw( 4)<<A5[iA5].lte
//                << std::setw( 4)<<int(A5[iA5].bur)
//                << std::setw( 8)<<A5[iA5].r
//                << std::setw( 6)<<A5[iA5].F2
//                << std::setw( 5)<<A5[iA5].Q2
//                << std::setw( 5)<<A5[iA5].A5
//                << std::setw( 4)<<int(A5[iA5].CHG)
//                << std::setw( 4)<<A5[iA5].sgn<<'\n';
//    }
// }
   return;
}
