#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../med/Dielec_Continu.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_med_func {
private:
   std::vector<int> o_A5don;            //{1=donor,0=neither,-1 or -2=acceptor}
public:
   MEM_med_func(int o):
      o_A5don(o)
   {
   }
   int& A5don(int i){
      return o_A5don.at( i);  }
};

void Dielec_Continu::MED_FUNC(const DAT_PHYSICS_CONSTS& physics_consts,
                              const DAT_ENERGY_PARAMS& energy_params,
                              const Structure& str,
                              Output_Streams& out){
//
//
// water entropy correction
//
   MEM_med_func vv(nA5);
   for(int iA5= 0;iA5<nA5;iA5++){
      int iT2=A5[iA5].typ;
      if( (iT2== 2)||(iT2== 5) ){
         if( A5[iA5].sa>(16.40) )vv.A5don(iA5)=1;
      }else if( (iT2==12)||(iT2==13)||(iT2==14)||(iT2==17) ){
         if( A5[iA5].sa>(20.25) )vv.A5don(iA5)=-1;
         if( A5[iA5].sa>(40.50) )vv.A5don(iA5)=-2;
      }else{
         vv.A5don(iA5)=0;
      }
   }
   Fen= (0.00);
   for(int iA5= 0;iA5<nA5;iA5++){
      if( vv.A5don(iA5)==0 )continue;
      double z= vv.A5don(iA5);
      for(int iI5= 0;iI5<A5[iA5].cI5;iI5++){
         int jA5=A5[iA5].I5[iI5].A5;
         z+=vv.A5don(jA5);
      }
      z= (.41068)*( std::abs( z +(1.00)) -(1.00));
      Fen+=z;
   }
//
//
// QSAR properties and solubility
//
   Qps= (physics_consts.CAL*Fps);
   Qss= (physics_consts.CAL*Fss);

   double ANGANG= (physics_consts.ANG*physics_consts.ANG);
   double ahp= (0.00);          //total exposed hydrophobic surface area
   double atot= (0.00);         //total exposed surface area
   for(int iA5= 0;iA5<nA5;iA5++){
      atot+=A5[iA5].sa;
      int iT2=A5[iA5].typ;
      if( (iT2!= 0)&&(iT2!= 3)&&(iT2!= 8)&&(iT2!=10) )continue;
      ahp+=A5[iA5].sa;
   }
   Qha= (.025)*ANGANG*ahp;
   Qpa= (.025)*ANGANG*( atot -ahp);

   Qtq= (0.00);
   Qfq= (0.00);
   int oZ0=str.nZ0;
   for(int iZ0=0;iZ0<oZ0;iZ0++){
      int mR0=str.Z0[iZ0].R0a;
      int nR0=(mR0-1+str.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=str.R0[iR0].aa;
         std::string ab=str.R0[iR0].aa;
         if( (ab[0]=='e')||(ab[0]=='z') )ab=ab.substr(1,3)+' ';
         if( (ab[3]=='e')||(ab[3]=='z') )ab=ab.substr(0,3)+' ';
         if( aa[0]=='e' ){
            Qtq++;
            Qfq++;
         }
         if      ( (ab=="ASP ")||(ab=="GLU ")||(ab=="TYZ ")||(ab=="CYZ ")||
                   (ab=="PO  ")||(ab=="PSR ")||(ab=="PSS ")||(ab=="GM  ")||
                   (ab=="TM  ")||(ab=="UM  ") ){
            Qtq--;
            Qfq++;
         }else if( (ab=="LYS ")||(ab=="ARG ")||(ab=="ORN ")||(ab=="HIP ")||
                   (ab=="AP  ")||(ab=="GP  ")||(ab=="CP  ") ){
            Qtq++;
            Qfq++;
         }else if( (ab=="5PO ")||(ab=="3PO ")||(ab=="SEP ")||(ab=="THP ")||
                   (ab=="TYP ") ){
            Qtq-=(2.00);
            Qfq+=(2.00);
         }
         if( aa[3]=='e' ){
            Qtq--;
            Qfq++;
         }
      }
   }
   Qtq= Qtq*Qtq;

   Qha*=energy_params.Qhs( 0);
   Qpa*=energy_params.Qhs( 1);
   Qps*=energy_params.Qhs( 2);
   Qss*=energy_params.Qhs( 3);
   Qtq*=energy_params.Qhs( 4);
   Qfq*=energy_params.Qhs( 5);
   Qsol=( Qha +Qpa +Qps +Qss +Qtq +Qfq);
// if( out.VERBOSE ){
//    out.FILE3<<"    Qsol  "
//               "     Qha  ""     Qpa  ""     Qps  ""     Qss  "
//               "     Qtq  ""     Qfq  "
//             <<'\n';
//    out.FILE3<< std::fixed<< std::setprecision(2);
//    out.FILE3<< std::setw(10)<<Qsol
//             << std::setw(10)<<Qha
//             << std::setw(10)<<Qpa
//             << std::setw(10)<<Qps
//             << std::setw(10)<<Qss
//             << std::setw(10)<<Qtq
//             << std::setw(10)<<Qfq<<'\n';
// }
   return;
}
