#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../med/Dielec_Continu.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_med_dot {
private:
   std::vector<int> o_DOTDOT;           //mapping order to dot index
   std::vector<int> o_DOTord;           //mapping dot index to order
   std::vector<int> o_D5D5;             //mapping order to dot index
   std::vector<int> o_D5ord;            //mapping dot index to order
public:
   std::vector<int> o_HITtyp;           //type of excluded dot
   MEM_med_dot(int oDOT,int oD5):
      o_DOTDOT(oDOT),
      o_DOTord(oDOT),
      o_D5D5(oD5),
      o_D5ord(oD5)
   {
   }
   int& DOTDOT(int i){
      return o_DOTDOT.at( i);  }
   int& DOTord(int i){
      return o_DOTord.at( i);  }
   int& HITtyp(int i){
      return o_HITtyp.at( i);  }
   int& D5D5(int i){
      return o_D5D5.at( i);  }
   int& D5ord(int i){
      return o_D5ord.at( i);  }
};

void Dielec_Continu::MED_DOT(const DAT_PHYSICS_CONSTS& physics_consts,
                             const DAT_ARRAY_CONSTS& array_consts,
                             Output_Streams& out){
   nDOT=0;
   nD5=-1;
//
//
// high density surface elements st motion is with rigid groups
//
   for(int iF5= 0;iF5<nF5;iF5++){
      int iC5=iF5;
      if( !C5[iC5].sub )continue;
//    int iA5=C5[iC5].N3A5[0];
//    int jA5=C5[iC5].N3A5[1];
//    int kA5=C5[iC5].N3A5[2];
//    int iQ2=A5[iA5].Q2;
//    int jQ2=A5[jA5].Q2;
//    int kQ2=A5[kA5].Q2;
//    int aQ2=A5[A5[iA5].A5].Q2;
//    int bQ2=A5[A5[jA5].A5].Q2;
//    int cQ2=A5[A5[kA5].A5].Q2;
//    if( (jQ2!=iQ2)&& (bQ2!=iQ2)&& (jQ2!=aQ2)&& (bQ2!=aQ2) )continue;
//    if( (kQ2!=iQ2)&& (cQ2!=iQ2)&& (kQ2!=aQ2)&& (cQ2!=aQ2) )continue;
//    if( (kQ2!=jQ2)&& (cQ2!=jQ2)&& (kQ2!=bQ2)&& (cQ2!=bQ2) )continue;
      int iE5=F5[iF5].N3E5[0];
      int jE5=F5[iF5].N3E5[1];
      int kE5=F5[iF5].N3E5[2];
      Coordinates w=C5[iC5].c;
      Coordinates v=C5[iC5].e;
      Coordinates u=cross(v,w);
      Rotation_Matrix ROT;
      ROT(0,0)= u(0);
      ROT(1,0)= u(1);
      ROT(2,0)= u(2);
      ROT(0,1)= v(0);
      ROT(1,1)= v(1);
      ROT(2,1)= v(2);
      ROT(0,2)= w(0);
      ROT(1,2)= w(1);
      ROT(2,2)= w(2);
      bool REPRESENTED=false;
      int n=0;
      for(int pF= 0;pF<20;pF++){
         for(int pT= 0;pT<16;pT++){
            tDOT x=FTprobe(pF,pT);
            x.elm=iF5;
            x.TILE=true;
            if( x.MED_DOTROT(ROT,C5[iC5].h) )continue;
            if( x.MED_CDOTSEC(physics_consts,-E5[iE5].c) )continue;
            if( x.MED_CDOTSEC(physics_consts,-E5[jE5].c) )continue;
            if( x.MED_CDOTSEC(physics_consts,-E5[kE5].c) )continue;
            x.MED_DOTTRANS(C5[iC5].x);
// exclude for rare cases of cusp intersection
            if( F5[iF5].CUSP ){
               bool EXCLUDE=false;
               for(int jF5= 0;jF5<nF5;jF5++){
                  if( jF5==iF5 )continue;
                  int jC5=jF5;
                  if( !C5[jC5].sub )continue;
                  if( F5[jF5].CUSP ){
                     double r=( x.x -C5[jC5].x).r();
                     if( r< probe )EXCLUDE= true;
                  }
               }
               if( EXCLUDE )continue;
            }
            if( !REPRESENTED ){
               nD5++;
               REPRESENTED=true;
            }
            x.D5=nD5;
            DOT.push_back(x);
            nDOT++;
            n++;
         }
         if( n>32 ){
            REPRESENTED=false;
            n=0;
         }
      }
   }
//
   for(int iF6= 0;iF6<nF6;iF6++){
      if( F6[iF6].sa<(1.00e-6) )continue;
      int jE6=F6[iF6].N2E6[0];
      int iE6=F6[iF6].N2E6[1];
      int jH5=E6[jE6].H5;
      int iH5=E6[iE6].H5;
      int iB5=H5[iH5].B5;
      int iA5=B5[iB5].N2A5[0];
      int jA5=B5[iB5].N2A5[1];
      int iQ2=A5[iA5].Q2;
      int jQ2=A5[jA5].Q2;
      int aQ2=A5[A5[iA5].A5].Q2;
      int bQ2=A5[A5[jA5].A5].Q2;
//    if( (jQ2!=iQ2)&& (bQ2!=iQ2)&& (jQ2!=aQ2)&& (bQ2!=aQ2) )continue;
      Coordinates ci=-H5[iH5].c;
      Coordinates cj=-H5[jH5].c;
      double di= probe*std::sin( H5[iH5].the);
      double dj= probe*std::sin( H5[jH5].the);
      int kE5=F6[iF6].N2E5[0];
      int lE5=F6[iF6].N2E5[1];
      int kC5=V5[E5[kE5].N2V5[0]].C5;
      int lC5=V5[E5[lE5].N2V5[0]].C5;
      int kA5=-1;
      for(int i=0;i<3;i++){
         int qA5=C5[kC5].N3A5[i];
         if( (qA5!=iA5)&&(qA5!=jA5) )kA5=qA5;
      }
      int lA5=-1;
      for(int i=0;i<3;i++){
         int qA5=C5[lC5].N3A5[i];
         if( (qA5!=iA5)&&(qA5!=jA5) )lA5=qA5;
      }
      int kQ2=A5[kA5].Q2;
      int cQ2=A5[A5[kA5].A5].Q2;
      int lQ2=A5[lA5].Q2;
      int dQ2=A5[A5[lA5].A5].Q2;
      if( ((kQ2==iQ2)|| (cQ2==iQ2)|| (kQ2==aQ2)|| (cQ2==aQ2))&&
          ((kQ2==jQ2)|| (cQ2==jQ2)|| (kQ2==bQ2)|| (cQ2==bQ2)) )kA5=-1;
      if( ((lQ2==iQ2)|| (dQ2==iQ2)|| (lQ2==aQ2)|| (dQ2==aQ2))&&
          ((lQ2==jQ2)|| (dQ2==jQ2)|| (lQ2==bQ2)|| (dQ2==bQ2)) )lA5=-1;
      Coordinates u= B5[iB5].c;
      Coordinates v;
      v(0)= Q2[bQ2].c(0,1);
      v(1)= Q2[bQ2].c(1,1);
      v(2)= Q2[bQ2].c(2,1);
      double Cthe= dot(v,u);
      if( (Cthe>( .999999))||(Cthe<(-.999999)) ){
         v(0)= Q2[bQ2].c(0,2);
         v(1)= Q2[bQ2].c(1,2);
         v(2)= Q2[bQ2].c(2,2);
         Cthe= dot(v,u);
      }
      double Sthe= std::sqrt( (1.00) -Cthe*Cthe);
      v-=(Cthe*u);
      v/=Sthe;
      Coordinates w=cross(u,v);
      Rotation_Matrix ROT;
      ROT(0,0)= u(0);
      ROT(1,0)= u(1);
      ROT(2,0)= u(2);
      ROT(0,1)= v(0);
      ROT(1,1)= v(1);
      ROT(2,1)= v(2);
      ROT(0,2)= w(0);
      ROT(1,2)= w(1);
      ROT(2,2)= w(2);
      bool REPRESENTED;
      for(int pF= 0;pF< 8;pF++){
         if( (pF%4)==0 )REPRESENTED=false;
         for(int pT= 0;pT<25;pT++){
            tDOT x=FTtorus(pF,pT);
            x.elm=iF6;
            x.TILE=true;
            if( x.MED_DOTROT(ROT,B5[iB5].r) )continue;
            if( x.MED_BDOTSEC(probe,ci,di,-1) )continue;
            if( x.MED_BDOTSEC(probe,cj,dj,-1) )continue;
            if( x.MED_BDOTSEC(probe,E5[kE5].c,( 0.00),kA5) )continue;
            if( x.MED_BDOTSEC(probe,E5[lE5].c,( 0.00),lA5) )continue;
            x.MED_DOTTRANS(B5[iB5].x);
            for(int iL6=0;iL6<4;iL6++){
               int qA5=x.K6[0].L6[iL6].jA5;
               if( qA5>-1 ){
                  x.TILE=false;
               }
            }
            if( !REPRESENTED ){
               nD5++;
               REPRESENTED=true;
            }
            x.D5=nD5;
            DOT.push_back(x);
            nDOT++;
         }
      }
   }
//
   for(int iF7= 0;iF7<nF7;iF7++){
      int iA5=F7[iF7].A5;
      int nX6=F7[iF7].nX6;
      int iQ2=A5[iA5].Q2;
      bool REPRESENTED;
      for(int pF= 0;pF<20;pF++){
         if( (pF%2)==0 )REPRESENTED=false;
         for(int pT= 0;pT<16;pT++){
            tDOT x=FTspher(pF,pT);
            x.elm=iF7;
            x.TILE=true;
            if( x.MED_DOTROT(Q2[iQ2].c,A5[iA5].r) )continue;
            bool EXCLUDE=false;
            for(int iX6= 0;iX6<nX6&&(!EXCLUDE);iX6++){
               int iY6=F7[iF7].X6[iX6].Y6;
               int nZ6=A5[iA5].Y6[iY6].nZ6;
               for(int iZ6= 0;iZ6<nZ6&&(!EXCLUDE);iZ6++){
                  int iE6=A5[iA5].Y6[iY6].Z6[iZ6].E6;
                  if( E6[iE6].phi<(1.00e-6) )continue;
                  int iH5=E6[iE6].H5;
                  int jA5=E6[iE6].jA5;
                  int jQ2=A5[jA5].Q2;
                  int bQ2=A5[A5[jA5].A5].Q2;
                  if( (jQ2==iQ2)|| (bQ2==iQ2) )jA5=-1;
                  EXCLUDE=EXCLUDE||x.MED_ADOTSEC(physics_consts,
                                                 H5[iH5].c,
                                                 H5[iH5].del,
                                                 jA5);
               }
               if      ( nZ6==1 ){
               }else if( nZ6==2 ){
               }else{
                  for(int iZ6= 0;iZ6<nZ6&&(!EXCLUDE);iZ6++){
                     EXCLUDE=EXCLUDE||x.MED_ADOTSEC(physics_consts,
                                            A5[iA5].Y6[iY6].Z6[iZ6].c,
                                            A5[iA5].Y6[iY6].Z6[iZ6].del);
                  }
               }
            }
            if( EXCLUDE )continue;
            x.MED_DOTTRANS(A5[iA5].x);
            int oK6=x.K6.size();
            for(int iK6=0;iK6<oK6;iK6++){
               int oL6=x.K6[iK6].L6.size();
               for(int iL6=0;iL6<oL6;iL6++){
                  int jA5=x.K6[iK6].L6[iL6].jA5;
                  if( jA5>-1 ){
                     x.TILE=false;
                  }
               }
            }
            if( !REPRESENTED ){
               nD5++;
               REPRESENTED=true;
            }
            x.D5=nD5;
            DOT.push_back(x);
            nDOT++;
         }
      }
   }
//
   for(int iA5= 0;iA5<nA5;iA5++){
      if( !A5[iA5].free )continue;
      int iQ2=A5[iA5].Q2;
      bool REPRESENTED;
      for(int pF= 0;pF<20;pF++){
         if( (pF%2)==0 )REPRESENTED=false;
         for(int pT= 0;pT<16;pT++){
            tDOT x=FTspher(pF,pT);
            x.elm=(-1-iA5);
            x.TILE=true;
            x.MED_DOTROT(Q2[iQ2].c,A5[iA5].r);
            x.MED_DOTTRANS(A5[iA5].x);
            if( !REPRESENTED ){
               nD5++;
               REPRESENTED=true;
            }
            x.D5=nD5;
            DOT.push_back(x);
            nDOT++;
         }
      }
   }
//
   for(int iB5= 0;iB5<nB5;iB5++){
      if( !B5[iB5].free )continue;
      int iH5=B5[iB5].N2H5[0];
      int jH5=B5[iB5].N2H5[1];
//    int iA5=B5[iB5].N2A5[0];
      int jA5=B5[iB5].N2A5[1];
//    int iQ2=A5[iA5].Q2;
//    int jQ2=A5[jA5].Q2;
//    int aQ2=A5[A5[iA5].A5].Q2;
      int bQ2=A5[A5[jA5].A5].Q2;
//    if( (jQ2!=iQ2)&& (bQ2!=iQ2)&& (jQ2!=aQ2)&& (bQ2!=aQ2) )continue;
      Coordinates ci=-H5[iH5].c;
      Coordinates cj=-H5[jH5].c;
      double di= probe*std::sin( H5[iH5].the);
      double dj= probe*std::sin( H5[jH5].the);
      Coordinates u= B5[iB5].c;
      Coordinates v;
      v(0)= Q2[bQ2].c(0,1);
      v(1)= Q2[bQ2].c(1,1);
      v(2)= Q2[bQ2].c(2,1);
      double Cthe= dot(v,u);
      if( (Cthe>( .999999))||(Cthe<(-.999999)) ){
         v(0)= Q2[bQ2].c(0,2);
         v(1)= Q2[bQ2].c(1,2);
         v(2)= Q2[bQ2].c(2,2);
         Cthe= dot(v,u);
      }
      double Sthe= std::sqrt( (1.00) -Cthe*Cthe);
      v-=(Cthe*u);
      v/=Sthe;
      Coordinates w=cross(u,v);
      Rotation_Matrix ROT;
      ROT(0,0)= u(0);
      ROT(1,0)= u(1);
      ROT(2,0)= u(2);
      ROT(0,1)= v(0);
      ROT(1,1)= v(1);
      ROT(2,1)= v(2);
      ROT(0,2)= w(0);
      ROT(1,2)= w(1);
      ROT(2,2)= w(2);
      bool REPRESENTED;
      for(int pF= 0;pF< 8;pF++){
         if( (pF%4)==0 )REPRESENTED=false;
         for(int pT= 0;pT<25;pT++){
            tDOT x=FTtorus(pF,pT);
            x.elm=(-1-iB5);
            x.TILE=true;
            if( x.MED_DOTROT(ROT,B5[iB5].r) )continue;
            if( x.MED_BDOTSEC(probe,ci,di,-1) )continue;
            if( x.MED_BDOTSEC(probe,cj,dj,-1) )continue;
            x.MED_DOTTRANS(B5[iB5].x);
            if( !REPRESENTED ){
               nD5++;
               REPRESENTED=true;
            }
            x.D5=nD5;
            DOT.push_back(x);
            nDOT++;
         }
      }
   }
   nD5++;
   MEM_med_dot vv(nDOT,nD5);
//
//
// grid dimensions
//
   Coordinates xMIN;                        //min value of dot coords
   Coordinates xMAX;                        //max value of dot coords
   Coordinates xMID;                        //mid value of dot coords
   Coordinates xDEL;                        //bin size of grid
   for(int i=0;i<3;i++){
      xMIN(i)=( 1.00e+6);
      xMAX(i)=(-1.00e+6);
      for(int iDOT= 0;iDOT<nDOT;iDOT++){
         if( DOT[iDOT].x(i)<xMIN(i) )xMIN(i)= DOT[iDOT].x(i);
         if( DOT[iDOT].x(i)>xMAX(i) )xMAX(i)= DOT[iDOT].x(i);
      }
      xMID(i)=( xMIN(i) +xMAX(i))/(2.00);
      xDEL(i)=( xMAX(i) -xMIN(i) +(.02))/(33.00);
      if( xDEL(i)<((2.00)/physics_consts.ANG) ){
         xDEL(i)= ((2.00)/physics_consts.ANG);
      }
   }
//
//
// order high density surface elements
//
   for(int iDOT= 0;iDOT<nDOT;iDOT++){
      int iG5[3];
      for(int i=0;i<3;i++){
         double z=( DOT[iDOT].x(i) -xMID(i))/xDEL(i);
         iG5[i]=int( std::floor( (.50) +z));
      }
      DOT[iDOT].G5= 1089*(iG5[0]+16)
                     +33*(iG5[1]+16)
                        +(iG5[2]+16);
   }
   for(int iDOT= 0;iDOT<nDOT;iDOT++){
      vv.DOTDOT(iDOT)=iDOT;
   }
   for(int iDOTmax=(nDOT-1);iDOTmax>0;iDOTmax--){
      bool ORDERED=true;
      int i=DOT[vv.DOTDOT( 0)].G5;
      for(int iDOT= 1;iDOT<=iDOTmax;iDOT++){
         int j=DOT[vv.DOTDOT(iDOT)].G5;
         if( j<i ){
            int L=vv.DOTDOT(iDOT);
            vv.DOTDOT(iDOT)= vv.DOTDOT(iDOT-1);
            vv.DOTDOT(iDOT-1)=L;
            ORDERED=false;
         }else{
            i=j;
         }
      }
      if( ORDERED )break;
   }
   for(int i= 0;i<35937;i++){
      G5G5G5(i).i=-1;
      G5G5G5(i).n=0;
   }
   for(int jDOT= 0;jDOT<nDOT;jDOT++){
      int iDOT=vv.DOTDOT(jDOT);
      int i=DOT[iDOT].G5;
      if( G5G5G5(i).n==0 )G5G5G5(i).i=jDOT;
      G5G5G5(i).n++;
   }
//
//
// instances of dot-dot distance below threshold
//
   for(int iDOT= 0;iDOT<nDOT;iDOT++){
      DOT[iDOT].HIT=false;
   }
   double b= probe*std::sqrt( (4.00)*physics_consts.PI/320);
   b*=(.125);
   for(int i0G5=-16;i0G5<= 16;i0G5++){
      for(int j0G5=-16;j0G5<= 16;j0G5++){
         for(int k0G5=-16;k0G5<= 16;k0G5++){
            if( G5G5G5(i0G5,j0G5,k0G5).n==0 )continue;
            int pDOTmin=G5G5G5(i0G5,j0G5,k0G5).i;
            int pDOTmax=(pDOTmin-1+G5G5G5(i0G5,j0G5,k0G5).n);
            for(int pDOT=pDOTmin;pDOT<=pDOTmax;pDOT++){
               int iDOT=vv.DOTDOT(pDOT);
               int iG5min=(i0G5  );
               int iG5max=(i0G5+1);
               if( iG5max> 16 )iG5max= 16;
               for(int iG5=iG5min;iG5<=iG5max;iG5++){
                  int jG5min=( iG5==i0G5 )?(j0G5  ):(j0G5-1);
                  if( jG5min<-16 )jG5min=-16;
                  int jG5max=(j0G5+1);
                  if( jG5max> 16 )jG5max= 16;
                  for(int jG5=jG5min;jG5<=jG5max;jG5++){
                     int kG5min=( (iG5==i0G5)&&(jG5==j0G5) )?(k0G5  ):(k0G5-1);
                     if( kG5min<-16 )kG5min=-16;
                     int kG5max=(k0G5+1);
                     if( kG5max> 16 )kG5max= 16;
                     for(int kG5=kG5min;kG5<=kG5max;kG5++){
                        if( G5G5G5(iG5,jG5,kG5).n==0 )continue;
                        int qDOTmin=G5G5G5(iG5,jG5,kG5).i;
                        int qDOTmax=(qDOTmin-1+G5G5G5(iG5,jG5,kG5).n);
                        if( (iG5==i0G5)&&(jG5==j0G5)&&
                            (kG5==k0G5) )qDOTmin=(pDOT+1);
                        for(int qDOT=qDOTmin;qDOT<=qDOTmax;qDOT++){
                           int jDOT=vv.DOTDOT(qDOT);
                           if( ( DOT[jDOT].x -DOT[iDOT].x).r()<b ){
                              DOT[iDOT].HIT=true;
                              DOT[jDOT].HIT=true;
// if( DOT[jDOT].typ==DOT[iDOT].typ ){
//    out.FILE3<<"__""    D5""     G5   "" typ"" nK6"" TIL"
//               "           DOTx        ""        DOTc     "
//               "   elm""    DOTa""  DOTr"" grp\n";
//    out.FILE3<<"__"
//             << std::setw( 6)<<DOT[iDOT].D5<<' '
//             << std::setw( 3)<<(iG5-16)
//             << std::setw( 3)<<(jG5-16)
//             << std::setw( 3)<<(kG5-16)
//             << std::setw( 4)<<DOT[iDOT].typ
//             << std::setw( 4)<<int(DOT[iDOT].K6.size())
//             << std::setw( 4)<<int(DOT[iDOT].TILE);
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 7)<<DOT[iDOT].x(i);
//    }
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 5)<<DOT[iDOT].c(i);
//    }
//    out.FILE3<< std::setw( 6)<<DOT[iDOT].elm
//             << std::setprecision(4)
//             << std::setw( 8)<<DOT[iDOT].a
//             << std::setprecision(2)
//             << std::setw( 6)<<DOT[iDOT].r
//             << std::setw( 4)<<DOT[iDOT].grp<<'\n';
//    out.FILE3<<"__"
//             << std::setw( 6)<<DOT[jDOT].D5<<' '
//             << std::setw( 3)<<(iG5-16)
//             << std::setw( 3)<<(jG5-16)
//             << std::setw( 3)<<(kG5-16)
//             << std::setw( 4)<<DOT[jDOT].typ
//             << std::setw( 4)<<int(DOT[jDOT].K6.size())
//             << std::setw( 4)<<int(DOT[jDOT].TILE);
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 7)<<DOT[jDOT].x(i);
//    }
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 5)<<DOT[jDOT].c(i);
//    }
//    out.FILE3<< std::setw( 6)<<DOT[jDOT].elm
//             << std::setprecision(4)
//             << std::setw( 8)<<DOT[jDOT].a
//             << std::setprecision(2)
//             << std::setw( 6)<<DOT[jDOT].r
//             << std::setw( 4)<<DOT[jDOT].grp<<'\n';
// }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
   }
   int nHIT=0;                              //number of dots st separation small
   for(int iDOT= 0;iDOT<nDOT;iDOT++){
      if( DOT[iDOT].HIT ){
         vv.o_HITtyp.push_back(DOT[iDOT].typ);
         nHIT++;
      }
   }
//
//
// order low and high density surface elements
//
   D5.resize(nD5);
   for(int iD5= 0;iD5<nD5;iD5++){
      D5[iD5].x.zero();
      D5[iD5].cDOT=0;
   }
   for(int iDOT= 0;iDOT<nDOT;iDOT++){
      int iD5=DOT[iDOT].D5;
      D5[iD5].x+=DOT[iDOT].x;
      D5[iD5].cDOT++;
   }
   for(int iD5= 0;iD5<nD5;iD5++){
      D5[iD5].x/=double(D5[iD5].cDOT);
   }
   for(int iD5= 0;iD5<nD5;iD5++){
      int iG5[3];
      for(int i=0;i<3;i++){
         double z=( D5[iD5].x(i) -xMID(i))/xDEL(i);
         iG5[i]=int( std::floor( (.50) +z));
      }
      D5[iD5].G5= 1089*(iG5[0]+16)
                   +33*(iG5[1]+16)
                      +(iG5[2]+16);
   }
   for(int iD5= 0;iD5<nD5;iD5++){
      vv.D5D5(iD5)=iD5;
   }
   for(int iD5max=(nD5-1);iD5max>0;iD5max--){
      bool ORDERED=true;
      int i=D5[vv.D5D5( 0)].G5;
      for(int iD5= 1;iD5<=iD5max;iD5++){
         int j=D5[vv.D5D5(iD5)].G5;
         if( j<i ){
            int L=vv.D5D5(iD5);
            vv.D5D5(iD5)= vv.D5D5(iD5-1);
            vv.D5D5(iD5-1)=L;
            ORDERED=false;
         }else{
            i=j;
         }
      }
      if( ORDERED )break;
   }
   for(int iD5= 0;iD5<nD5;iD5++){
      vv.D5ord(vv.D5D5(iD5))=iD5;
   }
   {
      int pDOT=0;
      for(int iD5= 0;iD5<nD5;iD5++){
         int jD5=vv.D5D5(iD5);
         D5[jD5].DOTa=pDOT;
         pDOT+=D5[jD5].cDOT;
      }
   }
   for(int jDOT= 0;jDOT<nDOT;jDOT++){
      int jD5=DOT[jDOT].D5;
      vv.DOTDOT(D5[jD5].DOTa++)=jDOT;
      DOT[jDOT].D5=vv.D5ord(jD5);
   }
   for(int iDOT= 0;iDOT<nDOT;iDOT++){
      vv.DOTord(vv.DOTDOT(iDOT))=iDOT;
   }
   for(int iDOT= 0;iDOT<nDOT;iDOT++){
      int jDOT=vv.DOTDOT(iDOT);
      int kDOT=vv.DOTord(iDOT);
      if( jDOT==iDOT )continue;
      tDOT z=DOT[iDOT];
      DOT[iDOT]=DOT[jDOT];
      DOT[jDOT]=z;
      vv.DOTDOT(iDOT)=iDOT;
      vv.DOTord(iDOT)=iDOT;
      vv.DOTDOT(kDOT)=jDOT;
      vv.DOTord(jDOT)=kDOT;
   }
   for(int iD5= 0;iD5<nD5;iD5++){
      int jD5=vv.D5D5(iD5);
      int kD5=vv.D5ord(iD5);
      if( jD5==iD5 )continue;
      tD5 z=D5[iD5];
      D5[iD5]=D5[jD5];
      D5[jD5]=z;
      vv.D5D5(iD5)=iD5;
      vv.D5ord(iD5)=iD5;
      vv.D5D5(kD5)=jD5;
      vv.D5ord(jD5)=kD5;
   }
   {
      int pDOT=0;
      for(int iD5= 0;iD5<nD5;iD5++){
         D5[iD5].DOTa=pDOT;
         pDOT+=D5[iD5].cDOT;
      }
   }
   for(int i= 0;i<35937;i++){
      G5G5G5(i).i=-1;
      G5G5G5(i).n=0;
   }
   for(int iD5= 0;iD5<nD5;iD5++){
      int i=D5[iD5].G5;
      if( G5G5G5(i).n==0 )G5G5G5(i).i=iD5;
      G5G5G5(i).n++;
   }
//
//
// dot characteristics
//
   {
      double z= (1.00)/std::sqrt( (2.00));
      for(int iDOT= 0;iDOT<nDOT;iDOT++){
         DOT[iDOT].n.r(0, 0)= (0.00);
         DOT[iDOT].n.i(0, 0)= (0.00);
         DOT[iDOT].n.r(1,-1)= z*DOT[iDOT].c(0);
         DOT[iDOT].n.i(1,-1)=-z*DOT[iDOT].c(1);
         DOT[iDOT].n.r(1, 0)= DOT[iDOT].c(2);
         DOT[iDOT].n.i(1, 0)= (0.00);
         DOT[iDOT].n.r(1, 1)=-z*DOT[iDOT].c(0);
         DOT[iDOT].n.i(1, 1)=-z*DOT[iDOT].c(1);
      }
   }
   for(int iD5= 0;iD5<nD5;iD5++){
      double rrmax= (0.20);
      int iDOTmin=D5[iD5].DOTa;
      int iDOTmax=(iDOTmin-1+D5[iD5].cDOT);
      for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
         Coordinates d=( D5[iD5].x -DOT[iDOT].x);
         double rr= d.rr();
         if( rr>rrmax )rrmax= rr;
      }
      D5[iD5].d= std::sqrt( rrmax);
      D5[iD5].d+=(1.00);
   }
   for(int iD5= 0;iD5<nD5;iD5++){
      D5[iD5].a= (0.00);
      int iDOTmin=D5[iD5].DOTa;
      int iDOTmax=(iDOTmin-1+D5[iD5].cDOT);
      for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
         D5[iD5].a+=DOT[iDOT].a;
      }
      if( D5[iD5].a<( .08) ){
         D5[iD5].a= ( .08);
      }
   }
   {
      Multipoles n(1);          //
      for(int iD5= 0;iD5<nD5;iD5++){
         D5[iD5].n.zero();
         int iDOTmin=D5[iD5].DOTa;
         int iDOTmax=(iDOTmin-1+D5[iD5].cDOT);
         for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
            n=DOT[iDOT].n;
            n*=DOT[iDOT].a;
            Coordinates d=( D5[iD5].x -DOT[iDOT].x);
            double rr= d.rr();
            if( rr<(1.00e-10) ){
               D5[iD5].n+=n;
            }else{
               D5[iD5].n.translate(array_consts,d,n);
            }
         }
      }
   }
   {
      Multipoles e(0);          //
      e.i(0,0)= (0.00);
      for(int iD5= 0;iD5<nD5;iD5++){
         D5[iD5].e.zero();
         int iDOTmin=D5[iD5].DOTa;
         int iDOTmax=(iDOTmin-1+D5[iD5].cDOT);
         for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
            e.r(0,0)= DOT[iDOT].a;
            Coordinates d=( D5[iD5].x -DOT[iDOT].x);
            double rr= d.rr();
            if( rr<(1.00e-10) ){
               D5[iD5].e+=e;
            }else{
               D5[iD5].e.translate(array_consts,d,e);
            }
         }
      }
   }
//
//
// mapping of dots to non-deformable base
//
   int oD5=bse_nD5;
   for(int jD5= 0;jD5<oD5;jD5++){
      int iG5[3];
      for(int i=0;i<3;i++){
         double z=( bse_D5[jD5].x(i) -xMID(i))/xDEL(i);
         iG5[i]=int( std::floor( (.50) +z));
      }
      bse_D5[jD5].G5= 1089*(iG5[0]+16)
                       +33*(iG5[1]+16)
                          +(iG5[2]+16);
   }
   for(int iD5= 0;iD5<nD5;iD5++){
      D5[iD5].bse=-1;
      int iDOTmin=D5[iD5].DOTa;
      int iDOTmax=(iDOTmin-1+D5[iD5].cDOT);
      for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
         DOT[iDOT].bse=-1;
      }
   }
   for(int jD5= 0;jD5<oD5;jD5++){
      int jDOTmin=bse_D5[jD5].DOTa;
      int jDOTmax=(jDOTmin-1+bse_D5[jD5].cDOT);
      int jG5=bse_D5[jD5].G5;
      if( G5G5G5(jG5).n==0 )continue;
      int iD5min=G5G5G5(jG5).i;
      int iD5max=(iD5min-1+G5G5G5(jG5).n);
      for(int iD5=iD5min;iD5<=iD5max;iD5++){
         int iDOTmin=D5[iD5].DOTa;
         int iDOTmax=(iDOTmin-1+D5[iD5].cDOT);
         if( ( D5[iD5].x -bse_D5[jD5].x).rr()>(1.00e-24) )continue;
         if( D5[iD5].cDOT!=bse_D5[jD5].cDOT )continue;
         bool GRPMATCH=true;
         for(int jDOT=jDOTmin;jDOT<=jDOTmax&&(GRPMATCH);jDOT++){
            bool DOTMATCH=false;
            for(int iDOT=iDOTmin;iDOT<=iDOTmax&&(!DOTMATCH);iDOT++){
               if( ( DOT[iDOT].x -bse_DOT[jDOT].x ).rr()>(1.00e-24) )continue;
               DOT[iDOT].bse=jDOT;
               DOTMATCH=true;
            }
            if( !DOTMATCH )GRPMATCH=false;
         }
         if( GRPMATCH )D5[iD5].bse=jD5;
         break;
      }
   }
//
//
// diagnostic output
//
   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<"  nDOT""   nD5"" nHIT\n";
      out.FILE3<< std::setw( 6)<<nDOT
               << std::setw( 6)<<nD5
               << std::setw( 5)<<nHIT<<'\n';
   }
// out.FILE3<< std::fixed;
// for(int iDOT= 0;iDOT<nDOT;iDOT++){
//    int kG5=DOT[iDOT].G5;
//    int iG5=(kG5/1089);
//    kG5-=(iG5*1089);
//    int jG5=(kG5/  33);
//    kG5-=(jG5*  33);
//    int oK6=DOT[iDOT].K6.size();
//    int typ=DOT[iDOT].typ;
//    int elm=DOT[iDOT].elm;
//    out.FILE3<<"  iDOT""    D5""     G5   "" typ"" nK6"" TIL"
//               "           DOTx        ""        DOTc     "
//               "   elm""    DOTa""  DOTr"" grp"" HIT\n";
//    out.FILE3<< std::setw( 6)<<iDOT
//             << std::setw( 6)<<DOT[iDOT].D5<<' '
//             << std::setw( 3)<<(iG5-16)
//             << std::setw( 3)<<(jG5-16)
//             << std::setw( 3)<<(kG5-16)
//             << std::setw( 4)<<typ
//             << std::setw( 4)<<oK6
//             << std::setw( 4)<<int(DOT[iDOT].TILE);
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 7)<<DOT[iDOT].x(i);
//    }
//    out.FILE3<<"  "<< std::setprecision(2);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 5)<<DOT[iDOT].c(i);
//    }
//    out.FILE3<< std::setw( 6)<<elm
//             << std::setprecision(4)
//             << std::setw( 8)<<DOT[iDOT].a
//             << std::setprecision(2)
//             << std::setw( 6)<<DOT[iDOT].r
//             << std::setw( 4)<<DOT[iDOT].grp
//             << std::setw( 4)<<int(DOT[iDOT].HIT)<<'\n';
//    out.FILE3<<"  iDOT"" iK6"" iL6"
//               "           DOTx        ""        DOTc     "
//               "   del ""  jA5""   phi ""   the ""   bet \n";
//    for(int iK6=0;iK6<oK6;iK6++){
//       int oL6=DOT[iDOT].K6[iK6].L6.size();
//       for(int iL6=0;iL6<oL6;iL6++){
//          const tL6& x=DOT[iDOT].K6[iK6].L6[iL6];
//          out.FILE3<< std::setw( 6)<<iDOT
//                   << std::setw( 4)<<iK6
//                   << std::setw( 4)<<iL6;
//          out.FILE3<<"  "<< std::setprecision(2);
//          for(int i=0;i<3;i++){
//             out.FILE3<< std::setw( 7)<<x.v(i);
//          }
//          out.FILE3<<"  "<< std::setprecision(2);
//          for(int i=0;i<3;i++){
//             out.FILE3<< std::setw( 5)<<x.c(i);
//          }
//          out.FILE3<< std::setprecision(3)
//                   << std::setw( 7)<<x.del
//                   << std::setw( 5)<<x.jA5
//                   << std::setw( 7)<<x.phi
//                   << std::setw( 7)<<x.the
//                   << std::setw( 7)<<x.bet<<'\n';
//       }
//    }
// }
// out.FILE3<<"   iD5""             D5x          ""     G5   "
//            "  DOTa"" cDOT""    D5a""   D5d\n";
// for(int iD5= 0;iD5<nD5;iD5++){
//    int kG5=D5[iD5].G5;
//    int iG5=(kG5/1089);
//    kG5-=(iG5*1089);
//    int jG5=(kG5/  33);
//    kG5-=(jG5*  33);
//    out.FILE3<< std::setw( 6)<<iD5;
//    out.FILE3<<"  "<< std::setprecision(3);
//    for(int i=0;i<3;i++){
//       out.FILE3<< std::setw( 8)<<D5[iD5].x(i);
//    }
//    out.FILE3<<' '
//             << std::setw( 3)<<(iG5-16)
//             << std::setw( 3)<<(jG5-16)
//             << std::setw( 3)<<(kG5-16)
//             << std::setw( 6)<<D5[iD5].DOTa
//             << std::setw( 5)<<D5[iD5].cDOT
//             << std::setprecision(2)
//             << std::setw( 7)<<D5[iD5].a
//             << std::setw( 6)<<D5[iD5].d<<'\n';
// }
// out.FILE3<<" iHIT"" typ\n";
// for(int iHIT= 0;iHIT<nHIT;iHIT++){
//    out.FILE3<< std::setw( 5)<<iHIT
//             << std::setw( 4)<<vv.HITtyp(iHIT)<<'\n';
// }
   return;
}
