#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../med/Dielec_Continu.hh"
#include "../phi/Coordinates.hh"
#include <vector>
#include <cmath>

class MEM_med_cdotsec {
public:
   std::vector<bool> o_L6sub;           //vertices included
   MEM_med_cdotsec(){
   }
   void L6sub(int i,bool a){
      o_L6sub[ i]=a;  }
   bool L6sub(int i){
      return o_L6sub[ i];  }
};

bool Dielec_Continu::tDOT::MED_CDOTSEC(const DAT_PHYSICS_CONSTS& physics_consts,
                                       const Coordinates& m){
   MEM_med_cdotsec vv;
   bool EXCLUDE;
   if( typ!=-1 )return EXCLUDE=true;
   int oL6=K6[0].L6.size();             //number of edges in original cycle
   double rr= (r*r);                    //square of probe radius
//
//
// test surface element for total exclusion
//
   vv.o_L6sub.resize(oL6);
   bool sub=false;
   for(int iL6=0;iL6<oL6;iL6++){
      vv.L6sub(iL6,( dot( K6[0].L6[iL6].v, m)<( 1.00e-7) ));
      sub=sub||vv.L6sub(iL6);
   }
   if( !sub ){
      vv.o_L6sub.clear();
      return EXCLUDE=true;
   }
//
//
// test surface element for total inclusion
//
   int aL6=-1;                          //edge entering plane
   int bL6=-1;                          //edge exiting plane
   for(int iL6=0;iL6<oL6;iL6++){
      int jL6=(iL6+1)%oL6;
      if      (  vv.L6sub(iL6)&&!vv.L6sub(jL6) ){
         aL6=iL6;
         Coordinates u=K6[0].L6[aL6].c;
         double Cbet= dot(m,u);
         if      ( ( Cbet -(1.00))>(-1.00e-7) ){
            vv.o_L6sub.clear();
            return EXCLUDE=false;
         }else if( ( Cbet +(1.00))<( 1.00e-7) ){
            vv.o_L6sub.clear();
            return EXCLUDE=true;
         }
      }else if( !vv.L6sub(iL6)&& vv.L6sub(jL6) ){
         bL6=iL6;
         Coordinates u= K6[0].L6[bL6].c;
         double Cbet= dot(m,u);
         if      ( ( Cbet -(1.00))>(-1.00e-7) ){
            vv.o_L6sub.clear();
            return EXCLUDE=false;
         }else if( ( Cbet +(1.00))<( 1.00e-7) ){
            vv.o_L6sub.clear();
            return EXCLUDE=true;
         }
      }
   }
   vv.o_L6sub.clear();
   if( aL6==-1 ){
      return EXCLUDE=false;
   }
//
//
// vertex entering plane
//
   Coordinates u=K6[0].L6[aL6].c;
   double Cbet= dot(m,u);
   double Sbet= std::sqrt( (1.00) -Cbet*Cbet);
   Coordinates v=m;
   v-=(Cbet*u);
   v/=Sbet;
   Coordinates w= cross(u,v);
   Coordinates q=r*w;
//
//
// patch edge aL6
//
   Coordinates o=K6[0].L6[aL6].v;
   double Cphi= dot(o,q)/rr;
   if( ( Cphi -(1.00))>(-1.00e-7) ){
      K6[0].L6[aL6].phi= (0.00);
   }else{
      K6[0].L6[aL6].phi= std::acos( Cphi);
   }
//
//
// initiate new edge intersecting plane
//
   tL6 g;                               //new edge
   g.v=q;
   g.c=m;
   g.del= (0.00);
   g.the= (0.00);
   g.bet= std::acos( Cbet);
   g.jA5=-1;
//
//
// vertex exiting plane
//
   u= K6[0].L6[bL6].c;
   Cbet= dot(m,u);
   Sbet= std::sqrt( (1.00) -Cbet*Cbet);
   v=m;
   v-=(Cbet*u);
   v/=Sbet;
   w= cross(v,u);
   Coordinates p=r*w;
//
//
// complete new edge
//
   Cphi= dot(p,q)/rr;
   if( ( Cphi -(1.00))>(-1.00e-7) ){
      g.phi= (0.00);
   }else{
      g.phi= std::acos( Cphi);
   }
//
//
// patch edge bL6
//
   o=K6[0].L6[(bL6+1)%oL6].v;
   K6[0].L6[bL6].v=p;
   K6[0].L6[bL6].bet= std::acos( Cbet);
   Cphi= dot(p,o)/rr;
   if( ( Cphi -(1.00))>(-1.00e-7) ){
      K6[0].L6[bL6].phi= (0.00);
   }else{
      K6[0].L6[bL6].phi= std::acos( Cphi);
   }
//
//
// modify cycle of edges
//
   int jL6=(aL6+1)%oL6;
   if      ( jL6< bL6 ){
      K6[0].L6.erase(K6[0].L6.begin()+jL6,K6[0].L6.begin()+bL6);
      K6[0].L6.insert(K6[0].L6.begin()+jL6,g);
   }else if( jL6==bL6 ){
      K6[0].L6.insert(K6[0].L6.begin()+jL6,g);
   }else if( jL6> bL6 ){
      K6[0].L6.erase(K6[0].L6.begin()+jL6,K6[0].L6.begin()+oL6);
      K6[0].L6.insert(K6[0].L6.begin()+jL6,g);
      K6[0].L6.erase(K6[0].L6.begin()    ,K6[0].L6.begin()+bL6);
   }
//
//
// area of surface element
//
   double z= (2.)*physics_consts.PI;
   oL6=K6[0].L6.size();
   for(int iL6=0;iL6<oL6;iL6++){
      z-=K6[0].L6[iL6].bet;
   }
   a= rr*z;

   return EXCLUDE=( a<(2.00e-4) );
}
