#include "../med/Dielec_Continu.hh"
#include "../phi/Coordinates.hh"
#include <cmath>

void Dielec_Continu::MED_BURIED(){
//
//
// partial construction of surface
//
   for(int iA5= 0;iA5<nA5;iA5++){
      A5[iA5].cI5=0;
   }
   for(int iA5= 0;iA5<(nA5-1);iA5++){
      for(int jA5=(iA5+1);jA5<nA5;jA5++){
         double rr=( A5[jA5].x -A5[iA5].x).rr();
         double z=( A5[iA5].r +A5[jA5].r +(2.)*probe);
         if( rr<(z*z) ){
            A5[iA5].I5.push_back( tA5::tA5I5());
            A5[iA5].I5[A5[iA5].cI5++].A5=jA5;
            A5[jA5].I5.push_back( tA5::tA5I5());
            A5[jA5].I5[A5[jA5].cI5++].A5=iA5;
         }
      }
   }

   for(int iA5= 0;iA5<nA5;iA5++){
      A5[iA5].free=true;
   }
   nB5=0;
   for(int iA5= 0;iA5<nA5;iA5++){
      for(int iI5= 0;iI5<A5[iA5].cI5;iI5++){
         int jA5=A5[iA5].I5[iI5].A5;
         if( jA5<iA5 )continue;
         Coordinates d=( A5[jA5].x -A5[iA5].x);
         double rr= d.rr();
         double p=( A5[iA5].r +A5[jA5].r +(2.)*probe);
         double q=( A5[iA5].r -A5[jA5].r);
         double f1=( p*p -rr);
         double f2=( rr -q*q);
         if( f2<=(0.00) ){
            if( A5[iA5].r<A5[jA5].r ){
               A5[iA5].free=false;
            }else{
               A5[jA5].free=false;
            }
         }else{
            A5[iA5].I5[iI5].B5=nB5;
            B5.push_back(tB5());
            B5[nB5].N2A5[0]=iA5;
            B5[nB5].N2A5[1]=jA5;
            B5[nB5].c= d;
            B5[nB5].c.normalize();
            double bi=( A5[iA5].r +probe);
            double bj=( A5[jA5].r +probe);
            double z=( rr +bi*bi -bj*bj)/( (2.)*rr);
            B5[nB5].x=( A5[iA5].x +z*d);
            B5[nB5].r= std::sqrt( f1*f2/rr)/(2.);
            nB5++;
            A5[iA5].free=false;
            A5[jA5].free=false;
         }
      }
   }

   for(int iB5= 0;iB5<nB5;iB5++){
      B5[iB5].free=true;
   }
   nC5=0;
   for(int ijB5= 0;ijB5<nB5;ijB5++){
      int iA5=B5[ijB5].N2A5[0];
      int jA5=B5[ijB5].N2A5[1];
      for(int jI5= 0;jI5<A5[jA5].cI5;jI5++){
         int jkB5=A5[jA5].I5[jI5].B5;
         if( jkB5==-1 )continue;
         int kA5=A5[jA5].I5[jI5].A5;
         int ikB5=-1;
         for(int iI5= 0;iI5<A5[iA5].cI5;iI5++){
            if( A5[iA5].I5[iI5].A5==kA5 )ikB5=A5[iA5].I5[iI5].B5;
         }
         if( ikB5==-1 )continue;
         Coordinates u= B5[ijB5].c;
         Coordinates c= B5[ikB5].c;
         double Cthe= dot(c,u);
         double Sthe=( (1.00) -Cthe*Cthe);
         if( Sthe<(1.00e-15) )continue;
         Sthe= ((1.00)/std::sqrt( Sthe));
         Coordinates w= Sthe*cross(u,c);
         Coordinates v= cross(w,u);
         double z= Sthe*dot(c,( B5[ikB5].x -B5[ijB5].x));
         Coordinates x=( B5[ijB5].x +z*v);
         double rr=( x -A5[iA5].x).rr();
         double bi=( A5[iA5].r +probe);
         double hh=( bi*bi -rr);
         if( hh<=(0.00) ){
         }else{
            B5[ijB5].free=false;
            B5[jkB5].free=false;
            B5[ikB5].free=false;
            double h= std::sqrt( hh);
            for(double SGN=( 1.00);SGN>=(-1.00);SGN-=( 2.00)){
               Coordinates y=( x +(SGN*h)*w);

               bool EXCLUDED=false;
               for(int iI5= 0;iI5<A5[iA5].cI5&&(!EXCLUDED);iI5++){
                  int lA5=A5[iA5].I5[iI5].A5;
                  if( lA5==jA5 )continue;
                  if( lA5==kA5 )continue;
                  double r=( y -A5[lA5].x).r();
                  double bl=( A5[lA5].r +probe);
                  if      ( ( r -bl)<(-1.00e-11) ){
                     EXCLUDED=true;
                  }else if( ( r -bl)<( 1.00e-11) ){
                     int pN3A5[3];
                     int qN3A5[3];
                     pN3A5[0]=iA5;
                     pN3A5[1]=jA5;
                     pN3A5[2]=kA5;
                     int iSGN=( SGN>(0.00) )? 1:-1;
                     if      ( lA5<iA5 ){
                        qN3A5[0]=lA5;
                        qN3A5[1]=iA5;
                        qN3A5[2]=jA5;
                        bool SHEDGE=false;
                        bool ADJFAC=false;
                        Coordinates d=( A5[iA5].x -A5[lA5].x);
                        Coordinates e=( A5[jA5].x -A5[lA5].x);
                        int jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        bool EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(1.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }
                        qN3A5[0]=lA5;
                        qN3A5[1]=iA5;
                        qN3A5[2]=kA5;
                        SHEDGE=false;
                        ADJFAC=false;
                        d=( A5[iA5].x -A5[lA5].x);
                        e=( A5[kA5].x -A5[lA5].x);
                        jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(1.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }
                        qN3A5[0]=lA5;
                        qN3A5[1]=jA5;
                        qN3A5[2]=kA5;
                        SHEDGE=false;
                        ADJFAC=false;
                        d=( A5[jA5].x -A5[lA5].x);
                        e=( A5[kA5].x -A5[lA5].x);
                        jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(1.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }

                     }else if( lA5<jA5 ){
                        qN3A5[0]=iA5;
                        qN3A5[1]=lA5;
                        qN3A5[2]=jA5;
                        bool SHEDGE=false;
                        bool ADJFAC=false;
                        Coordinates d=( A5[lA5].x -A5[iA5].x);
                        Coordinates e=( A5[jA5].x -A5[iA5].x);
                        int jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        bool EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(1.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }
                        qN3A5[0]=iA5;
                        qN3A5[1]=lA5;
                        qN3A5[2]=kA5;
                        SHEDGE=false;
                        ADJFAC=false;
                        d=( A5[lA5].x -A5[iA5].x);
                        e=( A5[kA5].x -A5[iA5].x);
                        jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(1.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }

                     }else if( lA5<kA5 ){
                        qN3A5[0]=iA5;
                        qN3A5[1]=jA5;
                        qN3A5[2]=lA5;
                        bool SHEDGE=false;
                        bool ADJFAC=false;
                        Coordinates d=( A5[jA5].x -A5[iA5].x);
                        Coordinates e=( A5[lA5].x -A5[iA5].x);
                        int jSGN=iSGN*(( dot( cross(d,e), w)>(0.00) )? 1:-1);
                        for(int i0=0;i0<3&&(!SHEDGE)&&(!ADJFAC);i0++){
                           int i1=( 3+i0+iSGN)%3;
                           for(int j0=0;j0<3&&(!SHEDGE)&&(!ADJFAC);j0++){
                              int j1=( 3+j0+jSGN)%3;
                              if( (pN3A5[i0]==qN3A5[j0])&&
                                  (pN3A5[i1]==qN3A5[j1]) ){
                                 SHEDGE=true;
                              }
                              if( (pN3A5[i0]==qN3A5[j1])&&
                                  (pN3A5[i1]==qN3A5[j0]) ){
                                 ADJFAC=true;
                              }
                           }
                        }
                        bool EQPROB=false;
                        for(int iC5= 0;iC5<nC5&&(!EQPROB);iC5++){
                           if( C5[iC5].N3A5[0]!=qN3A5[0] )continue;
                           if( C5[iC5].N3A5[1]!=qN3A5[1] )continue;
                           if( C5[iC5].N3A5[2]!=qN3A5[2] )continue;
                           rr=( C5[iC5].x -y).rr();
                           if( rr>(1.00e-22) )continue;
                           EQPROB=true;
                        }
                        if( EQPROB ){
                           if      ( SHEDGE ){
                              EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=false;
                           }else{
                              EXCLUDED=true;
                           }
                           continue;
                        }else{
                           if      ( SHEDGE ){
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }else if( ADJFAC ){
                              EXCLUDED=true;
                              continue;
                           }else{
                              if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                           }
                        }
                     }else{
                        if( ( r -bl)<(-1.00e-12) )EXCLUDED=true;
                     }

                  }
               }
               if( EXCLUDED )continue;

               C5.push_back(tC5());
               C5[nC5].N3A5[0]=iA5;
               C5[nC5].N3A5[1]=jA5;
               C5[nC5].N3A5[2]=kA5;
               C5[nC5].x= y;
               nC5++;
            }
         }
      }
   }
   for(int ijB5= 0;ijB5<nB5;ijB5++){
      if( !B5[ijB5].free )continue;
      int iA5=B5[ijB5].N2A5[0];
      int jA5=B5[ijB5].N2A5[1];
      for(int iI5= 0;iI5<A5[iA5].cI5;iI5++){
         int kA5=A5[iA5].I5[iI5].A5;
         if( kA5==jA5 )continue;
         double bk=( A5[kA5].r +probe);
         double rr=( A5[kA5].x -B5[ijB5].x).rr();
         double z=( bk*bk -rr -B5[ijB5].r*B5[ijB5].r);
         if( z>(0.00) ){
            B5[ijB5].free=false;
            break;
         }
      }
   }
//
//
// exclude surface exposed
//
   for(int iA5= 0;iA5<nA5;iA5++){
      A5[iA5].bur=true;
   }
   for(int iC5= 0;iC5<nC5;iC5++){
      A5[C5[iC5].N3A5[0]].bur=false;
      A5[C5[iC5].N3A5[1]].bur=false;
      A5[C5[iC5].N3A5[2]].bur=false;
   }
   for(int iA5= 0;iA5<nA5;iA5++){
      if( A5[iA5].free ){
         A5[iA5].bur=false;
      }
   }
   for(int iB5= 0;iB5<nB5;iB5++){
      if( B5[iB5].free ){
         A5[B5[iB5].N2A5[0]].bur=false;
         A5[B5[iB5].N2A5[1]].bur=false;
      }
   }
//
//
// clear arrays
//
   B5.clear();
   C5.clear();
   for(int iA5= 0;iA5<nA5;iA5++){
      A5[iA5].I5.clear();
   }
   return;
}
