#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../med/Dielec_Continu.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Scratch_Multipoles.hh"
#include "../phi/Spherical_Harmonics.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>

void Dielec_Continu::MED_BSE(const DAT_PHYSICS_CONSTS& physics_consts,
                             const DAT_ARRAY_CONSTS& array_consts,
                             Output_Streams& out){
   double f=( (1.) -(80.))/((2.)*physics_consts.PI*( (1.) +(80.)));
   Scratch_Multipoles q1;               //
   Scratch_Multipoles q2;               //
   Scratch_Multipoles q3;               //
   Scratch_Multipoles QQ;               //
   Spherical_Harmonics H;               //
//
//
// (1/r)**(L+1) >(1e-6)/(L+1)(4**L)
//
   double Lr[ 8];                       //(1/r)**L
   double Lz[ 8];                       //(1e-4)/L*(4**(L-1))
   Lz[ 1]= (1.00e-4);
   for(int L=2;L<8;L++){
      Lz[L  ]= Lz[L-1]*(L-1)/((L  )*(4.));
   }
   double Lb[ 8];                       //(1e-4)/L*(b**(L-1))
//
//
// backup base
//
   bse_DOT.resize(nDOT);
   bse_nDOT=nDOT;
   for(int iDOT= 0;iDOT<nDOT;iDOT++){
      bse_DOT[iDOT].x= DOT[iDOT].x;
   }
   bse_D5.resize(nD5);
   bse_nD5=nD5;
   for(int iD5= 0;iD5<nD5;iD5++){
      bse_D5[iD5].x= D5[iD5].x;
      bse_D5[iD5].DOTa= D5[iD5].DOTa;
      bse_D5[iD5].cDOT= D5[iD5].cDOT;
   }
//
//
// D5[].qn
//
   for(int iD5= 0;iD5<nD5;iD5++){
      int iDOTmin=D5[iD5].DOTa;
      int iDOTmax=(iDOTmin-1+D5[iD5].cDOT);
      q2.populate( 5,D5[iD5].n);
      bse_D5[iD5].qn= (0.00);
      double b=( D5[iD5].d>(4.00) )? D5[iD5].d: (4.00);
      b*=(4.00);
      Lb[ 1]= (1.00e-5);
      for(int L=2;L<8;L++){
         Lb[L  ]= Lb[L-1]*(L-1)/((L  )*b);
      }
      double qn= (0.00);
      for(int iA5= 0;iA5<nA5;iA5++){
         int LTE1=A5[iA5].lte;
         q1.populate(LTE1,A5[iA5].q);
         Coordinates d=( A5[iA5].x -D5[iD5].x);
         double r= d.r();
         double z= (1.00)/r;
//       if( r<( 1.00) ){
//          int jDOT=D5[iD5].DOTa;
//          std::cerr<< std::fixed<< std::setprecision( 3);
//          std::cerr<<"FLAG: Short (surface element,atom) distance."
//                   <<"  r="<< std::setw( 7)<<r
//                   << std::endl;
//          std::cerr<<" iD5="<< std::setw( 5)<<iD5
//                   <<D5[iD5].x
//                   <<" typ="<< std::setw( 2)<<DOT[jDOT].typ
//                   <<" d="<< std::setw( 7)<<D5[iD5].d
//                   <<" a="<< std::setw( 7)<<D5[iD5].a
//                   << std::endl;
//          std::cerr<<" iA5="<< std::setw( 5)<<iA5
//                   <<A5[iA5].x
//                   <<' '<<A5[iA5].atm
//                   <<" sa="<< std::setw( 7)<<A5[iA5].sa
//                   << std::endl;
//       }
         int LTE=6;
         Lr[ 1]= z;
         for(int L=2;L<=(LTE+1);L++){
            Lr[L  ]= z*Lr[L-1];
            if( Lr[L  ]<Lb[L  ] )LTE=(L-2);
         }
         if( LTE<=5 ){
            double CT= (d(2)*z);
            double ST= std::sqrt( (1.00) -CT*CT);
            double CP,SP;
            if( ST>(1.00e-10) ){
               CP= (d(0)*z)/ST;
               SP= (d(1)*z)/ST;
            }else{
               CP= (1.00);
               SP= (0.00);
            }
            H.populate(array_consts,LTE,CT,ST,CP,SP);
            if( LTE1>0 ){
               QQ.populate(LTE);
               QQ.product(array_consts,q2,q1);
               for(int L=0;L<=LTE;L++){
                  double F= (0.00);
                  for(int M=-L;M<=L;M++){
                     F+=( QQ.r(L,M)*H.r(L,M)
                         -QQ.i(L,M)*H.i(L,M));
                  }
                  qn+=(Lr[L+1]*F);
               }
            }else{
               double G= (0.00);
               for(int L=0;L<=LTE;L++){
                  double F= (0.00);
                  for(int M=-L;M<=L;M++){
                     F+=( q2.r(L,M)*H.r(L,M)
                         -q2.i(L,M)*H.i(L,M));
                  }
                  G+=(Lr[L+1]*F);
               }
               qn+=(q1.r(0,0)*G);
            }
         }else{
            for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
               q3.populate( 1,DOT[iDOT].n);
               d=( DOT[iDOT].x -A5[iA5].x);
               r= d.r();
               z= (1.00)/r;
               LTE=(1+LTE1);
               Lr[ 1]= z;
               for(int L=2;L<=(LTE+1);L++){
                  Lr[L  ]= z*Lr[L-1];
                  if( Lr[L  ]<Lz[L  ] )LTE=(L-2);
               }
               double t= (0.00);
               if      ( LTE==0 ){
               }else if( LTE==1 ){
                  double Cthe= z*dot(d,DOT[iDOT].c);
                  t+=(Lr[ 2]*q1.r(0,0)*Cthe);
               }else{
                  double CT= d(2)*z;
                  double ST= std::sqrt( (1.00) -CT*CT);
                  double CP,SP;
                  if( ST>(1.00e-10) ){
                     CP= d(0)*z/ST;
                     SP= d(1)*z/ST;
                  }else{
                     CP= (1.00);
                     SP= (0.00);
                  }
                  QQ.populate(LTE);
                  QQ.product(array_consts,q1,q3);
                  H.populate(array_consts,LTE,CT,ST,CP,SP);
                  for(int L=0;L<=LTE;L++){
                     double F= (0.00);
                     for(int M=-L;M<=L;M++){
                        F+=( QQ.r(L,M)*H.r(L,M)
                            -QQ.i(L,M)*H.i(L,M));
                     }
                     t-=Lr[L+1]*F;
                  }
               }
               qn+=(DOT[iDOT].a*t);
            }
         }
      }
      qn*=f;
      bse_D5[iD5].qn+=qn;
   }
//
//
// D5D5ne
//
   o_D5D5ne.clear();
   o_D5D5ne.resize(nD5*nD5,(0.00));
   for(int iD5= 0;iD5<nD5;iD5++){
      int iDOTmin=D5[iD5].DOTa;
      int iDOTmax=(iDOTmin-1+D5[iD5].cDOT);
      q1.populate( 5,D5[iD5].n);
      for(int jD5= 0;jD5<nD5;jD5++){
         int jDOTmin=D5[jD5].DOTa;
         int jDOTmax=(jDOTmin-1+D5[jD5].cDOT);
         double b=( D5[jD5].d>D5[iD5].d )? D5[jD5].d: D5[iD5].d;
         Coordinates d=( D5[jD5].x -D5[iD5].x);
         double r= d.r();
         if( r<(1.00e-6) )r= (1.00e-6);
         double z= (1.00)/r;
         int LTE=6;
         Lb[ 1]= (1.00e-4);
         Lr[ 1]= z;
         for(int L=2;L<=(LTE+1);L++){
            Lb[L  ]= Lb[L-1]*(L-1)/((L  )*b);
            Lr[L  ]= z*Lr[L-1];
            if( Lr[L  ]<Lb[L  ] )LTE=(L-2);
         }
         if( LTE<=5 ){
            q2.populate((LTE-1),D5[jD5].e);
            double CT= (d(2)*z);
            double ST= std::sqrt( (1.00) -CT*CT);
            double CP,SP;
            if( ST>(1.00e-10) ){
               CP= (d(0)*z)/ST;
               SP= (d(1)*z)/ST;
            }else{
               CP= (1.00);
               SP= (0.00);
            }
            QQ.populate(LTE);
            QQ.product(array_consts,q1,q2);
            H.populate(array_consts,LTE,CT,ST,CP,SP);
            for(int L=0;L<=LTE;L++){
               double F= (0.00);
               for(int M=-L;M<=L;M++){
                  F+=( QQ.r(L,M)*H.r(L,M)
                      -QQ.i(L,M)*H.i(L,M));
               }
               D5D5ne(iD5,jD5)+=Lr[L+1]*F;
            }
         }else{
            for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
               double en= (0.00);
               for(int jDOT=jDOTmin;jDOT<=jDOTmax;jDOT++){
                  if( jDOT==iDOT ){
                     if      ( DOT[jDOT].typ==-1 ){
                        en-=((2.)*physics_consts.PI/std::sqrt(320.));
                     }else if( DOT[jDOT].typ== 0 ){
                     }else if( DOT[jDOT].typ== 1 ){
                        en+=((2.)*physics_consts.PI/std::sqrt(320.));
                     }
                  }else{
                     d=( DOT[iDOT].x -DOT[jDOT].x);
                     r= d.r();
                     if( r<(0.40) )continue;
                     z= (1.00)/r;
                     double s= MED_SWITCH( r);
                     double Cthe= z*dot(d,DOT[iDOT].c);
                     en+=(s*z*z*DOT[jDOT].a*Cthe);
                  }
               }
               D5D5ne(iD5,jD5)-=(DOT[iDOT].a*en);
            }
         }
         D5D5ne(iD5,jD5)*=f;
      }
   }
//
//
// D5[].qe
//
   for(int iD5= 0;iD5<nD5;iD5++){
      int iDOTmin=D5[iD5].DOTa;
      int iDOTmax=(iDOTmin-1+D5[iD5].cDOT);
      q1.populate( 5,D5[iD5].e);
      bse_D5[iD5].qe= (0.00);
      double b=( D5[iD5].d>(4.00) )? D5[iD5].d: (4.00);
      Lb[ 1]= (1.00e-4);
      for(int L=2;L<8;L++){
         Lb[L  ]= Lb[L-1]*(L-1)/((L  )*b);
      }
      for(int iA5= 0;iA5<nA5;iA5++){
         int LTE2=A5[iA5].lte;
         Coordinates d=( A5[iA5].x -D5[iD5].x);
         double r= d.r();
         double z= (1.00)/r;
         int LTE=6;
         Lr[ 1]= z;
         for(int L=2;L<=(LTE+1);L++){
            Lr[L  ]= z*Lr[L-1];
            if( Lr[L  ]<Lb[L  ] )LTE=(L-2);
         }
         if( LTE<=5 ){
            double CT= (d(2)*z);
            double ST= std::sqrt( (1.00) -CT*CT);
            double CP,SP;
            if( ST>(1.00e-10) ){
               CP= (d(0)*z)/ST;
               SP= (d(1)*z)/ST;
            }else{
               CP= (1.00);
               SP= (0.00);
            }
            H.populate(array_consts,LTE,CT,ST,CP,SP);
            if( LTE2>0 ){
               q2.populate(LTE2,A5[iA5].q);
               QQ.populate(LTE);
               QQ.product(array_consts,q1,q2);
               for(int L=0;L<=LTE;L++){
                  double F= (0.00);
                  for(int M=-L;M<=L;M++){
                     F+=( QQ.r(L,M)*H.r(L,M)
                         -QQ.i(L,M)*H.i(L,M));
                  }
                  bse_D5[iD5].qe+=(Lr[L+1]*F);
               }
            }else{
               double G= (0.00);
               for(int L=0;L<=LTE;L++){
                  double F= (0.00);
                  for(int M=-L;M<=L;M++){
                     F+=( q1.r(L,M)*H.r(L,M)
                         -q1.i(L,M)*H.i(L,M));
                  }
                  G+=(Lr[L+1]*F);
               }
               bse_D5[iD5].qe+=(A5[iA5].q.r(0,0)*G);
            }
         }else{
            for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
               double qe= (0.00);
               d=( DOT[iDOT].x -A5[iA5].x);
               r= d.r();
               z= (1.00)/r;
               LTE=LTE2;
               Lr[ 1]= z;
               for(int L=2;L<=(LTE+1);L++){
                  Lr[L  ]= z*Lr[L-1];
                  if( Lr[L  ]<Lz[L  ] )LTE=(L-2);
               }
               if( LTE==0 ){
                  qe+=(A5[iA5].q.r(0,0)*z);
               }else{
                  q2.populate(LTE,A5[iA5].q);
                  double CT= d(2)*z;
                  double ST= std::sqrt( (1.00) -CT*CT);
                  double CP,SP;
                  if( ST>(1.00e-10) ){
                     CP= d(0)*z/ST;
                     SP= d(1)*z/ST;
                  }else{
                     CP= (1.00);
                     SP= (0.00);
                  }
                  H.populate(array_consts,LTE,CT,ST,CP,SP);
                  for(int L=0;L<=LTE;L++){
                     double F= (0.00);
                     for(int M=-L;M<=L;M++){
                        F+=( q2.r(L,M)*H.r(L,M)
                            -q2.i(L,M)*H.i(L,M));
                     }
                     qe+=(Lr[L+1]*F);
                  }
               }
               bse_D5[iD5].qe+=(DOT[iDOT].a*qe);
            }
         }
      }
   }
//
//
// D5D5ee
//
   o_D5D5ee.clear();
   o_D5D5ee.resize(nD5*nD5,(0.00));
   for(int iD5= 0;iD5<nD5;iD5++){
      int iDOTmin=D5[iD5].DOTa;
      int iDOTmax=(iDOTmin-1+D5[iD5].cDOT);
      q1.populate( 5,D5[iD5].e);
      for(int jD5=iD5;jD5<nD5;jD5++){
         int jDOTmin=D5[jD5].DOTa;
         int jDOTmax=(jDOTmin-1+D5[jD5].cDOT);
         double b=( D5[jD5].d>D5[iD5].d )? D5[jD5].d: D5[iD5].d;
         Coordinates d=( D5[jD5].x -D5[iD5].x);
         double r= d.r();
         if( r<(1.00e-6) )r= (1.00e-6);
         double z= (1.00)/r;
         int LTE=6;
         Lb[ 1]= (1.00e-4);
         Lr[ 1]= z;
         for(int L=2;L<=(LTE+1);L++){
            Lb[L  ]= Lb[L-1]*(L-1)/((L  )*b);
            Lr[L  ]= z*Lr[L-1];
            if( Lr[L  ]<Lb[L  ] )LTE=(L-2);
         }
         if( LTE<=5 ){
            q2.populate(LTE,D5[jD5].e);
            QQ.populate(LTE);
            QQ.product(array_consts,q1,q2);
            double CT= (d(2)*z);
            double ST= std::sqrt( (1.00) -CT*CT);
            double CP,SP;
            if( ST>(1.00e-10) ){
               CP= (d(0)*z)/ST;
               SP= (d(1)*z)/ST;
            }else{
               CP= (1.00);
               SP= (0.00);
            }
            H.populate(array_consts,LTE,CT,ST,CP,SP);
            for(int L=0;L<=LTE;L++){
               double F= (0.00);
               for(int M=-L;M<=L;M++){
                  F+=( QQ.r(L,M)*H.r(L,M)
                      -QQ.i(L,M)*H.i(L,M));
               }
               D5D5ee(iD5,jD5)+=(Lr[L+1]*F);
            }
         }else{
            for(int iDOT=iDOTmin;iDOT<=iDOTmax;iDOT++){
               double t= (0.00);
               if( jD5==iD5 )jDOTmin=(iDOT+1);
               for(int jDOT=jDOTmin;jDOT<=jDOTmax;jDOT++){
                  d=( DOT[iDOT].x -DOT[jDOT].x);
                  r= d.r();
                  if( r<(0.40) )continue;
                  double s= MED_SWITCH( r);
                  z= s/r;
                  t+=(DOT[jDOT].a*z);
               }
               D5D5ee(iD5,jD5)+=(DOT[iDOT].a*t);
            }
         }
         if( jD5>iD5 ){
            D5D5ee(jD5,iD5)= D5D5ee(iD5,jD5);
         }
      }
   }
//
//
// diagnostic output
//
// out.FILE3<< std::fixed<< std::setprecision(6);
// out.FILE3<<"   iD5""        qn""        qe\n";
// for(int iD5= 0;iD5<nD5;iD5++){
//    out.FILE3<< std::setw( 6)<<iD5
//             << std::setw(10)<<bse_D5[iD5].qn
//             << std::setw(10)<<bse_D5[iD5].qe<<'\n';
// }
// out.FILE3<< std::fixed;
// out.FILE3<<"   iD5""   jD5""      D5D5ne""      D5D5ee\n";
// for(int iD5= 0;iD5<nD5;iD5++){
//    for(int jD5= 0;jD5<nD5;jD5++){
//       out.FILE3<< std::setw( 6)<<iD5
//                << std::setw( 6)<<jD5
//                << std::setprecision(8)
//                << std::setw(12)<<D5D5ne(iD5,jD5)
//                << std::setw(12)<<D5D5ee(iD5,jD5)<<'\n';
//    }
// }
   return;
}
