#include "../med/Dielec_Continu.hh"
#include "../phi/Coordinates.hh"
#include <vector>
#include <cmath>

class MEM_med_bdotsec {
public:
   std::vector<bool> o_L6sub;           //vertices included
   MEM_med_bdotsec(){
   }
   void L6sub(int i,bool a){
      o_L6sub[ i]=a;  }
   bool L6sub(int i){
      return o_L6sub[ i];  }
};

bool Dielec_Continu::tDOT::MED_BDOTSEC(double probe,
                                       const Coordinates& m,
                                       double d,
                                       int jA5){
   MEM_med_bdotsec vv;
   bool EXCLUDE;
   if( typ!=0 )return EXCLUDE=true;
   int oL6=K6[0].L6.size();             //number of edges in original cycle
//
//
// test surface element for total exclusion
//
   vv.o_L6sub.resize(oL6);
   bool sub=false;
   for(int iL6=0;iL6<oL6;iL6++){
      vv.L6sub(iL6,( ( dot( K6[0].L6[iL6].v, m) -d)<( 1.00e-7) ));
      sub=sub||vv.L6sub(iL6);
   }
   if( !sub ){
      vv.o_L6sub.clear();
      return EXCLUDE=true;
   }
//
//
// test surface element for total inclusion
//
   int aL6=-1;                          //edge entering plane
   int bL6=-1;                          //edge exiting plane
   for(int iL6=0;iL6<oL6;iL6++){
      int jL6=(iL6+1)%oL6;
      if      (  vv.L6sub(iL6)&&!vv.L6sub(jL6) ){
         aL6=iL6;
      }else if( !vv.L6sub(iL6)&& vv.L6sub(jL6) ){
         bL6=iL6;
      }
   }
   vv.o_L6sub.clear();
   if( aL6==-1 ){
      return EXCLUDE=false;
   }
//
//
// vertex entering plane, patch edge aL6
//
   Coordinates u=m;
   Coordinates y;
   double Cphi=( 0.00);
   {
      Coordinates v=K6[0].L6[aL6].c;
      Coordinates w=cross(u,v);
      double z= (1.00)/probe;
      if      ( aL6%2==0 ){
         double Sthe= z*d;
         double Cthe= std::sqrt( (1.00) -Sthe*Sthe);
         y=( d*u +( r -probe*Cthe)*w);
         Coordinates s=z*( K6[0].L6[aL6].v -r*w);
         Coordinates t=z*( y -r*w);
         Cphi= dot(s,t);
      }else if( aL6%2==1 ){
         double Sthe= z*K6[0].L6[aL6].del;
         double Cthe= std::sqrt( (1.00) -Sthe*Sthe);
         double q=( r -probe*Cthe);
         y= K6[0].L6[aL6].del*v +q*w;
         Cphi= dot(K6[0].L6[aL6].v,w)/q;
      }
      if( Cphi >(.9999999) ){
         return EXCLUDE=true;
      }
   }
   K6[0].L6[aL6].phi= std::acos( Cphi);
//
//
// replace edge excluded by plane
//
   int gL6=(aL6+1)%oL6;
   K6[0].L6[gL6].v=y;
   K6[0].L6[gL6].c=m;
   K6[0].L6[gL6].del=d;
   if( jA5>-1 ){
      K6[0].L6[gL6].jA5=jA5;
      TILE=false;
   }
//
//
// vertex exiting plane, patch edge bL6
//
   {
      Coordinates v=K6[0].L6[bL6].c;
      Coordinates w=cross(v,u);
      double z= (1.00)/probe;
      int cL6=(bL6+1)%oL6;
      if      ( bL6%2==0 ){
         double Sthe= z*d;
         double Cthe= std::sqrt( (1.00) -Sthe*Sthe);
         y= d*u +( r -probe*Cthe)*w;
         Coordinates s=z*( K6[0].L6[cL6].v -r*w);
         Coordinates t=z*( y -r*w);
         Cphi= dot(s,t);
      }else if( bL6%2==1 ){
         double Sthe= z*K6[0].L6[bL6].del;
         double Cthe= std::sqrt( (1.00) -Sthe*Sthe);
         double q=( r -probe*Cthe);
         y= K6[0].L6[bL6].del*v +q*w;
         Cphi= dot(K6[0].L6[cL6].v,w)/q;
      }
      if( Cphi >(.9999999) ){
         return EXCLUDE=true;
      }
   }
   K6[0].L6[bL6].v=y;
   K6[0].L6[bL6].phi= std::acos( Cphi);
//
//
// area of surface element
//
   double dthe= K6[0].L6[ 0].phi;
   double dphi= K6[0].L6[ 1].phi;
   double z= std::sin( (0.50)*dthe);
   double Sthe= dot(K6[0].L6[ 0].v,K6[0].L6[ 1].c)/probe;
   double Cthe= std::sqrt( (1.00) -Sthe*Sthe);
   double the= std::atan2(Sthe,Cthe);
   the+=((0.50)*dthe);
   Cthe= std::cos( the);
   a= dphi*probe*( r*dthe -probe*(2.00)*Cthe*z);

   return EXCLUDE=( a<(2.00e-4) );
}
