#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../med/Dielec_Continu.hh"
#include "../phi/Coordinates.hh"
#include <vector>
#include <iostream>
#include <iomanip>
#include <cmath>

class MEM_med_adotsec {
public:
   std::vector<bool> o_K6sub;           //cycles included
   std::vector<bool> o_L6sub;           //vertices included
   MEM_med_adotsec(){
   }
   void K6sub(int i,bool a){
      o_K6sub[ i]=a;  }
   bool K6sub(int i){
      return o_K6sub[ i];  }
   void L6sub(int i,bool a){
      o_L6sub[ i]=a;  }
   bool L6sub(int i){
      return o_L6sub[ i];  }
};

bool Dielec_Continu::tDOT::MED_ADOTSEC(const DAT_PHYSICS_CONSTS& physics_consts,
                                       const Coordinates& m,
                                       double d,
                                       int jA5){
   MEM_med_adotsec vv;
   bool EXCLUDE;
   if( typ!=1 )return EXCLUDE=true;
   double rr= (r*r);                    //square of atom radius
   int oK6=K6.size();
   vv.o_K6sub.resize(oK6);
   for(int iK6=0;iK6<oK6;iK6++){
      int oL6=K6[iK6].L6.size();
//
//
// test surface element for total exclusion
//
      vv.o_L6sub.resize(oL6);
      vv.K6sub(iK6,false);
      for(int iL6=0;iL6<oL6;iL6++){
         vv.L6sub(iL6,( ( dot( K6[iK6].L6[iL6].v, m) -d)<( 1.00e-7) ));
         vv.K6sub(iK6,vv.K6sub(iK6)||vv.L6sub(iL6));
      }
      if( !vv.K6sub(iK6) )continue;
//
//
// test surface element for total inclusion
//
      int aL6=-1;                       //edge entering plane
      int bL6=-1;                       //edge exiting plane
      int gL6=-1;                       //edge created by plane
      bool PASS=false;
      for(int iL6=0;iL6<oL6&&(!PASS);iL6++){
         int jL6=(iL6+1)%oL6;
         if      (  vv.L6sub(iL6)&&!vv.L6sub(jL6) ){
            aL6=iL6;
            Coordinates u= K6[iK6].L6[aL6].c;
            double Cthe= dot(m,u);
            if      ( ( Cthe -(1.00))>(-1.00e-7) ){
               PASS=true;
            }else if( ( Cthe +(1.00))<( 1.00e-7) ){
               vv.K6sub(iK6,false);
               PASS=true;
            }
         }else if( !vv.L6sub(iL6)&& vv.L6sub(jL6) ){
            bL6=iL6;
            Coordinates u= K6[iK6].L6[bL6].c;
            double Cthe= dot(m,u);
            if      ( ( Cthe -(1.00))>(-1.00e-7) ){
               PASS=true;
            }else if( ( Cthe +(1.00))<( 1.00e-7) ){
               vv.K6sub(iK6,false);
               PASS=true;
            }
         }
      }
      if( PASS )continue;
      if( aL6==-1 ){
      }else{
//
//
// vertex entering plane
//
         Coordinates u= K6[iK6].L6[aL6].c;
         double Cthe= dot(m,u);
         double Sthe= std::sqrt( (1.00) -Cthe*Cthe);
         Coordinates v=m;
         v-=(Cthe*u);
         v/=Sthe;
         Coordinates w= cross(u,v);
         double zu= K6[iK6].L6[aL6].del;
         double zv=( d -Cthe*zu)/Sthe;
         double zz=( rr -zu*zu -zv*zv);
         if( zz<(0.00) )zz= (0.00);
         double zw= std::sqrt( zz);
         Coordinates q=( zu*u +zv*v +zw*w);
//
//
// patch edge aL6
//
         Coordinates s=( K6[iK6].L6[aL6].v -zu*u).normalize();
         Coordinates t=( q -zu*u).normalize();
         double Cphi= dot(s,t);
         if( Cphi>(1.00) )Cphi= (1.00);
         K6[iK6].L6[aL6].phi= std::acos( Cphi);
//
//
// initiate new edge intersecting plane
//
         tL6 g;                         //new edge
         g.v=q;
         g.c=m;
         g.del=d;
         g.the= std::asin( d/r);
         double Cbet= dot( cross(u,q).normalize(), cross(m,q).normalize());
         if( Cbet>(1.00) )Cbet= (1.00);
         g.bet= std::acos( Cbet);
         g.jA5=jA5;
         s=( q -d*m).normalize();
//
//
// vertex exiting plane
//
         u= K6[iK6].L6[bL6].c;
         Cthe= dot(m,u);
         Sthe= std::sqrt( (1.00) -Cthe*Cthe);
         v=m;
         v-=(Cthe*u);
         v/=Sthe;
         w= cross(v,u);
         zu= K6[iK6].L6[bL6].del;
         zv=( d -Cthe*zu)/Sthe;
         zz=( rr -zu*zu -zv*zv);
         if( zz<(0.00) )zz= (0.00);
         zw= std::sqrt( zz);
         Coordinates p=( zu*u +zv*v +zw*w);
//
//
// complete new edge
//
         t=( p -d*m).normalize();
         Cphi= dot(s,t);
         if( Cphi>(1.00) )Cphi= (1.00);
         g.phi= std::acos( Cphi);
//
//
// patch edge bL6
//
         s=( p -zu*u).normalize();
         t=( K6[iK6].L6[(bL6+1)%oL6].v -zu*u).normalize();
         K6[iK6].L6[bL6].v=p;
         Cphi= dot(s,t);
         if( Cphi>(1.00) )Cphi= (1.00);
         K6[iK6].L6[bL6].phi= std::acos( Cphi);
         Cbet= dot( cross(u,p).normalize(), cross(m,p).normalize());
         if( Cbet>(1.00) )Cbet= (1.00);
         K6[iK6].L6[bL6].bet= std::acos( Cbet);
//
//
// modify cycle of edges
//
         gL6=(aL6+1)%oL6;
         if      ( gL6< bL6 ){
            K6[iK6].L6.erase(K6[iK6].L6.begin()+gL6,K6[iK6].L6.begin()+bL6);
            K6[iK6].L6.insert(K6[iK6].L6.begin()+gL6,g);
         }else if( gL6==bL6 ){
            K6[iK6].L6.insert(K6[iK6].L6.begin()+gL6,g);
         }else if( gL6> bL6 ){
            K6[iK6].L6.erase(K6[iK6].L6.begin()+gL6,K6[iK6].L6.begin()+oL6);
            K6[iK6].L6.insert(K6[iK6].L6.begin()+gL6,g);
            K6[iK6].L6.erase(K6[iK6].L6.begin()    ,K6[iK6].L6.begin()+bL6);
            gL6-=bL6;
         }
         oL6=K6[iK6].L6.size();
         aL6=-1;
         bL6=-1;
         for(int iL6=0;iL6<oL6;iL6++){
            int jL6=(iL6+1)%oL6;
            if      ( jL6==gL6 ){
               aL6=iL6;
            }else if( iL6==gL6 ){
               bL6=jL6;
            }
         }
      }
//
//
// edge double intersections
//
      vv.o_L6sub.clear();
      vv.o_L6sub.resize(oL6,false);
      int nsub=0;
      int hL6=-1;
      for(int iL6=0;iL6<oL6;iL6++){
         if( iL6==aL6 )continue;
         if( iL6==gL6 )continue;
         if( iL6==bL6 )continue;
         Coordinates u= K6[iK6].L6[iL6].c;
         double zu= K6[iK6].L6[iL6].del;
         double f= (1.00)/std::sqrt( rr-zu*zu);
         double Cthe= dot(m,u);
         if      ( ( Cthe -(1.00))>(-1.00e-7) ){
            continue;
         }else if( ( Cthe +(1.00))<( 1.00e-7) ){
            continue;
         }
         double Sthe= std::sqrt( (1.00) -Cthe*Cthe);
         Coordinates v=m;
         v-=(Cthe*u);
         v/=Sthe;
         Coordinates w= cross(v,u);
         double zv=( d -Cthe*zu)/Sthe;
         double zz=( rr -zu*zu -zv*zv);
         if( zz<( 1.00e-7) )continue;
         double zw= std::sqrt( zz);
         double Cph0= f*dot(K6[iK6].L6[iL6].v,v);
         double Sph0= f*dot(K6[iK6].L6[iL6].v,w);
         double ph0= std::atan2(Sph0,Cph0);
         double ph3=( ph0 +K6[iK6].L6[iL6].phi);
         double Cph1= f*zv;
         double Sph1=-f*zw;
         double ph1= std::atan2(Sph1,Cph1);
         double ph2=-ph1;
         if( (ph0<ph1)&&(ph2<ph3) ){
            vv.L6sub(iL6, true);
            nsub++;
            hL6=iL6;
         }
      }
      if      ( nsub==0 ){
      }else if( nsub==1 ){
         Coordinates u= K6[iK6].L6[hL6].c;
         double zu= K6[iK6].L6[hL6].del;
         double f= (1.00)/std::sqrt( rr -zu*zu);
         double e= (1.00)/std::sqrt( rr -d*d);
         double Cthe= dot(m,u);
         double Sthe= std::sqrt( (1.00) -Cthe*Cthe);
         Coordinates v=m;
         v-=(Cthe*u);
         v/=Sthe;
         Coordinates w= cross(v,u);
         double zv=( d -Cthe*zu)/Sthe;
         double zw= std::sqrt( rr -zu*zu -zv*zv);
         Coordinates p=( zu*u +zv*v -zw*w);
         Coordinates q=( zu*u +zv*v +zw*w);
         double Cph0= f*dot(K6[iK6].L6[hL6].v,v);
         double Sph0= f*dot(K6[iK6].L6[hL6].v,w);
         double ph0= std::atan2(Sph0,Cph0);
         double ph3=( ph0 +K6[iK6].L6[hL6].phi);
         double Cph1= f*zv;
         double Sph1=-f*zw;
         double ph1= std::atan2(Sph1,Cph1);
         double ph2=-ph1;
         Coordinates s=e*( p -d*m);
         Coordinates t=e*( q -d*m);
         double Cbet= f*e*( Cthe*rr -d*zu);
         if( Cbet>(1.00) )Cbet= (1.00);
         if( gL6==-1 ){
//          std::cerr<<" FLAG: Occurance in intersection"
//                     " of dot surface element with convex face"
//                     " of edge double intersection"
//                     " with zero excluded vertices.\n";
//
//
// patch edges
//
            tL6 g,h;                    //new edges
            h=K6[iK6].L6[hL6];
            K6[iK6].L6[hL6].phi=( ph1 -ph0);
            g.v=p;
            g.c=m;
            g.del=d;
            double Cphi= dot(s,t);
            if( Cphi>(1.00) )Cphi= (1.00);
            g.phi= std::acos( Cphi);
            g.the= std::asin( d/r);
            g.bet= std::acos( Cbet);
            g.jA5=jA5;
            h.v=q;
            h.phi=( ph3 -ph2);
            h.bet= std::acos( Cbet);
//
//
// add 2 edges to cycle
//
            int jL6=(hL6+1)%oL6;
            K6[iK6].L6.insert(K6[iK6].L6.begin()+jL6,h);
            K6[iK6].L6.insert(K6[iK6].L6.begin()+jL6,g);
            oL6=K6[iK6].L6.size();

         }else{
//          std::cerr<<" FLAG: Occurance in intersection"
//                     " of dot surface element with convex face"
//                     " of edge double intersection"
//                     " with excluded vertices.\n";
//
//
// clone cycle
//
            tK6 g;                      //new cycle
            g.L6.resize(oL6);
            for(int iL6=0;iL6<oL6;iL6++){
               g.L6[iL6]=K6[iK6].L6[iL6];
            }
//
//
// patch edges of 1st cycle
//
            K6[iK6].L6[hL6].phi=( ph1 -ph0);
            K6[iK6].L6[gL6].v=p;
            double Cphi= dot( s, e*( K6[iK6].L6[bL6].v -d*m));
            if( Cphi>(1.00) )Cphi= (1.00);
            K6[iK6].L6[gL6].phi= std::acos( Cphi);
            K6[iK6].L6[gL6].bet= std::acos( Cbet);
            int jL6=(hL6+1)%oL6;
            if      ( jL6< gL6 ){
               K6[iK6].L6.erase(K6[iK6].L6.begin()+jL6,
                                K6[iK6].L6.begin()+gL6);
            }else if( jL6> gL6 ){
               K6[iK6].L6.erase(K6[iK6].L6.begin()+jL6,
                                K6[iK6].L6.begin()+oL6);
               K6[iK6].L6.erase(K6[iK6].L6.begin()    ,
                                K6[iK6].L6.begin()+gL6);
            }
//
//
// patch edges of 2nd cycle
//
            g.L6[hL6].phi=( ph3 -ph2);
            g.L6[hL6].v=q;
            g.L6[hL6].bet= std::acos( Cbet);
            Cphi= dot( t, e*( g.L6[gL6].v -d*m));
            if( Cphi>(1.00) )Cphi= (1.00);
            g.L6[gL6].phi= std::acos( Cphi);
            if      ( bL6< hL6 ){
               g.L6.erase(g.L6.begin()+bL6,
                          g.L6.begin()+hL6);
            }else if( bL6> hL6 ){
               g.L6.erase(g.L6.begin()+bL6,
                          g.L6.begin()+oL6);
               g.L6.erase(g.L6.begin()    ,
                          g.L6.begin()+hL6);
            }
//
//
// add new cycle of edges
//
            K6.push_back(g);

         }
      }else{
////     std::cerr<<"FLAG: Occurrence in intersection"
////                " of dot surface element with convex face"
////              <<" of"<< std::setw( 2)<<nsub
////              <<" double edge intersections.\n";
         vv.K6sub(iK6,false);
      }
      vv.o_L6sub.clear();
   }
//
//
// remove excluded cycles
//
   for(int iK6=(oK6-1);iK6>=0;iK6--){
      if( !vv.K6sub(iK6) ){
         K6.erase(K6.begin()+iK6);
      }
   }
   oK6=K6.size();
//
//
// area of surface element
//
   a= (0.00);
   for(int iK6=0;iK6<oK6;iK6++){
      int oL6=K6[iK6].L6.size();
      double z1= (2.)*physics_consts.PI;
      double z2= (0.00);
      double z3= (0.00);
      for(int iL6=0;iL6<oL6;iL6++){
         z2+=K6[iK6].L6[iL6].phi*std::sin( K6[iK6].L6[iL6].the);
         z3+=K6[iK6].L6[iL6].bet;
      }
      a+=rr*( z1 +z2 -z3);
   }
   vv.o_K6sub.clear();
   return EXCLUDE=( oK6==0 )||( a<(2.00e-4) );
}
//
//
// tilted plane exclusion
//
bool Dielec_Continu::tDOT::MED_ADOTSEC(const DAT_PHYSICS_CONSTS& physics_consts,
                                       const Coordinates& m,
                                       double d){
   MEM_med_adotsec vv;
   bool EXCLUDE;
   if( typ!=1 )return EXCLUDE=true;
   double rr= (r*r);                    //square of atom radius
   int oK6=K6.size();
   vv.o_K6sub.resize(oK6);
   for(int iK6=0;iK6<oK6;iK6++){
      int oL6=K6[iK6].L6.size();
//
//
// test surface element for total inclusion
//
      vv.o_L6sub.resize(oL6);
      vv.K6sub(iK6, true);
      for(int iL6=0;iL6<oL6;iL6++){
         vv.L6sub(iL6,( ( dot( K6[iK6].L6[iL6].v, m) -d)<( 1.00e-7) ));
         vv.K6sub(iK6,vv.K6sub(iK6)&&vv.L6sub(iL6));
      }
      vv.o_L6sub.clear();
   }
//
//
// remove excluded cycles
//
   for(int iK6=(oK6-1);iK6>=0;iK6--){
      if( !vv.K6sub(iK6) ){
//
//
// remove area contribution of cycle
//
         int oL6=K6[iK6].L6.size();
         double z1= (2.)*physics_consts.PI;
         double z2= (0.00);
         double z3= (0.00);
         for(int iL6=0;iL6<oL6;iL6++){
            z2+=K6[iK6].L6[iL6].phi*std::sin( K6[iK6].L6[iL6].the);
            z3+=K6[iK6].L6[iL6].bet;
         }
         a-=rr*( z1 +z2 -z3);
         K6.erase(K6.begin()+iK6);
      }
   }
   oK6=K6.size();
   vv.o_K6sub.clear();
   return EXCLUDE=( oK6==0 )||( a<(2.00e-4) );
}
