#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../med/Dielec_Continu.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <sstream>
#include <iomanip>
#include <cmath>

void Energy_Surface2::MED(Phi_Automatic& aut,
                          Dielec_Continu& med,
                          const DAT_PHYSICS_CONSTS& physics_consts,
                          const DAT_ARRAY_CONSTS& array_consts,
                          const DAT_ENERGY_PARAMS& energy_params,
                          const Thread_Options& opt,
                          Output_Streams& out,
                          const Structure& str,
                          const Mechanical_System& mol,
                          const Subset_Contracted_System::tM3& con,
                          Conf_Dependent_System& dep){
//
//
// physics consts
//
   double ANG= physics_consts.ANG;
   double ANGANG= ANG*ANG;
   double CAL= physics_consts.CAL;
   double RAD= physics_consts.RAD;
//
//
// update params
//
   for(int iQ2= 0;iQ2<oQ2;iQ2++){
      med.Q2[iQ2].c=Q2[iQ2].c;
      med.Q2[iQ2].cut=Q2[iQ2].cut;
   }
//
//
// system contains nucleic acid
//
   int np( 0);
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mR0=mol.Z0[iZ0].R0a;
      int nR0=(mR0-1+mol.Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( mol.R0[iR0].c1=='p' )np++;
      }
   }
   bool NUC=( np>16 );
//
//
// components neglected for partial system
//
   med.Fqd= (0.00);
   med.Fuh= (0.00);
   med.Fcc= (0.00);
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
   }else if( NUC ){
   }else{
//
//
// params for energy density of ionized group
//
      Gaussian_Volume vf;
      {
         vf.sig=(  2.5191);
         vf.eta=(  0.7745)*ANGANG;
      }
      Gaussian_Volume ef[4];
      {
         ef[0].sig=(   0.0364569);
         ef[1].sig=(   0.0231999);
         ef[2].sig=(   0.0082857);
         ef[3].sig=(   0.0078714);
         ef[0].eta=(   0.0700071);
         ef[1].eta=(   0.0175018);
         ef[2].eta=(   0.0043754);
         ef[3].eta=(   0.0010939);
      }
      double RRij=( 0.00);
      double e2(  0.00),e0(  0.00);
      for(int i=0;i<4;i++){
         for(int j=0;j<4;j++){
            e2+=eef(physics_consts,
                    ef[i],
                    ef[j],
                    RRij);
            e0+=eevf(physics_consts,
                     ef[i],
                     ef[j],
                     vf,
                     RRij,
                     RRij,
                     RRij);
         }
      }
//
//
// initiate ionized groups, pairs of ionized groups
//
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mR0=mol.Z0[iZ0].R0a;
         int nR0=(mR0-1+mol.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iN2min=1;
            if( (iR0==mR0)||(iR0==nR0) )iN2min=0;
            for(int iN2=iN2min;iN2<=1;iN2++){
               med.R0N2(iR0,iN2).x.zero();
               med.R0N2(iR0,iN2).n=0;
               med.R0N2(iR0,iN2).z= (0.00);
               med.R0N2(iR0,iN2).sgn=0;
               med.R0N2(iR0,iN2).fq= (0.00);
               med.R0N2(iR0,iN2).d.zero();
               med.R0N2(iR0,iN2).qd= (0.00);
            }
         }
      }
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mR0=mol.Z0[iZ0].R0a;
         int nR0=(mR0-1+mol.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iN2min=1;
            if( (iR0==mR0)||(iR0==nR0) )iN2min=0;
            for(int iN2=iN2min;iN2<=1;iN2++){
               for(int jZ0=iZ0;jZ0<oZ0;jZ0++){
                  int aR0=mol.Z0[jZ0].R0a;
                  int bR0=(aR0-1+mol.Z0[jZ0].cR0);
                  int jR0min=( jZ0==iZ0 )? iR0: aR0;
                  for(int jR0=jR0min;jR0<=bR0;jR0++){
                     int jN2min=1;
                     if( (jR0==aR0)||(jR0==bR0) )jN2min=0;
                     if( jR0==iR0 )jN2min=(iN2+ 1);
                     for(int jN2=jN2min;jN2<=1;jN2++){
                        med.R0N2R0N2(iR0,iN2,jR0,jN2).ee= (0.00);
                     }
                  }
               }
            }
         }
      }
//
//
// mean position of ionized groups
//
      Dielec_Continu::tA5 ai;
      for(int iF2= 0;iF2<oF2;iF2++){
         if( con.F2[iF2].lte<0 )continue;
         if( con.F2[iF2].typ>17 )continue;
         std::string atmi=con.F2[iF2].atm;
         if( atmi[0]=='+' )atmi=' '+atmi.substr(1,3);
         int iR0=con.F2[iF2].R0;
         char ci=mol.R0[iR0].c1;
         std::string aai=mol.R0[iR0].aa;
         ai.r= (0.00);
         ai.CHG=false;
         ai.N2=1;
         ai.sgn=0;
         ai.MED_MOL_CHG(physics_consts,ci,aai,atmi);
         if( !ai.CHG )continue;
         int iN2= ai.N2;
         med.R0N2(iR0,iN2).x+=aut.F2[iF2].x;
         med.R0N2(iR0,iN2).n++;
         med.R0N2(iR0,iN2).z+=aut.F2[iF2].q.r(0,0);
         med.R0N2(iR0,iN2).sgn=ai.sgn;
      }
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mR0=mol.Z0[iZ0].R0a;
         int nR0=(mR0-1+mol.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iN2min=1;
            if( (iR0==mR0)||(iR0==nR0) )iN2min=0;
            for(int iN2=iN2min;iN2<=1;iN2++){
               if( med.R0N2(iR0,iN2).n==0 )continue;
               med.R0N2(iR0,iN2).x/=double( med.R0N2(iR0,iN2).n);
            }
         }
      }
//
//
// integral over protein volume of energy density of ionized group
//
      for(int iF2= 0;iF2<oF2;iF2++){
         if( con.F2[iF2].lte<0 )continue;
         if( con.F2[iF2].typ>17 )continue;
         std::string atmi=con.F2[iF2].atm;
         if( atmi[0]=='+' )atmi=' '+atmi.substr(1,3);
         int iR0=con.F2[iF2].R0;
         char ci=mol.R0[iR0].c1;
         std::string aai=mol.R0[iR0].aa;
         ai.r= (0.00);
         ai.CHG=false;
         ai.N2=1;
         ai.sgn=0;
         ai.MED_MOL_CHG(physics_consts,ci,aai,atmi);
         if( !ai.CHG )continue;
         int iN2= ai.N2;
         double e3=(  0.00);
         for(int kF2= 0;kF2<oF2;kF2++){
            int kT2=con.F2[kF2].typ;
            if( (kT2< 8)||(kT2>17) )continue;
            if( con.F2[kF2].mu!=1 )continue;
            double RRik=( aut.F2[iF2].x -aut.F2[kF2].x).rr();
            double RRjk= RRik;
            for(int i=0;i<4;i++){
               for(int j=0;j<4;j++){
                  e3+=eevf(physics_consts,
                           ef[i],
                           ef[j],
                           vf,
                           RRij,
                           RRik,
                           RRjk);
               }
            }
         }
         if( e3> e2 )e3= e2;
         med.R0N2(iR0,iN2).fq+=(( e3 -e0)/( e2 -e0));
      }
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mR0=mol.Z0[iZ0].R0a;
         int nR0=(mR0-1+mol.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iN2min=1;
            if( (iR0==mR0)||(iR0==nR0) )iN2min=0;
            for(int iN2=iN2min;iN2<=1;iN2++){
               if( med.R0N2(iR0,iN2).n==0 )continue;
               med.R0N2(iR0,iN2).fq/=double( med.R0N2(iR0,iN2).n);
            }
         }
      }
//
//
// resolve (fullchg,fullchg) Fe wrt pairs of ionized groups
//
      Dielec_Continu::tA5 aj;
      for(int iF2= 0;iF2<(oF2- 1);iF2++){
         if( con.F2[iF2].lte<0 )continue;
         if( con.F2[iF2].typ>17 )continue;
         std::string atmi=con.F2[iF2].atm;
         if( atmi[0]=='+' )atmi=' '+atmi.substr(1,3);
         int iR0=con.F2[iF2].R0;
         char ci=mol.R0[iR0].c1;
         std::string aai=mol.R0[iR0].aa;
         ai.r= (0.00);
         ai.CHG=false;
         ai.N2=1;
         ai.sgn=0;
         ai.MED_MOL_CHG(physics_consts,ci,aai,atmi);
         if( !ai.CHG )continue;
         int iN2= ai.N2;
         double qi= aut.F2[iF2].q.r(0,0);
         for(int jF2=(iF2+ 1);jF2<oF2;jF2++){
            if( con.F2[jF2].lte<0 )continue;
            if( con.F2[jF2].typ>17 )continue;
            std::string atmj=con.F2[jF2].atm;
            if( atmj[0]=='+' )atmj=' '+atmj.substr(1,3);
            int jR0=con.F2[jF2].R0;
            char cj=mol.R0[jR0].c1;
            std::string aaj=mol.R0[jR0].aa;
            aj.r= (0.00);
            aj.CHG=false;
            aj.N2=1;
            aj.sgn=0;
            aj.MED_MOL_CHG(physics_consts,cj,aaj,atmj);
            if( !aj.CHG )continue;
            int jN2= aj.N2;
            if( (jR0==iR0)&&(jN2==iN2) )continue;
            double qj= aut.F2[jF2].q.r(0,0);
            double r=( aut.F2[jF2].x -aut.F2[iF2].x).r();
            if( r<(( 1.00)/ANG) )r= (( 1.00)/ANG);
            med.R0N2R0N2(iR0,iN2,jR0,jN2).ee+=(qi*qj/r);
         }
      }
//
//
// net dipole of ionized groups induced by ionized groups
//
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mR0=mol.Z0[iZ0].R0a;
         int nR0=(mR0-1+mol.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iN2min=1;
            if( (iR0==mR0)||(iR0==nR0) )iN2min=0;
            for(int iN2=iN2min;iN2<=1;iN2++){
               if( med.R0N2(iR0,iN2).n==0 )continue;
               double qi= double( med.R0N2(iR0,iN2).sgn);
               double fi= med.R0N2(iR0,iN2).fq;
               for(int jZ0=iZ0;jZ0<oZ0;jZ0++){
                  int aR0=mol.Z0[jZ0].R0a;
                  int bR0=(aR0-1+mol.Z0[jZ0].cR0);
                  int jR0min=( jZ0==iZ0 )? iR0: aR0;
                  for(int jR0=jR0min;jR0<=bR0;jR0++){
                     int jN2min=1;
                     if( (jR0==aR0)||(jR0==bR0) )jN2min=0;
                     if( jR0==iR0 )jN2min=(iN2+ 1);
                     for(int jN2=jN2min;jN2<=1;jN2++){
                        if( med.R0N2(jR0,jN2).n==0 )continue;
                        double qj= double( med.R0N2(jR0,jN2).sgn);
                        double fj= med.R0N2(jR0,jN2).fq;
                        Coordinates m=( med.R0N2(jR0,jN2).x
                                       -med.R0N2(iR0,iN2).x);
                        double r= m.r();
                        if( r<(( 5.00)/ANG) )r= (( 5.00)/ANG);
                        double rrr= r*r*r;
                        med.R0N2(iR0,iN2).d+=(-fj*qj/rrr)*m;
                        med.R0N2(jR0,jN2).d+=( fi*qi/rrr)*m;
                     }
                  }
               }
            }
         }
      }
//
// correction to Fe for (fullchg,induced dipole)
// resolve (fullchg,induced dipole) Fe wrt ionized groups
//
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mR0=mol.Z0[iZ0].R0a;
         int nR0=(mR0-1+mol.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iN2min=1;
            if( (iR0==mR0)||(iR0==nR0) )iN2min=0;
            for(int iN2=iN2min;iN2<=1;iN2++){
               if( med.R0N2(iR0,iN2).n==0 )continue;
               double qd= (  -.125)*CAL*med.R0N2(iR0,iN2).d.rr();
               med.Fqd+=qd;
               med.R0N2(iR0,iN2).qd= qd;
            }
         }
      }
//
//
// diagnostic output
//
//    out.FILE3<<std::fixed<<std::setprecision( 2);
//    out.FILE3<<" iR0  aa sc jR0  aa sc     ee  ei ej"<<'\n';
//    for(int iZ0= 0;iZ0<oZ0;iZ0++){
//       int mR0=mol.Z0[iZ0].R0a;
//       int nR0=(mR0-1+mol.Z0[iZ0].cR0);
//       for(int iR0=mR0;iR0<=nR0;iR0++){
//          int iN2min=1;
//          if( (iR0==mR0)||(iR0==nR0) )iN2min=0;
//          for(int iN2=iN2min;iN2<=1;iN2++){
//             if( med.R0N2(iR0,iN2).n==0 )continue;
//             int sgni= med.R0N2(iR0,iN2).sgn;
//             for(int jZ0=iZ0;jZ0<oZ0;jZ0++){
//                int aR0=mol.Z0[jZ0].R0a;
//                int bR0=(aR0-1+mol.Z0[jZ0].cR0);
//                int jR0min=( jZ0==iZ0 )? iR0: aR0;
//                for(int jR0=jR0min;jR0<=bR0;jR0++){
//                   int jN2min=1;
//                   if( (jR0==aR0)||(jR0==bR0) )jN2min=0;
//                   if( jR0==iR0 )jN2min=(iN2+ 1);
//                   for(int jN2=jN2min;jN2<=1;jN2++){
//                      if( med.R0N2(jR0,jN2).n==0 )continue;
//                      int sgnj= med.R0N2(jR0,jN2).sgn;
//                      double ee= med.R0N2R0N2(iR0,iN2,jR0,jN2).ee*CAL;
//                      out.FILE3<<std::setw( 4)<<(iR0+ 1)
//                               <<' '<<mol.R0[iR0].aa
//                               <<std::setw( 2)<<iN2
//                               <<std::setw( 4)<<(jR0+ 1)
//                               <<' '<<mol.R0[jR0].aa
//                               <<std::setw( 2)<<jN2
//                               <<std::setw( 8)<<ee
//                               <<std::setw( 3)<<sgni
//                               <<std::setw( 3)<<sgnj
//                               <<'\n';
//                   }
//                }
//             }
//          }
//       }
//    }
//    out.FILE3<<" iR0  aa sc      z      fq   n     ed  ei"<<'\n';
//    for(int iZ0= 0;iZ0<oZ0;iZ0++){
//       int mR0=mol.Z0[iZ0].R0a;
//       int nR0=(mR0-1+mol.Z0[iZ0].cR0);
//       for(int iR0=mR0;iR0<=nR0;iR0++){
//          int iN2min=1;
//          if( (iR0==mR0)||(iR0==nR0) )iN2min=0;
//          for(int iN2=iN2min;iN2<=1;iN2++){
//             if( med.R0N2(iR0,iN2).n==0 )continue;
//             double z= med.R0N2(iR0,iN2).z;
//             double fq= med.R0N2(iR0,iN2).fq;
//             int n= med.R0N2(iR0,iN2).n;
//             int sgn= med.R0N2(iR0,iN2).sgn;
//             double ed= med.R0N2(iR0,iN2).qd*CAL;
//             out.FILE3<<std::setw( 4)<<(iR0+ 1)
//                      <<' '<<mol.R0[iR0].aa
//                      <<std::setw( 2)<<iN2
//                      <<std::setw( 8)<<z
//                      <<std::setw( 8)<<fq
//                      <<std::setw( 3)<<n
//                      <<std::setw( 8)<<ed
//                      <<std::setw( 3)<<sgn
//                      <<'\n';
//          }
//       }
//    }
   }
//
//
// generate partial surface contributed by base
//
   med.Fps= (0.00);
   med.Fss= (0.00);
   if( med.bse_nA5==0 ){
      med.MED_MOL(aut,
                  physics_consts,energy_params,
                  out,mol,con,dep);
// require prior assignment of probe
      med.MED_SPHERE(physics_consts,out);
      med.MED_TORUS(physics_consts,out);
      med.bse_nB5=0;
      med.bse_nC5=0;
      med.bse_nF5=0;
      med.bse_nE5=0;
      med.bse_nV5=0;
      med.bse_nH5=0;
      med.ENDSTATE=0;
      med.MED_SURF(physics_consts,out);
      if( med.ENDSTATE>0 ){
         out.FILE3<<"ENDSTATE="<< std::setw( 2)<<med.ENDSTATE<< std::endl;
//       std::exit( 2);
         return;
      }
      med.bse_nA5=med.nA5;
      for(int iA5= 0;iA5<med.nA5;iA5++){
         med.A5[iA5].bse_cI5=med.A5[iA5].cI5;
         med.A5[iA5].bse_free=med.A5[iA5].free;
      }
      med.bse_nB5=med.nB5;
      for(int iB5= 0;iB5<med.nB5;iB5++){
         med.B5[iB5].bse_free=med.B5[iB5].free;
         int oX5=med.B5[iB5].nX5;
         med.B5[iB5].bse_nX5=oX5;
         med.B5[iB5].bse_X5.resize(oX5);
         for(int iX5= 0;iX5<oX5;iX5++){
            med.B5[iB5].bse_X5[iX5].E5=med.B5[iB5].X5[iX5].E5;
         }
      }
      med.bse_nC5=med.nC5;
      med.bse_nF5=med.nF5;
      med.bse_nE5=med.nE5;
      med.bse_nV5=med.nV5;
      med.bse_nH5=med.nH5;
      med.bse_nD5=0;
      med.MED_DOT(physics_consts,array_consts,out);
      med.MED_BSE(physics_consts,array_consts,out);
   }
//
//
// restore med object to base
//
   int oA5=med.A5.size();
   int oB5=med.B5.size();
   int oC5=med.C5.size();
   int oE5=med.E5.size();
   int oH5=med.H5.size();
   int oV5=med.V5.size();
   int oE6=med.E6.size();
   int oF5=med.F5.size();
   int oF6=med.F6.size();
   int oF7=med.F7.size();
   int oDOT=med.DOT.size();
   int oD5=med.D5.size();
   for(int iA5= 0;iA5<oA5;iA5++){
      if( iA5<med.bse_nA5 ){
         med.A5[iA5].I5.erase(med.A5[iA5].I5.begin()
                             +med.A5[iA5].bse_cI5,
                              med.A5[iA5].I5.begin()
                             +med.A5[iA5].cI5);
      }else{
         med.A5[iA5].I5.clear();
      }
      med.A5[iA5].Z5.clear();
      med.A5[iA5].Y6.clear();
   }
   if( oB5>med.bse_nB5 )med.B5.erase(med.B5.begin()+med.bse_nB5,
                                     med.B5.begin()+oB5);
   for(int iB5= 0;iB5<med.bse_nB5;iB5++){
      med.B5[iB5].X5.clear();
   }
   if( oC5>med.bse_nC5 )med.C5.erase(med.C5.begin()+med.bse_nC5,
                                     med.C5.begin()+oC5);
   if( oE5>med.bse_nE5 )med.E5.erase(med.E5.begin()+med.bse_nE5,
                                     med.E5.begin()+oE5);
   if( oH5>med.bse_nH5 )med.H5.erase(med.H5.begin()+med.bse_nH5,
                                     med.H5.begin()+oH5);
   if( oV5>med.bse_nV5 )med.V5.erase(med.V5.begin()+med.bse_nV5,
                                     med.V5.begin()+oV5);
   if( oF5>med.bse_nF5 )med.F5.erase(med.F5.begin()+med.bse_nF5,
                                     med.F5.begin()+oF5);
   if( oE6>0 )med.E6.clear();
   if( oF6>0 )med.F6.clear();
   if( oF7>0 )med.F7.clear();
   if( oDOT>0 )med.DOT.clear();
   if( oD5>0 )med.D5.clear();
//
//
// generate full surface
//
   med.MED_MOL(aut,
               physics_consts,energy_params,
               out,mol,con,dep);
   med.ENDSTATE=0;
   med.MED_SURF(physics_consts,out);
   if( med.ENDSTATE>0 ){
      out.FILE3<<"ENDSTATE="<< std::setw( 2)<<med.ENDSTATE<< std::endl;
//    std::exit( 2);
      return;
   }
   med.MED_DOT(physics_consts,array_consts,out);
   med.MED_SIG(physics_consts,array_consts,out);
//
//
// components neglected for partial system
//
   if( (opt.MODE=="bb ")||(opt.MODE=="sc ") ){
   }else{
      if( NUC ){
         med.Fqd= (-.15)*( energy_params.fac_ps*med.Fps
                          +energy_params.fac_ss*med.Fss
                          +Fe/CAL);
      }
//
//
// count H-bond donors and acceptors
//
      int ndPEP=0;
      int ndSC=0;
      int naPEP=0;
      int naSC=0;
      for(int iA5=0;iA5<med.nA5;iA5++){
         std::string atm=med.A5[iA5].atm;
         int iT2=med.A5[iA5].typ;
         if( (iT2== 0)||(iT2== 3)||(iT2== 7) )continue;
         if      ( (iT2== 2)&&(atm==" H  ") ){
            ndPEP++;
         }else if( (iT2== 2)||(iT2== 5) ){
            ndSC++;
         }else if( (iT2==13)&&(atm==" O  ") ){
            naPEP++;
         }else if( (iT2==12)||(iT2==13)||(iT2==14)||(iT2==17) ){
            naSC++;
         }
      }
//
//
// unit vector to optimal hydration site
//
      for(int iA5=0;iA5<med.nA5;iA5++){
         int iT2=med.A5[iA5].typ;
         if( (iT2== 2)||(iT2== 5) ){
            Coordinates u;
            bool MISSING=true;
            for(int jA5= 0;jA5<iA5&&( MISSING);jA5++){
               int jT2=med.A5[jA5].typ;
               if( jT2< 11 )continue;
               u=( med.A5[iA5].x -med.A5[jA5].x);
               double r= u.r();
               if( r<(( 1.11)/ANG) ){
                  u/=r;
                  MISSING=false;
               }
            }
            if( MISSING ){
               std::cerr<<"ERROR: Missing covalent bond to H-bond donor.\n";
               std::exit( 2);
            }
            med.A5[iA5].u=u;
         }else if( (iT2==12)||(iT2==13)||(iT2==14)||(iT2==17) ){
            Coordinates u,v;
            u.zero();
            int n=0;
            for(int jA5= 0;jA5<med.nA5;jA5++){
               int jT2=med.A5[jA5].typ;
               if( (jT2== 0)||(jT2== 3)||(jT2== 7)||(jT2==11)||
                   (jT2==12)||(jT2==13)||(jT2==14)||(jT2==15) )continue;
               v=( med.A5[iA5].x -med.A5[jA5].x);
               double r= v.r();
               if( r<(( 1.63)/ANG) ){
                  v/=r;
                  u+=v;
                  n++;
               }
            }
            if( n==0 ){
               std::cerr<<"ERROR: Missing covalent bond to H-bond acceptor.\n";
               std::exit( 2);
            }
            med.A5[iA5].u=u.normalize();
         }
      }
//
//
// map H-bond connectivity
//
      for(int iA5=0;iA5<med.nA5;iA5++){
         med.A5[iA5].nH3=0;
         med.A5[iA5].H3.clear();
      }
      for(int iA5=0;iA5<med.nA5;iA5++){
         int iT2=med.A5[iA5].typ;
         if( (iT2!= 2)&&(iT2!= 5) )continue;
         Coordinates u=med.A5[iA5].u;
         for(int jA5=0;jA5<med.nA5;jA5++){
            int jT2=med.A5[jA5].typ;
            if( (jT2!=12)&&(jT2!=13)&&(jT2!=14)&&
                (jT2!=17) )continue;
            Coordinates v=( med.A5[jA5].x -med.A5[iA5].x);
            double r= v.r();
            if( r>(( 2.85)/ANG) )continue;
            v/=r;
            double Cthe= dot(u,v);
            double the= std::acos( Cthe)/RAD;
            if( the>(  55.00) )continue;
            med.A5[iA5].H3.push_back( Dielec_Continu::tA5::tA5H3());
            med.A5[iA5].H3[med.A5[iA5].nH3++].A5=jA5;
            med.A5[jA5].H3.push_back( Dielec_Continu::tA5::tA5H3());
            med.A5[jA5].H3[med.A5[jA5].nH3++].A5=iA5;
         }
      }
//
//
// modification of buried Fuh for hydration or complementary chg
//
      for(int iA5=0;iA5<med.nA5;iA5++){
         int sgn=0;
         int iT2=med.A5[iA5].typ;
         if( (iT2== 2)||(iT2== 5) ){
            if( med.A5[iA5].nH3> 0 )continue;
            if( med.A5[iA5].sa*ANGANG>(  .25) )continue;
            sgn=-1;
         }else if( (iT2==12)||(iT2==13)||(iT2==14)||(iT2==17) ){
            if( med.A5[iA5].nH3> 0 )continue;
            if( med.A5[iA5].sa*ANGANG>( 1.00) )continue;
            sgn= 1;
         }else{
            continue;
         }
         Coordinates u=med.A5[iA5].u;
         double alp= (  .52);
         double bet= ( 2.08);
         double Gmax= ( 0.00);
         for(int jC5=0;jC5<med.nC5;jC5++){
            if( !med.C5[jC5].sub )continue;
            Coordinates v=( med.C5[jC5].x -med.A5[iA5].x);
            double r= v.r();
            if( r>(( 5.60)/ANG) )continue;
            v/=r;
            double Cthe= dot(u,v);
            double the= std::acos( Cthe)/RAD;
            if( the>(  55.00) )continue;
            double d=( ANG*r -( 3.60));
            double e= RAD*the;
            double G= std::exp( -alp*d*d -bet*e*e);
            if( G>Gmax ){
               Gmax= G;
            }
         }
         for(int jA5=0;jA5<med.nA5;jA5++){
            if( !med.A5[jA5].CHG )continue;
            if( med.A5[jA5].sgn!=sgn )continue;
            if( med.A5[jA5].typ== 7 )continue;
            Coordinates v=( med.A5[jA5].x -med.A5[iA5].x);
            double r= v.r();
            if( r>(( 6.60)/ANG) )continue;
            v/=r;
            double Cthe= dot(u,v);
            double the= std::acos( Cthe)/RAD;
            if( the>(  55.00) )continue;
            double d=( ANG*r -( 3.60));
            double e= RAD*the;
            double G= std::exp( -alp*(  .25)*d*d -bet*e*e);
            if( G>Gmax ){
               Gmax= G;
            }
         }
         med.A5[iA5].facuh=( ( 1.00) -Gmax);
      }
//
//
// partition H-bond donors and acceptors into buried+hydrated+paired
//
      int hdPEP=0;
      int bdPEP=0;
      int hdSC=0;
      int bdSC=0;
      int haPEP=0;
      int baPEP=0;
      int haSC=0;
      int baSC=0;
      for(int iA5=0;iA5<med.nA5;iA5++){
         std::string atm=med.A5[iA5].atm;
         int iT2=med.A5[iA5].typ;
         if( (iT2== 0)||(iT2== 3)||(iT2== 7) )continue;
         if      ( (iT2== 2)&&(atm==" H  ") ){
            if( med.A5[iA5].nH3==0 ){
               if( med.A5[iA5].sa*ANGANG>(  .25) ){
                  hdPEP++;
                  med.Fuh+=( -.60);
               }else{
                  bdPEP++;
                  med.Fuh+=((  .80)*med.A5[iA5].facuh);
               }
            }else{
            }
         }else if( (iT2== 2)||(iT2== 5) ){
            if( med.A5[iA5].nH3==0 ){
               if( med.A5[iA5].sa*ANGANG>(  .25) ){
                  hdSC++;
                  med.Fuh+=( -.30);
               }else{
                  bdSC++;
                  med.Fuh+=((  .20)*med.A5[iA5].facuh);
               }
            }else{
            }
         }else if( (iT2==13)&&(atm==" O  ") ){
            if( med.A5[iA5].nH3==0 ){
               if( med.A5[iA5].sa*ANGANG>( 1.00) ){
                  haPEP++;
                  med.Fuh+=( -.80);
               }else{
                  baPEP++;
                  med.Fuh+=(( 1.60)*med.A5[iA5].facuh);
               }
            }else{
            }
         }else if( (iT2==12)||(iT2==13)||(iT2==14)||(iT2==17) ){
            if( med.A5[iA5].nH3==0 ){
               if( med.A5[iA5].sa*ANGANG>( 1.00) ){
                  haSC++;
                  med.Fuh+=( -.40);
               }else{
                  baSC++;
                  med.Fuh+=((  .40)*med.A5[iA5].facuh);
               }
            }else{
            }
         }else{
         }
      }
      med.Fuh/=CAL;
//
//
// diagnostic output
//
//    out.FILE3<<std::fixed<<std::setprecision( 2);
//    out.FILE3<<"peptide H hydrated\n";
//    for(int iA5=0;iA5<med.nA5;iA5++){
//       std::string atm=med.A5[iA5].atm;
//       int iT2=med.A5[iA5].typ;
//       if( (iT2== 0)||(iT2== 3)||(iT2== 7) )continue;
//       if      ( (iT2== 2)&&(atm==" H  ") ){
//          if( med.A5[iA5].nH3==0 ){
//             double sa= med.A5[iA5].sa*ANGANG;
//             if( sa>(  .25) ){
//                out.FILE3<<' '<<atm
//                         <<std::setw( 4)<<(med.A5[iA5].R0+ 1)
//                         <<' '<<med.A5[iA5].aa
//                         <<std::setw( 7)<<sa<<'\n';
//             }else{
//             }
//          }else{
//          }
//       }else if( (iT2== 2)||(iT2== 5) ){
//       }
//    }
//    out.FILE3<<"peptide H buried\n";
//    for(int iA5=0;iA5<med.nA5;iA5++){
//       std::string atm=med.A5[iA5].atm;
//       int iT2=med.A5[iA5].typ;
//       if( (iT2== 0)||(iT2== 3)||(iT2== 7) )continue;
//       if      ( (iT2== 2)&&(atm==" H  ") ){
//          if( med.A5[iA5].nH3==0 ){
//             double sa= med.A5[iA5].sa*ANGANG;
//             if( sa>(  .25) ){
//             }else{
//                out.FILE3<<' '<<atm
//                         <<std::setw( 4)<<(med.A5[iA5].R0+ 1)
//                         <<' '<<med.A5[iA5].aa
//                         <<std::setw( 7)<<sa
//                         <<std::setw( 6)<<med.A5[iA5].facuh<<'\n';
//             }
//          }else{
//          }
//       }else if( (iT2== 2)||(iT2== 5) ){
//       }
//    }
//    out.FILE3<<"sc donor hydrated\n";
//    for(int iA5=0;iA5<med.nA5;iA5++){
//       std::string atm=med.A5[iA5].atm;
//       int iT2=med.A5[iA5].typ;
//       if( (iT2== 0)||(iT2== 3)||(iT2== 7) )continue;
//       if      ( (iT2== 2)&&(atm==" H  ") ){
//       }else if( (iT2== 2)||(iT2== 5) ){
//          if( med.A5[iA5].nH3==0 ){
//             double sa= med.A5[iA5].sa*ANGANG;
//             if( sa>(  .25) ){
//                out.FILE3<<' '<<atm
//                         <<std::setw( 4)<<(med.A5[iA5].R0+ 1)
//                         <<' '<<med.A5[iA5].aa
//                         <<std::setw( 7)<<sa<<'\n';
//             }else{
//             }
//          }else{
//          }
//       }
//    }
//    out.FILE3<<"sc donor buried\n";
//    for(int iA5=0;iA5<med.nA5;iA5++){
//       std::string atm=med.A5[iA5].atm;
//       int iT2=med.A5[iA5].typ;
//       if( (iT2== 0)||(iT2== 3)||(iT2== 7) )continue;
//       if      ( (iT2== 2)&&(atm==" H  ") ){
//       }else if( (iT2== 2)||(iT2== 5) ){
//          if( med.A5[iA5].nH3==0 ){
//             double sa= med.A5[iA5].sa*ANGANG;
//             if( sa>(  .25) ){
//             }else{
//                out.FILE3<<' '<<atm
//                         <<std::setw( 4)<<(med.A5[iA5].R0+ 1)
//                         <<' '<<med.A5[iA5].aa
//                         <<std::setw( 7)<<sa
//                         <<std::setw( 6)<<med.A5[iA5].facuh<<'\n';
//             }
//          }else{
//          }
//       }
//    }
//    out.FILE3<<"peptide O hydrated\n";
//    for(int iA5=0;iA5<med.nA5;iA5++){
//       std::string atm=med.A5[iA5].atm;
//       int iT2=med.A5[iA5].typ;
//       if( (iT2== 0)||(iT2== 3)||(iT2== 7) )continue;
//       if      ( (iT2==13)&&(atm==" O  ") ){
//          if( med.A5[iA5].nH3==0 ){
//             double sa= med.A5[iA5].sa*ANGANG;
//             if( sa>( 1.00) ){
//                out.FILE3<<' '<<atm
//                         <<std::setw( 4)<<(med.A5[iA5].R0+ 1)
//                         <<' '<<med.A5[iA5].aa
//                         <<std::setw( 7)<<sa<<'\n';
//             }else{
//             }
//          }else{
//          }
//       }else if( (iT2==12)||(iT2==13)||(iT2==14)||(iT2==17) ){
//       }
//    }
//    out.FILE3<<"peptide O buried\n";
//    for(int iA5=0;iA5<med.nA5;iA5++){
//       std::string atm=med.A5[iA5].atm;
//       int iT2=med.A5[iA5].typ;
//       if( (iT2== 0)||(iT2== 3)||(iT2== 7) )continue;
//       if      ( (iT2==13)&&(atm==" O  ") ){
//          if( med.A5[iA5].nH3==0 ){
//             double sa= med.A5[iA5].sa*ANGANG;
//             if( sa>( 1.00) ){
//             }else{
//               out.FILE3<<' '<<atm
//                        <<std::setw( 4)<<(med.A5[iA5].R0+ 1)
//                        <<' '<<med.A5[iA5].aa
//                        <<std::setw( 7)<<sa
//                        <<std::setw( 6)<<med.A5[iA5].facuh<<'\n';
//             }
//          }
//       }else if( (iT2==12)||(iT2==13)||(iT2==14)||(iT2==17) ){
//       }
//    }
//    out.FILE3<<"sc acceptor hydrated\n";
//    for(int iA5=0;iA5<med.nA5;iA5++){
//       std::string atm=med.A5[iA5].atm;
//       int iT2=med.A5[iA5].typ;
//       if( (iT2== 0)||(iT2== 3)||(iT2== 7) )continue;
//       if      ( (iT2==13)&&(atm==" O  ") ){
//       }else if( (iT2==12)||(iT2==13)||(iT2==14)||(iT2==17) ){
//          if( med.A5[iA5].nH3==0 ){
//             double sa= med.A5[iA5].sa*ANGANG;
//             if( sa>( 1.00) ){
//                out.FILE3<<' '<<atm
//                         <<std::setw( 4)<<(med.A5[iA5].R0+ 1)
//                         <<' '<<med.A5[iA5].aa
//                         <<std::setw( 7)<<sa<<'\n';
//             }else{
//             }
//          }else{
//          }
//       }
//    }
//    out.FILE3<<"sc acceptor buried\n";
//    for(int iA5=0;iA5<med.nA5;iA5++){
//       std::string atm=med.A5[iA5].atm;
//       int iT2=med.A5[iA5].typ;
//       if( (iT2== 0)||(iT2== 3)||(iT2== 7) )continue;
//       if      ( (iT2==13)&&(atm==" O  ") ){
//       }else if( (iT2==12)||(iT2==13)||(iT2==14)||(iT2==17) ){
//          if( med.A5[iA5].nH3==0 ){
//             double sa= med.A5[iA5].sa*ANGANG;
//             if( sa>( 1.00) ){
//             }else{
//               out.FILE3<<' '<<atm
//                        <<std::setw( 4)<<(med.A5[iA5].R0+ 1)
//                        <<' '<<med.A5[iA5].aa
//                        <<std::setw( 7)<<sa
//                        <<std::setw( 6)<<med.A5[iA5].facuh<<'\n';
//             }
//          }else{
//          }
//       }
//    }
//
//
// energy of cleft and cavity volume
//
      Dielec_Continu msm( 1, 1,med.nA5,med.oR0);
      msm.nA5=med.nA5;
      for(int iA5= 0;iA5<med.nA5;iA5++){
         msm.A5[iA5].atm=med.A5[iA5].atm;
         msm.A5[iA5].lte=med.A5[iA5].lte;
         msm.A5[iA5].typ=med.A5[iA5].typ;
         msm.A5[iA5].x=med.A5[iA5].x;
         msm.A5[iA5].q=med.A5[iA5].q;
         msm.A5[iA5].r= med.A5[iA5].r;
         msm.A5[iA5].CHG=med.A5[iA5].CHG;
         msm.A5[iA5].R0=med.A5[iA5].R0;
         msm.A5[iA5].N2=med.A5[iA5].N2;
         msm.A5[iA5].aa=med.A5[iA5].aa;
         msm.A5[iA5].sgn=med.A5[iA5].sgn;
         msm.A5[iA5].bur=false;
         msm.A5[iA5].F2=0;
         msm.A5[iA5].A5=med.A5[iA5].A5;
         msm.A5[iA5].Q2=0;
      }
      msm.Q2[ 0].c.identity();
//
//
// small probe radius dots
//
      bool VERBOSE_hold=out.VERBOSE;
      out.VERBOSE=false;
      msm.probe= ((  .70)/ANG);
      msm.MED_SPHERE(physics_consts,out);
      msm.MED_TORUS(physics_consts,out);
      msm.bse_nA5=0;
      msm.bse_nB5=0;
      msm.bse_nC5=0;
      msm.bse_nF5=0;
      msm.bse_nE5=0;
      msm.bse_nV5=0;
      msm.bse_nH5=0;
      msm.ENDSTATE=0;
      msm.MED_SURF(physics_consts,out);
      if( msm.ENDSTATE>0 ){
         out.FILE3<<"ENDSTATE="<< std::setw( 2)<<msm.ENDSTATE<< std::endl;
         std::exit( 2);
         return;
      }
      msm.bse_nD5=0;
      msm.MED_DOT(physics_consts,array_consts,out);
      out.VERBOSE=VERBOSE_hold;
//
//
// subset of cavity and cleft dots
//
      for(int iDOT= 0;iDOT<med.nDOT;iDOT++){
         msm.DOT[iDOT].HIT=false;
      }
      double rrcut= std::pow( ( 4.00)*msm.probe, 2);
      for(int i0G5=-16;i0G5<=16;i0G5++){
         int iG5min=(i0G5-2);
         if( iG5min<-16 )iG5min=-16;
         int iG5max=(i0G5+2);
         if( iG5max> 16 )iG5max= 16;
         for(int j0G5=-16;j0G5<=16;j0G5++){
            int jG5min=(j0G5-2);
            if( jG5min<-16 )jG5min=-16;
            int jG5max=(j0G5+2);
            if( jG5max> 16 )jG5max= 16;
            for(int k0G5=-16;k0G5<=16;k0G5++){
               int kG5min=(k0G5-2);
               if( kG5min<-16 )kG5min=-16;
               int kG5max=(k0G5+2);
               if( kG5max> 16 )kG5max= 16;
               if( msm.G5G5G5(i0G5,j0G5,k0G5).n==0 )continue;
               int iD5min=msm.G5G5G5(i0G5,j0G5,k0G5).i;
               int iD5max=(iD5min-1+msm.G5G5G5(i0G5,j0G5,k0G5).n);
               for(int iD5=iD5min;iD5<=iD5max;iD5++){
                  int aDOT=msm.D5[iD5].DOTa;
                  int bDOT=(aDOT-1+msm.D5[iD5].cDOT);
                  for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
                     bool HIT=(false);
                     for(int iG5=iG5min;iG5<=iG5max&&(!HIT);iG5++){
                        for(int jG5=jG5min;jG5<=jG5max&&(!HIT);jG5++){
                           for(int kG5=kG5min;kG5<=kG5max&&(!HIT);kG5++){
                              if( med.G5G5G5(iG5,jG5,kG5).n==0 )continue;
                              int jD5min=med.G5G5G5(iG5,jG5,kG5).i;
                              int jD5max=(jD5min-1+med.G5G5G5(iG5,jG5,kG5).n);
                              for(int jD5=jD5min;jD5<=jD5max&&(!HIT);jD5++){
                                 int pDOT=med.D5[jD5].DOTa;
                                 int qDOT=(pDOT-1+med.D5[jD5].cDOT);
                                 for(int jDOT=pDOT;jDOT<=qDOT&&(!HIT);jDOT++){
                                    double rr=( med.DOT[jDOT].x
                                               -msm.DOT[iDOT].x).rr();
                                    if( rr<rrcut ){
                                       msm.DOT[iDOT].HIT=true;
                                       HIT=true;
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
//
//
// output cavity and cleft dots, accumulate surface area
//
//    std::string filename="../../"+str.fam+"/dgn/dots."+str.mol+'.'+str.cnf
//                        +".pdb";
//    std::ofstream ofile( filename.c_str());
//    std::string rec="ATOM      1  T01 DOT     1       0.000   0.000   0.000";
//    int iatm=0;
      double cca= (0.00);
      for(int iD5= 0;iD5<msm.nD5;iD5++){
         int aDOT=msm.D5[iD5].DOTa;
         int bDOT=(aDOT-1+msm.D5[iD5].cDOT);
         for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
            if( msm.DOT[iDOT].HIT )continue;
            cca+=(ANGANG*msm.DOT[iDOT].a);
//          std::ostringstream ox;
//          ox<<(ANG*msm.DOT[iDOT].x);
//          rec.replace(30,24,ox.str());
//          std::ostringstream oi,oj;
//          oi<<std::setw( 5)<<iatm;
//          oj<<std::setw( 4)<<(iatm/100);
//          rec.replace( 6, 5,oi.str());
//          rec.replace(22, 4,oj.str());
//          ofile<<rec<<'\n';
//          iatm++;
         }
      }
//    ofile<<"TER\n";
//    ofile.close();
      med.Fcc= (( .064)/CAL)*cca;
//
//
// diagnostic output
//
//    if( out.VERBOSE&& out.SHELL ){
//       out.FILE3<< std::fixed<< std::setprecision( 2);
//       out.FILE3<<" probe radius="
//                <<std::setw( 6)<<(ANG*msm.probe)<<'\n';
//       out.FILE3<<" cavity surface area="
//                << std::setw( 9)<<cca<<'\n';
//    }
//
//
// output atoms consistent with dots
//
//    filename="../../"+str.fam+"/dgn/atoms."+str.mol+'.'+str.cnf+".pdb";
//    ofile.open(filename.c_str());
//    iatm=1;
//    for(int iA5= 0;iA5<med.nA5;iA5++){
//       std::string atm=med.A5[iA5].atm;
//       int iT2=med.A5[iA5].typ;
//       if( (iT2== 0)||(iT2== 3)||(iT2== 7) )continue;
//       int iR0=med.A5[iA5].R0;
//       std::string aa=med.A5[iA5].aa;
//       if( (aa[0]=='e')||
//           (aa[0]=='z') )aa=aa.substr(1,3)+' ';
//       if( (aa[3]=='e')||
//           (aa[3]=='z') )aa=aa.substr(0,3)+' ';
//       std::ostringstream oi,oj;
//       oi<<std::setw( 5)<<iatm;
//       oj<<std::setw( 4)<<(iR0+ 1);
//       rec.replace( 6, 5,oi.str());
//       rec.replace(12, 4,atm);
//       rec.replace(17, 4,aa);
//       rec.replace(22, 4,oj.str());
//       std::ostringstream ox;
//       ox<<(ANG*med.A5[iA5].x);
//       rec.replace(30,24,ox.str());
//       ofile<<rec<<'\n';
//       iatm++;
//    }
//    ofile<<"TER\n";
//    ofile.close();
//
//
// output dot surface
//
//    filename="../../"+str.fam+"/dgn/ds."+str.mol+'.'+str.cnf+".pdb";
//    ofile.open( filename.c_str());
//    rec="ATOM      1  T01 DOT     1       0.000   0.000   0.000";
//    iatm=1;
//    for(int iD5= 0;iD5<med.nD5;iD5++){
//       int aDOT=med.D5[iD5].DOTa;
//       int bDOT=(aDOT-1+med.D5[iD5].cDOT);
//       for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
//          int typ=med.DOT[iDOT].typ;
//          if      ( typ==-1 ){
//             rec[15]='0';
//          }else if( typ== 0 ){
//             rec[15]='1';
//          }else if( typ== 1 ){
//             rec[15]='2';
//          }
//          std::ostringstream ox;
//          ox<<(ANG*med.DOT[iDOT].x);
//          rec.replace(30,24,ox.str());
//          std::ostringstream oi,oj;
//          oi<<std::setw( 5)<<iatm;
//          oj<<std::setw( 4)<<(iatm/100);
//          rec.replace( 6, 5,oi.str());
//          rec.replace(22, 4,oj.str());
//          ofile<<rec<<'\n';
//          iatm++;
//       }
//    }
//    ofile<<"TER\n";
//    ofile.close();
//
//
// diagnostic output
//
      Fm=( energy_params.fac_ps*med.Fps
          +energy_params.fac_ss*med.Fss
          +energy_params.fac_qd*med.Fqd
          +energy_params.fac_uh*med.Fuh
          +energy_params.fac_cc*med.Fcc);
      Fm*=CAL;
      if( out.VERBOSE&& false ){
         out.FILE3<<"Peptide Hydrogen Bond Donors"
                    " (Total,Hydrated,Buried)=("
                  << std::setw( 4)<<ndPEP<<','
                  << std::setw( 4)<<hdPEP<<','
                  << std::setw( 4)<<bdPEP<<")\n";
         out.FILE3<<"Peptide Hydrogen Bond Acceptors"
                    " (Total,Hydrated,Buried)=("
                  << std::setw( 4)<<naPEP<<','
                  << std::setw( 4)<<haPEP<<','
                  << std::setw( 4)<<baPEP<<")\n";
         out.FILE3<<"Side Chain Hydrogen Bond Donors"
                    " (Total,Hydrated,Buried)=("
                  << std::setw( 4)<<ndSC<<','
                  << std::setw( 4)<<hdSC<<','
                  << std::setw( 4)<<bdSC<<")\n";
         out.FILE3<<"Side Chain Hydrogen Bond Acceptors"
                    " (Total,Hydrated,Buried)=("
                  << std::setw( 4)<<naSC<<','
                  << std::setw( 4)<<haSC<<','
                  << std::setw( 4)<<baSC<<")\n";
         out.FILE3<< std::fixed<< std::setprecision(4);
         out.FILE3<<"     Fm    ""     Fps   ""     Fss   "
                    "     Fqd   ""     Fuh   ""     Fcc   "<<'\n';
         out.FILE3<< std::setw(11)<<Fm
                  << std::setw(11)<<(med.Fps*CAL)
                  << std::setw(11)<<(med.Fss*CAL)
                  << std::setw(11)<<(med.Fqd*CAL)
                  << std::setw(11)<<(med.Fuh*CAL)
                  << std::setw(11)<<(med.Fcc*CAL)<<'\n';
      }
   }
   med.MED_FUNC(physics_consts,energy_params,str,out);
   return;
}
