#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../igo/Igor_Model.hh"
#include "../med/Defect_Automatic.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <fstream>
#include <sstream>
#include <iomanip>

class MEM_defect_ssp {
private:
   std::vector<bool> o_R0mis;           //ss predicted state mismatch wrt obs
   std::vector<std::string> o_R0rec;    //CA coords in pdb format
public:
   MEM_defect_ssp(int r):
      o_R0mis(r, false),
      o_R0rec(r)
   {
   }
   void R0mis(int i,bool a){
      o_R0mis[ i]=a;
   }
   bool R0mis(int i){
      return o_R0mis[ i];
   }
   std::string& R0rec(int i){
      return o_R0rec.at( i);
   }
};

void Structure::DEFECT_SSP(Defect_Automatic& aut,
                           const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_ARRAY_CONSTS& array_consts,
                           const DAT_RESIDUE_MAPPINGS& residue_mappings,
                           const DAT_IGOR_DATA& igor_data,
                           Thread_Options& opt,
                           Output_Streams& out){
   std::string rec="ATOM      1  B07 DOT     1       0.000   0.000   0.000";
   int mI2=aut.nI2;
//
// std::string filename="../../"+fam+"/dgn/igosco."+mol+'.'+cnf;
// std::ofstream ofile(filename.c_str());
// ofile<< std::fixed<< std::setprecision( 4);
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      if( aut.Z0[iZ0].c1!='a' )continue;
//    ofile<<"________________________________________"
//           "________________________________________\n";
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      int oR0=(nR0-mR0+1);
      MEM_defect_ssp vv(oR0);
//
//
// free energy of observed element composition relative to optimal
//
      bool bac_VERBOSE=out.VERBOSE;
      out.VERBOSE=false;
      std::string bac_MODE=opt.MODE;
      opt.MODE="ssp";
      Igor_Model igo;
      igo.IGO(physics_consts,array_consts,residue_mappings,igor_data,
              opt,out,*this,
              iZ0,mR0,nR0);
      out.VERBOSE=bac_VERBOSE;
      opt.MODE=bac_MODE;
//
//
// number of mismatches between predicted and observed
//
      int jmiss=0;
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int jR0=(iR0-mR0);
         int jP1=iatom(iR0," CA ");
         if( jP1==-1 )continue;
         if( P1[jP1].sub==0 )continue;
         int jC7=(igo.R0[jR0].C70);
         int iC7=R0[iR0].C7;
         if( jC7!=iC7 ){
            jmiss++;
            vv.R0mis(jR0, true);
            std::ostringstream oi;
            oi<<P1[jP1].x;
            vv.R0rec(jR0)=oi.str();
         }
//       ofile<<igor_data.C7[jC7].a1
//            <<igor_data.C7[iC7].a1<<' '
//            <<R0[iR0].aa
//            <<R0[iR0].cha
//            << std::setw( 4)<<R0[iR0].res
//            <<R0[iR0].ins<<'\n';
      }
//
//
// resolution of energy wrt residues
//
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int jR0=(iR0-mR0);
         if( vv.R0mis(jR0) ){
            int jC7=(igo.R0[jR0].C70);
            int iC7=R0[iR0].C7;
            double e=( igo.R0[jR0].C7e0(jC7) -igo.R0[jR0].C7e0(iC7));
            aut.R0[iR0].e[10]+=e;
            aut.I2.push_back( Defect_Automatic::tI2());
            aut.I2[aut.nI2].cha=R0[iR0].cha;
            aut.I2[aut.nI2].res=R0[iR0].res;
            aut.I2[aut.nI2].ins=R0[iR0].ins;
            aut.I2[aut.nI2].aa=R0[iR0].aa;
            aut.I2[aut.nI2].cigo=igor_data.C7[jC7].a1;
            aut.I2[aut.nI2].cobs=igor_data.C7[iC7].a1;
            aut.I2[aut.nI2].e= e;
            rec[21]=R0[iR0].cha;
            rec.replace(30,24,vv.R0rec(jR0));
            aut.I2[aut.nI2++].rec=rec;
         }
      }
   }
// ofile<<"________________________________________"
//         "________________________________________\n";
// ofile.close();
//
//
// diagnostic output
//
   if( out.VERBOSE&& false ){
      out.FILE3<<"IMPROBABLE SECONDARY STRUCTURE\n";
      out.FILE3<< std::fixed<< std::setprecision( 3);
      out.FILE3<<"Number of Improbable Secondary Structure States="
               << std::setw( 4)<<(aut.nI2-mI2)<<'\n';
      for(int jI2=mI2;jI2<aut.nI2;jI2++){
         out.FILE3<<aut.I2[jI2].aa
                  <<aut.I2[jI2].cha
                  << std::setw( 4)<<aut.I2[jI2].res
                  <<aut.I2[jI2].ins<<' '
                  <<" igo="<<aut.I2[jI2].cigo
                  <<" obs="<<aut.I2[jI2].cobs
                  <<" e="<< std::setw( 8)<<aut.I2[jI2].e<<'\n';
      }
   }
   return;
}
