#include "../fil/Structure.hh"
#include "../med/Defect_Automatic.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <cstdlib>
#include <sstream>
#include <iomanip>

void Structure::DEFECT_OLP(Defect_Automatic& aut,
                           Output_Streams& out){
   std::string rec="ATOM      1  B00 DOT     1       0.000   0.000   0.000";
   int mI2=aut.nI2;
//
//
// atom pair overlap
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char ci=R0[iR0].c1;
         std::string aai=R0[iR0].aa;
         if( ci=='a' ){
            if( (aai[0]=='e')||
                (aai[0]=='z') )aai=aai.substr(1,3)+' ';
            if( (aai[3]=='e')||
                (aai[3]=='z') )aai=aai.substr(0,3)+' ';
         }
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);

         for(int jZ0=iZ0;jZ0<nZ0;jZ0++){
            int aR0=Z0[jZ0].R0a;
            int bR0=(aR0-1+Z0[jZ0].cR0);
            if( jZ0==iZ0 ){
               aR0=( ci=='r' )? (iR0+3) :(iR0+2);
            }
            for(int jR0=aR0;jR0<=bR0;jR0++){
               char cj=R0[jR0].c1;
               std::string aaj=R0[jR0].aa;
               if( cj=='a' ){
                  if( (aaj[0]=='e')||
                      (aaj[0]=='z') )aaj=aaj.substr(1,3)+' ';
                  if( (aaj[3]=='e')||
                      (aaj[3]=='z') )aaj=aaj.substr(0,3)+' ';
               }
               int aP1=R0[jR0].P1a;
               int bP1=(aP1-1+R0[jR0].cP1);

               bool OVERLAP=false;
               for(int iP1=mP1;iP1<=nP1&&(!OVERLAP);iP1++){
                  if( P1[iP1].sub==0 )continue;
                  std::string atmi=P1[iP1].atm;
                  int iT2=P1[iP1].typ;
                  if( iT2< 8 )continue;
                  for(int jP1=aP1;jP1<=bP1&&(!OVERLAP);jP1++){
                     if( P1[jP1].sub==0 )continue;
                     std::string atmj=P1[jP1].atm;
                     int jT2=P1[jP1].typ;
                     if( jT2< 8 )continue;
                     if( (aai=="CYS ")&&(aaj=="CYS ") ){
                        if( ((atmi==" CB ")&&(atmj==" SG "))||
                            ((atmi==" SG ")&&(atmj==" CB "))||
                            ((atmi==" SG ")&&(atmj==" SG ")) ){
                           continue;
                        }
                     }
                     double r=( P1[jP1].x -P1[iP1].x).r();
                     if( r<(2.40) ){
                        aut.R0[iR0].e[ 1]+=(4.00);
                        aut.R0[jR0].e[ 1]+=(4.00);
                        std::ostringstream oi,oj;
                        oi<<P1[iP1].x;
                        oj<<P1[jP1].x;
                        aut.I2.push_back( Defect_Automatic::tI2());
                        aut.I2[aut.nI2].cha=R0[iR0].cha;
                        aut.I2[aut.nI2].res=R0[iR0].res;
                        aut.I2[aut.nI2].ins=R0[iR0].ins;
                        aut.I2[aut.nI2].aa=R0[iR0].aa;
                        rec[21]=R0[iR0].cha;
                        rec.replace(30,24,oi.str());
                        aut.I2[aut.nI2++].rec=rec;
                        aut.I2.push_back( Defect_Automatic::tI2());
                        aut.I2[aut.nI2].cha=R0[jR0].cha;
                        aut.I2[aut.nI2].res=R0[jR0].res;
                        aut.I2[aut.nI2].ins=R0[jR0].ins;
                        aut.I2[aut.nI2].aa=R0[jR0].aa;
                        rec[21]=R0[jR0].cha;
                        rec.replace(30,24,oj.str());
                        aut.I2[aut.nI2++].rec=rec;
                        OVERLAP=true;
                     }
                  }
               }

            }
         }

      }
   }
//
//
// diagnostic output
//
   if( out.VERBOSE ){
      out.FILE3<<"OVERLAP"<< std::endl;
      out.FILE3<<"Number of Residue-Residue Overlaps="
               << std::setw( 4)<<(aut.nI2-mI2)<<'\n';
      for(int jI2=mI2;jI2<aut.nI2;jI2++){
         out.FILE3<<"  "<<aut.I2[jI2].aa
                  <<aut.I2[jI2].cha
                  << std::setw( 4)<<aut.I2[jI2].res
                  <<aut.I2[jI2].ins;
         if( (jI2-mI2)% 2==1 ){
            out.FILE3<<'\n';
         }
      }
   }
   return;
}
