#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../med/Defect_Automatic.hh"
#include "../med/Dielec_Continu.hh"
#include <string>

void Structure::DEFECT_MOL(Defect_Automatic& aut,
                           Dielec_Continu& med,
                           const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_ENERGY_PARAMS& energy_params){
   med.nA5=0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            med.A5[med.nA5].atm=atm;
            med.A5[med.nA5].lte=-1;
            med.A5[med.nA5].typ=iT2;
            med.A5[med.nA5].x=P1[iP1].x;
            med.A5[med.nA5].x/=(physics_consts.ANG);
            med.A5[med.nA5].r= energy_params.T2[iT2].Rsph;
            char c1=R0[iR0].c1;
            std::string aa=R0[iR0].aa;
            std::string ab=R0[iR0].aa;
            if( c1=='a' ){
               if( (ab[0]=='e')||
                   (ab[0]=='z') )ab=ab.substr(1,3)+' ';
               if( (ab[3]=='e')||
                   (ab[3]=='z') )ab=ab.substr(0,3)+' ';
            }
            if      ( c1=='a' ){
               if      ( ab=="LYS " ){
                  if( (atm==" NZ ")||
                      (atm=="1HZ ")||
                      (atm=="2HZ ")||
                      (atm=="3HZ ") ){
                     med.A5[med.nA5].r+=( .25)/(.529177249);
                  }
               }else if( ab=="ARG " ){
                  if( (atm==" NE ")||
                      (atm==" HE ")||
                      (atm==" NH1")||
                      (atm=="1HH1")||
                      (atm=="2HH1")||
                      (atm==" NH2")||
                      (atm=="1HH2")||
                      (atm=="2HH2") ){
                     med.A5[med.nA5].r+=( .25)/(.529177249);
                  }
               }else if( ab=="ORN " ){
                  if( (atm==" NE ")||
                      (atm=="1HE ")||
                      (atm=="2HE ")||
                      (atm=="3HE ") ){
                     med.A5[med.nA5].r+=( .25)/(.529177249);
                  }
               }else if( aa[0]=='e' ){
                  if( (atm==" N  ")||
                      (atm=="1H  ")||
                      (atm=="2H  ")||
                      (atm=="3H  ") ){
                     med.A5[med.nA5].r+=( .20)/(.529177249);
                  }
               }else if( (ab=="SEP ")||(ab=="THP ")||(ab=="TYP ") ){
                  if( (atm==" P  ")||
                      (atm==" O1P")||
                      (atm==" O2P")||
                      (atm==" O3P") ){
                     med.A5[med.nA5].r+=( .40)/(.529177249);
                  }
               }
            }else if( c1=='e' ){
            }else if( c1=='r' ){
            }else if( c1=='b' ){
            }else if( c1=='p' ){
               if      ( aa=="PO  " ){
                  if( (atm==" O3'")||
                      (atm==" P  ")||
                      (atm==" O1P")||
                      (atm==" O2P") ){
                     med.A5[med.nA5].r+=( .20)/(.529177249);
                  }
               }else if( aa=="PSR " ){
                  if( (atm==" O3'")||
                      (atm==" P  ")||
                      (atm==" O1P")||
                      (atm==" S2P") ){
                     med.A5[med.nA5].r+=( .40)/(.529177249);
                  }
               }else if( aa=="PSS " ){
                  if( (atm==" O3'")||
                      (atm==" P  ")||
                      (atm==" S1P")||
                      (atm==" O2P") ){
                     med.A5[med.nA5].r+=( .40)/(.529177249);
                  }
               }else if( (aa=="5PO ")||(aa=="3PO ") ){
                  if( (atm==" P  ")||
                      (atm==" O1P")||
                      (atm==" O2P")||
                      (atm==" O3P") ){
                     med.A5[med.nA5].r+=( .40)/(.529177249);
                  }
               }
            }else if( c1=='s' ){
            }
            med.A5[med.nA5].bur=false;
            med.A5[med.nA5].F2=0;
            med.A5[med.nA5].Q2=0;
            med.A5[med.nA5].A5=med.nA5;
            aut.A5[med.nA5].Z0=iZ0;
            aut.A5[med.nA5].R0=iR0;
            aut.A5[med.nA5++].P1=iP1;
         }
      }
   }
   med.Q2[ 0].c.identity();
   return;
}
