#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../med/Defect_Automatic.hh"
#include <string>
#include <sstream>
#include <iomanip>

void Structure::DEFECT_FLAG(Defect_Automatic& aut,
                            const DAT_RESIDUE_MAPPINGS& residue_mappings,
                            int iR0,int iT1,const char typ){

   std::string rec="ATOM      1  B01 DOT     1       0.000   0.000   0.000";
   int mT1=R0[iR0].T1a;
   int iL0=R0[iR0].L0;
   int mT0=residue_mappings.L0[iL0].T0a;
   int iT0=(iT1-mT1+mT0);
   for(int iA0=1;iA0<3;iA0++){
      int jR0=(iR0+residue_mappings.T0A0R0(iT0,iA0));
      std::string atm=residue_mappings.T0A0atm(iT0,iA0);
      int jP1min=R0[jR0].P1a;
      int jP1max=(jP1min-1+R0[jR0].cP1);
      for(int jP1=jP1min;jP1<=jP1max;jP1++){
         if( P1[jP1].sub==0 )continue;
         if( P1[jP1].atm==atm ){
            std::ostringstream oj;
            oj<<P1[jP1].x;
            rec[21]=R0[jR0].cha;
            rec.replace(30,24,oj.str());
            aut.I2.push_back( Defect_Automatic::tI2());
            aut.I2[aut.nI2].cha=R0[jR0].cha;
            aut.I2[aut.nI2].res=R0[jR0].res;
            aut.I2[aut.nI2].ins=R0[jR0].ins;
            aut.I2[aut.nI2].aa=R0[jR0].aa;
            aut.I2[aut.nI2].typ=typ;
            aut.I2[aut.nI2++].rec=rec;
         }
      }
   }
   return;
}
