#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../med/Defect_Automatic.hh"
#include "../med/Dielec_Continu.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_defect_ehp {
public:
   class tA5 {
   public:
      int I3a;                  //start index of atoms within threshold
      int cI3;                  //number of atoms within threshold
      int I3b;                  //start index of higher neighbor atoms
      int dI3;                  //number of lower neighbor atoms
      tA5(){}
   };
public:
   std::vector<Defect_Automatic::tI2> I2;       //
   std::vector<tA5> A5;                         //physical atoms
   std::vector<int> o_I3A5;                     //index of neighbor atom
   MEM_defect_ehp(int o):
      A5(o)
   {
   }
   int& I3A5(int i){
      return o_I3A5.at( i);  }
};

void Structure::DEFECT_EHP(Defect_Automatic& aut,
                           Dielec_Continu& med,
                           const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_RESIDUE_MAPPINGS& residue_mappings,
                           Output_Streams& out){
   MEM_defect_ehp vv(med.nA5);
//
//
// exposed surface area resolved wrt atoms
//
   for(int iA5= 0;iA5<med.nA5;iA5++){
      aut.A5[iA5].exsa= (0.00);
   }
   double ANGANG= std::pow(physics_consts.ANG,2);
   for(int iF5= 0;iF5<med.nF5;iF5++){
      int iC5=iF5;
      if( !med.C5[iC5].sub )continue;
      double z= (ANGANG*med.F5[iF5].sa/(3.00));
      for(int iN3=0;iN3<3;iN3++){
         int iA5=med.C5[iC5].N3A5[iN3];
         aut.A5[iA5].exsa+=z;
      }
   }
   for(int iF6= 0;iF6<med.nF6;iF6++){
      double z= (ANGANG*med.F6[iF6].sa/(2.00));
      for(int iN2=0;iN2<2;iN2++){
         int iA5=med.H5[med.E6[med.F6[iF6].N2E6[iN2]].H5].A5;
         aut.A5[iA5].exsa+=z;
      }
   }
   for(int iF7= 0;iF7<med.nF7;iF7++){
      double z= (ANGANG*med.F7[iF7].sa);
      int iA5=med.F7[iF7].A5;
      aut.A5[iA5].exsa+=z;
   }
   for(int iA5= 0;iA5<med.nA5;iA5++){
      if( !med.A5[iA5].free )continue;
      double z= (ANGANG*med.A5[iA5].sa);
      aut.A5[iA5].exsa+=z;
   }
   for(int ijB5= 0;ijB5<med.nB5;ijB5++){
      if( !med.B5[ijB5].free )continue;
      double z= (ANGANG*med.B5[ijB5].sa/(2.00));
      for(int iN2=0;iN2<2;iN2++){
         int iA5=med.B5[ijB5].N2A5[iN2];
         aut.A5[iA5].exsa+=z;
      }
   }
//
//
// partition of residues into {0=buried, 1=exposed}
//
   for(int iA5= 0;iA5<med.nA5;iA5++){
      if( aut.A5[iA5].exsa>(1.00) ){
         int iR0=aut.A5[iA5].R0;
         aut.R0[iR0].expo=1;
      }
   }
//
//
// partition of residues into {internal=sc buried, external=sc exposed}
//
   aut.nR0tot=0;
   aut.nR0in=0;
   aut.nR0ex=0;
   int nR0hp=0;
   int nR0inhp=0;
   int nR0exhp=0;
   int pA5=-1;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      aut.nR0tot+=(nR0-mR0+1);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         int iL0=R0[iR0].L0;
         double asc= residue_mappings.L0[iL0].scsa;
         double a= (0.00);
//       double ahp= (0.00);
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            pA5++;
            if      ( c1=='a' ){
               if( aa=="GLY " ){
                  if( atm==" CA " ){
                     a+=aut.A5[pA5].exsa;
                  }
               }else{
                  if( (atm!=" N  ")&&(atm!=" H  ")&&
                      (atm!=" C  ")&&(atm!=" O  ")&&
                      (atm!=" CA ") ){
                     a+=aut.A5[pA5].exsa;
                  }
               }
            }else if( c1=='e' ){
               if( atm==" CH3" ){
                  a+=aut.A5[pA5].exsa;
               }
            }else if( c1=='r' ){
               a+=aut.A5[pA5].exsa;
            }else if( c1=='b' ){
               a+=aut.A5[pA5].exsa;
            }else if( c1=='p' ){
               a+=aut.A5[pA5].exsa;
            }else if( c1=='s' ){
               a+=aut.A5[pA5].exsa;
            }
//          if( (iT2== 8)||(iT2==10) ){
//             ahp+=aut.A5[pA5].exsa;
//          }
         }
         if( a>((.50)*asc) ){
            aut.nR0ex++;
         }else{
            aut.nR0in++;
         }
         if( (aa=="ALA ")||(aa=="PHE ")||(aa=="ILE ")||(aa=="LEU ")||
             (aa=="MET ")||(aa=="PRO ")||(aa=="VAL ")||(aa=="TRP ")||
             (aa=="TYR ")||(aa=="AIB ")||(aa=="ABU ")||(aa=="NLE ")||
             (aa=="CYS ")||(aa=="D   ")||(aa=="RF  ")||(aa=="CET ")||
             (aa=="A   ")||(aa=="G   ")||(aa=="T   ")||(aa=="C   ")||
             (aa=="U   ") ){
            nR0hp++;
            if( a>((.50)*asc) ){
               nR0exhp++;
            }else{
               nR0inhp++;
            }
         }
      }
   }
//
//
// total exposed hydrophobic surface area
//
   double ahp= (0.00);
   for(int iA5= 0;iA5<med.nA5;iA5++){
      int iT2=med.A5[iA5].typ;
      if( (iT2!= 8)&&(iT2!=10) )continue;
      ahp+=aut.A5[iA5].exsa;
   }
//
//
// entropy correction factor
//
   double C= (.025);            //coef relating hydrophobic energy to ahp
   double S= (0.00);            //-TS
   double F;                    //G=( C*ahp +S)=F*(C*ahp)
   bool BALANCE=( nR0hp<=aut.nR0in );
   {
      int n=( BALANCE )? nR0hp: (nR0hp-aut.nR0in);
      double z1=( BALANCE )? aut.nR0in: aut.nR0ex;
      double z2= (1.00);
      for(int i=0;i<n;i++){
         S+=(physics_consts.ekT*std::log( z1/z2));
         z1-=(1.00);
         z2+=(1.00);
      }
      z1= aut.nR0in;
      z2= (1.00);
      for(int i=0;i<nR0inhp;i++){
         S-=(physics_consts.ekT*std::log( z1/z2));
         z1-=(1.00);
         z2+=(1.00);
      }
      z1= aut.nR0ex;
      z2= (1.00);
      for(int i=0;i<nR0exhp;i++){
         S-=(physics_consts.ekT*std::log( z1/z2));
         z1-=(1.00);
         z2+=(1.00);
      }
      F=( (1.00) +S/(C*ahp));
   }
//
//
// hydrophobic residues with exposed hydrophobic surface area above threshold
//
   int nI2=0;
   pA5=-1;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         double a= (0.00);
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            std::string atm=P1[iP1].atm;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            pA5++;
            if( (iT2== 8)||(iT2==10) ){
               a+=aut.A5[pA5].exsa;
            }
         }
         if( (aa=="ALA ")||(aa=="PHE ")||(aa=="ILE ")||(aa=="LEU ")||
             (aa=="MET ")||(aa=="PRO ")||(aa=="VAL ")||(aa=="TRP ")||
             (aa=="TYR ")||(aa=="AIB ")||(aa=="ABU ")||(aa=="NLE ")||
             (aa=="CYS ")||(aa=="D   ")||(aa=="RF  ")||(aa=="CET ")||
             (aa=="A   ")||(aa=="G   ")||(aa=="T   ")||(aa=="C   ")||
             (aa=="U   ") ){
            if( (F*a)>(40.00) ){
               aut.R0[iR0].e[ 9]+=(C*F*a);
               vv.I2.push_back( Defect_Automatic::tI2());
               vv.I2[nI2].cha=R0[iR0].cha;
               vv.I2[nI2].res=R0[iR0].res;
               vv.I2[nI2].ins=R0[iR0].ins;
               vv.I2[nI2].aa=R0[iR0].aa;
               vv.I2[nI2].sa= (F*a);
               nI2++;
            }
         }
      }
   }
//
//
// spatial aggregation propensity
//
   int oA5=med.nA5;
   double z= ((5.00)/physics_consts.ANG);
   double zz= z*z;

   for(int iA5= 0;iA5<oA5;iA5++){
      vv.A5[iA5].cI3=0;
      vv.A5[iA5].dI3=0;
   }

   int mI3=0;
   for(int iA5= 0;iA5<oA5;iA5++){
      vv.A5[iA5].I3a=mI3;
      int n=vv.A5[iA5].cI3;
      for(int i=0;i<n;i++){
         vv.o_I3A5.push_back(-1);
         mI3++;
      }
      vv.A5[iA5].I3b=mI3;
      for(int jA5=(iA5+1);jA5<oA5;jA5++){
         double RR=( med.A5[jA5].x -med.A5[iA5].x).rr();
         if( RR<zz ){
            vv.o_I3A5.push_back(jA5);
            mI3++;
            vv.A5[iA5].cI3++;
            vv.A5[jA5].cI3++;
         }
      }
   }

   for(int iA5= 0;iA5<(oA5-1);iA5++){
      int iI3min=vv.A5[iA5].I3b;
      int iI3max=(vv.A5[iA5].I3a-1+vv.A5[iA5].cI3);
      for(int iI3=iI3min;iI3<=iI3max;iI3++){
         int jA5=vv.I3A5(iI3);
         vv.I3A5(vv.A5[jA5].I3a+vv.A5[jA5].dI3)=iA5;
         vv.A5[jA5].dI3++;
      }
   }

   pA5=-1;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         double sap= (0.00);
         int n=0;
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            pA5++;
            n++;
            if( P1[iP1].sc==1 ){
               double a= aut.A5[pA5].exsa;
               int iL0=R0[iR0].L0;
               double asc= residue_mappings.L0[iL0].scsa;
               double hsc= residue_mappings.L0[iL0].schp;
               sap+=(a*hsc/asc);
            }
            int iI3min=vv.A5[pA5].I3a;
            int iI3max=(iI3min-1+vv.A5[pA5].cI3);
            for(int iI3=iI3min;iI3<=iI3max;iI3++){
               int jA5=vv.I3A5(iI3);
               int jR0=aut.A5[jA5].R0;
               int jP1=aut.A5[jA5].P1;
               if( P1[jP1].sc==1 ){
                  double a= aut.A5[jA5].exsa;
                  int jL0=R0[jR0].L0;
                  double asc= residue_mappings.L0[jL0].scsa;
                  double hsc= residue_mappings.L0[jL0].schp;
                  sap+=(a*hsc/asc);
               }
            }
         }
         aut.R0[iR0].h[ 1]= (sap/n);
      }
   }
//
//
// diagnostic output
//
// out.FILE1<< std::fixed<< std::setprecision( 3);
// out.FILE1<<"iZ0"" iR0""   aa""  atm""    exsa\n";
// for(int iA5= 0;iA5<med.nA5;iA5++){
//    int iZ0=aut.A5[iA5].Z0;
//    int iR0=aut.A5[iA5].R0;
//    std::string aa=R0[iR0].aa;
//    std::string atm=med.A5[iA5].atm;
//    out.FILE1<< std::setw( 3)<<iZ0
//             << std::setw( 4)<<iR0
//             <<' '<<aa
//             <<' '<<atm
//             << std::setw( 8)<<aut.A5[iA5].exsa<<'\n';
// }

   if( out.VERBOSE ){
      out.FILE3<<"EXPOSED HYDROPHOBIC SURFACE"<< std::endl;
      out.FILE3<< std::fixed;
      out.FILE3<<"Total Exposed Hydrophobic Surface Area="
               << std::setprecision( 2)<< std::setw( 9)<<ahp<<'\n';
//    out.FILE3<<" nR0tot="<< std::setw( 4)<<aut.nR0tot
//             <<" nR0in="<< std::setw( 4)<<aut.nR0in
//             <<" nR0ex="<< std::setw( 4)<<aut.nR0ex<<'\n';
//    out.FILE3<<" nR0hp="<< std::setw( 4)<<nR0hp
//             <<" nR0inhp="<< std::setw( 4)<<nR0inhp
//             <<" nR0exhp="<< std::setw( 4)<<nR0exhp<<'\n';
//    out.FILE3<<"Total Exposed Hydrophobic Entropy="
//             << std::setprecision( 3)<< std::setw( 8)<<-S<<'\n';
//    out.FILE3<<"Entropy Correction Factor="
//             << std::setprecision( 3)<< std::setw( 8)<<F<<'\n';
      out.FILE3<<"Number of Exposed Hydrophobic Side Chains="
               << std::setw( 4)<<nI2<<'\n';
      out.FILE3<< std::setprecision( 2);
      for(int iI2= 0;iI2<nI2;iI2++){
         out.FILE3<<vv.I2[iI2].aa
                  <<vv.I2[iI2].cha
                  << std::setw( 4)<<vv.I2[iI2].res
                  <<vv.I2[iI2].ins
                  << std::setw( 9)<<vv.I2[iI2].sa
                  <<'\n';
      }
   }
   return;
}
