#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../med/Defect_Automatic.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_defect_con {
private:
   std::vector<int> o_R0N2L0;               //N2={ 0=sc chg grp, 1=bb chg grp}
   std::vector<Coordinates> o_R0sc;         //mean position of sc heavy atoms
   std::vector<int> o_R0nP1sc;              //number of sc heavy atoms
   std::vector<Coordinates> o_R0N2ch;       //mean position of atoms in chg grp
   std::vector<int> o_R0N2nP1ch;            //number of atoms in chg grp
   std::vector<double> o_L0base;            //mean +1sig of LLcon over res type
   std::vector<double> o_R0miya;            //relative to L0base
   std::vector<double> o_R0elec;            //
   std::vector<int> o_Y3R5;                 //
   std::vector<int> o_Y3ncyh;               //
public:
   std::vector<Defect_Automatic::tR5> R5;   //side chain able to bind Zn++
   std::vector<bool> o_R5sub;               //
   MEM_defect_con(int oR0,int oL0,int oY3):
      o_R0N2L0(oR0*2),
      o_R0sc(oR0),
      o_R0nP1sc(oR0, 0),
      o_R0N2ch(oR0*2),
      o_R0N2nP1ch(oR0*2, 0),
      o_L0base(oL0),
      o_R0miya(oR0,(0.00)),
      o_R0elec(oR0,(0.00)),
      o_Y3R5(oY3),
      o_Y3ncyh(oY3)
   {
   }
   int& R0N2L0(int i,int j){
      return o_R0N2L0.at( i*2 +j);  }
   Coordinates& R0sc(int i){
      return o_R0sc.at( i);  }
   int& R0nP1sc(int i){
      return o_R0nP1sc.at( i);  }
   Coordinates& R0N2ch(int i,int j){
      return o_R0N2ch.at( i*2 +j);  }
   int& R0N2nP1ch(int i,int j){
      return o_R0N2nP1ch.at( i*2 +j);  }
   double& L0base(int i){
      return o_L0base.at( i);  }
   double& R0miya(int i){
      return o_R0miya.at( i);  }
   double& R0elec(int i){
      return o_R0elec.at( i);  }
   void R5sub(int i,bool a){
      o_R5sub[ i]=a;  }
   bool R5sub(int i){
      return o_R5sub[ i];  }
   int& Y3R5(int i){
      return o_Y3R5.at( i);  }
   int& Y3ncyh(int i){
      return o_Y3ncyh.at( i);  }
};

void Structure::DEFECT_CON(Defect_Automatic& aut,
                           const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_RESIDUE_MAPPINGS& residue_mappings,
                           Output_Streams& out){
   int oR0=( Z0[nZ0-1].R0a +Z0[nZ0-1].cR0);
   int oL0=residue_mappings.nL0;
   int oY3=4;
   MEM_defect_con vv(oR0,oL0,oY3);
//
//
// populate interaction sites
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         std::string ab=aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )ab=ab.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )ab=ab.substr(0,3)+' ';
         }
         int jL0=residue_mappings.iresidue( ab);
         vv.R0N2L0(iR0, 0)=jL0;
         vv.R0N2L0(iR0, 1)=-1;
         if( c1=='a' ){
            if      ( aa[0]=='e' ){
               vv.R0N2L0(iR0, 1)=residue_mappings.iresidue("LYS ");
            }else if( aa[3]=='e' ){
               vv.R0N2L0(iR0, 1)=residue_mappings.iresidue("ASP ");
            }
         }

         vv.R0sc(iR0).zero();
         for(int iN2=0;iN2<2;iN2++){
            vv.R0N2ch(iR0,iN2).zero();
         }

         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            int ATMSC=( iT2< 8 )? 0: P1[iP1].sc;
            if( ATMSC==1 ){
               vv.R0sc(iR0)+=P1[iP1].x;
               vv.R0nP1sc(iR0)++;
            }
            int ATMCHG=DEFECT_CHG(iR0,iP1);
            if( ATMCHG!=0 ){
               int iN2=( P1[iP1].sc==1 )? 0: 1;
               vv.R0N2ch(iR0,iN2)+=P1[iP1].x;
               vv.R0N2nP1ch(iR0,iN2)++;
            }
         }

         if( vv.R0nP1sc(iR0)>0 ){
            vv.R0sc(iR0)/=(vv.R0nP1sc(iR0)*physics_consts.ANG);
         }
         for(int iN2=0;iN2<2;iN2++){
            if( vv.R0N2nP1ch(iR0,iN2)>0 ){
               vv.R0N2ch(iR0,iN2)/=(vv.R0N2nP1ch(iR0,iN2)*physics_consts.ANG);
            }
         }

      }
   }
//
//
// accumulate contact energy
//
   for(int iL0= 0;iL0<oL0;iL0++){
      double z1= (0.00);
      double z2= (0.00);
      for(int jL0= 0;jL0<oL0;jL0++){
         z1+=(residue_mappings.L0L0con(iL0,jL0)/(2.));
         z2+=std::pow(residue_mappings.L0L0con(iL0,jL0)/(2.),2);
      }
      z1= (z1/oL0);
      z2= (z2/oL0);
      vv.L0base(iL0)=( z1 +std::sqrt( z2 -z1*z1));
   }

   double Fmiya= (0.00);
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      if( aut.Z0[iZ0].c1!='a' )continue;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0nP1sc(iR0)==0 )continue;
         int iL0=R0[iR0].L0;
         for(int jZ0=iZ0;jZ0<nZ0;jZ0++){
            int aR0=Z0[jZ0].R0a;
            int bR0=(aR0-1+Z0[jZ0].cR0);
            if( jZ0==iZ0 )aR0=(iR0+1);
            for(int jR0=aR0;jR0<=bR0;jR0++){
               if( vv.R0nP1sc(jR0)==0 )continue;
               int jL0=R0[jR0].L0;

               double R=( vv.R0sc(jR0) -vv.R0sc(iR0)).r();
               if( R<(12.28) ){
                  double Z= residue_mappings.L0L0con(iL0,jL0);
                  Fmiya+=Z;
                  vv.R0miya(iR0)+=( (Z/(2.)) -vv.L0base(iL0));
                  vv.R0miya(jR0)+=( (Z/(2.)) -vv.L0base(jL0));
               }

            }
         }
      }
   }
//
//
// add stability contributed by disulfide bonds
//
   {
      double Z= (-32.);
      for(int iS0= 0;iS0<nS0;iS0++){
         Fmiya+=Z;
         for(int iN2=0;iN2<2;iN2++){
            int iR0=S0N2R0(iS0,iN2);
            vv.R0miya(iR0)+=(Z/(2.));
         }
      }
   }
//
//
// accumulate electrostatic energy
//
   int nPOS=0;
   int nNEG=0;
   double F2bod= (0.00);
   double F3bod= (0.00);
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char ci=R0[iR0].c1;
         std::string aai=R0[iR0].aa;
         int iN2max=1;
         if( ci=='a' ){
            if( (aai[0]=='e')||
                (aai[3]=='e') )iN2max=2;
         }
         for(int iN2=0;iN2<iN2max;iN2++){
            if( vv.R0N2nP1ch(iR0,iN2)==0 )continue;
            int iL0=vv.R0N2L0(iR0,iN2);
            if( residue_mappings.L0[iL0].pol<2 )continue;
            double sig1= residue_mappings.L0[iL0].gau.sig;
            double eta1= residue_mappings.L0[iL0].gau.eta;
            if( sig1<(0.00) ){
               nNEG++;
            }else{
               nPOS++;
            }
            for(int jZ0=iZ0;jZ0<nZ0;jZ0++){
               int aR0=Z0[jZ0].R0a;
               int bR0=(aR0-1+Z0[jZ0].cR0);
               if( jZ0==iZ0 )aR0=iR0;
               for(int jR0=aR0;jR0<=bR0;jR0++){
                  char cj=R0[jR0].c1;
                  std::string aaj=R0[jR0].aa;
                  int jN2min=( jR0==iR0 )? iN2: 0;
                  int jN2max=1;
                  if( cj=='a' ){
                     if( (aaj[0]=='e')||
                         (aaj[3]=='e') )jN2max=2;
                  }
                  for(int jN2=jN2min;jN2<jN2max;jN2++){
                     if( vv.R0N2nP1ch(jR0,jN2)==0 )continue;
                     int jL0=vv.R0N2L0(jR0,jN2);
                     if( residue_mappings.L0[jL0].pol<2 )continue;
                     double F=( (jR0==iR0)&&(jN2==iN2) )? (1.): (2.);
                     double sig= residue_mappings.L0[jL0].gau.sig;
                     double eta= residue_mappings.L0[jL0].gau.eta;
                     double eta2=( eta1 +eta);
                     double RR=( vv.R0N2ch(jR0,jN2)
                                -vv.R0N2ch(iR0,iN2)).rr();
                     double G= (eta1*eta/eta2);
                     double sig2a= F*(4.)*eta1*eta*sig1*sig*std::exp(-G*RR);
                     double H= sig2a*( eta1 -eta)/eta2;
                     Coordinates x= ((1.00)/eta2)*( eta1*vv.R0N2ch(iR0,iN2)
                                                    +eta*vv.R0N2ch(jR0,jN2));
                     Coordinates sig2b= H*( vv.R0N2ch(iR0,iN2)
                                           -vv.R0N2ch(jR0,jN2));
                     double sig2c= sig2a*(-G*RR/eta2);
                     double Z= (physics_consts.PI/eta2);
                     double e= (Z*std::sqrt( Z)
                               *( ((1.50)/eta2)*sig2a +sig2c));
                     F2bod+=e;
                     vv.R0elec(iR0)+=(e/(2.));
                     vv.R0elec(jR0)+=(e/(2.));

                     for(int kZ0=0;kZ0<nZ0;kZ0++){
                        int kR0min=Z0[kZ0].R0a;
                        int kR0max=(kR0min-1+Z0[kZ0].cR0);
                        for(int kR0=kR0min;kR0<=kR0max;kR0++){
                           if( vv.R0nP1sc(kR0)==0 )continue;
                           int kL0=vv.R0N2L0(kR0, 0);
                           if( residue_mappings.L0[kL0].pol!=0 )continue;
                           sig= residue_mappings.L0[kL0].gau.sig;
                           eta= residue_mappings.L0[kL0].gau.eta;
                           double eta3=( eta2 +eta);
                           Coordinates zD=( vv.R0sc(kR0) -x);
                           RR= zD.rr();
                           G= (eta2*eta/eta3);
                           double sig3= sig*std::exp(-G*RR);
                           H= (eta/eta3);
                           Z= (physics_consts.PI/eta3);
                           e=sig3*Z*std::sqrt( Z)*(
                             +sig2a*( ((1.50)/eta3) +(H*H)*RR)
                             +H*dot(sig2b,zD)
                             +sig2c);
                           F3bod+=e;
                           vv.R0elec(iR0)+=(e/(2.));
                           vv.R0elec(jR0)+=(e/(2.));
                        }
                     }

                  }
               }
            }
         }
      }
   }
//
//
// correct electrostatic energy for composition
//
   double Fbase= (0.00);
   if( (nPOS+nNEG)>0 ){
      int nFREE=( nPOS>=nNEG )? (nPOS-nNEG): (nNEG-nPOS);
      int nPAIR=( nPOS>=nNEG )? nNEG: nPOS;
      double Rfree= ((3.6)/physics_consts.ANG)
                   *std::exp( (.33333333)*std::log( aut.nR0tot));
      double Rpair= ((4.0)/physics_consts.ANG);
      double sig1= residue_mappings.L0[ 8].gau.sig;
      double eta1= residue_mappings.L0[ 8].gau.eta;
      double eta2=( eta1 +eta1);
      double G= (eta1*eta1/eta2);
      double sig2a= (4.)*eta1*eta1*sig1*sig1;
      double Z= (physics_consts.PI/eta2);
      double e= (Z*std::sqrt( Z)*((1.50)/eta2)*sig2a);
      double Fpp= nFREE*e;
      double Fpn= 2*nPAIR*e;
      double RR= (Rfree*Rfree);
      double sig3a= sig2a*std::exp(-G*RR);
      double sig3c= sig3a*(-G*RR/eta2);
      e= (Z*std::sqrt( Z)*( ((1.50)/eta2)*sig3a +sig3c));
      Fpp+=(nFREE*(nFREE-1)*e);
      RR= (Rpair*Rpair);
      sig3a= sig2a*std::exp(-G*RR);
      sig3c= sig3a*(-G*RR/eta2);
      e= (Z*std::sqrt( Z)*( ((1.50)/eta2)*sig3a +sig3c));
      Fpn+=((-2.)*nPAIR*e);
      Fbase=( Fpp +Fpn);
      F2bod-=Fbase;
      Z= Fbase/( nPOS +nNEG);
      for(int iZ0=0;iZ0<nZ0;iZ0++){
         int mR0=Z0[iZ0].R0a;
         int nR0=(mR0-1+Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            char c1=R0[iR0].c1;
            std::string aa=R0[iR0].aa;
            int iN2max=1;
            if( c1=='a' ){
               if( (aa[0]=='e')||
                   (aa[3]=='e') )iN2max=2;
            }
            for(int iN2=0;iN2<iN2max;iN2++){
               if( vv.R0N2nP1ch(iR0,iN2)==0 )continue;
               int iL0=vv.R0N2L0(iR0,iN2);
               if( residue_mappings.L0[iL0].pol<2 )continue;
               vv.R0elec(iR0)-=Z;
            }
         }
      }
   }
//
//
// Zn++ binding site
//
   int nR5=0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      if( aut.Z0[iZ0].c1!='a' )continue;
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         if( c1=='a' ){
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
         }
         if( (aa!="ASP ")&&(aa!="CYH ")&&(aa!="HIS ")&&(aa!="HIE ")&&
             (aa!="HIP ") )continue;
         Coordinates x;
         x.zero();
         double z= (0.00);
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            int iT2=P1[iP1].typ;
            if( iT2< 8 )continue;
            std::string atm=P1[iP1].atm;
            if( (atm==" N  ")||(atm==" CA ")||(atm==" C  ")||(atm==" CB ")||
                (atm==" O  ") )continue;
            x+=P1[iP1].x;
            z++;
         }
         if( z>(0.00) ){
            vv.R5.push_back( Defect_Automatic::tR5());
            vv.R5[nR5].Z0=iZ0;
            vv.R5[nR5].R0=iR0;
            vv.R5[nR5].aa=aa;
            vv.R5[nR5].x=x;
            vv.R5[nR5].x/=z;
            nR5++;
         }
      }
   }
   int nZN=0;
   {
      double Z= (-32.);
      vv.o_R5sub.resize(nR5, true);
      int iY3= 0;
      vv.Y3R5( 0)=-1;
      for(;;){
         vv.Y3R5(iY3)++;
         if( vv.Y3R5(iY3)>(nR5-oY3+iY3) ){
            if( iY3== 0 ){
               break;
            }else{
               iY3--;
               continue;
            }

         }else{
            if( iY3==0 ){
               vv.Y3ncyh(iY3)=( vv.R5[vv.Y3R5(iY3)].aa=="CYS " )? 1: 0;
            }else{
               for(int jY3=0;jY3<iY3;jY3++){
                  double R=( vv.R5[vv.Y3R5(iY3)].x -vv.R5[vv.Y3R5(jY3)].x).r();
                  if( R>(7.0) )continue;
               }
               vv.Y3ncyh(iY3)=vv.Y3ncyh(iY3-1)
                             +( vv.R5[vv.Y3R5(iY3)].aa=="CYS " )? 1: 0;
            }
            if( iY3==(oY3-1) ){
               if( vv.Y3ncyh(iY3)<2 )continue;
               for(int jY3=0;jY3<oY3;jY3++){
                  if( !vv.R5sub(vv.Y3R5(jY3)) )continue;
               }
               nZN++;
               Fmiya+=Z;
               for(int jY3=0;jY3<oY3;jY3++){
                  vv.R0miya(vv.R5[vv.Y3R5(jY3)].R0)+=(Z/oY3);
                  vv.R5sub(vv.Y3R5(jY3),false);
               }
            }else{
               iY3++;
               vv.Y3R5(iY3)=vv.Y3R5(iY3-1);
            }

         }
      }
   }
//
//
// hydrophobic helix
//
   int nHEL=0;
   {
      double Z= (-32.);
      for(int iZ0=0;iZ0<nZ0;iZ0++){
         if( aut.Z0[iZ0].c1!='a' )continue;
         int mR0=Z0[iZ0].R0a;
         int nR0=(mR0-1+Z0[iZ0].cR0);
         for(int iR0=(mR0+1);iR0<(nR0-15);iR0++){
            bool EXPOHELIX=true;
            for(int jR0=iR0;jR0<=(iR0+15);jR0++){
               int coil=aut.R0[jR0].coil;
               int expo=aut.R0[jR0].expo;
               std::string cnf=aut.R0[jR0].bbcnf;
               if( (coil==1)||((cnf!="A ")&&(cnf!="B "))||(expo==0) ){
                  EXPOHELIX=false;
               }
            }
            if( !EXPOHELIX )continue;
            bool HYDROPHOB=false;
            for(int kR0min=iR0;kR0min<=(iR0+4);kR0min++){
               int nPOL=0;
               int kR0max=(kR0min+11);
               for(int kR0=kR0min;kR0<=kR0max;kR0++){
                  std::string aa=R0[kR0].aa;
                  if      ( (aa=="ASP ")||(aa=="GLU ")||(aa=="LYS ")||
                            (aa=="ARG ")||(aa=="ORN ")||(aa=="HIP ")||
                            (aa=="CYZ ")||(aa=="TYZ ") ){
                     nPOL+=2;
                  }else if( (aa=="HIS ")||(aa=="ASN ")||(aa=="GLN ")||
                            (aa=="SER ")||(aa=="THR ")||(aa=="TYR ")||
                            (aa=="HIE ")||(aa=="HPR ") ){
                     nPOL+=1;
                  }else if( (aa=="TRP ")||(aa=="CYH ") ){
                     nPOL+=0;
                  }else{
                  }
               }
               if( nPOL<3 )HYDROPHOB=true;
            }
            if( HYDROPHOB ){
               nHEL++;
               Fmiya+=Z;
               for(int jR0=iR0;jR0<=(iR0+15);jR0++){
                  vv.R0miya(jR0)+=(Z/(16.));
               }
               iR0+=15;
            }
         }
      }
   }
//
//
// local concentration of charge
//
   int nCONC=0;
   {
      double Z= (-.75);
      for(int iZ0=0;iZ0<nZ0;iZ0++){
         if( aut.Z0[iZ0].c1!='a' )continue;
         int mR0=Z0[iZ0].R0a;
         int nR0=(mR0-1+Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=(nR0-15);iR0++){
            int iCHG=0;
            for(int jR0=iR0;jR0<=(iR0+15);jR0++){
               char c1=R0[jR0].c1;
               std::string aa=R0[jR0].aa;
               if( c1=='a' ){
                  if      ( aa[0]=='e' ){
                     aa=aa.substr(1,3)+' ';
                     iCHG++;
                  }else if( aa[0]=='z' ){
                     aa=aa.substr(1,3)+' ';
                  }
                  if      ( aa[3]=='e' ){
                     aa=aa.substr(0,3)+' ';
                     iCHG--;
                  }else if( aa[3]=='z' ){
                     aa=aa.substr(0,3)+' ';
                  }
                  if      ( aa=="ASP " ){
                     iCHG--;
                  }else if( aa=="GLU " ){
                     iCHG--;
                  }else if( aa=="LYS " ){
                     iCHG++;
                  }else if( aa=="ARG " ){
                     iCHG++;
                  }else if( aa=="ORN " ){
                     iCHG++;
                  }else if( aa=="HIP " ){
                     iCHG++;
                  }else if( aa=="CYZ " ){
                     iCHG--;
                  }else if( aa=="TYZ " ){
                     iCHG--;
                  }
               }
            }
            if( (iCHG> 4)||(iCHG<-4) ){
               nCONC++;
               for(int jR0=iR0;jR0<=(iR0+15);jR0++){
                  char c1=R0[jR0].c1;
                  std::string aa=R0[jR0].aa;
                  if( c1=='a' ){
                     if( (aa[0]=='e')||
                         (aa[0]=='z') )aa=aa.substr(1,3)+' ';
                     if( (aa[3]=='e')||
                         (aa[3]=='z') )aa=aa.substr(0,3)+' ';
                  }
                  if( ((iCHG<0)&&
                       ((aa=="ASP ")||(aa=="GLU ")||(aa=="CYZ ")||
                        (aa=="TYZ ")))||
                      ((iCHG>0)&&
                       ((aa=="LYS ")||(aa=="ARG ")||(aa=="ORN ")||
                        (aa=="HIP "))) ){
                     F2bod+=Z;
                     vv.R0elec(jR0)+=Z;
                  }
               }
               iR0+=15;
            }
         }
      }
   }
//
//
// identify outlier values
//
   std::vector<Defect_Automatic::tI2>  I2;
   int nI2=0;
   int cI2=0;
   int eI2=0;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0miya(iR0)>(0.10) ){
            aut.R0[iR0].e[11]+=(2.00);
            I2.push_back( Defect_Automatic::tI2());
            I2[nI2].cha=R0[iR0].cha;
            I2[nI2].res=R0[iR0].res;
            I2[nI2].ins=R0[iR0].ins;
            I2[nI2].aa=R0[iR0].aa;
            I2[nI2].typ='c';
            I2[nI2].e= vv.R0miya(iR0);
            nI2++;
            cI2++;
         }
         if( vv.R0elec(iR0)>(20.0) ){
            aut.R0[iR0].e[12]+=(3.00);
            I2.push_back( Defect_Automatic::tI2());
            I2[nI2].cha=R0[iR0].cha;
            I2[nI2].res=R0[iR0].res;
            I2[nI2].ins=R0[iR0].ins;
            I2[nI2].aa=R0[iR0].aa;
            I2[nI2].typ='e';
            I2[nI2].e= vv.R0elec(iR0);
            nI2++;
            eI2++;
         }
      }
   }
   vv.R5.clear();
   vv.o_R5sub.clear();
//
//
// diagnostic output
//
   if( out.VERBOSE ){
      out.FILE3<< std::fixed<< std::setprecision( 2);
      out.FILE3<<"OUTLIER STATISTICAL CONTACT"<< std::endl;
      out.FILE3<<"Statistical Residue-Residue Contact Energy="
               << std::setw( 9)<<Fmiya<<'\n';
      out.FILE3<<"ELECTROSTATIC"<< std::endl;
      out.FILE3<<"2-body Electrostatic Energy="
               << std::setw( 9)<<F2bod<<'\n';
      out.FILE3<<"3-body Electrostatic Energy="
               << std::setw( 9)<<F3bod<<'\n';
//    out.FILE3<<"Electrostatic Energy Composition Correction="
//             << std::setw( 9)<<Fbase<<'\n';
      out.FILE3<<"Number of Zn++ Binding Sites="
               << std::setw( 2)<<nZN<<'\n';
      out.FILE3<<"Number of Hydrophobic Helicies="
               << std::setw( 2)<<nHEL<<'\n';
      out.FILE3<<"Number of High Charge Segments="
               << std::setw( 2)<<nCONC<<'\n';
//    out.FILE3<<"Total Contact Energy="
//             << std::setw( 9)<<( Fmiya +F2bod +F3bod)<<'\n';
      out.FILE3<<"Number of Outlier Statistical Contact Impulses="
               << std::setw( 4)<<cI2<<'\n';
      out.FILE3<< std::setprecision( 3);
      for(int iI2= 0;iI2<nI2;iI2++){
         if( I2[iI2].typ!='c' )continue;
         out.FILE3<<I2[iI2].aa
                  <<I2[iI2].cha
                  << std::setw( 4)<<I2[iI2].res
                  <<I2[iI2].ins<<' '
                  << std::setw( 8)<<I2[iI2].e<<'\n';
      }
      out.FILE3<<"Number of Outlier Electrostatic Impulses="
               << std::setw( 4)<<eI2<<'\n';
      out.FILE3<< std::setprecision( 2);
      for(int iI2= 0;iI2<nI2;iI2++){
         if( I2[iI2].typ!='e' )continue;
         out.FILE3<<I2[iI2].aa
                  <<I2[iI2].cha
                  << std::setw( 4)<<I2[iI2].res
                  <<I2[iI2].ins<<' '
                  << std::setw( 8)<<I2[iI2].e<<'\n';
      }
   }
   I2.clear();
   return;
}
