#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../med/Defect_Automatic.hh"
#include "../med/Dielec_Continu.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <iostream>
#include <cstdlib>
#include <sstream>
#include <iomanip>
#include <cmath>

class MEM_defect_cav {
public:
   class tQ5 { /*clusters of dots representing connected surfaces*/
   public:
      double sa;                                //
      std::vector<Defect_Automatic::tI2> I2;    //
      tQ5():sa( 0.00){}
   };
private:
   std::vector<bool> o_DOTsub;          //
public:
   std::vector<tQ5> Q5;                 //
   MEM_defect_cav(int oDOT,int oQ5):
      o_DOTsub(oDOT, true),
      Q5(oQ5)
   {
   }
   void DOTsub(int i,bool a){
      o_DOTsub[ i]=a;  }
   bool DOTsub(int i){
      return o_DOTsub[ i];  }
};

void Structure::DEFECT_CAV(Defect_Automatic& aut,
                           Dielec_Continu& mlg,
                           Dielec_Continu& med,
                           const DAT_PHYSICS_CONSTS& physics_consts,
                           const DAT_ARRAY_CONSTS& array_consts,
                           const DAT_ENERGY_PARAMS& energy_params,
                           const DAT_RESIDUE_MAPPINGS& residue_mappings,
                           Output_Streams& out){
   bool VERBOSE_hold=out.VERBOSE;
// std::string filename="../../"+fam+"/dgn/defectcav."+mol+'.'+cnf;
// out.FILE1.open(filename.c_str());
//
//
// large probe radius dots
//
   mlg.probe= ((2.80)/physics_consts.ANG);
   mlg.MED_SPHERE(physics_consts,out);
   mlg.MED_TORUS(physics_consts,out);
   DEFECT_MOL(aut,mlg,physics_consts,energy_params);
   out.VERBOSE=false;
   mlg.bse_nA5=0;
   mlg.bse_nB5=0;
   mlg.bse_nC5=0;
   mlg.bse_nF5=0;
   mlg.bse_nE5=0;
   mlg.bse_nV5=0;
   mlg.bse_nH5=0;
   mlg.ENDSTATE=0;
   mlg.MED_SURF(physics_consts,out);
   if( mlg.ENDSTATE>0 ){
      out.FILE3<<"ENDSTATE="<< std::setw( 2)<<mlg.ENDSTATE<< std::endl;
      std::exit( 2);
      return;
   }
   mlg.bse_nD5=0;
   mlg.MED_DOT(physics_consts,array_consts,out);
   out.VERBOSE=VERBOSE_hold;
   DEFECT_SURF(mlg,physics_consts,out);
//
//
// small probe radius dots
//
   med.probe= ((1.40)/physics_consts.ANG);
   med.MED_SPHERE(physics_consts,out);
   med.MED_TORUS(physics_consts,out);
   DEFECT_MOL(aut,med,physics_consts,energy_params);
   out.VERBOSE=false;
   med.bse_nA5=0;
   med.bse_nB5=0;
   med.bse_nC5=0;
   med.bse_nF5=0;
   med.bse_nE5=0;
   med.bse_nV5=0;
   med.bse_nH5=0;
   med.ENDSTATE=0;
   med.MED_SURF(physics_consts,out);
   if( med.ENDSTATE>0 ){
      out.FILE3<<"ENDSTATE="<< std::setw( 2)<<med.ENDSTATE<< std::endl;
      std::exit( 2);
      return;
   }
   med.bse_nD5=0;
   med.MED_DOT(physics_consts,array_consts,out);
   out.VERBOSE=VERBOSE_hold;
   DEFECT_SURF(med,physics_consts,out);
   DEFECT_EHP(aut,med,physics_consts,residue_mappings,out);
// out.FILE1.close();
//
//
// subset of cavity and cleft dots
//
   MEM_defect_cav vv(med.nDOT,med.nQ5);
   double rrcut= std::pow((3.20)/physics_consts.ANG,2);
   for(int i0G5=-16;i0G5<=16;i0G5++){
      int iG5min=(i0G5-3);
      if( iG5min<-16 )iG5min=-16;
      int iG5max=(i0G5+3);
      if( iG5max> 16 )iG5max= 16;
      for(int j0G5=-16;j0G5<=16;j0G5++){
         int jG5min=(j0G5-3);
         if( jG5min<-16 )jG5min=-16;
         int jG5max=(j0G5+3);
         if( jG5max> 16 )jG5max= 16;
         for(int k0G5=-16;k0G5<=16;k0G5++){
            int kG5min=(k0G5-3);
            if( kG5min<-16 )kG5min=-16;
            int kG5max=(k0G5+3);
            if( kG5max> 16 )kG5max= 16;
            if( med.G5G5G5(i0G5,j0G5,k0G5).n==0 )continue;
            int iD5min=med.G5G5G5(i0G5,j0G5,k0G5).i;
            int iD5max=(iD5min-1+med.G5G5G5(i0G5,j0G5,k0G5).n);
            for(int iD5=iD5min;iD5<=iD5max;iD5++){
               int aDOT=med.D5[iD5].DOTa;
               int bDOT=(aDOT-1+med.D5[iD5].cDOT);
               for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
                  bool HIT=(false);
                  for(int iG5=iG5min;iG5<=iG5max&&(!HIT);iG5++){
                     for(int jG5=jG5min;jG5<=jG5max&&(!HIT);jG5++){
                        for(int kG5=kG5min;kG5<=kG5max&&(!HIT);kG5++){
                           if( mlg.G5G5G5(iG5,jG5,kG5).n==0 )continue;
                           int jD5min=mlg.G5G5G5(iG5,jG5,kG5).i;
                           int jD5max=(jD5min-1+mlg.G5G5G5(iG5,jG5,kG5).n);
                           for(int jD5=jD5min;jD5<=jD5max&&(!HIT);jD5++){
//                            if( mlg.D5[jD5].Q5> 0 )continue;
                              int pDOT=mlg.D5[jD5].DOTa;
                              int qDOT=(pDOT-1+mlg.D5[jD5].cDOT);
                              for(int jDOT=pDOT;jDOT<=qDOT&&(!HIT);jDOT++){
                                 double rr=( mlg.DOT[jDOT].x
                                            -med.DOT[iDOT].x).rr();
                                 if( rr<rrcut ){
                                    vv.DOTsub(iDOT,false);
                                    HIT=true;
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
   }
//
// flag cavity and cleft dots
// accumulate residue defect energy
//
   std::string rec="ATOM      1  B02 DOT     1       0.000   0.000   0.000";
   int oQ5=med.nQ5;
   double ANGANG= std::pow(physics_consts.ANG,2);
   for(int iD5= 0;iD5<med.nD5;iD5++){
      int iQ5=med.D5[iD5].Q5;
      double f=( iQ5== 0 )? (.016): (.032);
      f*=ANGANG;
      std::string atm=" B02";
      if      ( iQ5== 0 ){
      }else if( iQ5== 1 ){
         atm=" B10";
      }else if( iQ5== 2 ){
         atm=" B11";
      }else if( iQ5== 3 ){
         atm=" B12";
      }else if( iQ5== 4 ){
         atm=" B13";
      }else if( iQ5== 5 ){
         atm=" B14";
      }else{
         atm=" B15";
      }
      rec.replace(12, 4,atm);
      int aDOT=med.D5[iD5].DOTa;
      int bDOT=(aDOT-1+med.D5[iD5].cDOT);
      for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
         if( !vv.DOTsub(iDOT) )continue;
         vv.Q5[iQ5].sa+=(ANGANG*med.DOT[iDOT].a);
         std::ostringstream oj;
         oj<<(physics_consts.ANG*med.DOT[iDOT].x);
         rec.replace(30,24,oj.str());
         aut.I2.push_back( Defect_Automatic::tI2());
         aut.I2[aut.nI2++].rec=rec;
         double e= (f*med.DOT[iDOT].a);
         if      ( med.DOT[iDOT].typ==-1 ){
            int iC5=med.DOT[iDOT].elm;
            for(int iN3=0;iN3<3;iN3++){
               int iA5=med.C5[iC5].N3A5[iN3];
               int iR0=aut.A5[iA5].R0;
               aut.R0[iR0].e[ 6]+=(e/(3.));
               char cha=R0[iR0].cha;
               int res=R0[iR0].res;
               char ins=R0[iR0].ins;
               int nI2=vv.Q5[iQ5].I2.size();
               int iI2=-1;
               for(int jI2= 0;jI2<nI2;jI2++){
                  if( (vv.Q5[iQ5].I2[jI2].cha==cha)&&
                      (vv.Q5[iQ5].I2[jI2].res==res)&&
                      (vv.Q5[iQ5].I2[jI2].ins==ins) )iI2=jI2;
               }
               if( iI2==-1 ){
                  vv.Q5[iQ5].I2.push_back( Defect_Automatic::tI2());
                  vv.Q5[iQ5].I2[nI2].sa= ANGANG*med.DOT[iDOT].a/(3.);
                  vv.Q5[iQ5].I2[nI2].cha=cha;
                  vv.Q5[iQ5].I2[nI2].res=res;
                  vv.Q5[iQ5].I2[nI2].ins=ins;
                  vv.Q5[iQ5].I2[nI2].aa=R0[iR0].aa;
               }else{
                  vv.Q5[iQ5].I2[iI2].sa+=(ANGANG*med.DOT[iDOT].a/(3.));
               }
            }
         }else if( med.DOT[iDOT].typ== 0 ){
            int elm=med.DOT[iDOT].elm;
            int iB5;
            if( elm< 0 ){
               iB5=(-1-elm);
            }else{
               int jE6=med.F6[elm].N2E6[0];
               int iE6=med.F6[elm].N2E6[1];
               int jH5=med.E6[jE6].H5;
               int iH5=med.E6[iE6].H5;
               iB5=med.H5[iH5].B5;
            }
            for(int iN2=0;iN2<2;iN2++){
               int iA5=med.B5[iB5].N2A5[iN2];
               int iR0=aut.A5[iA5].R0;
               aut.R0[iR0].e[ 6]+=(e/(2.));
               char cha=R0[iR0].cha;
               int res=R0[iR0].res;
               char ins=R0[iR0].ins;
               int nI2=vv.Q5[iQ5].I2.size();
               int iI2=-1;
               for(int jI2= 0;jI2<nI2;jI2++){
                  if( (vv.Q5[iQ5].I2[jI2].cha==cha)&&
                      (vv.Q5[iQ5].I2[jI2].res==res)&&
                      (vv.Q5[iQ5].I2[jI2].ins==ins) )iI2=jI2;
               }
               if( iI2==-1 ){
                  vv.Q5[iQ5].I2.push_back( Defect_Automatic::tI2());
                  vv.Q5[iQ5].I2[nI2].sa= ANGANG*med.DOT[iDOT].a/(2.);
                  vv.Q5[iQ5].I2[nI2].cha=cha;
                  vv.Q5[iQ5].I2[nI2].res=res;
                  vv.Q5[iQ5].I2[nI2].ins=ins;
                  vv.Q5[iQ5].I2[nI2].aa=R0[iR0].aa;
               }else{
                  vv.Q5[iQ5].I2[iI2].sa+=(ANGANG*med.DOT[iDOT].a/(2.));
               }
            }
         }else if( med.DOT[iDOT].typ== 1 ){
            int elm=med.DOT[iDOT].elm;
            int iA5;
            if( elm< 0 ){
               iA5=(-1-elm);
            }else{
               iA5=med.F7[elm].A5;
            }
            int iR0=aut.A5[iA5].R0;
            aut.R0[iR0].e[ 6]+=e;
            char cha=R0[iR0].cha;
            int res=R0[iR0].res;
            char ins=R0[iR0].ins;
            int nI2=vv.Q5[iQ5].I2.size();
            int iI2=-1;
            for(int jI2= 0;jI2<nI2;jI2++){
               if( (vv.Q5[iQ5].I2[jI2].cha==cha)&&
                   (vv.Q5[iQ5].I2[jI2].res==res)&&
                   (vv.Q5[iQ5].I2[jI2].ins==ins) )iI2=jI2;
            }
            if( iI2==-1 ){
               vv.Q5[iQ5].I2.push_back( Defect_Automatic::tI2());
               vv.Q5[iQ5].I2[nI2].sa= ANGANG*med.DOT[iDOT].a;
               vv.Q5[iQ5].I2[nI2].cha=cha;
               vv.Q5[iQ5].I2[nI2].res=res;
               vv.Q5[iQ5].I2[nI2].ins=ins;
               vv.Q5[iQ5].I2[nI2].aa=R0[iR0].aa;
            }else{
               vv.Q5[iQ5].I2[iI2].sa+=ANGANG*med.DOT[iDOT].a;
            }
         }
      }
   }
//
//
// accumulate residue defect energy
//
   for(int iD5= 0;iD5<med.nD5;iD5++){
      int iQ5=med.D5[iD5].Q5;
      if( iQ5== 0 )continue;
      if( vv.Q5[iQ5].sa<=(0.00) )continue;
      int aDOT=med.D5[iD5].DOTa;
      int bDOT=(aDOT-1+med.D5[iD5].cDOT);
      for(int iDOT=aDOT;iDOT<=bDOT;iDOT++){
         if( !vv.DOTsub(iDOT) )continue;
         double e= (2.00)*(ANGANG*med.DOT[iDOT].a/vv.Q5[iQ5].sa);
         if      ( med.DOT[iDOT].typ==-1 ){
            int iC5=med.DOT[iDOT].elm;
            for(int iN3=0;iN3<3;iN3++){
               int iA5=med.C5[iC5].N3A5[iN3];
               int iR0=aut.A5[iA5].R0;
               aut.R0[iR0].e[ 6]+=(e/(3.));
            }
         }else if( med.DOT[iDOT].typ== 0 ){
            int elm=med.DOT[iDOT].elm;
            int iB5;
            if( elm< 0 ){
               iB5=(-1-elm);
            }else{
               int jE6=med.F6[elm].N2E6[0];
               int iE6=med.F6[elm].N2E6[1];
               int jH5=med.E6[jE6].H5;
               int iH5=med.E6[iE6].H5;
               iB5=med.H5[iH5].B5;
            }
            for(int iN2=0;iN2<2;iN2++){
               int iA5=med.B5[iB5].N2A5[iN2];
               int iR0=aut.A5[iA5].R0;
               aut.R0[iR0].e[ 6]+=(e/(2.));
            }
         }else if( med.DOT[iDOT].typ== 1 ){
            int elm=med.DOT[iDOT].elm;
            int iA5;
            if( elm< 0 ){
               iA5=(-1-elm);
            }else{
               iA5=med.F7[elm].A5;
            }
            int iR0=aut.A5[iA5].R0;
            aut.R0[iR0].e[ 6]+=e;
         }
      }
   }
//
//
// diagnostic output
//
   double acle= vv.Q5[ 0].sa;
   double acav= (0.00);
   int nCAV=0;
   for(int iQ5= 1;iQ5<oQ5;iQ5++){
      if( vv.Q5[iQ5].sa> (0.00) ){
         acav+=vv.Q5[iQ5].sa;
         nCAV++;
      }
   }
   if( out.VERBOSE ){
      out.FILE3<<"CAVITY"<< std::endl;
      out.FILE3<< std::fixed<< std::setprecision( 2);
      out.FILE3<<"Number of Cavities="
               << std::setw( 2)<<nCAV<<'\n';
      out.FILE3<<"Total Cavity Surface Area="
               << std::setw( 9)<<acav<<'\n';
      for(int iQ5= 1;iQ5<oQ5;iQ5++){
         if( vv.Q5[iQ5].sa> (0.00) ){
            out.FILE3<<" Cavity Index="
                     << std::setw( 2)<<iQ5<<'\n';
            out.FILE3<<" Cavity Surface Area="
                     << std::setw( 9)
                     <<vv.Q5[iQ5].sa
                     <<'\n';
            int nI2=vv.Q5[iQ5].I2.size();
            out.FILE3<<" Number of Contributing Residues="
                     << std::setw( 3)<<nI2<<'\n';
            for(int jI2= 0;jI2<nI2;jI2++){
               out.FILE3<<vv.Q5[iQ5].I2[jI2].aa
                        <<vv.Q5[iQ5].I2[jI2].cha
                        << std::setw( 4)<<vv.Q5[iQ5].I2[jI2].res
                        <<vv.Q5[iQ5].I2[jI2].ins
                        << std::setw( 8)
                        <<vv.Q5[iQ5].I2[jI2].sa
                        <<'\n';
            }
         }
      }
      out.FILE3<<"Total Cleft Surface Area="
               << std::setw( 9)
               <<acle<<'\n';
      if( vv.Q5[ 0].sa> (0.00) ){
         int nI2=vv.Q5[ 0].I2.size();
         out.FILE3<<" Number of Contributing Residues="
                  << std::setw( 3)<<nI2<<'\n';
         for(int jI2= 0;jI2<nI2;jI2++){
            out.FILE3<<vv.Q5[ 0].I2[jI2].aa
                     <<vv.Q5[ 0].I2[jI2].cha
                     << std::setw( 4)<<vv.Q5[ 0].I2[jI2].res
                     <<vv.Q5[ 0].I2[jI2].ins
                     << std::setw( 8)
                     <<vv.Q5[ 0].I2[jI2].sa
                     <<'\n';
         }
      }
   }
   return;
}
