#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../med/Defect_Automatic.hh"
#include "../med/Dielec_Continu.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>
#include <sstream>
#include <iomanip>
#include <cmath>

class MEM_defect_bchg {
private:
   std::vector<double> o_R0d;                   //distance from chg to surf
public:
   std::vector<Defect_Automatic::tI2> I2;       //
   MEM_defect_bchg(int o):
      o_R0d(o,(0.00))
   {
   }
   double& R0d(int i){
      return o_R0d.at( i);  }
};

void Structure::DEFECT_BCHG(Defect_Automatic& aut,
                            Dielec_Continu& mlg,
                            const DAT_PHYSICS_CONSTS& physics_consts,
                            Output_Streams& out){
   int oR0=( Z0[nZ0-1].R0a +Z0[nZ0-1].cR0);
   MEM_defect_bchg vv(oR0);
//
//
// count buried charges
//
   int nCHG=0;                  //number of charged residues
   int nBUR=0;                  //number of buried charges
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         char c1=R0[iR0].c1;
         std::string aa=R0[iR0].aa;
         bool CHARGED=false;
         if      ( c1=='a' ){
            if( (aa[0]=='e')||(aa[3]=='e') )CHARGED=true;
            if( (aa[0]=='e')||
                (aa[0]=='z') )aa=aa.substr(1,3)+' ';
            if( (aa[3]=='e')||
                (aa[3]=='z') )aa=aa.substr(0,3)+' ';
            if( (aa=="ASP ")||(aa=="GLU ")||(aa=="LYS ")||(aa=="ARG ")||
                (aa=="ORN ")||(aa=="HIP ")||(aa=="CYZ ")||(aa=="TYZ ")||
                (aa=="SEP ")||(aa=="THP ")||(aa=="TYP ")
                )CHARGED=true;
         }else if( c1=='e' ){
         }else if( c1=='r' ){
         }else if( c1=='b' ){
            if( (aa=="AP  ")||(aa=="GP  ")||(aa=="GM  ")||(aa=="TM  ")||
                (aa=="CP  ")||(aa=="UM  ") )CHARGED=true;
         }else if( c1=='p' ){
            if( (aa=="PO  ")||(aa=="PSR ")||(aa=="PSS ")||(aa=="5PO ")||
                (aa=="3PO ") )CHARGED=true;
         }else if( c1=='s' ){
         }
         if( !CHARGED )continue;
         nCHG++;
         vv.R0d(iR0)= (1.00e+6);
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            int iCHG=DEFECT_CHG(iR0,iP1);
            if( iCHG!=0 ){
               for(int jDOT= 0;jDOT<mlg.nDOT;jDOT++){
                  double r=( physics_consts.ANG*mlg.DOT[jDOT].x
                            -P1[iP1].x).r();
                  if( r<vv.R0d(iR0) )vv.R0d(iR0)= r;
               }
            }
         }
         if( vv.R0d(iR0)>(4.20) )nBUR++;
      }
   }
//
//
// entropy correction factor
//
   double S= (1.00);            //-TS
   double F= (0.00);            //entropy correction per buried chg
   if( nBUR>0 ){
      if( nCHG<=aut.nR0ex ){
         double z1= aut.nR0in;
         double z2= (1.00);
         double z3= (aut.nR0ex-nCHG+1);
         double z4= nCHG;
         for(int i=0;i<nBUR;i++){
            S*=((z1*z4)/(z2*z3));
            z1-=(1.00);
            z2+=(1.00);
            z3+=(1.00);
            z4-=(1.00);
         }
      }else{
         double z1= aut.nR0ex;
         double z2= (1.00);
         double z3= (nCHG-aut.nR0ex+1);
         double z4= (aut.nR0in-(nCHG-aut.nR0ex));
         int n=(nBUR-(nCHG-aut.nR0ex));
         for(int i=0;i<n;i++){
            S*=((z1*z4)/(z2*z3));
            z1-=(1.00);
            z2+=(1.00);
            z3+=(1.00);
            z4-=(1.00);
         }
      }
      S= -physics_consts.ekT*std::log( S);
      F= (S/nBUR);
   }
//
//
// partition buried charges into paired+solvated+isolated
//
   std::string rec="ATOM      1  B03 DOT     1       0.000   0.000   0.000";
   int nI2=0;
   int pI2=0;
   int sI2=0;
   int bI2=0;
   int iA5=-1;
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         bool BURIED=( vv.R0d(iR0)>(4.20) )? true: false;
         bool PAIRED=false;
         bool SOLVATED=false;
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            iA5++;
            if( !BURIED )continue;
            int iCHG=DEFECT_CHG(iR0,iP1);
            if( iCHG==0 )continue;

            for(int jZ0=0;jZ0<nZ0;jZ0++){
               int aR0=Z0[jZ0].R0a;
               int bR0=(aR0-1+Z0[jZ0].cR0);
               for(int jR0=aR0;jR0<=bR0;jR0++){
                  if( jR0==iR0 )continue;
                  if( vv.R0d(jR0)<(.10) )continue;
                  int aP1=R0[jR0].P1a;
                  int bP1=(aP1-1+R0[jR0].cP1);
                  for(int jP1=aP1;jP1<=bP1;jP1++){
                     if( P1[jP1].sub==0 )continue;
                     int jT2=P1[jP1].typ;
                     if( (jT2== 0)||(jT2== 3) )continue;
                     int jCHG=DEFECT_CHG(jR0,jP1);
                     if( jCHG==0 )continue;
                     if( (jCHG*iCHG)==-1 ){
                        double r=( P1[jP1].x -P1[iP1].x).r();
                        if( r<(4.00) )PAIRED=true;
                     }
                  }
               }
            }

            if( aut.A5[iA5].exsa>(.25) )SOLVATED=true;
         }
         if( !BURIED )continue;
         vv.I2.push_back( Defect_Automatic::tI2());
         vv.I2[nI2].d= vv.R0d(iR0);
         vv.I2[nI2].cha=R0[iR0].cha;
         vv.I2[nI2].res=R0[iR0].res;
         vv.I2[nI2].ins=R0[iR0].ins;
         vv.I2[nI2].aa=R0[iR0].aa;
         if( PAIRED ){
            aut.R0[iR0].e[ 5]+=( (4.00) +F);
            vv.I2[nI2].typ='p';
            pI2++;
         }else if( SOLVATED ){
            aut.R0[iR0].e[ 5]+=( (6.00) +F);
            vv.I2[nI2].typ='s';
            sI2++;
         }else{
            aut.R0[iR0].e[ 5]+=( (12.0) +F);
            vv.I2[nI2].typ='b';
            bI2++;
         }
         nI2++;
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            int iCHG=DEFECT_CHG(iR0,iP1);
            if( iCHG==0 )continue;
            std::ostringstream oi;
            oi<<P1[iP1].x;
            aut.I2.push_back( Defect_Automatic::tI2());
            aut.I2[aut.nI2].cha=R0[iR0].cha;
            aut.I2[aut.nI2].res=R0[iR0].res;
            aut.I2[aut.nI2].ins=R0[iR0].ins;
            aut.I2[aut.nI2].aa=R0[iR0].aa;
            rec[21]=R0[iR0].cha;
            rec.replace(30,24,oi.str());
            if      ( iCHG== 1 ){
               rec.replace(12, 4," B03");
            }else if( iCHG!=-1 ){
               rec.replace(12, 4," B04");
            }
            aut.I2[aut.nI2++].rec=rec;
            break;
         }
      }
   }
//
//
// diffuse defect energy to contacting residues
//
   for(int iZ0=0;iZ0<nZ0;iZ0++){
      bool POLYPEPTIDE=(aut.Z0[iZ0].c1=='a');
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( vv.R0d(iR0)<=(4.20) )continue;
         double z= (aut.R0[iR0].e[ 5]/(8.00));
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int jZ0=0;jZ0<nZ0;jZ0++){
            int aR0=Z0[jZ0].R0a;
            int bR0=(aR0-1+Z0[jZ0].cR0);
            for(int jR0=aR0;jR0<=bR0;jR0++){
               if( jR0==iR0 )continue;
               int aP1=R0[jR0].P1a;
               int bP1=(aP1-1+R0[jR0].cP1);
               if( (jZ0==iZ0)&&
                  ((jR0==(iR0-1))||(jR0==(iR0+1)))&&
                  POLYPEPTIDE ){
                  aP1+=7;
                  char c1=R0[jR0].c1;
                  std::string aa=R0[jR0].aa;
                  if( c1=='a' ){
                     if( (aa[0]=='e')||
                         (aa[0]=='z') )aa=aa.substr(1,3)+' ';
                     if( (aa[3]=='e')||
                         (aa[3]=='z') )aa=aa.substr(0,3)+' ';
                  }
                  if( (aa=="PRO ")||(aa=="HPR ") )aP1--;
               }

               bool HIT=false;
               for(int iP1=mP1;iP1<=nP1&&(!HIT);iP1++){
                  if( P1[iP1].sub==0 )continue;
                  int iCHG=DEFECT_CHG(iR0,iP1);
                  if( iCHG==0 )continue;
                  for(int jP1=aP1;jP1<=bP1&&(!HIT);jP1++){
                     if( P1[jP1].sub==0 )continue;
                     double r=( P1[jP1].x -P1[iP1].x).r();
                     if( r<(4.00) ){
                        aut.R0[iR0].e[ 5]-=z;
                        aut.R0[jR0].e[ 5]+=z;
                        HIT=true;
                     }
                  }
               }

            }
         }
      }
   }
//
//
// diagnostic output
//
   if( out.VERBOSE ){
      out.FILE3<<"BURIED CHARGE"<< std::endl;
      out.FILE3<< std::fixed;
      out.FILE3<<"Number of Buried Charges="
               << std::setw( 3)<<bI2<<'\n';
      for(int iI2= 0;iI2<nI2;iI2++){
         if( vv.I2[iI2].typ!='b' )continue;
         out.FILE3<< std::setprecision( 2)<< std::setw( 7)<<vv.I2[iI2].d<<' '
                  <<vv.I2[iI2].aa
                  <<vv.I2[iI2].cha
                  << std::setw( 4)<<vv.I2[iI2].res
                  <<vv.I2[iI2].ins<<'\n';
      }
      out.FILE3<<"Number of Buried Paired Charges="
               << std::setw( 3)<<pI2<<'\n';
      for(int iI2= 0;iI2<nI2;iI2++){
         if( vv.I2[iI2].typ!='p' )continue;
         out.FILE3<< std::setprecision( 2)<< std::setw( 7)<<vv.I2[iI2].d<<' '
                  <<vv.I2[iI2].aa
                  <<vv.I2[iI2].cha
                  << std::setw( 4)<<vv.I2[iI2].res
                  <<vv.I2[iI2].ins<<'\n';
      }
      out.FILE3<<"Number of Buried Solvated Charges="
               << std::setw( 3)<<sI2<<'\n';
      for(int iI2= 0;iI2<nI2;iI2++){
         if( vv.I2[iI2].typ!='s' )continue;
         out.FILE3<< std::setprecision( 2)<< std::setw( 7)<<vv.I2[iI2].d<<' '
                  <<vv.I2[iI2].aa
                  <<vv.I2[iI2].cha
                  << std::setw( 4)<<vv.I2[iI2].res
                  <<vv.I2[iI2].ins<<'\n';
      }
      out.FILE3<<" nCHG="<< std::setw( 4)<<nCHG
               <<" nBUR="<< std::setw( 4)<<nBUR<<'\n';
//    out.FILE3<<"Entropy Contribution to Free Energy of Folding="
//             << std::setprecision( 3)<< std::setw( 8)<<S<<'\n';
//    out.FILE3<<"Entropy Contribution Per Buried Charge="
//             << std::setprecision( 3)<< std::setw( 8)<<F<<'\n';
   }
   return;
}
