#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../med/Defect_Automatic.hh"
#include "../med/Dielec_Continu.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <iomanip>

void Structure::DEFECT(const DAT_PHYSICS_CONSTS& physics_consts,
                       const DAT_ARRAY_CONSTS& array_consts,
                       const DAT_ENERGY_PARAMS& energy_params,
                       const DAT_RESIDUE_MAPPINGS& residue_mappings,
                       const DAT_REGION_MAPS& region_maps,
                       const DAT_IGOR_DATA& igor_data,
                       Thread_Options& opt,
                       Output_Streams& out){

   int oZ0=nZ0;
   int oR0=(Z0[oZ0-1].R0a+Z0[oZ0-1].cR0);
   int oA5=0;
   for(int iZ0=0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int mP1=R0[iR0].P1a;
         int nP1=(mP1-1+R0[iR0].cP1);
         for(int iP1=mP1;iP1<=nP1;iP1++){
            if( P1[iP1].sub==0 )continue;
            int iT2=P1[iP1].typ;
            if( (iT2== 0)||(iT2== 3) )continue;
            oA5++;
         }
      }
   }
   Defect_Automatic aut(oZ0,oR0,oA5);
   Dielec_Continu mlg( 1, 1,oA5,oR0);
   Dielec_Continu med( 1, 1,oA5,oR0);

   for(int iZ0=0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
//    int nR0=(mR0-1+Z0[iZ0].cR0);
      char c1=R0[mR0].c1;
      if      ( (c1=='a')||
                (c1=='e') ){
         aut.Z0[iZ0].c1='a';
      }else if( (c1=='r')||
                (c1=='b')||
                (c1=='p') ){
         aut.Z0[iZ0].c1='p';
      }else if( (c1=='s') ){
         aut.Z0[iZ0].c1='s';
      }
   }
   for(int iZ0=0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         aut.R0[iR0].coil=1;
         aut.R0[iR0].expo=0;
         for(int i= 0;i<16;i++){
            aut.R0[iR0].e[i]= (0.00);
         }
         aut.R0[iR0].bbcnf="  ";
         aut.R0[iR0].sccnf=' ';
      }
   }

   aut.nI2=0;
   DEFECT_OLP(aut,out);
   DEFECT_CNF(aut,residue_mappings,region_maps,out);
   DEFECT_CAV(aut,mlg,med,
              physics_consts,array_consts,energy_params,residue_mappings,
              out);
   DEFECT_BCHG(aut,mlg,physics_consts,out);
   DEFECT_HBND(aut,physics_consts,out);

   for(int iZ0=0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         if( aut.R0[iR0].coil==1 )continue;
         std::string cnf=aut.R0[iR0].bbcnf;
         int L=-1;
         if      ( (cnf=="A ")||(cnf=="B ") ){
            L=5;
         }else if( (cnf[0]=='E')||(cnf[0]=='F')||(cnf[0]=='D') ){
            L=3;
         }
         bool SSELEM=false;
         for(int iTER=-L;iTER<= 0;iTER++){
            int aR0=(iR0+iTER);
            int bR0=(aR0+L);
            if( (aR0<mR0)||(bR0>nR0) )continue;
            int ii=0;
            for(int jR0=aR0;jR0<=bR0;jR0++){
               ii+=aut.R0[jR0].coil;
            }
            if( ii<=1 )SSELEM=true;
         }
         if( !SSELEM )aut.R0[iR0].coil=1;
      }
   }

   DEFECT_SSP(aut,physics_consts,array_consts,residue_mappings,igor_data,
              opt,out);
   DEFECT_CON(aut,physics_consts,residue_mappings,out);

   for(int iZ0=0;iZ0<oZ0;iZ0++){
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         aut.R0[iR0].loop= aut.R0[iR0].coil*aut.R0[iR0].expo;
         aut.R0[iR0].e[ 0]= aut.R0[iR0].e[ 1]
                           +aut.R0[iR0].e[ 2]
                           +aut.R0[iR0].e[ 3]
                           +aut.R0[iR0].e[ 4]
                           +aut.R0[iR0].e[ 5]
                           +aut.R0[iR0].e[ 6]
                           +aut.R0[iR0].e[ 7]
                           +aut.R0[iR0].e[ 8]
                           +aut.R0[iR0].e[ 9]
                           +aut.R0[iR0].e[10]
                           +aut.R0[iR0].e[11]
                           +aut.R0[iR0].e[12];
//       aut.R0[iR0].e[ 0]*=aut.R0[iR0].loop;
         aut.R0[iR0].h[ 0]= aut.R0[iR0].h[ 1];
      }
   }
//
//
// compact analysis of defect energy
//

   std::string filename="../../"+fam+"/car/dprof."+mol+'.'+cnf;
   std::ofstream ofile(filename.c_str());
   ofile<< std::fixed<< std::setprecision( 2);
//Residue..................Overlap............................Unpaired Hbond Acceptor...........
//|.........bb Conformation.....Disallowed (phi,psi)..........|....Exposed Hydrophobic Surface..
//|.........|.sc Conformation...|....Disallowed omega.........|....|....Secondary Structure.....
//|.........|.|.Total Energy....|....|....Disallowed chi......|....|....|....Statistical Contact
//|.........|.|.|......isCoil...|....|....|....Buried Charge..|....|....|....|....Electrostatic.
//|.........|.|.|......|isExposed....|....|....|....Cavity....|....|....|....|....|.............
//|.........|.|.|......||isLoop.|....|....|....|....|....Unpaired Hbond Donor|....|.............
//|.........|.|.|......|||.|....|....|....|....|....|....|....|....|....|....|....|.............

   ofile<<"Residue..................Overlap.................."
          "..........Unpaired Hbond Acceptor...........\n";
   ofile<<"|.........bb Conformation.....Disallowed (phi,psi)"
          "..........|....Exposed Hydrophobic Surface..\n";
   ofile<<"|.........|.sc Conformation...|....Disallowed omeg"
          "a.........|....|....Secondary Structure.....\n";
   ofile<<"|.........|.|.Total Energy....|....|....Disallowed"
          " chi......|....|....|....Statistical Contact\n";
   ofile<<"|.........|.|.|......isCoil...|....|....|....Burie"
          "d Charge..|....|....|....|....Electrostatic.\n";
   ofile<<"|.........|.|.|......|isExposed....|....|....|...."
          "Cavity....|....|....|....|....|.............\n";
   ofile<<"|.........|.|.|......||isLoop.|....|....|....|...."
          "|....Unpaired Hbond Donor|....|.............\n";
   ofile<<"|.........|.|.|......|||.|....|....|....|....|...."
          "|....|....|....|....|....|....|.............\n";

   for(int iZ0=0;iZ0<oZ0;iZ0++){
      ofile<<"________________________________________"
             "________________________________________"
             "_____\n";
      int mR0=Z0[iZ0].R0a;
      int nR0=(mR0-1+Z0[iZ0].cR0);
      for(int iR0=mR0;iR0<=nR0;iR0++){
         std::string aa=R0[iR0].aa;
         char cha=R0[iR0].cha;
         int res=R0[iR0].res;
         char ins=R0[iR0].ins;
         std::string bbcnf=aut.R0[iR0].bbcnf;
         char sccnf=aut.R0[iR0].sccnf;
         int coil=aut.R0[iR0].coil;
         int expo=aut.R0[iR0].expo;
         int loop=aut.R0[iR0].loop;
         ofile<<aa
              <<cha
              << std::setw( 4)<<res
              <<ins
              <<bbcnf
              <<sccnf<<' '
              << std::setw( 6)<<aut.R0[iR0].e[ 0]<<' '
              << std::setw( 1)<<coil
              << std::setw( 1)<<expo
              << std::setw( 1)<<loop<<' ';
         ofile<< std::setprecision( 1);
         for(int i= 1;i<13;i++){
            ofile<< std::setw( 5)<<aut.R0[iR0].e[ i];
         }
         ofile<<'\n';
         ofile<< std::setprecision( 2);
      }
   }
   ofile<<"________________________________________"
          "________________________________________"
          "_____\n";
   ofile.close();
//
//
// output dot visualization of defects
//
// filename="../../"+fam+"/dgn/defects."+mol+'.'+cnf+".pdb";
// std::ofstream ofile(filename.c_str());
// ofile<< std::fixed<< std::setprecision( 3);
// int i=0;
// for(int iZ0=0;iZ0<oZ0;iZ0++){
//    int mR0=Z0[iZ0].R0a;
//    int nR0=(mR0-1+Z0[iZ0].cR0);
//    for(int iR0=mR0;iR0<=nR0;iR0++){
//       char c1=R0[iR0].c1;
//       std::string aa=R0[iR0].aa;
//       if( c1=='a' ){
//          if( (aa[0]=='e')||
//              (aa[0]=='z') )aa=aa.substr(1,3)+' ';
//          if( (aa[3]=='e')||
//              (aa[3]=='z') )aa=aa.substr(0,3)+' ';
//       }
//       char cha=R0[iR0].cha;
//       int res=R0[iR0].res;
//       char ins=R0[iR0].ins;
//       int mP1=R0[iR0].P1a;
//       int nP1=(mP1-1+R0[iR0].cP1);
//       for(int iP1=mP1;iP1<=nP1;iP1++){
//          std::string atm=P1[iP1].atm;
//          int iT2=P1[iP1].typ;
//          if( (aa=="CYH ")&&(atm==" HG ") )iT2= 5;
//          if( (iT2== 0)||(iT2== 3) )continue;
//          if( P1[iP1].sub==0 ){
//             std::cerr<<"ERROR: Missing atom in PDB file."
//                      <<" mol="<<mol
//                      <<" iZ0="<< std::setw( 2)<<iZ0
//                      <<" iR0="<< std::setw( 4)<<iR0
//                      <<" aa="<<aa
//                      <<" atm="<<atm<<".\n";
//             std::exit( 1);
//          }
//          ofile<<"ATOM  "
//               << std::setw( 5)<<i<<' '
//               <<atm<<' '
//               <<aa.substr(0,3)<<' '
//               <<cha
//               << std::setw( 4)<<res
//               <<ins<<"   ";
//          for(int j=0;j<3;j++){
//             ofile<< std::setw( 8)<<P1[iP1].x(j);
//          }
//          ofile<<'\n';
//          i++;
//       }
//    }
// }
// if( aut.nI2>0 ){
//    for(int iI2= 0;iI2<aut.nI2;iI2++){
//       std::ostringstream oi;
//       oi<<i;
//       aut.I2[iI2].rec.replace( 6, 5,oi.str());
//       aut.I2[iI2].rec.replace(22, 4,oi.str());
//       i++;
//       ofile<<aut.I2[iI2].rec;
//    }
// }
// ofile<<"TER\n";
// ofile.close();
//
//
// create step focused on defects
//
   bool PROTEINCHAIN=false;
   for(int iZ0=0;iZ0<oZ0;iZ0++){
      if( aut.Z0[iZ0].c1=='a' ){
         PROTEINCHAIN=true;
      }
   }
   if( PROTEINCHAIN ){
   if( opt.MODE=="   " ){
      DEFECT_STP(aut,residue_mappings);
   }
   }
   return;
}
