#ifndef DEF_DIELEC_CONTINU
#define DEF_DIELEC_CONTINU

#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../fil/Structure.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Phi_Automatic.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include <string>
#include <vector>

class Dielec_Continu {
public:
   class tA5 { /*physical atoms in system of molecules*/
   public:
      class tA5I5 { /*atoms within probe diameter of central atom*/
      public:
         int A5;                //mapping to atoms
         int B5;                //mapping to tori
         tA5I5():B5(-1){}
      };
      class tA5Z5 { /*convex edges on an atom*/
      public:
         int E6;                //index of convex edge
         tA5Z5(){}
      };
      class tA5Y6 { /*cycles on an atom*/
      public:
         class tA5Y6Z6 { /*convex edges in a cycle*/
         public:
            int E6;             //index of convex edge
            Coordinates c;      //unit vector normal to convex edge
            double del;         //distance to atom center
            tA5Y6Z6(){}
         };
      public:
         int nZ6;                   //number
         std::vector<tA5Y6Z6> Z6;   //convex edges in a cycle
         tA5Y6(){}
      };
      class tA5H3 { /*H-bonds to donor or acceptor*/
      public:
         int A5;                //index of H-bonded atom
         tA5H3(){}
      };
   public:
      std::string atm;          //4 char name
      int lte;                  //maximum L of multipoles
      int typ;                  //type
      Coordinates x;            //coords (bohr)
      Multipoles q;             //multipoles
      double r;                 //radius (bohr)
      bool CHG;                 //ionized
      int R0;                   //index of residue
      int N2;                   //ionizable group within res, {0,1}={bb,sc}
      std::string aa;           //4 char residue name
      int sgn;                  //magnitude of full chg
      bool bur;                 //buried relative to molecular surface
      int F2;                   //site st dot motion is equivalent
      int Q2;                   //forward group st dot motion is equivalent
      int A5;                   //equivalent sphere
      int cI5;                  //number within probe diameter of central atom
      int bse_cI5;              //number in non-deformable base
      std::vector<tA5I5> I5;    //atoms within probe diameter of central atom
      bool free;                //no tori
      bool bse_free;            //no tori to atoms in non-deformable base
      int nZ5;                  //number of convex edges on atom
      std::vector<tA5Z5> Z5;    //convex edges on an atom
      int nY6;                  //number
      std::vector<tA5Y6> Y6;    //cycles on atom
      double sa;                //surface area (bohr**2)
      Coordinates u;            //unit vector to optimal hydration site
      int nH3;                  //number of H-bonds
      std::vector<tA5H3> H3;    //index of H-bonded atom
      double facuh;             //mod of buried Fuh for hydration or chg
      tA5(){}
      void MED_MOL_CHG(const DAT_PHYSICS_CONSTS& physics_consts,
                       char c1,
                       std::string& aa,
                       std::string& atm);
   };
   class tB5 { /*atom pairs within 1 probe diameter supporting torus*/
   public:
      class tB5X5 { /*concave edges on a torus*/
      public:
         int E5;                //index of concave edge
         double the;            //angle of concave edge about torus
         tB5X5(){}
      };
   public:
      int N2A5[2];                  //pair of atoms [i,j]
      Coordinates c;                //unit vector from lower to higher index
      Coordinates x;                //coords of center of torus (bohr)
      double r;                     //radius of torus (bohr)
      int nX5;                      //number of concave edges on a torus
      int bse_nX5;                  //number in non-deformable base
      std::vector<tB5X5> X5;        //concave edges on a torus
      std::vector<tB5X5> bse_X5;    //concave edges in non-deformable base
      bool free;                    //no probe fixed positions
      bool bse_free;                //no probe fixed positions within base
      bool circ;                    //contributes circles
      int N2H5[2];                  //pair of circles
      double sa;                    //surface area (bohr**2)
      tB5(){}
   };
   class tC5 { /*atom triples supporting probe fixed position*/
   public:
      int N3A5[3];              //triple of atoms [i,j,k]
      int N3B5[3];              //triple of tori [ij,jk,ik]
      Coordinates c;            //unit vector normal to [i,j,k] plane
      Coordinates e;            //unit vector c cross unit vector along [i,j]
//    Coordinates b;            //coords of base in [i,j,k] plane (bohr)
      double h;                 //height above plane of probe position (bohr)
      Coordinates x;            //coords of probe position (bohr)
      bool sub;                 //probe position not excluded
      tC5(){}
   };
   class tE5 { /*concave edges*/
   public:
      int N2V5[2];              //pair of vertices
      Coordinates c;            //unit vector normal to plane of edge
      int F5;                   //adjacent face
      int F6;                   //adjacent face
      tE5(){}
   };
   class tH5 { /*circles*/
   public:
      int B5;                   //index of torus
      int A5;                   //index of atom
      Coordinates x;            //coordinates of circle center (bohr)
      Coordinates c;            //unit vector normal to circle
      double r;                 //radius of circle (bohr)
      double del;               //distance from atom center to circle center
      double the;               //angle from probe center to vertex (radian)
      tH5(){}
   };
   class tV5 { /*vertices*/
   public:
      int A5;                   //index of atom
      int C5;                   //index of probe fixed position
      Coordinates x;            //coords of vertex (bohr)
      double alp;               //angle on sphere between convex edges (radian)
      double bet;               //angle between concave edge planes (radian)
      tV5(){}
   };
   class tE6 { /*convex edges*/
   public:
      int N2V5[2];              //pair of vertices
      int H5;                   //index of circle
      double phi;               //circular arc (radian)
      int jA5;                  //atom of torus
      int F6;                   //adjacent face
      int F7;                   //adjacent face
      tE6(){}
   };
   class tF5 { /*concave faces*/
   public:
      int N3E5[3];              //triple of concave edges
      bool CUSP;                //potential cusp
      double sa;                //surface area (bohr**2)
      tF5(){}
   };
   class tF6 { /*saddle faces*/
   public:
      int N2E5[2];              //pair of concave edges
      int N2E6[2];              //pair of convex edges
      bool CUSP;                //potential cusp
      double sa;                //surface area (bohr**2)
      tF6(){}
   };
   class tF7 { /*convex faces*/
   public:
      class tF7X6 { /*cycles bounding a convex face*/
      public:
         int Y6;                //index of cycle
         tF7X6(){}
      };
   public:
      int A5;                   //index of atom
      int nX6;                  //number of cycles bounding a convex face
      std::vector<tF7X6> X6;    //cycles bounding a convex face
      double sa;                //surface area (bohr**2)
      tF7(){}
   };
   class tL6 { /*edge bounding a fragment of surface on a sphere or torus*/
   public:
      Coordinates v;            //start vertex of edge (bohr)
      Coordinates c;            //normal to edge plane
      double del;               //distance from atom center to edge plane (bohr)
      double phi;               //circular arc (radian)
      double the;               //angle from probe center to vertex (radian)
      double bet;               //pi minus angle between edges (radian)
      int jA5;                  //neighbor atom
      tL6(){}
      tL6& operator=(const tL6& o);
   };
   class tK6 { /*cycle of edges bounding a fragment of surface*/
   public:
      std::vector<tL6> L6;      //edges
      tK6(){}
   };
   class tDOT { /*high density surface element of a sphere or torus*/
   public:
      Coordinates x;            //coords of representative dot (bohr)
      Coordinates c;            //normal to surface
      double r;                 //radius of sphere or torus (bohr)
      std::vector<tK6> K6;      //cycles of edges
      double a;                 //area (bohr**2)
      int grp;                  //index of low density surface elem
      int typ;                  //{-1=concave, 0=saddle, 1=convex}
      int elm;                  //index of probe position, torus, or atom
      bool TILE;                //surface triangle not intersected
      int D5;                   //index of low density surface elem
      int G5;                   //map to bin in 3D grid
      bool HIT;                 //distance to another dot < (.1)probe
      Multipoles n;             //surface normal
      int bse;                  //mapping to non-deformable base
      double qn;                //f*(-A5q,DOT[ja]n)
      double chg;               //D5[i]sig*DOT[ia]a
      double qe;                //( A5q,DOT[ja]e)
      tDOT():n( 1){}
      tDOT& operator=(const tDOT& o);
      bool MED_DOTROT(const Rotation_Matrix& ROT,
                      double h);
      bool MED_CDOTSEC(const DAT_PHYSICS_CONSTS& physics_consts,
                       const Coordinates& m);
      bool MED_BDOTSEC(double probe,
                       const Coordinates& m,
                       double d,
                       int jA5);
      bool MED_ADOTSEC(const DAT_PHYSICS_CONSTS& physics_consts,
                       const Coordinates& m,
                       double d,
                       int jA5);
      bool MED_ADOTSEC(const DAT_PHYSICS_CONSTS& physics_consts,
                       const Coordinates& m,
                       double d);
      void MED_DOTTRANS(const Coordinates& TRANS);
   };
   class tD5 { /*low density surface element*/
   public:
      Coordinates x;            //coords (bohr)
      int DOTa;                 //start index into high density dots
      int cDOT;                 //number of high density dots
      int G5;                   //map to bin in 3D grid
      double d;                 //largest distance to high density dot
      double a;                 //sum of high density dot surface areas
      Multipoles n;             //surface normals moved to representative dot
      Multipoles e;             //surface areas moved to representative dot
      int bse;                  //mapping to non-deformable base
      double qn;                //sum_a DOT[ja]a*DOT[ja]qn
      double sig;               //surface charge density
      double qe;                //sum_a DOT[ja]a*DOT[ja]qe
      bool PO;                  //(phosphodiester, 3' phosphate, 5' phosphate)
      double fac;               //entropy resistance to medium polarization
      int Q5;                   //index of connected surface
      tD5():n(5),e(5){}
      tD5& operator=(const tD5& o);
   };
   class tG5G5G5 { /*bins of a 3D grid*/
   public:
      int i;                    //start index into set of dots
      int n;                    //number of dots in bin
      tG5G5G5(){}
   };
   class bDOT { /*high density surface element in non-deformable base*/
   public:
      Coordinates x;            //coords (bohr)
      double qn;                //f*(-A5q,DOT[ja]n)
      double qe;                //( A5q,DOT[ja]e)
      bDOT(){}
   };
   class bD5 { /*low density surface element in non-deformable base*/
   public:
      Coordinates x;            //coords (bohr)
      int G5;                   //map to bin in 3D grid
      int DOTa;                 //start index into high density dots
      int cDOT;                 //number of high density dots
      double qn;                //sum_a DOT[ja]a*DOT[ja]qn
      double qe;                //sum_a DOT[ja]a*DOT[ja]qe
      bD5(){}
   };
   class tF2 { /*atoms [backward order]*/
   public:
      int A5;                   //physical atom st dot motion is equiv
      tF2():A5(-1){}
   };
   class tQ2 { /*torsions [forward order]*/
   public:
      Rotation_Matrix c;        //rotation of forward group
      bool cut;                 //ignore forward group
      tQ2():cut(false){}
   };
   class tR0N2 { /*ionized group*/
   public:
      Coordinates x;            //mean position
      int n;                    //number of atoms in group
      double z;                 //net chg of group
      int sgn;                  //sign of chg
      double fq;                //reduction of elec field by polaization
      Coordinates d;            //net dipole induced by ionized groups
      double qd;                //correction for (fullchg,induced dipole)
      tR0N2(){}
   };
   class tR0N2R0N2 { /*pair of ionized groups*/
   public:
      double ee;                //(fullchg,fullchg) for pair of ionized groups
      tR0N2R0N2(){}
   };

private:
   std::vector<tDOT> o_FTspher;         //surf elems on a unit sphere
   std::vector<tDOT> o_FTprobe;         //surf elems on a probe sphere
   std::vector<tDOT> o_FTtorus;         //surf elems on a torus with r=1+probe
   std::vector<tG5G5G5> o_G5G5G5;       //3D grid
   std::vector<double> o_D5D5lu;        //delta[ij]*D5[j]a
                                        // -f*sum_ab DOT[ia]a
                                        // *DOT[jb]a*(DOT[jb]e,DOT[ia]n)
   std::vector<double> o_D5D5ee;        //sum_ab DOT[ib]a*DOT[ja]a
                                        // *(DOT[ib]e,DOT[ja]e)
   std::vector<double> o_D5D5ne;        // -f*sum_ab DOT[ia]a
                                        // *DOT[jb]a*(DOT[jb]e,DOT[ia]n)

   tDOT& FTspher(int i,int j){
      return o_FTspher.at( i*16 +j);
   }
   tDOT& FTprobe(int i,int j){
      return o_FTprobe.at( i*16 +j);
   }
   tDOT& FTtorus(int i,int j){
      return o_FTtorus.at( i*25 +j);
   }
   tG5G5G5& G5G5G5(int j){
      return o_G5G5G5.at(j);
   }
   double& D5D5lu(int i,int j){
      return o_D5D5lu.at( i*nD5 +j);
   }
   double& D5D5ee(int i,int j){
      return o_D5D5ee.at( i*bse_nD5 +j);
   }
   double& D5D5ne(int i,int j){
      return o_D5D5ne.at( i*bse_nD5 +j);
   }

public:
   double probe;                        //probe radius (bohr)
   std::vector<tF2> F2;                 //atoms [backward order]
   std::vector<tQ2> Q2;                 //torsions [forward order]
   int oR0;                             //n of residues
   std::vector<tR0N2> o_R0N2;           //ionized functional groups
   std::vector<tR0N2R0N2> o_R0N2R0N2;   //pairs of ionized groups
   double Fqd;                          //correction (fullchg,induced dipole)
   double Fuh;                          //penalty buried donor or acceptor
   double Fcc;                          //cleft +cavity volume
   int ENDSTATE;                        //error code for functions
   double Fps;                          //protein boundary
   double Fss;                          //boundary boundary
   int nA5;                             //number
   int bse_nA5;                         //number in non-deformable base
   std::vector<tA5> A5;                 //physical atoms
   int nB5;                             //number
   int bse_nB5;                         //number in non-deformable base
   std::vector<tB5> B5;                 //tori
   int nC5;                             //number
   int bse_nC5;                         //number in non-deformable base
   std::vector<tC5> C5;                 //fixed probe positions
   int nE5;                             //number
   int bse_nE5;                         //number in non-deformable base
   std::vector<tE5> E5;                 //concave edges
   int nH5;                             //number
   int bse_nH5;                         //number in non-deformable base
   std::vector<tH5> H5;                 //circles
   int nV5;                             //number
   int bse_nV5;                         //number in non-deformable base
   std::vector<tV5> V5;                 //vertices
   int nE6;                             //number
   std::vector<tE6> E6;                 //convex edges
   int nF5;                             //number
   int bse_nF5;                         //number in non-deformable base
   std::vector<tF5> F5;                 //concave faces
   int nF6;                             //number
   std::vector<tF6> F6;                 //saddle faces
   int nF7;                             //number
   std::vector<tF7> F7;                 //convex faces
   int nDOT;                            //number
   std::vector<tDOT> DOT;               //high density dots
   int nD5;                             //number
   std::vector<tD5> D5;                 //low density dots
   int bse_nDOT;                        //number
   std::vector<bDOT> bse_DOT;           //dots in non-deformable base
   int bse_nD5;                         //number
   std::vector<bD5> bse_D5;             //dots in non-deformable base
   int nQ5;                             //number of connected surfaces
   double Fen;                          //water entropy correction
/*QSAR properties*/
   double Qha;                          //hydrophobic surf area
   double Qpa;                          //polar surf area
   double Qps;                          //Fps
   double Qss;                          //Fss
   double Qtq;                          //total charge
   double Qfq;                          //sum of absolute charges
   double Qsol;                         //solubility

   tG5G5G5& G5G5G5(int x,int y,int z){
      return o_G5G5G5.at( 1089*(x+16) +33*(y+16) +(z+16));
   }
   const tG5G5G5& G5G5G5(int x,int y,int z) const {
      return o_G5G5G5.at( 1089*(x+16) +33*(y+16) +(z+16));
   }
   tR0N2& R0N2(int i,int j){
      int ij=( i*2 +j);
      return o_R0N2.at( ij);
   }
   tR0N2R0N2& R0N2R0N2(int i,int j,int k,int l){
      int ij=( i*2 +j);
      int kl=( k*2 +l);
      if( ij<=kl ){
         return o_R0N2R0N2.at( ij*(oR0*2) -ij*(ij+1)/2 +kl);
      }else{
         return o_R0N2R0N2.at( kl*(oR0*2) -kl*(kl+1)/2 +ij);
      }
   }

   void MED_BURIED();
   void MED_SPHERE(const DAT_PHYSICS_CONSTS& physics_consts,
                   Output_Streams& out);
   void MED_TORUS(const DAT_PHYSICS_CONSTS& physics_consts,
                  Output_Streams& out);
   void MED_MOL(Phi_Automatic& aut,
                const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ENERGY_PARAMS& energy_params,
                Output_Streams& out,
                const Mechanical_System& mol,
                const Subset_Contracted_System::tM3& con,
                Conf_Dependent_System& dep);
   void MED_SURF(const DAT_PHYSICS_CONSTS& physics_consts,
                 Output_Streams& out);
   void MED_DOT(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ARRAY_CONSTS& array_consts,
                Output_Streams& out);
   void MED_BSE(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ARRAY_CONSTS& array_consts,
                Output_Streams& out);
   void MED_SIG(const DAT_PHYSICS_CONSTS& physics_consts,
                const DAT_ARRAY_CONSTS& array_consts,
                Output_Streams& out);
   void MED_FUNC(const DAT_PHYSICS_CONSTS& physics_consts,
                 const DAT_ENERGY_PARAMS& energy_params,
                 const Structure& str,
                 Output_Streams& out);
   double MED_SWITCH(double r) const;

   Dielec_Continu(int q,int f,int a,int r):
      o_FTspher(320),
      o_FTprobe(320),
      o_FTtorus(200),
      o_G5G5G5(35937),
      F2(f),
      Q2(q),
      oR0(r),
      o_R0N2(r*2),
      o_R0N2R0N2((r*2)*(r*2+1)/2),
      A5(a)
   {
   }
};

#endif
