#ifndef DEF_DEFECT_AUTOMATIC
#define DEF_DEFECT_AUTOMATIC

#include "../phi/Coordinates.hh"
#include <string>
#include <vector>

class Defect_Automatic {
public:
   class tZ0 { /*chains in system of molecules*/
   public:
      char c1;                  //1 char class name
      tZ0(){}
   };
   class tR0 { /*residues in chains*/
   public:
      int coil;                 //not alpha or beta
      int expo;                 //exposed
      int loop;                 //not alpha or beta and exposed
      double e[16];             //components of defect energy
      std::string bbcnf;        //2 char backbone conf region
      char sccnf;               //side chain is rotamer
      std::string bbsta;        //2 char backbone state
      double h[ 4];             //components of hydration energy
      tR0(){}
   };
   class tI2 { /*pdb record at site of defect*/
   public:
      std::string rec;          //54 char
      char cha;                 //chain id
      int res;                  //residue number
      char ins;                 //insertion character
      std::string aa;           //4 char amino acid name
      char typ;                 //type of defect
      double sa;                //surface area
      double d;                 //smallest distance to surface dot
      std::string atm;          //4 char atom name
      double e;                 //defect energy
      char cigo;                //state predicted
      char cobs;                // observed
      tI2(){}
   };
   class tA5 { /*physical atoms in system of molecules*/
   public:
      int Z0;                   //index of chain
      int R0;                   //index of residue
      int P1;                   //index of atom
      double exsa;              //exposed surface area (angstrom**2)
      tA5(){}
   };
   class tR5 { /*subset of residues capable of metal binding*/
   public:
      int Z0;                   //index of chain
      int R0;                   //index of residue
      std::string aa;           //4 char amino acid name
      Coordinates x;            //coords (angstrom)
      tR5(){}
   };

public:
   std::vector<tZ0> Z0;         //set of chains
   std::vector<tR0> R0;         //set of residues
   int nI2;                     //number
   std::vector<tI2> I2;         //set of defects
   std::vector<tA5> A5;         //set of physical atoms
   int nR0tot;                  //number of total residues
   int nR0in;                   //number of buried residues
   int nR0ex;                   //number of exposed residues

   Defect_Automatic(int oZ0,int oR0,int oA5):
      Z0(oZ0),
      R0(oR0),
      A5(oA5)
   {
   }
};

#endif
