#include "../con/Subset_Contracted_System.hh"
#include "../loc/Loc.hh"
#include "../loc/Loc_Automatic.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include <cmath>

void Loc::LOC_U2(Loc_Automatic& aut,
                 const Mechanical_System& mol,
                 const Subset_Contracted_System::tM3& con,
                 const Conf_Dependent_System& dep,
                 Energy_Surface2& ene,
                 Local_Minimization2& loc){
//
//
// populate Energy_Surface2
//
   ene.nU2=0;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      if( con.Z0[iZ0].sub )ene.nU2+=6;
      ene.nU2+=con.Z0[iZ0].cQ2-1;
   }
   int iU2=0;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      if( con.Z0[iZ0].sub ){
         ene.Z0[iZ0].U2a=iU2;
         ene.U2chi(iU2  )= dep.Z0[iZ0].trans(0);
         ene.U2chi(iU2+1)= dep.Z0[iZ0].trans(1);
         ene.U2chi(iU2+2)= dep.Z0[iZ0].trans(2);
         ene.U2uca(iU2  )= (2.00);
         ene.U2uca(iU2+1)= (2.00);
         ene.U2uca(iU2+2)= (2.00);
         ene.U2chi(iU2+3)= dep.Z0[iZ0].rot(0);
         ene.U2chi(iU2+4)= dep.Z0[iZ0].rot(1);
         ene.U2chi(iU2+5)= dep.Z0[iZ0].rot(2);
         ene.U2uca(iU2+3)= (.125);
         ene.U2uca(iU2+4)= (.125);
         ene.U2uca(iU2+5)= (.125);
         iU2+=6;
      }else{
         ene.Z0[iZ0].U2a=(ene.nU2);
      }
   }
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ2>mQ2 ){
         for(int iQ2=(mQ2+1);iQ2<=nQ2;iQ2++){
            ene.Q2[iQ2].U2=iU2;
            ene.U2chi(iU2)= dep.Q2[iQ2].chi;
            ene.U2uca(iU2)=( con.Q2[iQ2].br>0 )? (.500): (.125);
            if( ene.Q2[iQ2].cut )ene.U2uca(iU2)= (0.00);
            iU2++;
         }
      }
   }
//
//
// populate Local_Minimization2
//
   loc.BETA= loc.M3BETA(loc.iM3);
   loc.BMIN= (1.00e-06);
   loc.BMAX= (0.80e-01);
   loc.BDEL= (2.00e-01);
   loc.EPS1= (1.00e-03);
   loc.EPS2= (1.00e-02);
   loc.nM2=( aut.nCYC>1 )?  32: 256;
   loc.BETA= std::sqrt( ene.nU2)*loc.BETA;
   loc.BMIN= std::sqrt( ene.nU2)*loc.BMIN;
   loc.BMAX= std::sqrt( ene.nU2)*loc.BMAX;
   loc.EPS1= ene.nU2*(loc.EPS1*loc.EPS1);
   return;
}
