#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../loc/Loc.hh"
#include "../loc/Loc_Automatic.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include <string>
#include <vector>
#include <cstdlib>
#include <cmath>

class MEM_loc_q2 {
private:
   std::vector<int> o_J1J2;             //
public:
   MEM_loc_q2(int o):
      o_J1J2(o)
   {
   }
   int& J1J2(int i){
      return o_J1J2.at( i);  }
};

void Loc::LOC_Q2(Loc_Automatic& aut,
                 const DAT_ARRAY_CONSTS& array_consts,
                 const DAT_ENERGY_PARAMS& energy_params,
                 const Mechanical_System& mol,
                 const Subset_Contracted_System::tM3& con,
                 Conf_Dependent_System& dep,
                 Energy_Surface2& ene){
   int oJ1=mol.J1.size();
   MEM_loc_q2 vv(oJ1);
   int oZ0=mol.nZ0;
//
//
// populate Conf_Dependent_System, 1st pass
//
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ1=mol.Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
      int mQ2=con.Z0[iZ0].Q2a;
//    int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      if( nQ1>mQ1 ){
         int iQ2=mQ2;
         for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
            if( con.Q1[iQ1].sub ){
               dep.Q2[++iQ2].chi= dep.Q1[iQ1].chi;
            }
         }
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      for(int iQ2=mQ2;iQ2<=nQ2;iQ2++){
         ene.Q2[iQ2].cut=false;
      }
   }
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mB1=mol.Z0[iZ0].B1a;
      int nB1=(mB1-1+mol.Z0[iZ0].cB1);
      for(int iB1=mB1;iB1<=nB1;iB1++){
         aut.F1[mol.B1[iB1].F1].x=mol.B1[iB1].x;
      }
      int mQ1=mol.Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
      for(int iQ1=mQ1;iQ1<=nQ1;iQ1++){
         aut.Q1[iQ1].tu=mol.Q1[iQ1].tu;
      }
      int mF1=mol.Z0[iZ0].F1a;
      int nF1=(mF1-1+mol.Z0[iZ0].cF1);
      for(int iF1=mF1;iF1<=nF1;iF1++){
         aut.F1[iF1].q=mol.F1[iF1].q;
      }
   }
   int mGEN=0;
   int mJ2=0;
   int mY2=0;
   for(int iZ0= 0;iZ0<oZ0;iZ0++){
      int mQ1=mol.Z0[iZ0].Q1a;
      int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
      int mQ2=con.Z0[iZ0].Q2a;
      int nQ2=(mQ2-1+con.Z0[iZ0].cQ2);
      aut.Q2[mQ2].Q1=mQ1;
      aut.Q1[mQ1].Q2=mQ2;
      if( nQ1>mQ1 ){
         int iQ2=mQ2;
         for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
            if( con.Q1[iQ1].sub ){
               iQ2++;
               aut.Q2[iQ2].Q1=iQ1;
               aut.Q1[iQ1].Q2=iQ2;
               dep.Q2[iQ2].tu=mol.Q1[iQ1].tu;
               int jQ1=mol.Q1[iQ1].jnt;
               if( !con.Q1[jQ1].sub ){
                  dep.Q2[iQ2].tu=aut.Q1[jQ1].tu*dep.Q2[iQ2].tu;
               }
               int mG1=mol.Q1[iQ1].G1a;
               int nG1=(mG1-1+mol.Q1[iQ1].cG1);
               for(int iG1=mG1;iG1<=nG1;iG1++){
                  aut.G1[iG1].b=mol.G1[iG1].b;
                  aut.F1[mol.G1[iG1].F1].x=mol.G1[iG1].b;
               }
               dep.Q2[iQ2].tau=mol.Q1[iQ1].tau;
            }else{
               aut.Q1[iQ1].tu.extend(dep.Q1[iQ1].chi);
               int jQ1=mol.Q1[iQ1].jnt;
               if( !con.Q1[jQ1].sub ){
                  aut.Q1[iQ1].tu=aut.Q1[jQ1].tu*aut.Q1[iQ1].tu;
               }
               int jQ2=aut.Q1[jQ1].Q2;
               aut.Q1[iQ1].Q2=jQ2;
               int mG1=mol.Q1[iQ1].G1a;
               int nG1=(mG1-1+mol.Q1[iQ1].cG1);
               for(int iG1=mG1;iG1<=nG1;iG1++){
                  aut.F1[mol.G1[iG1].F1].x.generate(aut.F1[mol.Q1[iQ1].bse].x,
                                                    aut.Q1[iQ1].tu,
                                                    mol.G1[iG1].b);
               }
               if( jQ2==mQ2 ){
               }else{
                  for(int iG1=mG1;iG1<=nG1;iG1++){
                     aut.G1[iG1].b=aut.F1[mol.G1[iG1].F1].x;
                  }
               }
               for(int iG1=mG1;iG1<=nG1;iG1++){
                  int iF1=mol.G1[iG1].F1;
                  if( mol.F1[iF1].lte<1 )continue;
                  aut.F1[iF1].q.rotate(array_consts,aut.Q1[iQ1].tu);
               }
            }
         }
      }
      aut.Z0[iZ0].GENa=mGEN;
      int iGEN=(mGEN-1);
      if( nQ1>mQ1 ){
         int iQ1=mQ1;
         int iQ1hold=(mQ1+mol.Z0[iZ0].cQ1bb);
         for(int icQ1=(nQ1-mQ1);icQ1>0;icQ1--){
            if( mol.Q1[iQ1].omg==1 ){
               int L=iQ1hold;
               iQ1hold=(iQ1+1);
               iQ1=L;
            }else{
               iQ1++;
            }
            if( aut.Q1[iQ1].Q2>mQ2 ){
               aut.GEN[++iGEN].Q1=iQ1;
            }
         }
      }
      aut.Z0[iZ0].cGEN=(iGEN-mGEN+1);
      if( nQ2>mQ2 ){
         int iORD=-1;
         int iQ2=mQ2;
         int iQ2hold=(mQ2+con.Z0[iZ0].cQ2bb);
         for(int icQ2=(nQ2-mQ2);icQ2>0;icQ2--){
            if( con.Q2[iQ2].omg==1 ){
               int L=iQ2hold;
               iQ2hold=(iQ2+1);
               iQ2=L;
            }else{
               iQ2++;
            }
            aut.Q2[iQ2].ORD=++iORD;
         }
      }
      int nGEN=(mGEN-1+aut.Z0[iZ0].cGEN);
      if( nGEN>mGEN ){
         int iGENmin=(mGEN+1);
         for(int iGENmax=nGEN;iGENmax>mGEN;iGENmax--){
            bool ORDERED=true;
            int iORD=aut.Q2[aut.Q1[aut.GEN[mGEN].Q1].Q2].ORD;
            for(int iGEN=iGENmin;iGEN<=iGENmax;iGEN++){
               int jORD=aut.Q2[aut.Q1[aut.GEN[iGEN].Q1].Q2].ORD;
               if( jORD<iORD ){
                  int L=aut.GEN[iGEN].Q1;
                  aut.GEN[iGEN].Q1=aut.GEN[iGEN-1].Q1;
                  aut.GEN[iGEN-1].Q1=L;
                  ORDERED=false;
               }else{
                  iORD=jORD;
               }
            }
            if( ORDERED )break;
         }
      }
      int iG2=(con.Z0[iZ0].G2a-1);
      if( nGEN>=mGEN ){
         for(int iGEN=mGEN;iGEN<=nGEN;iGEN++){
            int iQ1=aut.GEN[iGEN].Q1;
            int mG1=mol.Q1[iQ1].G1a;
            int nG1=(mG1-1+mol.Q1[iQ1].cG1);
            for(int iG1=mG1;iG1<=nG1;iG1++){
               dep.G2[++iG2].b=aut.G1[iG1].b;
            }
         }
      }
      mGEN=(nGEN+1);
      int mJ1=mol.Z0[iZ0].J1a;
      int nJ1=(mJ1-1+mol.Z0[iZ0].cJ1);
      if( nJ1>=mJ1 ){
         int iJ2=mJ2;
         for(int iJ1=mJ1;iJ1<=nJ1;iJ1++){
            vv.J1J2(iJ1)=-1;
            int iQ1=mol.J1N2Q1(iJ1,0);
            int jQ1=mol.J1N2Q1(iJ1,1);
            if( con.Q1[iQ1].sub ){
               int iQ2=aut.Q1[iQ1].Q2;
               if( con.Q1[jQ1].sub ){
                  int jQ2=aut.Q1[jQ1].Q2;
                  vv.J1J2(iJ1)=iJ2;
                  dep.J2N2Q2(iJ2,0)=iQ2;
                  dep.J2N2Q2(iJ2,1)=jQ2;
                  dep.J2[iJ2++].tau=mol.J1[iJ1].tau;
               }else{
                  dep.Q2[iQ2].tau.fix2(mol.J1[iJ1].tau,
                                       dep.Q1[jQ1].chi);
               }
            }else{
               if( con.Q1[jQ1].sub ){
                  int jQ2=aut.Q1[jQ1].Q2;
                  dep.Q2[jQ2].tau.fix1(mol.J1[iJ1].tau,
                                       dep.Q1[iQ1].chi);
               }else{
               }
            }
         }
         mJ2=iJ2;
      }
      int mY1=mol.Z0[iZ0].Y1a;
      int nY1=(mY1-1+mol.Z0[iZ0].cY1);
      if( nY1>=mY1 ){
         int iY2=mY2;
         for(int iY1=mY1;iY1<=nY1;iY1++){
            int iQ1=mol.Y1N3Q1(iY1,0);
            int jQ1=mol.Y1N3Q1(iY1,1);
            int kQ1=mol.Y1N3Q1(iY1,2);
            if( con.Q1[iQ1].sub ){
               int iQ2=aut.Q1[iQ1].Q2;
               if( con.Q1[jQ1].sub ){
                  int jQ2=aut.Q1[jQ1].Q2;
                  if( con.Q1[kQ1].sub ){
                     int kQ2=aut.Q1[kQ1].Q2;
                     dep.Y2N3Q2(iY2,0)=iQ2;
                     dep.Y2N3Q2(iY2,1)=jQ2;
                     dep.Y2N3Q2(iY2,2)=kQ2;
                     dep.Y2[iY2++].tau=mol.Y1[iY1].tau;
                  }else{
                     int ijJ1=mol.Y1N3J1(iY1,0);
                     int ijJ2=vv.J1J2(ijJ1);
                     dep.J2[ijJ2].tau.fix3(mol.Y1[iY1].tau,
                                           dep.Q1[kQ1].chi);
                  }
               }else{
                  if( con.Q1[kQ1].sub ){
                     int ikJ1=mol.Y1N3J1(iY1,1);
                     int ikJ2=vv.J1J2(ikJ1);
                     dep.J2[ikJ2].tau.fix2(mol.Y1[iY1].tau,
                                           dep.Q1[jQ1].chi);
                  }else{
                     dep.Q2[iQ2].tau.fix23(mol.Y1[iY1].tau,
                                           dep.Q1[jQ1].chi,
                                           dep.Q1[kQ1].chi);
                  }
               }
            }else{
               if( con.Q1[jQ1].sub ){
                  int jQ2=aut.Q1[jQ1].Q2;
                  if( con.Q1[kQ1].sub ){
                     int jkJ1=mol.Y1N3J1(iY1,2);
                     int jkJ2=vv.J1J2(jkJ1);
                     dep.J2[jkJ2].tau.fix1(mol.Y1[iY1].tau,
                                           dep.Q1[iQ1].chi);
                  }else{
                     dep.Q2[jQ2].tau.fix13(mol.Y1[iY1].tau,
                                           dep.Q1[iQ1].chi,
                                           dep.Q1[kQ1].chi);
                  }
               }else{
                  if( con.Q1[kQ1].sub ){
                     int kQ2=aut.Q1[kQ1].Q2;
                     dep.Q2[kQ2].tau.fix12(mol.Y1[iY1].tau,
                                           dep.Q1[iQ1].chi,
                                           dep.Q1[jQ1].chi);
                  }else{
                  }
               }
            }
         }
         mY2=iY2;
      }
//
//
// neutralize forward groups
//
      int nQ2bb=(mQ2-1+con.Z0[iZ0].cQ2bb);
// con.Q2[nQ2+1].jnt=mQ2
      if( nQ2>nQ2bb ){
         for(int iQ2=(nQ2bb+1);iQ2<=nQ2;iQ2++){
            if( con.Q2[iQ2+1].jnt!=iQ2 ){
               int br=con.Q2[iQ2].br;
               for(int jQ2=iQ2;con.Q2[jQ2].br==br;jQ2=con.Q2[jQ2].jnt){
                  int mG2=con.Q2[jQ2].G2a;
                  int nG2=(mG2-1+con.Q2[jQ2].cG2);
                  std::string atm='+'+mol.F1[con.Q2[jQ2].bseF1].atm.substr(1,3);
                  int jG2=-1;
                  double z=-con.Q2[jQ2].chg*((.001)/(1.12))
                                           *std::sqrt( energy_params.fac_pp);
                  for(int iG2=mG2;iG2<=nG2;iG2++){
                     int iF1=con.G2[iG2].F1;
                     if( mol.F1[iF1].lte<0 )continue;
                     z+=aut.F1[iF1].q.r(0,0);
                     if( mol.F1[iF1].atm==atm )jG2=iG2;
                  }
                  if( jG2==-1 )std::exit( 2);
                  aut.F1[con.Q2[jQ2].bseF1].q.r(0,0)+=z;
                  aut.F1[con.G2[jG2].F1].q.r(0,0)-=z;
               }
            }
         }
      }
      if( nQ2bb>mQ2 ){
         for(int iQ2=nQ2bb;iQ2>mQ2;iQ2=con.Q2[iQ2].jnt){
            int mG2=con.Q2[iQ2].G2a;
            int nG2=(mG2-1+con.Q2[iQ2].cG2);
            std::string atm='+'+mol.F1[con.Q2[iQ2].bseF1].atm.substr(1,3);
            int jG2=-1;
            double z=-con.Q2[iQ2].chg*((.001)/(1.12))
                                     *std::sqrt( energy_params.fac_pp);
            for(int iG2=mG2;iG2<=nG2;iG2++){
               int iF1=con.G2[iG2].F1;
               if( mol.F1[iF1].lte<0 )continue;
               z+=aut.F1[iF1].q.r(0,0);
               if( mol.F1[iF1].atm==atm )jG2=iG2;
            }
            if( jG2==-1 )std::exit( 2);
            aut.F1[con.Q2[iQ2].bseF1].q.r(0,0)+=z;
            aut.F1[con.G2[jG2].F1].q.r(0,0)-=z;
         }
      }
//
//
// reduce full charges of ionized groups
//
//       int mF1=mol.Z0[iZ0].F1a;
//       int nF1=(mF1-1+mol.Z0[iZ0].cF1);
//       for(int iF1=mF1;iF1<=nF1;iF1++){
//          if( !mol.F1[iF1].ion )continue;
//          aut.F1[iF1].q.r(0,0)+=mol.F1[iF1].off;
//       }
   }
   return;
}
