#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../loc/Loc.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <fstream>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_loc_numeric {
private:
   int oU2;                             //
   std::vector<double> o_U2chi;         //undisplaced conformation
   std::vector<double> o_U2del;         //coordinate displacement
   std::vector<double> o_U2g;           //analytic 1st derivative
   std::vector<double> o_U2U2a;         //analytic 2nd derivative
   std::vector<double> o_U2df;          //numeric 1st derivative
   std::vector<double> o_U2U2dg;        //numeric 2nd derivative
public:
   MEM_loc_numeric(int o):
      oU2(o),
      o_U2chi(o),
      o_U2del(o),
      o_U2g(o),
      o_U2U2a(o*o),
      o_U2df(o),
      o_U2U2dg(o*o)
   {
   }
   double& U2chi(int i){
      return o_U2chi.at( i);  }
   double& U2del(int i){
      return o_U2del.at( i);  }
   double& U2g(int i){
      return o_U2g.at( i);  }
   double& U2U2a(int i,int j){
      return o_U2U2a.at( i*oU2 +j);  }
   double& U2df(int i){
      return o_U2df.at( i);  }
   double& U2U2dg(int i,int j){
      return o_U2U2dg.at( i*oU2 +j);  }
};

void Loc::LOC_NUMERIC(const DAT_PHYSICS_CONSTS& physics_consts,
                      const DAT_ARRAY_CONSTS& array_consts,
                      const DAT_ENERGY_PARAMS& energy_params,
                      const DAT_REGION_MAPS& region_maps,
                      const Thread_Options& opt,
                      Output_Streams& out,
                      const Mechanical_System& mol,
                      const Subset_Contracted_System::tM3& con,
                      Conf_Dependent_System& dep,
                      Energy_Surface2& ene,
                      Local_Minimization2& loc){
   int oU2=ene.nU2;
   MEM_loc_numeric vv(oU2);
   for(int iU2= 0;iU2<oU2;iU2++){
      vv.U2chi(iU2)= ene.U2chi(iU2);
      vv.U2del(iU2)= (1.00e-8);
   }
   std::string filename="../../"+out.FAMILY+"/dgn/locnumeric."+opt.QSUB
                       +"."+out.PROTEIN;
   out.FILE1.open(filename.c_str());
//
//
// evaluate undisplaced analytic energy surface
//
   Phi_Automatic ph2(con);
   loc.nM2=0;
   ene.RECYCLE=false;
   loc.MOV(ph2,
           physics_consts,array_consts,energy_params,
           region_maps,
           opt,out,mol,con,dep,ene);
   double F= ene.TOT;
   for(int iU2= 0;iU2<oU2;iU2++){
      vv.U2g(iU2)= ene.U2g(iU2);
      for(int jU2=iU2;jU2<oU2;jU2++){
         vv.U2U2a(iU2,jU2)= ene.U2U2a(iU2,jU2);
         vv.U2U2a(jU2,iU2)= ene.U2U2a(iU2,jU2);
      }
   }
//
//
// evaluate numeric 1st and 2nd derivatives
//
   out.FILE1<<" iU2"<<" U2uca"<<"     U2del"
            <<"  TOT                 |"
            <<'\n';
   out.FILE1<<"                    "
            <<"  .         |         |"
            <<'\n';
   for(int iU2= 0;iU2<oU2;iU2++){
      int bU2=-1;
      for(int jZ0= 0;jZ0<con.oZ0;jZ0++){
         int jU2=ene.Z0[jZ0].U2a;
         if( (iU2==(jU2+3))||
             (iU2==(jU2+4))||
             (iU2==(jU2+5)) ){
            bU2=jU2;
         }
      }
      bool OPTIMAL=false;
      while( !OPTIMAL ){
         if( bU2>-1 ){
            double Cbet,Sbet,bet, Calp,Salp,alp, Cgam,Sgam,gam;
            alp= vv.U2chi(bU2+3);
            bet= vv.U2chi(bU2+4);
            gam= vv.U2chi(bU2+5);
            Rotation_Matrix ROT1(alp,bet,gam);
            Rotation_Matrix ROT2;
            alp= (0.00);
            bet= (0.00);
            gam= (0.00);
            if      ( iU2==(bU2+3) ){
               alp= vv.U2del(iU2);
            }else if( iU2==(bU2+4) ){
               bet= vv.U2del(iU2);
            }else if( iU2==(bU2+5) ){
               gam= vv.U2del(iU2);
            }
            Calp= std::cos( alp);
            Salp= std::sin( alp);
            Cbet= std::cos( bet);
            Sbet= std::sin( bet);
            Cgam= std::cos( gam);
            Sgam= std::sin( gam);
            ROT2(0,0)= Cbet*Cgam;
            ROT2(1,0)=-Cbet*Sgam;
            ROT2(2,0)= Sbet;
            ROT2(0,1)= Salp*Sbet*Cgam +Calp*Sgam;
            ROT2(1,1)=-Salp*Sbet*Sgam +Calp*Cgam;
            ROT2(2,1)=-Salp*Cbet;
            ROT2(0,2)=-Calp*Sbet*Cgam +Salp*Sgam;
            ROT2(1,2)= Calp*Sbet*Sgam +Salp*Cgam;
            ROT2(2,2)= Calp*Cbet;
            Rotation_Matrix ROT;
            for(int i=0;i<3;i++){
               for(int j=0;j<3;j++){
                  ROT(i,j)= ROT2(i,0)*ROT1(0,j)
                           +ROT2(i,1)*ROT1(1,j)
                           +ROT2(i,2)*ROT1(2,j);
               }
            }
            Cbet= ROT(2,2);
            Sbet= std::sqrt( (1.00) -Cbet*Cbet);
            bet= std::atan2(Sbet,Cbet);
            if( Sbet<(1.00e-12) ){
               gam= (0.00);
               if( Cbet>(0.00) ){
                  Calp= ROT(0,0);
                  Salp= ROT(0,1);
               }else{
                  Calp=-ROT(0,0);
                  Salp=-ROT(0,1);
               }
               alp= std::atan2(Salp,Calp);
            }else{
               Calp= (ROT(2,0)/Sbet);
               Salp= (ROT(2,1)/Sbet);
               alp= std::atan2(Salp,Calp);
               Cgam=-(ROT(0,2)/Sbet);
               Sgam= (ROT(1,2)/Sbet);
               gam= std::atan2(Sgam,Cgam);
            }
            ene.U2chi(bU2+3)= alp;
            ene.U2chi(bU2+4)= bet;
            ene.U2chi(bU2+5)= gam;
         }else{
            ene.U2chi(iU2)=( vv.U2chi(iU2) +vv.U2del(iU2));
         }
         ene.RECYCLE=false;
         loc.MOV(ph2,
                 physics_consts,array_consts,energy_params,
                 region_maps,
                 opt,out,mol,con,dep,ene);
         double df= std::abs(( ene.TOT -F)/F);
         if      ( (df<(1.00e-11))&&(vv.U2del(iU2)<(1.00e-5 )) ){
            vv.U2del(iU2)*=(2.00);
         }else if( (df>(1.00e-10))&&(vv.U2del(iU2)>(1.00e-10)) ){
            vv.U2del(iU2)/=(2.00);
         }else{
            OPTIMAL=true;
         }
      }
      out.FILE1<< std::setw( 4)<<iU2
               << std::fixed
               << std::setprecision( 3)<< std::setw( 6)<<ene.U2uca(iU2)
               << std::scientific
               << std::setprecision( 2)<< std::setw(10)<<vv.U2del(iU2)
               << std::setprecision(16)<< std::setw(23)<<F
               <<'\n';
      out.FILE1<<"                    "
               << std::setprecision(16)<< std::setw(23)<<ene.TOT
               <<'\n';
      vv.U2df(iU2)= ene.U2uca(iU2)*( ene.TOT -F)/vv.U2del(iU2);
      for(int jU2= 0;jU2<oU2;jU2++){
         vv.U2U2dg(iU2,jU2)= ene.U2uca(iU2)*( ene.U2g(jU2) -vv.U2g(jU2))
                                           /vv.U2del(iU2);
      }
      if( bU2>-1 ){
         ene.U2chi(bU2+3)= vv.U2chi(bU2+3);
         ene.U2chi(bU2+4)= vv.U2chi(bU2+4);
         ene.U2chi(bU2+5)= vv.U2chi(bU2+5);
      }else{
         ene.U2chi(iU2)= vv.U2chi(iU2);
      }
   }
//
//
// compare numeric 1st and 2nd derivatives with analytic
//
   out.FILE1<<" iU2"<<"           U2df        "
                    <<"            U2g       |"<<'\n';
   for(int iU2= 0;iU2<oU2;iU2++){
      double zz=( vv.U2df(iU2) -vv.U2g(iU2))/
                ( std::abs( vv.U2g(iU2)) +(1.00e-10));
/**/      if( std::abs( zz)<( 1.00e-10) )continue;
/**/      if( std::abs( vv.U2g(iU2))<( 1.00e-10) )continue;
      out.FILE1<< std::setw( 4)<<iU2
               << std::setw(23)<<vv.U2df(iU2)
               << std::setw(23)<<vv.U2g(iU2)
               << std::setw(23)<<zz<<'\n';
   }
   out.FILE1<<" iU2"<<" jU2"<<"         U2U2dg        "
                            <<"          U2U2a       |"<<'\n';
   for(int iU2= 0;iU2<oU2;iU2++){
      for(int jU2= 0;jU2<oU2;jU2++){
         double zz=( vv.U2U2dg(iU2,jU2) -vv.U2U2a(iU2,jU2))/
                   ( std::abs( vv.U2U2a(iU2,jU2)) +(1.00e-10));
/**/         if( std::abs( zz)<( 1.00e-10) )continue;
/**/         if( std::abs( vv.U2U2a(iU2,jU2))<( 1.00e-10) )continue;
         out.FILE1<< std::setw( 4)<<iU2<< std::setw( 4)<<jU2
                  << std::setw(23)<<vv.U2U2dg(iU2,jU2)
                  << std::setw(23)<<vv.U2U2a(iU2,jU2)
                  << std::setw(23)<<zz<<'\n';
      }
   }
   out.FILE1.close();
   return;
}
