#include "../con/Subset_Contracted_System.hh"
#include "../loc/Loc.hh"
#include "../loc/Loc_Automatic.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../set/Mechanical_System.hh"

void Loc::LOC_F2(const Loc_Automatic& aut,
                 const Mechanical_System& mol,
                 const Subset_Contracted_System::tM3& con,
                 Conf_Dependent_System& dep){
//
//
// populate Conf_Dependent_System, 2nd pass
//
   int iF2=-1;
   int iG3=-1;
   for(int iZ0= 0;iZ0<mol.nZ0;iZ0++){
      int mF1=mol.Z0[iZ0].F1a;
      int nF1=(mF1-1+mol.Z0[iZ0].cF1);
      for(int iF1=mF1;iF1<=nF1;iF1++){
         if( con.F1[iF1].imp==0 )continue;
         dep.F2[++iF2].x=aut.F1[iF1].x;
         dep.F2[iF2].q=aut.F1[iF1].q;
         if( con.F2[iF2].ion ){
            dep.F2[iF2].q.r(0,0)+=con.F2[iF2].off;
         }
      }
      int mG2=con.Z0[iZ0].G2a;
      int nG2=(mG2-1+con.Z0[iZ0].cG2);
      if( nG2>=mG2 ){
         for(int iG2=mG2;iG2<=nG2;iG2++){
            if( con.F1[con.G2[iG2].F1].imp==0 )continue;
            dep.G3[++iG3].b=dep.G2[iG2].b;
         }
      }
   }
   return;
}
