#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../loc/Loc.hh"
#include "../loc/Loc_Automatic.hh"
#include "../med/Dielec_Continu.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Phi_Automatic.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>
#include <iomanip>
#include <cstdlib>

class MEM_loc {
private:
   std::vector<bool> o_T1sub;           //
   std::vector<double> o_T1ch0;         //(degree)
   std::vector<bool> o_Q1sub;           //
   std::vector<double> o_Q1ch0;         //(radian)
public:
   std::vector<std::string> o_Lrec;     //lines from input file
   MEM_loc(int t,int q):
      o_T1sub(t,false),
      o_T1ch0(t),
      o_Q1sub(q,false),
      o_Q1ch0(q)
   {
   }
   bool T1sub(int i){
      return o_T1sub[ i];
   }
   void T1sub(int i,bool a){
      o_T1sub[ i]=a;
      return;
   }
   double& T1ch0(int i){
      return o_T1ch0.at( i);  }
   bool Q1sub(int i){
      return o_Q1sub[ i];
   }
   void Q1sub(int i,bool a){
      o_Q1sub[ i]=a;
      return;
   }
   double& Q1ch0(int i){
      return o_Q1ch0.at( i);  }
   std::string& Lrec(int i){
      return o_Lrec.at( i);  }
};

bool Loc::LOC(const DAT_PHYSICS_CONSTS& physics_consts,
              const DAT_ARRAY_CONSTS& array_consts,
              const DAT_ENERGY_PARAMS& energy_params,
              const DAT_RESIDUE_MAPPINGS& residue_mappings,
              const DAT_REGION_MAPS& region_maps,
              Thread_Options& opt,
              Output_Streams& out,
              Structure& str,
              const Mechanical_System& mol,
              const Subset_Contracted_System& col,
              Conf_Dependent_System& dep){
   int oZ0=mol.Z0.size();
   int oR0=mol.R0.size();
   int oQ1=mol.Q1.size();
   int oF1=mol.F1.size();
   int oG1=mol.G1.size();

   int oM2=2048;
   int oM3=col.nM3;
   Local_Minimization2 loc(oM2,oM3);
   for(int iM3= 0;iM3<oM3;iM3++){
      loc.M3BETA(iM3)= (3.20e-02);
   }

   int oT1=str.T1.size();
   MEM_loc vv(oT1,oQ1);
   bool TETHER=false;
   std::string filename="../../"+str.fam+"/tor/xform_"+str.mol;
   std::ifstream ifile(filename.c_str());
   if( ifile ){
      std::string rec;
      while( !std::getline(ifile,rec).eof() ){
         vv.o_Lrec.push_back(rec);
      }
      ifile.close();
      int p=0;
      for(int iZ0=0;iZ0<oZ0;iZ0++){
         p++;
         int mR0=str.Z0[iZ0].R0a;
         int nR0=(mR0-1+str.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            std::string aa=vv.Lrec(p  ).substr( 0, 4);
            if( aa!=str.R0[iR0].aa ){
               std::cerr<<"ERROR: Inconsistency of xform file"
                        <<" with SEQ file."
                        <<" iZ0="<< std::setw( 2)<<(iZ0+1)
                        <<" iR0="<< std::setw( 4)<<(iR0-mR0+1)
                        <<" aa="<<aa<<".\n";
               std::exit( 2);
            }
            char c1=str.R0[iR0].c1;
            rec=vv.Lrec(p++).substr( 5,84);
            int i=0;
            int mT1=str.R0[iR0].T1a;
            int nT1=(mT1-1+str.R0[iR0].cT1);
            for(int iT1=mT1;iT1<=nT1;iT1++){
               if( (c1=='a')&&
                   ((aa[3]=='e')||(aa[3]=='z'))&&
                   (iT1==(mT1+2)) ){
               }else{
                  bool sub=( rec[i]=='|' );
                  vv.T1sub(iT1, sub);
                  std::istringstream irec(rec.substr(i+1, 6));
                  irec>>vv.T1ch0(iT1);
               }
               i+=7;
            }
         }
      }
      for(int iZ0= 0;iZ0<oZ0;iZ0++){
         int mQ1=mol.Z0[iZ0].Q1a;
         int iQ1bb=(mQ1+1);
         int iQ1sc=(mQ1+mol.Z0[iZ0].cQ1bb);
         int mR0=str.Z0[iZ0].R0a;
         int nR0=(mR0-1+str.Z0[iZ0].cR0);
         for(int iR0=mR0;iR0<=nR0;iR0++){
            char c1=str.R0[iR0].c1;
            int iL0=str.R0[iR0].L0;
            int mQ0=residue_mappings.L0[iL0].Q0a;
            int nQ0=(mQ0-1+residue_mappings.L0[iL0].cQ0);
            if( nQ0>=mQ0 ){
               for(int iQ0=mQ0;iQ0<=nQ0;iQ0++){
                  int iQ1=( residue_mappings.Q0[iQ0].br>0 )? iQ1sc++: iQ1bb++;
                  std::string tor=mol.Q1[iQ1].tor;
                  int jR0=( ((c1=='a')||(c1=='e'))&&
                            (tor=="OMG") )? iR0-1: iR0;
                  int iT1=str.itorsion(jR0,tor);
                  if( iT1==-1 ){
                     std::exit( 2);
                  }else{
                     vv.Q1sub(iQ1, vv.T1sub(iT1));
                     vv.Q1ch0(iQ1)= (physics_consts.RAD*vv.T1ch0(iT1));
                  }
               }
            }
         }
      }
      TETHER=true;
   }

   if( out.VERBOSE&& out.SHELL ){
      out.FILE3<<" distance constraint coeff index="
               << std::setw( 2)
               <<opt.iW0_active<<'\n';
   }
   int nCYC=( oM3> 1 )? 8: 1;
   for(int iCYC= 0;iCYC<nCYC;iCYC++){
      for(int iM3= 0;iM3<oM3;iM3++){
         loc.iM3=iM3;
         const Subset_Contracted_System::tM3& con=col.M3[loc.iM3];
         opt.QSUB=con.QSUB;
         if( out.VERBOSE&& out.SHELL ){
            out.FILE3<<" subset name="<<opt.QSUB<<'\n';
         }

         int oQ2=con.oQ2;
         int oF2=con.oF2;
         int oE1=con.oE1;
         int oU2=con.oU2;
         Energy_Surface2 ene(oZ0,oR0,oQ2,oF2,oE1,oU2+ 6);
         {
            ene.iCYC=iCYC;
            if( TETHER ){
               ene.TETHER=TETHER;
               int iU2=0;
               for(int iZ0= 0;iZ0<oZ0;iZ0++){
                  if( con.Z0[iZ0].sub ){
                     for(int i=0;i<6;i++){
                        ene.U2sub(iU2+i, false);
                        ene.U2ch0(iU2+i)= (0.00);
                     }
                     iU2+=6;
                  }
               }
               for(int iZ0= 0;iZ0<oZ0;iZ0++){
                  int mQ1=mol.Z0[iZ0].Q1a;
                  int nQ1=(mQ1-1+mol.Z0[iZ0].cQ1);
                  if( nQ1>mQ1 ){
                     for(int iQ1=(mQ1+1);iQ1<=nQ1;iQ1++){
                        if( con.Q1[iQ1].sub ){
                           ene.U2sub(iU2, vv.Q1sub(iQ1));
                           ene.U2ch0(iU2)= vv.Q1ch0(iQ1);
                           iU2++;
                        }
                     }
                  }
               }
            }
         }

         Loc_Automatic aut(oZ0,oQ1,oF1,oG1,oQ2);
         {
            aut.nCYC=nCYC;
         }
         LOC_Q2(aut,
                array_consts,energy_params,
                mol,con,dep,ene);
         LOC_U2(aut,
                mol,con,dep,ene,loc);
         LOC_F2(aut,
                mol,con,dep);

         Phi_Automatic ph2(con);
         ene.RECYCLE=false;
         ene.QMEDIUM=true;
         ene.QFAC(ph2,
                  physics_consts,
                  out,mol,con,dep);
//       loc.nM2=2;
         if( out.SHELL ){
            std::cout<<"LOCAL MINIMIZATION TRAJECTORY\n";
         }
         loc.MOV(ph2,
                 physics_consts,array_consts,energy_params,
                 region_maps,
                 opt,out,mol,con,dep,ene);
         loc.WRT(physics_consts,residue_mappings,
                 opt,out,str,mol,con,dep,ene);
//       LOC_NUMERIC(physics_consts,array_consts,energy_params,
//                   region_maps,
//                   opt,out,mol,con,dep,ene,loc);
//       out.FILE1.flush();
//       out.FILE3.flush();
//       std::exit( 2);
         if( (oM3==1)&&(con.QSUB=="a00") ){
            if( out.VERBOSE&& out.SHELL ){
               out.FILE3<<" SINGLE POINT RESTBCHMGP EVALUATION\n";
            }
            ene.ethresh= (2.00e-6);
            ene.RECYCLE=false;
            ene.QMEDIUM=false;
            ene.QFAC(ph2,
                     physics_consts,
                     out,mol,con,dep);
            if( out.SHELL ){
               std::cout<<"SINGLE POINT FULL ENERGY\n";
            }
            ene.PHIG(ph2,
                     physics_consts,array_consts,energy_params,
                     region_maps,
                     opt,out,mol,con,dep);
            ene.Fr*=physics_consts.CAL;
            ene.Fe*=physics_consts.CAL;
            ene.Fs*=physics_consts.CAL;
            ene.Ft*=physics_consts.CAL;
            ene.Fb*=physics_consts.CAL;
            ene.Fc*=physics_consts.CAL;
            ene.Fh*=physics_consts.CAL;
            ene.Fw*=physics_consts.CAL;         //here Fw is not included
            ene.Fp*=physics_consts.CAL;
            ene.Fp_a*=physics_consts.CAL;
            ene.Fp_b*=physics_consts.CAL;
            ene.Fp_c*=physics_consts.CAL;
            ene.Fp_d*=physics_consts.CAL;
            ene.Fp_e*=physics_consts.CAL;
            int oA5=con.oA5;
            Dielec_Continu med(oQ2,oF2,oA5,oR0);
            med.bse_nA5=0;
            ene.MED(ph2,med,
                    physics_consts,array_consts,energy_params,
                    opt,out,str,mol,con,dep);
            ene.Fm=( energy_params.fac_ps*med.Fps
                    +energy_params.fac_ss*med.Fss
                    +energy_params.fac_qd*med.Fqd
                    +energy_params.fac_uh*med.Fuh
                    +energy_params.fac_cc*med.Fcc);
            med.Fps*=physics_consts.CAL;
            med.Fss*=physics_consts.CAL;
            ene.Fm*=physics_consts.CAL;
            ene.TOT=( ene.Fr +ene.Fe +ene.Fs +ene.Ft
                     +ene.Fb +ene.Fc +ene.Fh +ene.Fm);
            ene.TOT+=( ene.Fg +ene.Fp);
            ene.TOT-=( ene.Fc);
            if( out.VERBOSE&& out.SHELL ){
               out.FILE3<< std::fixed<< std::setprecision(2);
               out.FILE3<<"      F  \n";
               out.FILE3<< std::setw( 9)<<ene.TOT<<'\n';
               out.FILE3<<"     Fr  "
                        <<"     Fe  "
                        <<"     Fs  "
                        <<"     Ft  "
                        <<"     Fb  "
                        <<"     Fc  "
                        <<"     Fh  "
                        <<"     Fm  "
                        <<"     Fg  "
                        <<"     Fp  \n";
               out.FILE3<< std::setw( 9)<<ene.Fr
                        << std::setw( 9)<<ene.Fe
                        << std::setw( 9)<<ene.Fs
                        << std::setw( 9)<<ene.Ft
                        << std::setw( 9)<<ene.Fb
                        << std::setw( 9)<<ene.Fc
                        << std::setw( 9)<<ene.Fh
                        << std::setw( 9)<<ene.Fm
                        << std::setw( 9)<<ene.Fg
                        << std::setw( 9)<<ene.Fp<<'\n';
//             out.FILE3<<"     Fp_a"
//                      <<"     Fp_b"
//                      <<"     Fp_c"
//                      <<"     Fp_d"
//                      <<"     Fp_e\n";
//             out.FILE3<< std::setw( 9)<<ene.Fp_a
//                      << std::setw( 9)<<ene.Fp_b
//                      << std::setw( 9)<<ene.Fp_c
//                      << std::setw( 9)<<ene.Fp_d
//                      << std::setw( 9)<<ene.Fp_e<<'\n';
            }
            if( (ene.TOT>TOT_pre) &&(!opt.ALTEREG) ){
               return false;
            }else{
               TOT_pre= ene.TOT;
               int n=Table.size();
               Table.push_back( Record());
               Table[n].F= ene.TOT;
               Table[n].Fr= ene.Fr;
               Table[n].Fe= ene.Fe;
               Table[n].Fs= ene.Fs;
               Table[n].Ft= ene.Ft;
               Table[n].Fb= ene.Fb;
               Table[n].Fc= ene.Fc;
               Table[n].Fh= ene.Fh;
               Table[n].Fw= ene.Fw;
               Table[n].Fm= ene.Fm;
               Table[n].Fps= med.Fps;
               Table[n].Fss= med.Fss;
               Table[n].Fg= ene.Fg;
               Table[n].Fp= ene.Fp;
               Table[n].Fp_a= ene.Fp_a;
               Table[n].Fp_b= ene.Fp_b;
               Table[n].Fp_c= ene.Fp_c;
               Table[n].Fp_d= ene.Fp_d;
               Table[n].Fp_e= ene.Fp_e;
               Table[n].iW0=opt.iW0_active;
               Table[n].rmsd=( n>0 )? Table[n-1].rmsd: (0.00);
               return ( loc.iM2>0 );
            }
         }
      }
   }

// std::string filename="../../"+str.fam+"/dgn/locfga."+str.mol+"."+str.cnf;
// out.FILE1.open(filename.c_str());
// out.FILE1<< std::fixed<< std::setprecision(5);
// out.FILE1<<"       F    \n";
// out.FILE1<< std::setw(12)<<ene.TOT<<'\n';
// out.FILE1<<"      Fr    "
//          <<"      Fe    "
//          <<"      Fs    "
//          <<"      Ft    "
//          <<"      Fc    "
//          <<"      Fb    "
//          <<"      Fh    "
//          <<"      Fw    \n";
// out.FILE1<< std::setw(12)<<ene.Fr
//          << std::setw(12)<<ene.Fe
//          << std::setw(12)<<ene.Fs
//          << std::setw(12)<<ene.Ft
//          << std::setw(12)<<ene.Fc
//          << std::setw(12)<<ene.Fb
//          << std::setw(12)<<ene.Fh
//          << std::setw(12)<<ene.Fw<<'\n';
// out.FILE1<<"      Fg    "
//          <<"      Fp    \n";
// out.FILE1<< std::setw(12)<<ene.Fg
//          << std::setw(12)<<ene.Fp<<'\n';
// out.FILE1<< std::scientific;
// out.FILE1<<"           G\n";
// for(int iU2= 0;iU2<ene.nU2;iU2++){
//    out.FILE1<< std::setw(12)<<ene.U2g(iU2);
//    if( (iU2+1)%8==0 )out.FILE1<<'\n';
// }
// out.FILE1<<"           A\n";
// for(int iU2= 0;iU2<ene.nU2;iU2++){
//    for(int jU2=iU2;jU2<ene.nU2;jU2++){
//       out.FILE1<< std::setw(12)<<ene.U2U2a(iU2,jU2);
//       if( (jU2+1)%8==0 )out.FILE1<<'\n';
//    }
// }
// out.FILE1.close();

   return true;
}
