#ifndef DEF_LOC_AUTOMATIC
#define DEF_LOC_AUTOMATIC

#include "../phi/Coordinates.hh"
#include "../phi/Multipoles.hh"
#include "../phi/Rotation_Matrix.hh"
#include <vector>

class Loc_Automatic {
public:
   class tZ0 { /*chains in system of molecules*/
   public:
      int GENa;                 //start index into forward subgroups
      int cGEN;                 //number of forward subgroups
      tZ0(){}
   };
   class tQ1 { /*torsions in chains [forward order]*/
   public:
      Rotation_Matrix tu;       //t(chi about x-axis)u(lam about z-axis)
      int Q2;                   //map to forward variable torsion
      tQ1(){}
   };
   class tF1 { /*atoms in chains [backward order]*/
   public:
      Coordinates x;            //coords (bohr)
      Multipoles q;             //atom multipoles
      tF1(){}
   };
   class tG1 { /*atoms in chain forward groups [forward order]*/
   public:
      Coordinates b;            //untransformed coords (bohr)
      tG1(){}
   };
   class tQ2 { /*torsions in torsion-contracted chains [forward order]*/
   public:
      int Q1;                   //map to forward torsion
      int ORD;                  //map to order of generation
      tQ2(){}
   };
   class tGEN { /*generated groups*/
   public:
      int Q1;                   //map to forward torsion
      tGEN(){}
   };

public:
   int nCYC;                    //number of cycles over subsets
   std::vector<tZ0> Z0;         //chains
   std::vector<tQ1> Q1;         //torsions [forward order]
   std::vector<tF1> F1;         //atoms [backward order]
   std::vector<tG1> G1;         //atoms in chain forward groups
   std::vector<tQ2> Q2;         //torsions contracted [forward order]
   std::vector<tGEN> GEN;       //generated groups

   Loc_Automatic(int z,int q,int f,int g,int o):
      nCYC( 1),
      Z0(z),
      Q1(q),
      F1(f),
      G1(g),
      Q2(o),
      GEN(q)
   {
   }
};

#endif
