#ifndef DEF_LOC
#define DEF_LOC

#include "../con/Subset_Contracted_System.hh"
#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_ENERGY_PARAMS.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../dat/DAT_REGION_MAPS.hh"
#include "../dat/DAT_RESIDUE_MAPPINGS.hh"
#include "../fil/Structure.hh"
#include "../loc/Loc_Automatic.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Conf_Dependent_System.hh"
#include "../phi/Energy_Surface.hh"
#include "../set/Mechanical_System.hh"
#include "../str/Output_Streams.hh"
#include "../str/Thread_Options.hh"
#include <vector>

class Loc {
public:
   class Record { /*decomposition of restchm*/
   public:
      double F;                 //total
      double Fr;                //repulsion+dispersion
      double Fe;                //electrostatic
      double Fs;                //disulfide bond
      double Ft;                //intrinsic torsional
      double Fc;                //distance constraint
      double Fb;                //ring closure
      double Fh;                //hydrophobic
      double Fw;                //hydration site excluded vol
      double Fm;                //dielectric medium
      double Fps;               //protein-solvent
      double Fss;               //solvent-solvent
      double Fg;                //entropic reduction, disallow regions
      double Fg_a;              //
      double Fg_b;              //
      double Fp;                //polarization
      double Fp_a;              // H-bonds
      double Fp_b;              // multiple H-bonds to a donor or acceptor
      double Fp_c;              // chains of peptide plane alignment
      double Fp_d;              // modulation of peptide H-bonds by elem type
      double Fp_e;              // nonpolar atoms in the electric field
      double Fp_f;              //
      int iW0;                  //index of distance constraint coeff
      double rmsd;              //heavy atom rmsd
      Record(){}
   };

public:
   double TOT_pre;              //
   std::vector<Record> Table;   //

   bool LOC(const DAT_PHYSICS_CONSTS& physics_consts,
            const DAT_ARRAY_CONSTS& array_consts,
            const DAT_ENERGY_PARAMS& energy_params,
            const DAT_RESIDUE_MAPPINGS& residue_mappings,
            const DAT_REGION_MAPS& region_maps,
            Thread_Options& opt,
            Output_Streams& out,
            Structure& str,
            const Mechanical_System& mol,
            const Subset_Contracted_System& col,
            Conf_Dependent_System& dep);

   void LOC_Q2(Loc_Automatic& aut,
               const DAT_ARRAY_CONSTS& array_consts,
               const DAT_ENERGY_PARAMS& energy_params,
               const Mechanical_System& mol,
               const Subset_Contracted_System::tM3& con,
               Conf_Dependent_System& dep,
               Energy_Surface2& ene);

   void LOC_U2(Loc_Automatic& aut,
               const Mechanical_System& mol,
               const Subset_Contracted_System::tM3& con,
               const Conf_Dependent_System& dep,
               Energy_Surface2& ene,
               Local_Minimization2& loc);

   void LOC_F2(const Loc_Automatic& aut,
               const Mechanical_System& mol,
               const Subset_Contracted_System::tM3& con,
               Conf_Dependent_System& dep);

   void LOC_NUMERIC(const DAT_PHYSICS_CONSTS& physics_consts,
                    const DAT_ARRAY_CONSTS& array_consts,
                    const DAT_ENERGY_PARAMS& energy_params,
                    const DAT_REGION_MAPS& region_maps,
                    const Thread_Options& opt,
                    Output_Streams& out,
                    const Mechanical_System& mol,
                    const Subset_Contracted_System::tM3& con,
                    Conf_Dependent_System& dep,
                    Energy_Surface2& ene,
                    Local_Minimization2& loc);

   Loc():
      TOT_pre( 1.00e+8)
   {
   }
};

#endif
