#include "../dat/DAT_IGOR_DATA.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>

void Igor_Model::IGO_ULOAD(const DAT_IGOR_DATA& igor_data,
                           Output_Streams& out){
   int oC7=igor_data.oC7;
//
//
// output profile of K7 sample from previous traj
//
   out.FILE3<<"  K7""   e3  ""  n\n";
   for(int iK7= 0;iK7<oK7;iK7++){
      if( !K7[iK7].b )continue;
      double e3= K7[iK7].e3;
      int n=0;
      for(int iR0= 0;iR0<oR0;iR0++){
         if( K7[iK7].R0[iR0].b )n++;
      }
      out.FILE3<< std::setw( 4)<<iK7
               << std::setw( 7)<<e3
               << std::setw( 3)<<n<<'\n';
      oG7=K7[iK7].oG7;
      for(int iG7= 0;iG7<oG7;iG7++){
         int mR0=K7[iK7].G7[iG7].mR0;
         int nR0=K7[iK7].G7[iG7].nR0;
         int iC7=K7[iK7].G7[iG7].C7;
         char a1=igor_data.C7[iC7].a1;
         for(int iR0=mR0;iR0<=nR0;iR0++){
            out.FILE3<<a1;
            if( ((iR0+ 1)%100==0)||(iR0==(oR0-1)) ){
               out.FILE3<<'\n';
            }
         }
      }
      for(int iG7= 0;iG7<oG7;iG7++){
         int mR0=K7[iK7].G7[iG7].mR0;
         int nR0=K7[iK7].G7[iG7].nR0;
         for(int iR0=mR0;iR0<=nR0;iR0++){
            int iL1=R0[iR0].L1;
            char a1=igor_data.L1[iL1].a1;
            out.FILE3<<(( K7[iK7].R0[iR0].b )? a1: '.');
            if( ((iR0+ 1)%100==0)||(iR0==(oR0-1)) ){
               out.FILE3<<'\n';
            }
         }
      }
   }
//
//
// output energies attainable from patch crosslinks
//
   out.FILE3<<"  R0 "" aa ""  "
              "    (H,E,C) bo     "
              "    (H,E,C) eo     "
              "    (H,E,C) zo     "
              "   (H,E,C) K7  \n";
   out.FILE3<< std::fixed<< std::setprecision( 2);
   for(int iR0= 0;iR0<oR0;iR0++){
      out.FILE3<< std::setw( 4)<<iR0<<' '
               <<igor_data.L1[ R0[iR0].L1].a3<<' '
               <<igor_data.C7[R0[iR0].C70].a1<<' ';
      for(int iC7= 1;iC7<oC7;iC7++){
         out.FILE3<< std::setw( 6)<<R0[iR0].C7bo(iC7);
      }
      out.FILE3<<' ';
      for(int iC7= 1;iC7<oC7;iC7++){
         out.FILE3<< std::setw( 6)<<R0[iR0].C7eo(iC7);
      }
      out.FILE3<<' ';
      for(int iC7= 1;iC7<oC7;iC7++){
         out.FILE3<< std::setw( 6)<<R0[iR0].C7zo(iC7);
      }
      out.FILE3<<' ';
      for(int iC7= 1;iC7<oC7;iC7++){
         out.FILE3<< std::setw( 5)<<R0[iR0].C7K7(iC7);
      }
      out.FILE3<<'\n';
   }
//
//
// update to 1-bod res impulses
//
   for(int iR0= 0;iR0<oR0;iR0++){
      int j=0;
      for(int iC7= 1;iC7<oC7;iC7++){
         if( R0[iR0].C7K7(iC7)==-1 )j++;
      }
      if( j==3 ){
         for(int iC7= 1;iC7<oC7;iC7++){
            R0[iR0].C7po(iC7)= R0[iR0].C7p0(iC7);
         }
      }else{
         double q= (0.00);
         double z= (0.00);
         for(int iC7= 1;iC7<oC7;iC7++){
            if( R0[iR0].C7K7(iC7)==-1 ){
               R0[iR0].C7po(iC7)= ( .02);
               q+=R0[iR0].C7po(iC7);
            }else{
               R0[iR0].C7po(iC7)= std::exp( R0[iR0].C7e0(iC7)
                                           +R0[iR0].C7bo(iC7));
               z+=R0[iR0].C7po(iC7);
            }
         }
         for(int iC7= 1;iC7<oC7;iC7++){
            if( R0[iR0].C7K7(iC7)==-1 ){
            }else{
               R0[iR0].C7po(iC7)*=(( (1.00) -q)/z);
            }
         }
      }
      for(int iC7= 1;iC7<oC7;iC7++){
         double x= R0[iR0].C7p0(iC7);
         if( x<( .02) )x= ( .02);
         if( x>( .98) )x= ( .98);
         double y= R0[iR0].C7po(iC7);
         if( y<( .02) )y= ( .02);
         if( y>( .98) )y= ( .98);
         R0[iR0].C7go(iC7)= std::log( y/x);
      }
   }
//
//
// output 1-bod update
//
   out.FILE3<<"Update to 1-Bod Residue Impulses\n";
   out.FILE3<<"  R0 "" aa ""  "
              " (H,E,C) p prior   "
              " (H,E,C) p obs     "
              " (H,E,C) de update\n";
   for(int iR0= 0;iR0<oR0;iR0++){
      out.FILE3<< std::setw( 4)<<iR0<<' '
               <<igor_data.L1[ R0[iR0].L1].a3<<' '
               <<igor_data.C7[R0[iR0].C70].a1;
      out.FILE3<<' '<< std::setprecision( 3);
      for(int iC7= 1;iC7<oC7;iC7++){
         out.FILE3<< std::setw( 6)<<R0[iR0].C7p0(iC7);
      }
      out.FILE3<<' '<< std::setprecision( 3);
      for(int iC7= 1;iC7<oC7;iC7++){
         out.FILE3<< std::setw( 6)<<R0[iR0].C7po(iC7);
      }
      out.FILE3<<' '<< std::setprecision( 2);
      for(int iC7= 1;iC7<oC7;iC7++){
         out.FILE3<< std::setw( 6)<<R0[iR0].C7go(iC7);
      }
      out.FILE3<<'\n';
   }
//
//
// update 1-bod residue probabilities
//
   for(int iR0= 0;iR0<oR0;iR0++){
      for(int iC7= 1;iC7<oC7;iC7++){
         R0C7e(iR0,iC7)+=R0[iR0].C7go(iC7);
      }
   }
   return;
}
