#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>

void Igor_Model::IGO_STEP(const DAT_PHYSICS_CONSTS& physics_consts,
                          const DAT_IGOR_DATA& igor_data,
                          Output_Streams& out){
//
//
// retain backup of highest scoring config
//
   SCORE=( SCORE0  +SCORE1  +SCORE1b +SCORE2 +SCORE2b);
   if( SCORE>zSCORE ){
      zSCORE= SCORE;
      zSCORE0= SCORE0;
      zSCORE1= SCORE1;
      zSCORE1b= SCORE1b;
      zSCORE2= SCORE2;
      zSCORE2b= SCORE2b;
      zSCORE3= (0.00);
      zSCORE3b= (0.00);
      zSCORE3c= (0.00);
//
//
// chain state
//
      zoG7=oG7;
      if( int(zG7.size())!=oG7 ){
         zG7.clear();
         zG7.resize(oG7);
      }
      for(int iG7= 0;iG7<oG7;iG7++){
         zG7[iG7]=G7[iG7];
         int mR0=G7[iG7].mR0;
         int nR0=G7[iG7].nR0;
         for(int iR0=mR0;iR0<=nR0;iR0++){
            R0[iR0].C7z=( 10*iG7 +G7[iG7].C70);
         }
      }
      SWITCH=true;
//
//
// diagnostic output
//
//    out.FILE3<<"CYC ( 0R0, 7R0)   G7nR0\n";
//    out.FILE3<<std::setw( 3)<<iCYCLE<<" ("
//             <<std::setw( 4)<<i0R0<<','
//             <<std::setw( 4)<<i7R0<<')';
//    for(int iG7=mG7grp;iG7<=nG7grp;iG7++){
//       out.FILE3<<std::setw( 4)<<G7[iG7].nR0;
//    }
//    out.FILE3<<'\n';
//    out.FILE3<<"  SCORE"
//             <<"  SCO0 "
//             <<"  SCO1 "
//             <<"  SCO1b"
//             <<"  SCO2 "
//             <<"  SCO2b"
//             <<"  SCO3 "
//             <<"  SCO3b"
//             <<"  SCO3c\n";
//    out.FILE3<<std::fixed<<std::setprecision( 2);
//    out.FILE3<<std::setw( 7)<<SCORE
//             <<std::setw( 7)<<SCORE0
//             <<std::setw( 7)<<SCORE1
//             <<std::setw( 7)<<SCORE1b
//             <<std::setw( 7)<<SCORE2
//             <<std::setw( 7)<<SCORE2b
//             <<std::setw( 7)<<SCORE3
//             <<std::setw( 7)<<SCORE3b
//             <<std::setw( 7)<<SCORE3c<<'\n';
//    out.FILE3<<"Input Elements\n";
//    for(int iR0= 0;iR0<oR0;iR0++){
//       out.FILE3<<std::setw( 1)<<(R0[iR0].C7def%10);
//       if( ((iR0+ 1)%80==0)||(iR0==(oR0-1)) ){
//          out.FILE3<<'\n';
//       }
//    }
//    out.FILE3<<"Predicted Residue States\n";
//    for(int iR0= 0;iR0<oR0;iR0++){
//       out.FILE3<<igor_data.C7[R0[iR0].C7z%10].a1;
//       if( ((iR0+ 1)%80==0)||(iR0==(oR0-1)) ){
//          out.FILE3<<'\n';
//       }
//    }
//    out.FILE3<<" oG7\n";
//    out.FILE3<<std::setw( 4)<<oG7<<'\n';
//    out.FILE3<<"  G7"" T7"" C7""         G7C7p       \n";
//    out.FILE3<<std::setprecision( 3);
//    for(int iG7= 0;iG7<oG7;iG7++){
//       int iT7=G7[iG7].T7;
//       int iC7=G7[iG7].C70;
//       out.FILE3<<std::setw( 4)<<iG7
//                <<"  "<<igor_data.T7[iT7].a1
//                <<"  "<<igor_data.C7[iC7].a1;
//       for(int iC7=1;iC7<4;iC7++){
//          out.FILE3<<std::setw( 7)<<G7[iG7].C7p0(iC7);
//       }
//       out.FILE3<<'\n';
//    }
   }
   return;
}
