#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../mov/Local_Minimization.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Energy_Surface.hh"
#include "../phi/Gaussian_Volume.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../reg/Regularization_Target.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <cstdlib>
#include <iomanip>
#include <cmath>

class MEM_igo_sco3_wpol {
private:
   std::vector<bool> o_G7sub;           //subset of elements
   std::vector<bool> o_R0sub;           //subset of residues
   std::vector<double> o_R0dr;          //dist relaxation (bohr)
   std::vector<double> o_R0fb;          //sqrt of dielec const
   std::vector<Coordinates> o_R0n;      //normal along (R0[].xsc-R0[].xca)
   std::vector<Coordinates> o_R0t;      //interaction site for sc
public:
   MEM_igo_sco3_wpol(int g,int r):
      o_G7sub(g, false),
      o_R0sub(r, false),
      o_R0dr(r),
      o_R0fb(r),
      o_R0n(r),
      o_R0t(r)
   {
   }
   void G7sub(int i,bool a){
      o_G7sub[ i]=a;  }
   bool G7sub(int i){
      return o_G7sub[ i];  }
   void R0sub(int i,bool a){
      o_R0sub[ i]=a;  }
   bool R0sub(int i){
      return o_R0sub[ i];  }
   double& R0dr(int i){
      return o_R0dr.at( i);  }
   double& R0fb(int i){
      return o_R0fb.at( i);  }
   Coordinates& R0n(int i){
      return o_R0n.at( i);  }
   Coordinates& R0t(int i){
      return o_R0t.at( i);  }
};

bool Igor_Model::IGO_SCO3_WPOL(const DAT_PHYSICS_CONSTS& physics_consts,
                               const DAT_IGOR_DATA& igor_data,
                               Output_Streams& out,
                               double& Fm,double& Fh){
   MEM_igo_sco3_wpol vv(oG7,oR0);
//
//
// packed core, subset of elements and residues
//
   for(int iZ9= 0;iZ9<pU9;iZ9++){
      int oK4=Z9[iZ9].oK4;
      for(int iK4= 0;iK4<oK4;iK4++){
         int iG7=Z9[iZ9].K4[iK4].G7;
         vv.G7sub(iG7,true);
         int mR0=G7[iG7].mR0;
         int nR0=G7[iG7].nR0;
         for(int iR0=mR0;iR0<=nR0;iR0++){
            vv.R0sub(iR0,true);
         }
      }
   }
//
//
// packed core, mean position
//
   Coordinates xcor,xsig;
   {
      xcor.zero();
      int n=0;
      for(int iR0= 0;iR0<oR0;iR0++){
         if( vv.R0sub(iR0) ){
            xcor+=R0[iR0].xca;
            n++;
         }
      }
      xcor/=double( n);
      xsig.zero();
      for(int iR0= 0;iR0<oR0;iR0++){
         if( vv.R0sub(iR0) ){
            Coordinates t=( R0[iR0].xca -xcor);
            for(int i=0;i<3;i++){
               xsig(i)+=t(i)*t(i);
            }
         }
      }
      xsig/=double( n);
   }
//
//
// distance of relaxation
//
   for(int iR0= 0;iR0<oR0;iR0++){
      int iL1=R0[iR0].L1;
      vv.R0dr(iR0)= igor_data.L1[iL1].rho*physics_consts.ANG;
      if( vv.R0sub(iR0) ){
      }else{
         vv.R0dr(iR0)+=(  .125);
      }
   }
//
//
// coil bb and sc coords
//
   int aR0=-1;
   for(int iG7= 0;iG7<oG7;iG7++){
      if( !vv.G7sub(iG7) )continue;
      int bR0=G7[iG7].mR0;
      int nolp=0;
      if( aR0==-1 ){
         double R= (5.00);
         double dz= ( 2.70);
         double Sbet= dz/(3.);
         double Cbet= std::sqrt( (1.00) -Sbet*Sbet);
         double dthe= (3.)*Cbet/R;
//
//
// N-terminal segment bb and sc site coords
//
         Rotation_Matrix rot;
         Coordinates trans;
         {
            Coordinates u=( xcor -R0[bR0].xca);
            Coordinates z=-R0[bR0].nca;
            Coordinates x=cross(z,u);
            double rr= x.rr();
            if( rr<( 1.00e-10) ){
//             out.FILE3<<"LOOP GEN FAILURE\n";
               return true;
            }
            double r= std::sqrt( rr);
            x/=r;
            Coordinates y=cross(z,x);
            for(int i=0;i<3;i++){
               rot(i,0)= x(i);
               rot(i,1)= y(i);
               rot(i,2)= z(i);
            }
            trans=( R0[bR0].xca -R*x);
         }
         double sgnx= (-1.00)*(R0[bR0].del
                    /std::abs( R0[bR0].del));
         double Sgam= dz/(3.80);
         double SSgam= Sgam*Sgam;
         double Cgam= std::sqrt( (1.00) -SSgam);
         double CCgam= Cgam*Cgam;
         double CSgam= Cgam*Sgam;
         double gam= std::atan2(Sgam,Cgam);
         double alp= physics_consts.RAD*(  17.771);
         double bb= R*R;
         double cc= (1.90)*Cgam*(1.90)*Cgam;
         CM(3,4)= bb;
         CM(4,3)= bb;
         CM(2,3)= cc;
         CM(3,2)= cc;
         CM(1,4)= (1.00);
         CM(4,1)= (1.00);
//
         for(int iR0=(bR0- 1);iR0>aR0;iR0--){
            double the=( double(bR0-iR0)*dthe);
            double Cthe= std::cos( the);
            double Sthe= std::sin( the);
            Coordinates a;
            a(0)=( R +sgnx*(1.16619))*Cthe;
            a(1)=( R +sgnx*(1.16619))*Sthe;
            a(2)= double(bR0-iR0)*dz;
            Coordinates b;
            b(0)=( R +sgnx*(3.41619))*Cthe;
            b(1)=( R +sgnx*(3.41619))*Sthe;
            b(2)= double(bR0-iR0)*dz;
            R0[iR0].xca=( trans +rot*a);
            R0[iR0].xsc=( trans +rot*b);
            double aa= ( R +sgnx*(1.16619))*( R +sgnx*(1.16619));
            CM(2,4)= aa;
            CM(4,2)= aa;
            for(int j=-1;j< 2;j+=2){
               double f= double(j);
               Coordinates dx;
               {
                  double lam=( gam +f*sgnx*alp);
                  if( j==1 ){
                  }else{
                     lam-=physics_consts.PI;
                  }
                  dx(0)= (0.00);
                  dx(1)= ( 1.488)*std::cos( lam);
                  dx(2)= ( 1.488)*std::sin( lam);
               }
               Coordinates m,n;      //target plane, peptide plane
               {
                  double pR=( R +sgnx*(1.16619)*SSgam);
                  double pthe= (-.50)*dthe*SSgam;
                  double Cpthe= std::cos( pthe);
                  double Spthe= std::sin( pthe);
                  double pz= ( .50)*dz*CCgam;
                  m(0)=-pR*pthe*Spthe;
                  m(1)= pR*pthe*Cpthe;
                  m(2)= pz;
                  m.normalize();
                  n(0)= f*sgnx*(1.16619)*SSgam;
                  n(1)= -std::sqrt( cc -(1.16619)*(1.16619))*SSgam;
                  n(2)= pz;
                  n.normalize();
               }
               double Cphi= dot(m,n);
               double Sphi=-f*sgnx*std::sqrt( (1.00) -Cphi*Cphi);
               double phi= std::atan2(Sphi,Cphi);
               Rotation_Matrix Q;
               Q(0,0)= Cphi;
               Q(1,0)= Sgam*Sphi;
               Q(2,0)=-Cgam*Sphi;
               Q(0,1)=-Sgam*Sphi;
               Q(1,1)=( SSgam*Cphi +CCgam);
               Q(2,1)=-CSgam*( Cphi -(1.));
               Q(0,2)= Cgam*Sphi;
               Q(1,2)=-CSgam*( Cphi -(1.));
               Q(2,2)=( CCgam*Cphi +SSgam);
               dx=Q*dx;
               double xx=( dx(0)*dx(0) +dx(1)*dx(1));
               double yy=( dx(0)*dx(0)
                          +std::pow( ( (1.90)*Cgam -f*dx(1)), 2));
               CM(1,2)= xx;
               CM(2,1)= xx;
               CM(1,3)= yy;
               CM(3,1)= yy;
               double zz= IGO_CAYLEY_MENGER(out,( dx(0)<=(0.00) ));
               double z= std::sqrt( zz);
               double qR=( z -R);
               double p;
               double qthe( 0.00);
               if( aa>zz ){
                  p=( aa -xx +zz)/((2.)*( R +sgnx*(1.16619)));
                  qthe= f*std::acos( p/z);
               }else{
                  p=( aa -xx +zz)/((2.)*z);
                  qthe= f*std::acos( p/( R +sgnx*(1.16619)));
               }
               double qz= dx(2);
               a(0)=( R +qR)*std::cos( the +qthe);
               a(1)=( R +qR)*std::sin( the +qthe);
               a(2)= double(bR0-iR0)*dz +qz;
               if( j==1 ){
                  R0[iR0].xn=( trans +rot*a);
               }else{
                  R0[iR0].xc=( trans +rot*a);
               }
            }
            for(int jR0= 0;jR0<oR0;jR0++){
               if( !vv.R0sub(jR0) )continue;
               double rr=( R0[jR0].xca -R0[iR0].xca).rr();
               if( rr<(7.84) ){
                  nolp++;
                  if( nolp>4 ){
//                   out.FILE3<<"OVERLAP END-CORE\n";
                     return true;
                  }
               }
               if( R0[iR0].lnk==jR0 ){
                  double ss=( R0[jR0].xsc -R0[iR0].xsc).rr();
                  if( ss>(144.00) ){
//                   out.FILE3<<"CROSSLINK END-CORE r="
//                            <<std::fixed<<std::setprecision( 2)
//                            <<std::setw( 6)<<std::sqrt(ss)
//                            <<'\n';
                     return true;
                  }
               }
            }
            sgnx=-sgnx;
         }
      }else if( bR0>(aR0+ 1) ){
//
//
// loop segments bb and sc site coords
//
         {
            double R= (5.00);
            double dz= ( 2.70);
            double Sbet= dz/(3.);
            double Cbet= std::sqrt( (1.00) -Sbet*Sbet);
            double dthe= (3.)*Cbet/R;
//
            Rotation_Matrix rot;
            Coordinates trans;
            {
               Coordinates u=( xcor -R0[bR0].xca);
               Coordinates z=-R0[bR0].nca;
               Coordinates x=cross(z,u);
               double rr= x.rr();
               if( rr<( 1.00e-10) ){
//                out.FILE3<<"LOOP GEN FAILURE\n";
                  return true;
               }
               double r= std::sqrt( rr);
               x/=r;
               Coordinates y=cross(z,x);
               for(int i=0;i<3;i++){
                  rot(i,0)= x(i);
                  rot(i,1)= y(i);
                  rot(i,2)= z(i);
               }
               trans=( R0[bR0].xca -R*x);
            }
            double sgnx= (-1.00)*(R0[bR0].del
                       /std::abs( R0[bR0].del));
            for(int iR0=(bR0- 1);iR0>aR0;iR0--){
               double fa= std::pow( double(iR0-aR0), 2);
               double fb= std::pow( double(bR0-iR0), 2);
               double f= fa/( fa +fb);
               double the=( double(bR0-iR0)*dthe);
               double Cthe= std::cos( the);
               double Sthe= std::sin( the);
               Coordinates a;
               a(0)=( R +sgnx*(1.16619))*Cthe;
               a(1)=( R +sgnx*(1.16619))*Sthe;
               a(2)= double(bR0-iR0)*dz;
               R0[iR0].xca=f*( trans +rot*a);
               sgnx=-sgnx;
            }
            {
               Coordinates u=( xcor -R0[aR0].xca);
               Coordinates z=R0[aR0].nca;
               Coordinates x=cross(z,u);
               double rr= x.rr();
               if( rr<( 1.00e-10) ){
//                out.FILE3<<"LOOP GEN FAILURE\n";
                  return true;
               }
               double r= std::sqrt( rr);
               x/=r;
               Coordinates y=cross(z,x);
               for(int i=0;i<3;i++){
                  rot(i,0)= x(i);
                  rot(i,1)= y(i);
                  rot(i,2)= z(i);
               }
               trans=( R0[aR0].xca -R*x);
            }
            sgnx= (-1.00)*(R0[aR0].del
                /std::abs( R0[aR0].del));
            for(int iR0=(aR0+ 1);iR0<bR0;iR0++){
               double fa= std::pow( double(iR0-aR0), 2);
               double fb= std::pow( double(bR0-iR0), 2);
               double f= fb/( fa +fb);
               double the=( double(iR0-aR0)*dthe);
               double Cthe= std::cos( the);
               double Sthe= std::sin( the);
               Coordinates a;
               a(0)=( R +sgnx*(1.16619))*Cthe;
               a(1)=( R +sgnx*(1.16619))*Sthe;
               a(2)= double(iR0-aR0)*dz;
               R0[iR0].xca+=f*( trans +rot*a);
               sgnx=-sgnx;
            }
         }
         {
            Regularization_Target reg;
//
//
// add target function elements for heavy atom positions
//
            reg.nA1=0;
            for(int iR0=aR0;iR0<=bR0;iR0++){
               reg.A1.push_back( Regularization_Target::tA1());
               reg.A1[reg.nA1].y= R0[iR0].xca;
               reg.A1[reg.nA1].x= R0[iR0].xca;
               reg.A1[reg.nA1].U2=-1;
               reg.nA1++;
            }
//
//
// add target function elements from z-matrix
//
            reg.nA2= 0;
            reg.nA3= 0;
            reg.nA4= 0;
            for(int iA1= 1;iA1<reg.nA1;iA1++){
               reg.A2.push_back( Regularization_Target::tA2());
               reg.o_A2N2A1.push_back( iA1   );
               reg.o_A2N2A1.push_back( iA1- 1);
               reg.A2[reg.nA2++].dst= (3.80);
            }
            for(int iA1= 2;iA1<reg.nA1;iA1++){
               reg.A3.push_back( Regularization_Target::tA3());
               reg.o_A3N3A1.push_back( iA1   );
               reg.o_A3N3A1.push_back( iA1- 1);
               reg.o_A3N3A1.push_back( iA1- 2);
               reg.A3[reg.nA3++].lam= ( 110.00);
            }
            for(int iA1= 3;iA1<reg.nA1;iA1++){
               reg.A4.push_back( Regularization_Target::tA4());
               reg.o_A4N4A1.push_back( iA1   );
               reg.o_A4N4A1.push_back( iA1- 1);
               reg.o_A4N4A1.push_back( iA1- 2);
               reg.o_A4N4A1.push_back( iA1- 3);
               reg.A4[reg.nA4++].chi= (-165.00);
            }
//
//
// harmonic coeffs
//
            reg.coa= ( 1.25e-1);
            reg.cob= ( 1.00e+2);
            reg.coc= ( 2.00e-3)/std::pow(physics_consts.RAD,2);
            reg.cod= ( 1.25e-4)/std::pow(physics_consts.RAD,2);
            reg.iK1=0;
//
            for(int i=0;i<3;i++){
               for(int j=0;j<3;j++){
                  for(int k=0;k<3;k++){
                     reg.feps(i,j,k)= (0.00);
                  }
               }
            }
            reg.feps(0,1,2)=( 1.00);
            reg.feps(0,2,1)=(-1.00);
            reg.feps(1,2,0)=( 1.00);
            reg.feps(1,0,2)=(-1.00);
            reg.feps(2,0,1)=( 1.00);
            reg.feps(2,1,0)=(-1.00);
//
//
// minimize target function
//
            int oU2=3*(bR0-aR0- 1);
            Energy_Surface5 ene(oU2);
            {
               ene.nU2= 0;
               for(int iA1= 1;iA1<(reg.nA1- 1);iA1++){
                  for(int i=0;i<3;i++){
                     ene.U2chi(ene.nU2+i)= reg.A1[iA1].x(i);
                  }
                  reg.A1[iA1].U2=ene.nU2;
                  ene.nU2+=3;
               }
            }
            int oM2=128;
            int oK1=1;
            Local_Minimization5 loc(oM2,oK1);
            {
               double z= double( ene.nU2);
               loc.BETA= std::sqrt( z)*(1.00e-02);
               loc.BMIN= std::sqrt( z)*(1.00e-06);
               loc.BMAX= std::sqrt( z)*(1.00e-01);
               loc.BDEL= (2.00e-01);
               loc.EPS1= z*std::pow( (1.00e-06), 2);
               loc.EPS2= (1.00e-02);
               loc.K1BETA( 0)= loc.BETA;
               loc.nM2=(oM2- 1);
            }
//
            loc.MOV(physics_consts,out,ene,reg);
            loc.WRT(out,ene,reg);
////  out.FILE3<<" Fa="<<std::setw( 8)<<ene.Fa
////           <<" Fb="<<std::setw( 8)<<ene.Fb
////           <<" Fc="<<std::setw( 8)<<ene.Fc
////           <<" Fd="<<std::setw( 8)<<ene.Fd<<'\n';
            if( ( ene.Fb +ene.Fc)>( 4.00) ){
//             out.FILE3<<"LOOP GEN FAILURE\n";
               return true;
            }
//
            int iU2= 0;
            for(int iA1= 1;iA1<(reg.nA1- 1);iA1++){
               for(int i=0;i<3;i++){
                  reg.A1[iA1].x(i)= ene.U2chi(iU2+i);
               }
               iU2+=3;
            }
//
//
// update structure
//
            int iA1=0;
            for(int iR0=(aR0+ 1);iR0<bR0;iR0++){
               R0[iR0].xca=reg.A1[++iA1].x;
            }
         }
         {
            double R= ( 8.75);
            double gam= physics_consts.RAD*(  33.93);
            double Cgam= std::cos( gam);
            double Sgam= std::sin( gam);
            double CCgam= Cgam*Cgam;
            double SSgam= Sgam*Sgam;
            double CSgam= Cgam*Sgam;
            double alp= physics_consts.RAD*(  17.771);
            double bb= R*R;
            double cc= (1.90)*Cgam*(1.90)*Cgam;
            CM(3,4)= bb;
            CM(4,3)= bb;
            CM(2,3)= cc;
            CM(3,2)= cc;
            CM(1,4)= (1.00);
            CM(4,1)= (1.00);
            double sgnx= (-1.00)*(R0[aR0].del
                       /std::abs( R0[aR0].del));
            for(int iR0=(aR0+ 1);iR0<bR0;iR0++){
               Rotation_Matrix rot;
               Coordinates trans;
               double dz( 0.00),dthe( 0.00);
               {
                  Coordinates a1=R0[iR0   ].xca;
                  Coordinates n0=( R0[iR0- 1].xca -a1).normalize();
                  Coordinates a0=( a1 +(3.80)*n0);
                  Coordinates n2=( R0[iR0+ 1].xca -a1).normalize();
                  Coordinates a2=( a1 +(3.80)*n2);
                  Coordinates x=((-sgnx)*( n2 +n0)).normalize();
                  Coordinates w=(sgnx*cross(n2,n0)).normalize();
                  Coordinates v=cross(w,x);
                  Coordinates y=( Cgam*v -Sgam*w);
                  Coordinates z=( Sgam*v +Cgam*w);
                  for(int i=0;i<3;i++){
                     rot(i,0)= x(i);
                     rot(i,1)= y(i);
                     rot(i,2)= z(i);
                  }
                  trans=( a1 -( R +sgnx*(1.16619))*x);
                  dz= ( .50)*dot(( a2 -a0), z);
                  double C= dot(( a2 -trans),( a0 -trans))
                           /( a2 -trans).rr();
                  dthe= ( .50)*std::acos( C);
               }
               double aa= ( R +sgnx*(1.16619))*( R +sgnx*(1.16619));
               CM(2,4)= aa;
               CM(4,2)= aa;
               for(int j=-1;j< 2;j+=2){
                  double f= double(j);
                  Coordinates dx;
                  {
                     double lam=( gam -f*sgnx*alp);
                     if( j==1 ){
                     }else{
                        lam-=physics_consts.PI;
                     }
                     dx(0)= (0.00);
                     dx(1)= ( 1.488)*std::cos( lam);
                     dx(2)= ( 1.488)*std::sin( lam);
                  }
                  Coordinates m,n;      //target plane, peptide plane
                  {
                     double pR=( R +sgnx*(1.16619)*SSgam);
                     double pthe= (-.50)*dthe*SSgam;
                     double Cpthe= std::cos( pthe);
                     double Spthe= std::sin( pthe);
                     double pz= ( .50)*dz*CCgam;
                     m(0)=-pR*pthe*Spthe;
                     m(1)= pR*pthe*Cpthe;
                     m(2)= pz;
                     m.normalize();
                     n(0)= f*sgnx*(1.16619)*SSgam;
                     n(1)= -std::sqrt( cc -(1.16619)*(1.16619))*SSgam;
                     n(2)= pz;
                     n.normalize();
                  }
                  double Cphi= dot(m,n);
                  double Sphi=-f*sgnx*std::sqrt( (1.00) -Cphi*Cphi);
                  double phi= std::atan2(Sphi,Cphi);
////         Cphi= (1.00);
////         Sphi= (0.00);
////         phi= (0.00);
                  Rotation_Matrix Q;
                  Q(0,0)= Cphi;
                  Q(1,0)= Sgam*Sphi;
                  Q(2,0)=-Cgam*Sphi;
                  Q(0,1)=-Sgam*Sphi;
                  Q(1,1)=( SSgam*Cphi +CCgam);
                  Q(2,1)=-CSgam*( Cphi -(1.));
                  Q(0,2)= Cgam*Sphi;
                  Q(1,2)=-CSgam*( Cphi -(1.));
                  Q(2,2)=( CCgam*Cphi +SSgam);
                  dx=Q*dx;
                  double xx=( dx(0)*dx(0) +dx(1)*dx(1));
                  double yy=( dx(0)*dx(0)
                                +std::pow( ( (1.90)*Cgam -f*dx(1)), 2));
                  CM(1,2)= xx;
                  CM(2,1)= xx;
                  CM(1,3)= yy;
                  CM(3,1)= yy;
                  double zz= IGO_CAYLEY_MENGER(out,( dx(0)<=(0.00) ));
                  double z= std::sqrt( zz);
                  double qR=( z -R);
                  double p;
                  double qthe( 0.00);
                  if( aa>zz ){
                     p=( aa -xx +zz)/((2.)*( R +sgnx*(1.16619)));
                     qthe= f*std::acos( p/z);
                  }else{
                     p=( aa -xx +zz)/((2.)*z);
                     qthe= f*std::acos( p/( R +sgnx*(1.16619)));
                  }
                  double qz= dx(2);
                  Coordinates a;
                  a(0)=( R +qR)*std::cos( qthe);
                  a(1)=( R +qR)*std::sin( qthe);
                  a(2)= qz;
                  if( j==1 ){
                     R0[iR0].xc=( trans +rot*a);
                  }else{
                     R0[iR0].xn=( trans +rot*a);
                  }
               }
               sgnx=-sgnx;
            }
         }
//
// place xsc relative to bb
//
//
         for(int iR0=(aR0+ 1);iR0<bR0;iR0++){
            Coordinates z=( R0[iR0].xca -R0[iR0].xn).normalize();
            Coordinates x=( R0[iR0].xc -R0[iR0].xca);
            double xz= dot(x,z);
            x-=xz*z;
            x.normalize();
            Coordinates y=cross(z,x);
            double the=( physics_consts.PI -physics_consts.RAD*( 109.50));
            double Cthe= std::cos( the);
            double Sthe= std::sin( the);
            double phi= physics_consts.RAD*(-123.53);
            double Cphi= std::cos( phi);
            double Sphi= std::sin( phi);
            Coordinates b;
            b(0)= Sthe*Cphi;
            b(1)= Sthe*Sphi;
            b(2)= Cthe;
            R0[iR0].xsc=( R0[iR0].xca +b(0)*x +b(1)*y +b(2)*z);
         }
         for(int iR0=(aR0+ 1);iR0<bR0;iR0++){
            for(int jR0= 0;jR0<oR0;jR0++){
               if( !vv.R0sub(jR0) )continue;
               double rr=( R0[jR0].xca -R0[iR0].xca).rr();
               if( rr<( 7.84) ){
                  nolp++;
                  if( nolp>4 ){
//                   out.FILE3<<"OVERLAP LOOP-CORE\n";
                     return true;
                  }
               }
               if( R0[iR0].lnk==jR0 ){
                  double ss=( R0[jR0].xsc -R0[iR0].xsc).rr();
                  if( ss>(100.00) ){
//                   out.FILE3<<"CROSSLINK LOOP-CORE r="
//                            <<std::fixed<<std::setprecision( 2)
//                            <<std::setw( 6)<<std::sqrt(ss)
//                            <<'\n';
                     return true;
                  }
               }
            }
         }
      }
//
      aR0=G7[iG7].nR0;
   }
//
//
// C-terminal segment bb and sc site coords
//
   if( aR0<(oR0- 1) ){
      double R= (5.00);
      double dz= ( 2.70);
      double Sbet= dz/(3.);
      double Cbet= std::sqrt( (1.00) -Sbet*Sbet);
      double dthe= (3.)*Cbet/R;
      int nolp=0;
      Rotation_Matrix rot;
      Coordinates trans;
      {
         Coordinates u=( xcor -R0[aR0].xca);
         Coordinates z= R0[aR0].nca;
         Coordinates x=cross(z,u);
         double rr= x.rr();
         if( rr<( 1.00e-10) ){
//          out.FILE3<<"LOOP GEN FAILURE\n";
            return true;
         }
         double r= std::sqrt( rr);
         x/=r;
         Coordinates y=cross(z,x);
         for(int i=0;i<3;i++){
            rot(i,0)= x(i);
            rot(i,1)= y(i);
            rot(i,2)= z(i);
         }
         trans=( R0[aR0].xca -R*x);
      }
      double sgnx= (-1.00)*(R0[aR0].del
                 /std::abs( R0[aR0].del));
      double Sgam= dz/(3.80);
      double SSgam= Sgam*Sgam;
      double Cgam= std::sqrt( (1.00) -SSgam);
      double CCgam= Cgam*Cgam;
      double CSgam= Cgam*Sgam;
      double gam= std::atan2(Sgam,Cgam);
      double alp= physics_consts.RAD*(  17.771);
      double bb= R*R;
      double cc= (1.90)*Cgam*(1.90)*Cgam;
      CM(3,4)= bb;
      CM(4,3)= bb;
      CM(2,3)= cc;
      CM(3,2)= cc;
      CM(1,4)= (1.00);
      CM(4,1)= (1.00);
//
      for(int iR0=(aR0+ 1);iR0<oR0;iR0++){
         double the=( double(iR0-aR0)*dthe);
         double Cthe= std::cos( the);
         double Sthe= std::sin( the);
         Coordinates a;
         a(0)=( R +sgnx*(1.16619))*Cthe;
         a(1)=( R +sgnx*(1.16619))*Sthe;
         a(2)= double(iR0-aR0)*dz;
         Coordinates b;
         b(0)=( R +sgnx*(3.41619))*Cthe;
         b(1)=( R +sgnx*(3.41619))*Sthe;
         b(2)= double(iR0-aR0)*dz;
         R0[iR0].xca=( trans +rot*a);
         R0[iR0].xsc=( trans +rot*b);
         double aa= ( R +sgnx*(1.16619))*( R +sgnx*(1.16619));
         CM(2,4)= aa;
         CM(4,2)= aa;
         for(int j=-1;j< 2;j+=2){
            double f= double(j);
            Coordinates dx;
            {
               double lam=( gam -f*sgnx*alp);
               if( j==1 ){
               }else{
                  lam-=physics_consts.PI;
               }
               dx(0)= (0.00);
               dx(1)= ( 1.488)*std::cos( lam);
               dx(2)= ( 1.488)*std::sin( lam);
            }
            Coordinates m,n;      //target plane, peptide plane
            {
               double pR=( R +sgnx*(1.16619)*SSgam);
               double pthe= (-.50)*dthe*SSgam;
               double Cpthe= std::cos( pthe);
               double Spthe= std::sin( pthe);
               double pz= ( .50)*dz*CCgam;
               m(0)=-pR*pthe*Spthe;
               m(1)= pR*pthe*Cpthe;
               m(2)= pz;
               m.normalize();
               n(0)= f*sgnx*(1.16619)*SSgam;
               n(1)= -std::sqrt( cc -(1.16619)*(1.16619))*SSgam;
               n(2)= pz;
               n.normalize();
            }
            double Cphi= dot(m,n);
            double Sphi=-f*sgnx*std::sqrt( (1.00) -Cphi*Cphi);
            double phi= std::atan2(Sphi,Cphi);
            Rotation_Matrix Q;
            Q(0,0)= Cphi;
            Q(1,0)= Sgam*Sphi;
            Q(2,0)=-Cgam*Sphi;
            Q(0,1)=-Sgam*Sphi;
            Q(1,1)=( SSgam*Cphi +CCgam);
            Q(2,1)=-CSgam*( Cphi -(1.));
            Q(0,2)= Cgam*Sphi;
            Q(1,2)=-CSgam*( Cphi -(1.));
            Q(2,2)=( CCgam*Cphi +SSgam);
            dx=Q*dx;
            double xx=( dx(0)*dx(0) +dx(1)*dx(1));
            double yy=( dx(0)*dx(0)
                       +std::pow( ( (1.90)*Cgam -f*dx(1)), 2));
            CM(1,2)= xx;
            CM(2,1)= xx;
            CM(1,3)= yy;
            CM(3,1)= yy;
            double zz= IGO_CAYLEY_MENGER(out,( dx(0)<=(0.00) ));
            double z= std::sqrt( zz);
            double qR=( z -R);
            double p;
            double qthe( 0.00);
            if( aa>zz ){
               p=( aa -xx +zz)/((2.)*( R +sgnx*(1.16619)));
               qthe= f*std::acos( p/z);
            }else{
               p=( aa -xx +zz)/((2.)*z);
               qthe= f*std::acos( p/( R +sgnx*(1.16619)));
            }
            double qz= dx(2);
            a(0)=( R +qR)*std::cos( the +qthe);
            a(1)=( R +qR)*std::sin( the +qthe);
            a(2)= double(iR0-aR0)*dz +qz;
            if( j==1 ){
               R0[iR0].xc=( trans +rot*a);
            }else{
               R0[iR0].xn=( trans +rot*a);
            }
         }
         for(int jR0= 0;jR0<oR0;jR0++){
            if( !vv.R0sub(jR0) )continue;
            double rr=( R0[jR0].xca -R0[iR0].xca).rr();
            if( rr<(7.84) ){
               nolp++;
               if( nolp>4 ){
//                out.FILE3<<"OVERLAP END-CORE\n";
                  return true;
               }
            }
            if( R0[iR0].lnk==jR0 ){
               double ss=( R0[jR0].xsc -R0[iR0].xsc).rr();
               if( ss>(144.00) ){
//                out.FILE3<<"CROSSLINK END-CORE r="
//                         <<std::fixed<<std::setprecision( 2)
//                         <<std::setw( 6)<<std::sqrt(ss)
//                         <<'\n';
                  return true;
               }
            }
         }
         sgnx=-sgnx;
      }
   }
   for(int iR0= 0;iR0<(oR0- 1);iR0++){
      if( vv.R0sub(iR0) )continue;
      for(int jR0=(iR0+ 1);jR0<oR0;jR0++){
         if( vv.R0sub(jR0) )continue;
         if( R0[iR0].lnk==jR0 ){
            double ss=( R0[jR0].xsc -R0[iR0].xsc).rr();
            if( ss>(144.00) ){
//             out.FILE3<<"CROSSLINK LOOP-LOOP r="
//                      <<std::fixed<<std::setprecision( 2)
//                      <<std::setw( 6)<<std::sqrt(ss)
//                      <<'\n';
               return true;
            }
         }
      }
   }
//
// calc Fm
// e2= integration of energy(bohr) density from R(angstrom)=[ 3.0, inf]
//
   double f2= std::pow(( .400), 4);
   double f3= ( .400);
   double Fm2( 0.00),Fm3( 0.00);
   for(int iR0= 0;iR0<oR0;iR0++){
      if( R0[iR0].zet==0 )continue;
      double e2=(  .10756);
//    Fm2+=(f2*e2);
      Fm3-=(( .0625)*f3*e2);
      double e3=(  0.00);
      for(int kR0= 0;kR0<oR0;kR0++){
         if( kR0==iR0 )continue;
         if( R0[kR0].kap==0 )continue;
         int l=R0[kR0].kap;
         double rik=( R0[kR0].xsc -R0[iR0].xsc).r();
         int j=int( std::floor(( rik -( 2.95))/( .10)));
         if      ( j<  0 ){
            j= 0;
            e3+=( .25)*e2;
         }else if( j>390 ){
            continue;
         }
         e3+=igor_data.GKe3(j,l);
      }
      for(int kR0= 0;kR0<oR0;kR0++){
         double rik=( kR0==iR0 )?(  3.25):
                                 ( R0[kR0].xca -R0[iR0].xsc).r();
         int j=int( std::floor(( rik -( 2.95))/( .10)));
         if      ( j<  0 ){
            j= 0;
            e3+=( .25)*e2;
         }else if( j>390 ){
            continue;
         }
         e3+=igor_data.GKe3(j,3);
      }
      if( e3> e2 )e3= e2;
      Fm2-=(f2*e3);
      double x= (e3/e2);
      double a= (3.00)*( (1.00) -x);
      double b= std::exp( a*std::log( ( .400)));
      vv.R0fb(iR0)= std::sqrt( b);
      Fm3+=(f3*vv.R0fb(iR0)*vv.R0fb(iR0)*e3);
   }
   for(int iR0= 0;iR0<(oR0- 1);iR0++){
      if( R0[iR0].zet==0 )continue;
      for(int jR0=(iR0+ 1);jR0<oR0;jR0++){
         if( R0[jR0].zet==0 )continue;
//
         double sgn= double( R0[jR0].zet*R0[iR0].zet);
         Coordinates nij=( R0[jR0].xsc -R0[iR0].xsc);
         double rij= nij.r();
         nij/=rij;
         double dr=( vv.R0dr(iR0) +vv.R0dr(jR0));
         rij+=(sgn*dr);
         int i=int( std::floor(( rij -( 2.95))/( .10)));
         if      ( i<  0 ){
            i= 0;
         }else if( i>390 ){
            continue;
         }
         double e2= igor_data.Ge2(i);
         Fm2+=((2.)*f2*sgn*e2);
//
         double e3=(  0.00);
         for(int kR0= 0;kR0<oR0;kR0++){
            if( kR0==iR0 )continue;
            if( kR0==jR0 )continue;
            if( R0[kR0].kap==0 )continue;
            int l=R0[kR0].kap;
            Coordinates nik=( R0[kR0].xsc -R0[iR0].xsc);
            double rik= nik.r();
            nik/=rik;
            int j=int( std::floor(( rik -( 2.95))/( .10)));
            if      ( j<  0 ){
               j= 0;
            }else if( j>390 ){
               continue;
            }
            double Cthe= dot(nij,nik);
            double the= std::acos( Cthe)/physics_consts.RAD;
            int k=int( std::floor( ( .50) +the));
            e3+=igor_data.GGGKe3(i,j,k,l);
         }
         for(int kR0= 0;kR0<oR0;kR0++){
            if( kR0==iR0 )continue;
            if( kR0==jR0 )continue;
            Coordinates nik=( R0[kR0].xca -R0[iR0].xsc);
            double rik= nik.r();
            nik/=rik;
            int j=int( std::floor(( rik -( 2.95))/( .10)));
            if      ( j<  0 ){
               j= 0;
            }else if( j>390 ){
               continue;
            }
            double Cthe= dot(nij,nik);
            double the= std::acos( Cthe)/physics_consts.RAD;
            int k=int( std::floor( ( .50) +the));
            e3+=igor_data.GGGKe3(i,j,k,3);
         }
         if( e3> e2 )e3= e2;
         Fm2-=((2.)*f2*sgn*e3);
         Fm3+=((2.)*f3*vv.R0fb(iR0)*vv.R0fb(jR0)*sgn*e3);
      }
   }
   Fm2*=(physics_consts.CAL*( -.50));
   Fm3*=(physics_consts.CAL*( -.25));
   Fm=( Fm2 +Fm3);
//
//
// calc Fh
//
   for(int iR0= 0;iR0<oR0;iR0++){
      vv.R0n(iR0)=( R0[iR0].xsc -R0[iR0].xca).normalize();
      int iL1=R0[iR0].L1;
      int i=igor_data.L1[iL1].doc;
      double f= ( 0.00);
      if( i> 0 ){
         if( vv.R0sub(iR0) ){
            f= double( i)*( .32);
         }else{
         }
      }else{
         if( vv.R0sub(iR0) ){
         }else{
            f= (-.50);
         }
      }
      vv.R0t(iR0)=( R0[iR0].xsc -xcor +f*vv.R0n(iR0));
   }
   Fh= (0.00);
   for(int iR0= 0;iR0<oR0;iR0++){ // hydrophobic&core
      int iL1=R0[iR0].L1;
      int i=igor_data.L1[iL1].doc;
      if( i<=0 )continue;
      if( !vv.R0sub(iR0) ){
         Fh+=double( i)*( .20);
      }else{
         bool BURIED=false;
         for(int jR0= 0;jR0<oR0&&(!BURIED);jR0++){
            if( jR0==iR0 )continue;
            int jL1=R0[jR0].L1;
            int j=igor_data.L1[jL1].doc;
            if( j< 0 )continue;
            if( dot( vv.R0n(jR0), vv.R0n(iR0))>=(   0.00) )continue;
            double d=( vv.R0t(jR0) -vv.R0t(iR0)).r();
            double s=( vv.R0sub(jR0) )? (4.00): (3.30);
            if( d<s ){
               BURIED=true;
            }
         }
         if( BURIED ){
            Fh+=double( i)*( .55);
         }else{
            Fh+=double( i)*(-.35);
         }
      }
   }
   for(int iR0= 0;iR0<oR0;iR0++){ // chg&core
      if( R0[iR0].zet==0 )continue;
      if( !vv.R0sub(iR0) ){
      }else{
         bool BURIED=false;
         for(int jR0= 0;jR0<oR0&&(!BURIED);jR0++){
            if( jR0==iR0 )continue;
            if( R0[jR0].zet!=0 )continue;
            if( dot( vv.R0n(jR0), vv.R0n(iR0))>=(   0.00) )continue;
            double d=( vv.R0t(jR0) -vv.R0t(iR0)).r();
            double s=( vv.R0sub(jR0) )? (4.00): (3.30);
            if( d<s ){
               BURIED=true;
            }
         }
         if( BURIED ){
            Fh-=( 1.40);
         }else{
         }
      }
   }
   for(int iR0= 0;iR0<oR0;iR0++){ // nonchg&core
      if( R0[iR0].zet!=0 )continue;
      if( !vv.R0sub(iR0) ){
      }else{
         double e2=(  .10756);
         double e3=(  0.00);
         for(int jR0= 0;jR0<oR0;jR0++){
            if( jR0==iR0 )continue;
            double rij=( R0[jR0].xca -R0[iR0].xca).r();
            if( rij<( 3.80) )rij= ( 3.80);
            if( rij>(42.00) )continue;
            int j=int( std::floor(( rij -( 2.90))/( .20)));
            e3+=igor_data.GKe3(j,4);
         }
         if( e3>e2 )e3= e2;
         Fh+=(( .15)*e3/e2);
      }
   }
   for(int iR0= 0;iR0<oR0;iR0++){ // chg&core
      if( R0[iR0].zet==0 )continue;
      if( !vv.R0sub(iR0) ){
      }else{
         double e= (0.00);
         for(int i=0;i<3;i++){
            e+=vv.R0t(iR0)(i)*vv.R0t(iR0)(i)/xsig(i);
         }
// ln( 2)/6
         double z= std::exp( -( .1155)*e);
         double f= ( 1.00)/( ( 1.00e-6) +vv.R0t(iR0).r());
         Fh+=( .25)*( dot( vv.R0n(iR0), f*vv.R0t(iR0)) -z);
      }
   }
//
// if( NATIVE ){
//    out.FILE2<<std::fixed<<std::setprecision( 2);
//    out.FILE2<<"    Fm      2bod    3bod    Fh  \n";
//    out.FILE2<<std::setw( 8)<<Fm
//             <<std::setw( 8)<<Fm2
//             <<std::setw( 8)<<Fm3
//             <<std::setw( 8)<<Fh<<'\n';
// }
   return false;
}
