#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>

bool Igor_Model::IGO_SCO3_WOLP(const DAT_PHYSICS_CONSTS& physics_consts,
                               Output_Streams& out,
                               int pZ9,int lZ9){
   bool BETAHELIX=( M9[ 0].oS9==1 )?  true: false;
//
//
// bod ca and sc coords
//
   for(int iZ9= 0;iZ9<pU9;iZ9++){
      int oK4=Z9[iZ9].oK4;
      if( oK4==1 ){
         int iG7=Z9[iZ9].K4[ 0].G7;
         int mR0=G7[iG7].mR0;
         int nR0=G7[iG7].nR0;
//
         Coordinates z;
         {
            double alp= Z9[iZ9].c(0,0);
            double bet= Z9[iZ9].c(1,0);
            double Calp= std::cos( alp);
            double Salp= std::sin( alp);
            double Cbet= std::cos( bet);
            double Sbet= std::sin( bet);
            z(0)= Calp*Sbet;
            z(1)= Salp*Sbet;
            z(2)= Cbet;
         }
         double d= dot(( Z9[iZ9].K4[ 0].u
                        -Z9[iZ9].t),z);
         Coordinates trans=( Z9[iZ9].t +d*z);
         Rotation_Matrix rot=Z9[iZ9].K4[ 0].r;
//
         double R= (2.278);
         double dthe= physics_consts.PI/(1.80);
         double dz= (1.50);
         double dR=( 2.25);
//
         for(int iR0=mR0;iR0<=nR0;iR0++){
            double the=( double(iR0-mR0)*dthe);
            double Cthe= std::cos( the);
            double Sthe= std::sin( the);
            Coordinates a;
            a(0)= R*Cthe;
            a(1)= R*Sthe;
            a(2)= double(iR0-mR0)*dz;
            Coordinates n;
            n(0)=-dthe*R*Sthe;
            n(1)= dthe*R*Cthe;
            n(2)= dz;
            n.normalize();
            Coordinates b;
            b(0)=( R +dR)*Cthe;
            b(1)=( R +dR)*Sthe;
            b(2)= double(iR0-mR0)*dz +( .50);
            R0[iR0].xca=( trans +rot*a);
            R0[iR0].nca=rot*n;
            R0[iR0].xsc=( trans +rot*b);
            double phi=( the -( .519));
            double Cphi= std::cos( phi);
            double Sphi= std::sin( phi);
            a(0)= (1.576)*Cphi;
            a(1)= (1.576)*Sphi;
            a(2)= double(iR0-mR0)*dz -(1.164);
            R0[iR0].xn=( trans +rot*a);
            phi=( the +( .519));
            Cphi= std::cos( phi);
            Sphi= std::sin( phi);
            a(0)= (1.576)*Cphi;
            a(1)= (1.576)*Sphi;
            a(2)= double(iR0-mR0)*dz +(1.220);
            R0[iR0].xc=( trans +rot*a);
            R0[iR0].del= dR;
         }
//
      }else if( BETAHELIX ){
         for(int iK4= 0;iK4<oK4;iK4++){
            int iG7=Z9[iZ9].K4[iK4].G7;
            int mR0=G7[iG7].mR0;
            int nR0=G7[iG7].nR0;
            double sgnz= double( Z9[iZ9].K4[iK4].sgny);
            double sgny= double( Z9[iZ9].K4[iK4].sgnx);
            double sgnx=-sgny*sgnz;
//
            Rotation_Matrix rot;
            Coordinates trans;
            double R( 0.00),dz( 0.00),dthe( 0.00);
            {
               rot=Z9[iZ9].K4[iK4].r;
               Coordinates x,z;
               for(int i=0;i<3;i++){
                  x(i)= rot(i,0);
                  z(i)= rot(i,2);
               }
               Coordinates u=Z9[iZ9].K4[iK4].u;
               Coordinates v=Z9[iZ9].K4[iK4].v;
               Coordinates t=Z9[iZ9].t;
               double d= dot(( u -t),z);
               trans=( t +d*z);
               R= dot(( u -t),x);
               dz= dot(( v -u),z);
               dz/=double(nR0-mR0);
               double Sbet= dz/(3.);
               double Cbet= sgnz*std::sqrt( (1.00) -Sbet*Sbet);
               dthe= (3.)*Cbet/R;
            }
            double Sgam= dz/(3.80);
            double SSgam= Sgam*Sgam;
            double Cgam= sgnz*std::sqrt( (1.00) -SSgam);
            double CCgam= Cgam*Cgam;
            double CSgam= Cgam*Sgam;
            double gam= std::atan2(Sgam,Cgam);
            double alp= physics_consts.RAD*(  17.771);
            double bb= R*R;
            double cc= (1.90)*Cgam*(1.90)*Cgam;
            CM(3,4)= bb;
            CM(4,3)= bb;
            CM(2,3)= cc;
            CM(3,2)= cc;
            CM(1,4)= (1.00);
            CM(4,1)= (1.00);
//
            for(int iR0=mR0;iR0<=nR0;iR0++){
               double the=( double(iR0-mR0)*dthe);
               double Cthe= std::cos( the);
               double Sthe= std::sin( the);
               Coordinates a;
               a(0)=( R +sgnx*(1.16619))*Cthe;
               a(1)=( R +sgnx*(1.16619))*Sthe;
               a(2)= double(iR0-mR0)*dz;
               Coordinates n;
               n(0)=-dthe*R*Sthe;
               n(1)= dthe*R*Cthe;
               n(2)= dz;
               n.normalize();
               Coordinates b;
               b(0)=( R +sgnx*(3.41619))*Cthe;
               b(1)=( R +sgnx*(3.41619))*Sthe;
               b(2)= double(iR0-mR0)*dz;
               R0[iR0].xca=( trans +rot*a);
               R0[iR0].nca=rot*n;
               R0[iR0].xsc=( trans +rot*b);
               double aa= ( R +sgnx*(1.16619))*( R +sgnx*(1.16619));
               CM(2,4)= aa;
               CM(4,2)= aa;
               for(int j=-1;j< 2;j+=2){
                  double f= double(j);
                  Coordinates dx;
                  {
                     double lam=( gam -f*sgnx*alp);
                     if( j==1 ){
                     }else{
                        lam-=physics_consts.PI;
                     }
                     dx(0)= (0.00);
                     dx(1)= ( 1.488)*std::cos( lam);
                     dx(2)= ( 1.488)*std::sin( lam);
                  }
                  Coordinates m,n;      //target plane, peptide plane
                  {
                     double pR=( R +sgnx*(1.16619)*SSgam);
                     double pthe= (-.50)*dthe*SSgam;
                     double Cpthe= std::cos( pthe);
                     double Spthe= std::sin( pthe);
                     double pz= ( .50)*dz*CCgam;
                     m(0)=-pR*pthe*Spthe;
                     m(1)= pR*pthe*Cpthe;
                     m(2)= pz;
                     m.normalize();
                     n(0)= f*sgnx*(1.16619)*SSgam;
                     n(1)= -sgnz*std::sqrt( cc -(1.16619)*(1.16619))*SSgam;
                     n(2)= pz;
                     n.normalize();
                  }
                  double Cphi= dot(m,n);
                  double Sphi=-f*sgnx*std::sqrt( (1.00) -Cphi*Cphi);
                  double phi= std::atan2(Sphi,Cphi);
                  Rotation_Matrix Q;
                  Q(0,0)= Cphi;
                  Q(1,0)= Sgam*Sphi;
                  Q(2,0)=-Cgam*Sphi;
                  Q(0,1)=-Sgam*Sphi;
                  Q(1,1)=( SSgam*Cphi +CCgam);
                  Q(2,1)=-CSgam*( Cphi -(1.));
                  Q(0,2)= Cgam*Sphi;
                  Q(1,2)=-CSgam*( Cphi -(1.));
                  Q(2,2)=( CCgam*Cphi +SSgam);
                  dx=Q*dx;
                  double xx=( dx(0)*dx(0) +dx(1)*dx(1));
                  double yy=( dx(0)*dx(0)
                             +std::pow( ( (1.90)*Cgam -f*dx(1)), 2));
                  CM(1,2)= xx;
                  CM(2,1)= xx;
                  CM(1,3)= yy;
                  CM(3,1)= yy;
                  double zz= IGO_CAYLEY_MENGER(out,( dx(0)<=(0.00) ));
                  double z= std::sqrt( zz);
                  double qR=( z -R);
                  double p;
                  double qthe( 0.00);
                  if( aa>zz ){
                     p=( aa -xx +zz)/((2.)*( R +sgnx*(1.16619)));
                     qthe= f*sgnz*std::acos( p/z);
                  }else{
                     p=( aa -xx +zz)/((2.)*z);
                     qthe= f*sgnz*std::acos( p/( R +sgnx*(1.16619)));
                  }
                  double qz= dx(2);
                  a(0)=( R +qR)*std::cos( the +qthe);
                  a(1)=( R +qR)*std::sin( the +qthe);
                  a(2)= double(iR0-mR0)*dz +qz;
                  if( j==1 ){
                     R0[iR0].xc=( trans +rot*a);
                  }else{
                     R0[iR0].xn=( trans +rot*a);
                  }
               }
               R0[iR0].del= (2.25)*sgnx;
               sgnx=-sgnx;
            }
         }
//
      }else{
         for(int iK4= 0;iK4<oK4;iK4++){
            int iG7=Z9[iZ9].K4[iK4].G7;
            int mR0=G7[iG7].mR0;
            int nR0=G7[iG7].nR0;
//
            Coordinates trans=Z9[iZ9].K4[iK4].u;
            Rotation_Matrix rot=Z9[iZ9].K4[iK4].r;
//
            double dz= (3.00);
            double sgnz= double( Z9[iZ9].K4[iK4].sgny);
            double sgny= double( Z9[iZ9].K4[iK4].sgnx);
            double sgnx= sgny*sgnz;
            double Cbet= ( .78947);
            double Sbet= ( .61378);
            double Cdel= ( .94767);
            double Sdel= ( .31924);
//
            for(int iR0=mR0;iR0<=nR0;iR0++){
               Coordinates a;
               a(0)= ( 1.16619)*sgnx;
               a(1)=( 0.00);
               a(2)= double(iR0-mR0)*sgnz*dz;
               R0[iR0].xca=( trans +rot*a);
               for(int i=0;i<3;i++){
                  R0[iR0].nca(i)= sgnz*rot(i,2);
               }
               Coordinates b;
               b(0)=( ( 1.16619) +( 2.25))*sgnx;
               b(1)=( 0.00);
               b(2)= double(iR0-mR0)*sgnz*dz;
               R0[iR0].xsc=( trans +rot*b);
               a(0)=( ( 1.16619) -( 1.453)*Sbet*Cdel)*sgnx;
               a(1)= ( 1.453)*Sdel*sgny;
               a(2)=( double(iR0-mR0)*dz -( 1.453)*Cbet*Cdel)*sgnz;
               R0[iR0].xn=( trans +rot*a);
               b(0)=( ( 1.16619) -( 1.522)*Sbet*Cdel)*sgnx;
               b(1)= ( 1.522)*Sdel*sgny;
               b(2)=( double(iR0-mR0)*dz +( 1.522)*Cbet*Cdel)*sgnz;
               R0[iR0].xc=( trans +rot*b);
               R0[iR0].del= ( 2.25)*sgnx;
               sgny=-sgny;
               sgnx=-sgnx;
            }
         }
//
      }
   }
   if( pU9== 1 )return false;
//
//
// element overlap constraint
//
   int oiK4=Z9[pZ9].oK4;
   int ojK4=Z9[lZ9].oK4;
   int n=0;
   bool OVERLAP=false;
   for(int iK4= 0;iK4<oiK4&&(!OVERLAP);iK4++){
      int iG7=Z9[pZ9].K4[iK4].G7;
      int mR0=G7[iG7].mR0;
      int nR0=G7[iG7].nR0;
      for(int jK4= 0;jK4<ojK4&&(!OVERLAP);jK4++){
         int jG7=Z9[lZ9].K4[jK4].G7;
         int aR0=G7[jG7].mR0;
         int bR0=G7[jG7].nR0;
         for(int iR0=mR0;iR0<=nR0&&(!OVERLAP);iR0++){
            for(int jR0=aR0;jR0<=bR0&&(!OVERLAP);jR0++){
               double rr=( R0[jR0].xca -R0[iR0].xca).rr();
               if      ( rr<(1.96) ){  //r<( 1.4)
                  if( NATIVE ){
                     out.FILE3<<"OVERLAP\n";
                  }
                  OVERLAP=true;
               }else if( rr<(7.84) ){  //r<( 2.8)
                  n++;
                  if( n>2 ){
                     if( NATIVE ){
                        out.FILE3<<"OVERLAP\n";
                     }
                     OVERLAP=true;
                  }
               }
               if( R0[iR0].lnk==jR0 ){
                  double ss=( R0[jR0].xsc -R0[iR0].xsc).rr();
                  if( ss>( 64.00) ){
//                   out.FILE3<<"CROSSLINK CORE-CORE r="
//                            <<std::fixed<<std::setprecision( 2)
//                            <<std::setw( 6)<<std::sqrt(ss)
//                            <<'\n';
                     OVERLAP=true;
                  }
               }
            }
         }
      }
   }
   return OVERLAP;
}
