#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Config_Merge.hh"
#include "../igo/Igor_Model.hh"
#include "../igo/Target_Surf.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <vector>
////#include <string>
////#include <fstream>
////#include <cstdlib>
#include <iomanip>
#include <cmath>

////class MEM_numeric {
////private:
////   int oU2;                             //
////   std::vector<double> o_U2chi;         //undisplaced conformation
////   std::vector<double> o_U2del;         //coordinate displacement
////   std::vector<double> o_U2g;           //analytic 1st derivative
////   std::vector<double> o_U2U2a;         //analytic 2nd derivative
////   std::vector<double> o_U2df;          //numeric 1st derivative
////   std::vector<double> o_U2U2dg;        //numeric 2nd derivative
////public:
////   MEM_numeric(int o):
////      oU2(o),
////      o_U2chi(o),
////      o_U2del(o),
////      o_U2g(o),
////      o_U2U2a(o*o),
////      o_U2df(o),
////      o_U2U2dg(o*o)
////   {
////   }
////   double& U2chi(int i){
////      return o_U2chi.at( i);  }
////   double& U2del(int i){
////      return o_U2del.at( i);  }
////   double& U2g(int i){
////      return o_U2g.at( i);  }
////   double& U2U2a(int i,int j){
////      return o_U2U2a.at( i*oU2 +j);  }
////   double& U2df(int i){
////      return o_U2df.at( i);  }
////   double& U2U2dg(int i,int j){
////      return o_U2U2dg.at( i*oU2 +j);  }
////};
//
//
// dock of 2 (oU-1)-bod subsystems
//
bool Igor_Model::IGO_SCO3_W2DOC(const DAT_PHYSICS_CONSTS& physics_consts,
                                const DAT_IGOR_DATA& igor_data,
                                Output_Streams& out,
                                int iY9,
                                int aY9,int aD9,int bY9,int bD9,
                                int pZ9,int lZ9,
                                int pS9,int lS9,
                                int aX,int bX,
                                std::vector<int>& o_XZ9,
                                std::vector<short>& o_Z9A,
                                std::vector<short>& o_Z9B,
                                std::vector<float>& o_Z9e,double& Fp,
                                Coordinates& t,Coordinates& u,
                                Rotation_Matrix& r){
//
//
// shared bod
//
   int gS9=U9[pU9].Y9[iY9].Z9[o_XZ9[ 1]].S9;
   bool SHEET=( M9[ 0].S9[gS9].oK4> 1 );
   int iB4(-1),jB4(-1);
   if      ( o_XZ9[ 0]==pZ9 ){
      short i=o_Z9B[o_XZ9[ 0]];
      iB4=( i/256);
      short j=o_Z9A[o_XZ9[ 2]];
      jB4=( j/256);
   }else if( o_XZ9[ 0]==lZ9 ){
      short j=o_Z9B[o_XZ9[ 0]];
      jB4=( j/256);
      short i=o_Z9A[o_XZ9[ 2]];
      iB4=( i/256);
   }
   int iW4=M9[ 0].S9[gS9].B4[iB4].W4;
   int jW4=M9[ 0].S9[gS9].B4[jB4].W4;
   int iO1=W4[iW4].O1;
   int iP3=W4[iW4].P3;
   int iR0=W4[iW4].R0;
   int jO1=W4[jW4].O1;
   int jP3=W4[jW4].P3;
   int jR0=W4[jW4].R0;
   int aQo(-1),bQo(-1);         //index of shared bod
   if      ( (aX== 0)&&(bX== 0) ){
      aQo=1;
      bQo=3;
   }else if( (aX== 0)&&(bX==(pU9- 2)) ){
      aQo=1;
      bQo=0;
   }else if( (aX==(pU9- 2))&&(bX== 0) ){
      aQo=0;
      bQo=1;
   }else if( (aX==(pU9- 2))&&(bX==(pU9- 2)) ){
      aQo=2;
      bQo=0;
   }
// if( NATIVE ){
//    out.FILE3<<"SHARED ELEMENT\n";
//    out.FILE3<<" S9[  W4 O  P  R0][  W4 O  P  R0]\n";
//    out.FILE3<<std::setw( 3)<<gS9<<'['
//             <<std::setw( 4)<<iW4
//             <<std::setw( 2)<<iO1
//             <<std::setw( 3)<<iP3
//             <<std::setw( 4)<<iR0<<"]["
//             <<std::setw( 4)<<jW4
//             <<std::setw( 2)<<jO1
//             <<std::setw( 3)<<jP3
//             <<std::setw( 4)<<jR0<<']'<<'\n';
// }
//
//
// local axes of shared bod for 1st and 2nd (pU- 1)-bod
//
   t=Y9[aY9].D9[aD9].Q[aQo].t;
   Rotation_Matrix P=Y9[aY9].D9[aD9].Q[aQo].r;
   u=Y9[bY9].D9[bD9].Q[bQo].t;
   Rotation_Matrix Q=Y9[bY9].D9[bD9].Q[bQo].r;
   double the( 0.00),dy( 0.00),dz( 0.00);
   Rotation_Matrix T;
   if( pU9== 3 ){
      if( SHEET ){
         int oX=W4[iW4].oX;
         int oY=W4[iW4].oY;
         bool iUP=( W4[iW4].N< 4 );
         bool jUP=( W4[jW4].N< 4 );
         if( iUP ){
            if( jUP ){
               dy= double( (jR0/oY) -(iR0/oY))*(5.)
                  -igor_data.O1[jO1].P3[jP3].dy
                  +igor_data.O1[iO1].P3[iP3].dy;
            }else{
               the= physics_consts.PI;
               dy= double( (jR0/oY) -(oX- 1) +(iR0/oY))*(5.)
                  -igor_data.O1[jO1].P3[jP3].dy
                  -igor_data.O1[iO1].P3[iP3].dy;
            }
         }else{
            if( jUP ){
               the= physics_consts.PI;
               dy= double( (jR0/oY) -(oX- 1) +(iR0/oY))*(5.)
                  -igor_data.O1[jO1].P3[jP3].dy
                  -igor_data.O1[iO1].P3[iP3].dy;
            }else{
               dy= double( (jR0/oY) -(iR0/oY))*(5.)
                  -igor_data.O1[jO1].P3[jP3].dy
                  +igor_data.O1[iO1].P3[iP3].dy;
            }
         }
         dz= double( (jR0%oY) -(iR0%oY))*(6.)
            -igor_data.O1[jO1].P3[jP3].dz
            +igor_data.O1[iO1].P3[iP3].dz;
      }else{
         the= double(jR0-iR0)*physics_consts.PI/(1.80)
             -igor_data.O1[jO1].P3[jP3].gam
             +igor_data.O1[iO1].P3[iP3].gam;
         dy=( 0.00);
         dz= double(jR0-iR0)*(1.50)
            -igor_data.O1[jO1].P3[jP3].dz
            +igor_data.O1[iO1].P3[iP3].dz;
      }
      while( the> physics_consts.PI ){
         the-=(2.)*physics_consts.PI;
      }
      while( the<-physics_consts.PI ){
         the+=(2.)*physics_consts.PI;
      }
      double Cthe= std::cos( the);
      double Sthe= std::sin( the);
      T(0,0)= Cthe;
      T(1,0)= Sthe;
      T(2,0)=( 0.00);
      T(0,1)=-Sthe;
      T(1,1)= Cthe;
      T(2,1)=( 0.00);
      T(0,2)=( 0.00);
      T(1,2)=( 0.00);
      T(2,2)=( 1.00);
      P=P*T;
      for(int i=0;i<3;i++){
         u(i)+=( dy*Q(i,1) -dz*Q(i,2));
      }
   }else{
   }
   r=P*transpose(Q);
//
//
// transform element endpoints for 2nd (pU- 1)-bod
//
   Z9.clear();
   Z9.resize(pU9);
   int iZ9=-1;
   int jZ9=-1;
   for(int gZ9= 0;gZ9<pU9;gZ9++){
      gS9=U9[pU9].Y9[iY9].Z9[gZ9].S9;
      int oK4=M9[ 0].S9[gS9].oK4;
      Z9[gZ9].K4.resize(oK4);
      Z9[gZ9].oK4=oK4;
      SHEET=( oK4> 1 );
      if      ( gZ9==(pZ9  ) ){
         iZ9++;
         for(int iK4= 0;iK4<oK4;iK4++){
            Z9[gZ9].K4[iK4].G7=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].G7;
            Z9[gZ9].K4[iK4].X=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].X;
            Z9[gZ9].K4[iK4].Y=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].Y;
            Z9[gZ9].K4[iK4].sgnx=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].sgnx;
            Z9[gZ9].K4[iK4].sgny=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].sgny;
            Z9[gZ9].K4[iK4].u=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].u;
            Z9[gZ9].K4[iK4].v=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].v;
            Z9[gZ9].K4[iK4].r=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].r;
         }
         Z9[gZ9].c=Y9[aY9].D9[aD9].Z9[iZ9].c;
         Z9[gZ9].t=Y9[aY9].D9[aD9].Z9[iZ9].t;
      }else if( gZ9==(lZ9  ) ){
         jZ9++;
         for(int iK4= 0;iK4<oK4;iK4++){
            Z9[gZ9].K4[iK4].G7=Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].G7;
            Z9[gZ9].K4[iK4].X=Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].X;
            Z9[gZ9].K4[iK4].Y=Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].Y;
            Z9[gZ9].K4[iK4].sgnx=Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].sgnx;
            Z9[gZ9].K4[iK4].sgny=Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].sgny;
            Z9[gZ9].K4[iK4].u=( t +r*( Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].u -u));
            Z9[gZ9].K4[iK4].v=( t +r*( Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].v -u));
            Z9[gZ9].K4[iK4].r=r*Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].r;
         }
         Z9[gZ9].c.zero();
         Coordinates x;
         for(int i=0;i<3;i++){
            x(i)= Y9[bY9].D9[bD9].Z9[jZ9].c(i,0);
         }
         Rotation_Matrix QR=transpose(Rotation_Matrix(x));
         x= (transpose(r*QR)).euler();
         for(int i=0;i<3;i++){
            Z9[gZ9].c(i,0)= x(i);
         }
         Z9[gZ9].t=( t +r*( Y9[bY9].D9[bD9].Z9[jZ9].t -u));
      }else{
         iZ9++;
         jZ9++;
         for(int iK4= 0;iK4<oK4;iK4++){
            Z9[gZ9].K4[iK4].G7=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].G7;
            Z9[gZ9].K4[iK4].X=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].X;
            Z9[gZ9].K4[iK4].Y=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].Y;
            Z9[gZ9].K4[iK4].sgnx=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].sgnx;
            Z9[gZ9].K4[iK4].sgny=Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].sgny;
            Z9[gZ9].K4[iK4].u=( .50)*(
                Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].u
               +( t +r*( Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].u -u))
                                       );
            Z9[gZ9].K4[iK4].v=( .50)*(
                Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].v
               +( t +r*( Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].v -u))
                                       );
            Coordinates x,y,z;
            for(int i=0;i<3;i++){
               if( SHEET ){
                  x(i)= Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].r(i,0);
               }else{
                  x(i)= ( .50)*(
                      Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].r(i,0)
                     +(r*Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].r)(i,0)
                                 );
               }
               z(i)= ( .50)*(
                   Y9[aY9].D9[aD9].Z9[iZ9].K4[iK4].r(i,2)
                  +(r*Y9[bY9].D9[bD9].Z9[jZ9].K4[iK4].r)(i,2)
                              );
            }
            z.normalize();
            double d= dot(x,z);
            x-=d*z;
            x.normalize();
            y=cross(z,x);
            for(int i=0;i<3;i++){
               Z9[gZ9].K4[iK4].r(i,0)= x(i);
               Z9[gZ9].K4[iK4].r(i,1)= y(i);
               Z9[gZ9].K4[iK4].r(i,2)= z(i);
            }
         }
         if( pU9== 3 ){
            if      ( (aX== 0)&&(bX== 0) ){
               Z9[gZ9].t=Y9[aY9].D9[aD9].Z9[iZ9].t;
               Z9[gZ9].c=Y9[aY9].D9[aD9].Z9[iZ9].c;
               Z9[gZ9].c(0,2)= the;
               Z9[gZ9].c(1,2)= dy;
               Z9[gZ9].c(2,2)= dz;
//
            }else if( (aX== 0)&&(bX==(pU9- 2)) ){
               Z9[gZ9].t=Y9[aY9].D9[aD9].Z9[iZ9].t;
               Z9[gZ9].c=Y9[aY9].D9[aD9].Z9[iZ9].c;
               Z9[gZ9].c(0,2)= the;
               Z9[gZ9].c(1,2)= dy;
               Z9[gZ9].c(2,2)= dz;
//
            }else if( (aX==(pU9- 2))&&(bX== 0) ){
               Z9[gZ9].c.zero();
               Coordinates ti=Y9[aY9].D9[aD9].Z9[iZ9].t;
               Coordinates ri;
               for(int i=0;i<3;i++){
                  ri(i)= Y9[aY9].D9[aD9].Z9[iZ9].c(i,0);
               }
               Rotation_Matrix QR=transpose(Rotation_Matrix(ri));
               Coordinates xi= transpose(QR*T).euler();
               for(int i=0;i<3;i++){
                  ti(i)+=( QR(i,1)*dy +QR(i,2)*dz);
               }
               Z9[gZ9].t=ti;
               for(int i=0;i<3;i++){
                  Z9[gZ9].c(i,0)= xi(i);
               }
               Z9[gZ9].c(0,2)=-the;
               if( SHEET ){
                  Z9[gZ9].c(1,2)=( std::abs( the)<( 1.00e-2) )?-dy: dy;
               }else{
                  Z9[gZ9].c(1,2)= (0.00);
               }
               Z9[gZ9].c(2,2)=-dz;
//
            }else if( (aX==(pU9- 2))&&(bX==(pU9- 2)) ){
               Z9[gZ9].t=Y9[aY9].D9[aD9].Z9[iZ9].t;
               Z9[gZ9].c=Y9[aY9].D9[aD9].Z9[iZ9].c;
               Z9[gZ9].c(0,2)= the;
               Z9[gZ9].c(1,2)= dy;
               Z9[gZ9].c(2,2)= dz;
//
            }
         }else{
            Z9[gZ9].c.zero();
            Coordinates ti= Y9[aY9].D9[aD9].Z9[iZ9].t;
            Coordinates ri,di;
            for(int i=0;i<3;i++){
               ri(i)= Y9[aY9].D9[aD9].Z9[iZ9].c(i,0);
               di(i)= Y9[aY9].D9[aD9].Z9[iZ9].c(i,2);
            }
            Coordinates tj= Y9[bY9].D9[bD9].Z9[jZ9].t;
            Coordinates rj,dj;
            for(int i=0;i<3;i++){
               rj(i)= Y9[bY9].D9[bD9].Z9[jZ9].c(i,0);
               dj(i)= Y9[bY9].D9[bD9].Z9[jZ9].c(i,2);
            }
            if      ( (aX== 0)&&(bX== 0) ){
               Rotation_Matrix QR=transpose(Rotation_Matrix(rj));
               Rotation_Matrix S;
               double Cthe= std::cos( dj(0));
               double Sthe= std::sin( dj(0));
               S(0,0)= Cthe;
               S(1,0)= Sthe;
               S(2,0)=( 0.00);
               S(0,1)=-Sthe;
               S(1,1)= Cthe;
               S(2,1)=( 0.00);
               S(0,2)=( 0.00);
               S(1,2)=( 0.00);
               S(2,2)=( 1.00);
               Rotation_Matrix QRS=QR*S;
               rj= transpose(QRS).euler();
               for(int i=0;i<3;i++){
                  tj(i)+=( QR(i,1)*dj(1) +QR(i,2)*dj(2));
               }
               dj=-dj;
               if      ( gZ9==o_XZ9[ 1    ] ){
                  QR=transpose(Rotation_Matrix(rj));
                  Cthe= std::cos(-di(0));
                  Sthe= std::sin(-di(0));
                  S(0,0)= Cthe;
                  S(1,0)= Sthe;
                  S(2,0)=( 0.00);
                  S(0,1)=-Sthe;
                  S(1,1)= Cthe;
                  S(2,1)=( 0.00);
                  S(0,2)=( 0.00);
                  S(1,2)=( 0.00);
                  S(2,2)=( 1.00);
                  QRS=QR*S;
                  rj= transpose(QRS).euler();
                  for(int i=0;i<3;i++){
                     tj(i)-=( QRS(i,1)*di(1) +QRS(i,2)*di(2));
                  }
                  dj=di;
               }else if( gZ9==o_XZ9[pU9- 2] ){
                  di=dj;
               }else{
               }
//
            }else if( (aX== 0)&&(bX==(pU9- 2)) ){
               if      ( gZ9==o_XZ9[ 1    ] ){
                  Rotation_Matrix QR=transpose(Rotation_Matrix(rj));
                  Rotation_Matrix S;
                  double Cthe= std::cos(-di(0));
                  double Sthe= std::sin(-di(0));
                  S(0,0)= Cthe;
                  S(1,0)= Sthe;
                  S(2,0)=( 0.00);
                  S(0,1)=-Sthe;
                  S(1,1)= Cthe;
                  S(2,1)=( 0.00);
                  S(0,2)=( 0.00);
                  S(1,2)=( 0.00);
                  S(2,2)=( 1.00);
                  Rotation_Matrix QRS=QR*S;
                  rj= transpose(QRS).euler();
                  for(int i=0;i<3;i++){
                     tj(i)-=( QRS(i,1)*di(1) +QRS(i,2)*di(2));
                  }
                  dj=di;
               }else if( gZ9==o_XZ9[pU9- 2] ){
                  di=dj;
               }else{
               }
//
            }else if( (aX==(pU9- 2))&&(bX== 0) ){
               if      ( gZ9==o_XZ9[ 1    ] ){
                  Rotation_Matrix QR=transpose(Rotation_Matrix(ri));
                  Rotation_Matrix S;
                  double Cthe= std::cos(-dj(0));
                  double Sthe= std::sin(-dj(0));
                  S(0,0)= Cthe;
                  S(1,0)= Sthe;
                  S(2,0)=( 0.00);
                  S(0,1)=-Sthe;
                  S(1,1)= Cthe;
                  S(2,1)=( 0.00);
                  S(0,2)=( 0.00);
                  S(1,2)=( 0.00);
                  S(2,2)=( 1.00);
                  Rotation_Matrix QRS=QR*S;
                  ri= transpose(QRS).euler();
                  for(int i=0;i<3;i++){
                     ti(i)-=( QRS(i,1)*dj(1) +QRS(i,2)*dj(2));
                  }
                  di=dj;
               }else if( gZ9==o_XZ9[pU9- 2] ){
                  dj=di;
               }else{
               }
//
            }else if( (aX==(pU9- 2))&&(bX==(pU9- 2)) ){
               Rotation_Matrix QR=transpose(Rotation_Matrix(ri));
               Rotation_Matrix S;
               double Cthe= std::cos( di(0));
               double Sthe= std::sin( di(0));
               S(0,0)= Cthe;
               S(1,0)= Sthe;
               S(2,0)=( 0.00);
               S(0,1)=-Sthe;
               S(1,1)= Cthe;
               S(2,1)=( 0.00);
               S(0,2)=( 0.00);
               S(1,2)=( 0.00);
               S(2,2)=( 1.00);
               Rotation_Matrix QRS=QR*S;
               ri= transpose(QRS).euler();
               for(int i=0;i<3;i++){
                  ti(i)+=( QR(i,1)*di(1) +QR(i,2)*di(2));
               }
               di=-di;
               if      ( gZ9==o_XZ9[ 1    ] ){
                  QR=transpose(Rotation_Matrix(rj));
                  Cthe= std::cos(-di(0));
                  Sthe= std::sin(-di(0));
                  S(0,0)= Cthe;
                  S(1,0)= Sthe;
                  S(2,0)=( 0.00);
                  S(0,1)=-Sthe;
                  S(1,1)= Cthe;
                  S(2,1)=( 0.00);
                  S(0,2)=( 0.00);
                  S(1,2)=( 0.00);
                  S(2,2)=( 1.00);
                  QRS=QR*S;
                  rj= transpose(QRS).euler();
                  for(int i=0;i<3;i++){
                     tj(i)-=( QRS(i,1)*di(1) +QRS(i,2)*di(2));
                  }
                  dj=di;
               }else if( gZ9==o_XZ9[pU9- 2] ){
                  di=dj;
               }else{
               }
//
            }
            Coordinates xj= (Rotation_Matrix(rj)*transpose(r)).euler();
            double dalp=( xj(0) -ri(0));
            if      ( dalp<-physics_consts.PI ){
               xj(0)+=(2.)*physics_consts.PI;
            }else if( dalp> physics_consts.PI ){
               xj(0)-=(2.)*physics_consts.PI;
            }
            double dgam=( xj(2) -ri(2));
            if      ( dgam<-physics_consts.PI ){
               xj(2)+=(2.)*physics_consts.PI;
            }else if( dgam> physics_consts.PI ){
               xj(2)-=(2.)*physics_consts.PI;
            }
            for(int i=0;i<3;i++){
               Z9[gZ9].c(i,0)=( .50)*( ri(i) +xj(i));
               Z9[gZ9].c(i,2)= di(i);
            }
            Z9[gZ9].t=( .50)*( ti +( t +r*( tj -u)));
         }
      }
   }
//
//
// initiate target func surface
//
   int oU2=( 6*pU9);
   Target_Surf enq(oU2,pU9);
   {
      int iU2=0;
      for(int iX= 0;iX<pU9;iX++){
         int iZ9=o_XZ9[iX];
         enq.XU2(iX)=iU2;
         enq.XZ9(iX)=iZ9;
         for(int i=0;i<3;i++){
            enq.U2chi(iU2  +i)= Z9[iZ9].t(i);
            enq.U2chi(iU2+3+i)= Z9[iZ9].c(i,0);
            enq.U2uca(iU2  +i)= (1.00);
            enq.U2uca(iU2+3+i)= (1.00);
         }
         iU2+=6;
         enq.Xdgam(iX)= Z9[iZ9].c(0,2);
         enq.Xdy(iX)= Z9[iZ9].c(1,2);
         enq.Xdz(iX)= Z9[iZ9].c(2,2);
      }
      for(int iX= 0;iX<(pU9- 1);iX++){
         int iZ9=o_XZ9[iX  ];
         int jZ9=o_XZ9[iX+1];
         double d= (0.00);
         d+=( Z9[iZ9].oK4> 1 )?( 5.00):( 3.75);
         d+=( Z9[jZ9].oK4> 1 )?( 5.00):( 3.75);
         enq.Xr(iX)= d;
         Coordinates zi,zj;
         double alp= Z9[iZ9].c(0,0);
         double bet= Z9[iZ9].c(1,0);
         double Calp= std::cos( alp);
         double Salp= std::sin( alp);
         double Cbet= std::cos( bet);
         double Sbet= std::sin( bet);
         zi(0)= Calp*Sbet;
         zi(1)= Salp*Sbet;
         zi(2)= Cbet;
         alp= Z9[jZ9].c(0,0);
         bet= Z9[jZ9].c(1,0);
         Calp= std::cos( alp);
         Salp= std::sin( alp);
         Cbet= std::cos( bet);
         Sbet= std::sin( bet);
         zj(0)= Calp*Sbet;
         zj(1)= Salp*Sbet;
         zj(2)= Cbet;
         double Cthe= dot(zi,zj);
         enq.Xthe(iX)= std::acos( Cthe)/physics_consts.RAD;
      }
      for(int iX= 0;iX<pU9;iX++){
         int iZ9=o_XZ9[iX];
         double alp= Z9[iZ9].c(0,0);
         double bet= Z9[iZ9].c(1,0);
         double gam= Z9[iZ9].c(2,0);
         Rotation_Matrix r=Rotation_Matrix(alp,bet,gam);
         Coordinates t=Z9[iZ9].t;
         int oK4=Z9[iZ9].oK4;
         for(int iK4= 0;iK4<oK4;iK4++){
            enq.XK4u(iX,iK4)=r*( Z9[iZ9].K4[iK4].u -t);
            enq.XK4v(iX,iK4)=r*( Z9[iZ9].K4[iK4].v- t);
         }
      }
   }
//
//
// perturb starting config for identical patch crosslinks
//
   if( pU9==3 ){
      Coordinates ti,zi;
      int iU2=enq.XU2( 0);
      ti(0)= enq.U2chi(iU2  );
      ti(1)= enq.U2chi(iU2+1);
      ti(2)= enq.U2chi(iU2+2);
      double alp= enq.U2chi(iU2+3);
      double bet= enq.U2chi(iU2+4);
      double gam= enq.U2chi(iU2+5);
      double Calp= std::cos( alp);
      double Salp= std::sin( alp);
      double Cbet= std::cos( bet);
      double Sbet= std::sin( bet);
      double Cgam= std::cos( gam);
      double Sgam= std::sin( gam);
      zi(0)= Calp*Sbet;
      zi(1)= Salp*Sbet;
      zi(2)= Cbet;
      Coordinates tj,zj;
      int jU2=enq.XU2( 2);
      tj(0)= enq.U2chi(jU2  );
      tj(1)= enq.U2chi(jU2+1);
      tj(2)= enq.U2chi(jU2+2);
      alp= enq.U2chi(jU2+3);
      bet= enq.U2chi(jU2+4);
      gam= enq.U2chi(jU2+5);
      Calp= std::cos( alp);
      Salp= std::sin( alp);
      Cbet= std::cos( bet);
      Sbet= std::sin( bet);
      Cgam= std::cos( gam);
      Sgam= std::sin( gam);
      zj(0)= Calp*Sbet;
      zj(1)= Salp*Sbet;
      zj(2)= Cbet;
      if( ( ti -tj).r()<( 1.00e-3) ){
         double C= dot(zi,zj);
         if( (C<(-.999))||(C>( .999)) ){
            enq.U2chi(iU2+1)+=(-1.00e-2);
            enq.U2chi(iU2+4)+=(-1.00e-2);
            enq.U2chi(jU2+1)+=( 1.00e-2);
            enq.U2chi(jU2+4)+=( 1.00e-2);
         }
      }
   }
//
//
// initiate local minimization of target func
//
   int oM2= 256;
   Config_Merge loq(oM2,oU2);
//
//
// local minimization
//
// out.FILE3<<"________________________________________"
//            "________________________________________\n";
   loq.IGO_LOQ(physics_consts,out,enq,G7,Z9, 0);
// loq.IGO_LOQ_WRT(physics_consts,out,enq);
//// out.FILE3<< std::fixed<< std::setprecision(3);
//// out.FILE3<<"[aY9,aD9,bY9,bD9]=["
////          << std::setw( 3)<<aY9
////          << std::setw( 5)<<aD9
////          << std::setw( 3)<<bY9
////          << std::setw( 5)<<bD9<<']'
////          << std::setw( 8)<<enq.Fa
////          << std::setw( 8)<<enq.Fb
////          << std::setw( 8)<<enq.Fc
////          << std::setw( 8)<<enq.Fd
////          << std::setw( 8)<<enq.Fe
////          << std::setw( 8)<<enq.Ff
////          << std::setw( 8)<<enq.Fg<<'\n';
//
//
// update config
//
   if( enq.Ff>( 1.00) ){
//    if( NATIVE ){
//       out.FILE3<<"CHAIN CONNECTIVITY FAIL\n";
//    }
      return true;
   }
   if( enq.Fg>( 1.00) ){
      return true;
   }
   Fp-=enq.Ff;
   o_Z9e[pZ9]-=( .50)*enq.Ff;
   o_Z9e[lZ9]-=( .50)*enq.Ff;
   Fp-=( (  .25)*enq.Fe +( 1.00)*enq.Fg);
   for(int iX= 0;iX<pU9;iX++){
      int iZ9=o_XZ9[iX];
      Coordinates ti,ri;
      for(int i=0;i<3;i++){
         ti(i)= Z9[iZ9].t(i);
         ri(i)= Z9[iZ9].c(i,0);
      }
      Rotation_Matrix pi=Rotation_Matrix(ri);
      Coordinates tj,rj;
      int iU2=enq.XU2(iX);
      for(int i=0;i<3;i++){
         tj(i)= enq.U2chi(iU2  +i);
         rj(i)= enq.U2chi(iU2+3+i);
      }
      Rotation_Matrix pj=Rotation_Matrix(rj);
//
      Rotation_Matrix p=transpose(pj)*pi;
      int oK4=Z9[iZ9].oK4;
      for(int iK4= 0;iK4<oK4;iK4++){
         Z9[iZ9].K4[iK4].u=( tj +p*( Z9[iZ9].K4[iK4].u -ti));
         Z9[iZ9].K4[iK4].v=( tj +p*( Z9[iZ9].K4[iK4].v -ti));
         Z9[iZ9].K4[iK4].r=p*Z9[iZ9].K4[iK4].r;
      }
      for(int i=0;i<3;i++){
         Z9[iZ9].t(i)= tj(i);
         Z9[iZ9].c(i,0)= rj(i);
      }
   }
//
//
// diagnostic output
//
// if( NATIVE ){
//    out.FILE3<<" Z9 K4           u        "
//                     "           v        \n";
//    out.FILE3<<std::fixed<<std::setprecision( 1);
//    for(int iZ9= 0;iZ9<pU9;iZ9++){
//       int oK4=Z9[iZ9].oK4;
//       for(int iK4= 0;iK4<oK4;iK4++){
//          out.FILE3<<std::setw( 3)<<iZ9
//                   <<std::setw( 3)<<iK4<<'[';
//          for(int i=0;i<3;i++){
//             out.FILE3<<std::setw( 6)<<Z9[iZ9].K4[iK4].u(i);
//          }
//          out.FILE3<<"][";
//          for(int i=0;i<3;i++){
//             out.FILE3<<std::setw( 6)<<Z9[iZ9].K4[iK4].v(i);
//          }
//          out.FILE3<<"]\n";
//       }
//    }
// }
////   MEM_numeric vv(oU2);
////   for(int iU2= 0;iU2<oU2;iU2++){
////      vv.U2chi(iU2)= enq.U2chi(iU2);
////      vv.U2del(iU2)= (1.00e-8);
////   }
////   std::string filename="../../test/dgn/numeric";
////   out.FILE1.open(filename.c_str());
//
//
// evaluate undisplaced analytic energy surface
//
//// for(int COMPONENT=1;COMPONENT<9;COMPONENT++){
////   loq.nM2=0;
////   loq.IGO_LOQ(physics_consts,out,enq,G7,Z9,COMPONENT);
////   double F= enq.TOT;
////   for(int iU2= 0;iU2<oU2;iU2++){
////      vv.U2g(iU2)= enq.U2g(iU2);
////      for(int jU2=iU2;jU2<oU2;jU2++){
////         vv.U2U2a(iU2,jU2)= enq.U2U2a(iU2,jU2);
////         vv.U2U2a(jU2,iU2)= enq.U2U2a(iU2,jU2);
////      }
////   }
//
//
// evaluate numeric 1st and 2nd derivatives
//
////   out.FILE1<<" iU2"<<" U2uca"<<"     U2del"
////            <<"  TOT                 |"
////            <<'\n';
////   out.FILE1<<"                    "
////            <<"  .         |         |"
////            <<'\n';
////   for(int iU2= 0;iU2<oU2;iU2++){
////      bool OPTIMAL=false;
////      while( !OPTIMAL ){
////         enq.U2chi(iU2)=( vv.U2chi(iU2) +vv.U2del(iU2));
////         loq.IGO_LOQ(physics_consts,out,enq,G7,Z9,COMPONENT);
////         double df= std::abs(( enq.TOT -F)/F);
////         if      ( (df<( 1.00e-11))&&(vv.U2del(iU2)<( 1.00e-5 )) ){
////            vv.U2del(iU2)*=(2.00);
////         }else if( (df>( 1.00e-10))&&(vv.U2del(iU2)>( 1.00e-10)) ){
////            vv.U2del(iU2)/=(2.00);
////         }else{
////            OPTIMAL=true;
////         }
////      }
////      out.FILE1<< std::setw( 4)<<iU2
////               << std::fixed
////               << std::setprecision( 3)<< std::setw( 6)<<enq.U2uca(iU2)
////               << std::scientific
////               << std::setprecision( 2)<< std::setw(10)<<vv.U2del(iU2)
////               << std::setprecision(16)<< std::setw(23)<<F
////               <<'\n';
////      out.FILE1<<"                    "
////               << std::setprecision(16)<< std::setw(23)<<enq.TOT
////               <<'\n';
////      vv.U2df(iU2)= enq.U2uca(iU2)*( enq.TOT -F)/vv.U2del(iU2);
////      for(int jU2= 0;jU2<oU2;jU2++){
////         vv.U2U2dg(iU2,jU2)= enq.U2uca(iU2)*( enq.U2g(jU2) -vv.U2g(jU2))
////                                           /vv.U2del(iU2);
////      }
////      enq.U2chi(iU2)= vv.U2chi(iU2);
////   }
//
//
// compare numeric 1st and 2nd derivatives with analytic
//
////   out.FILE1<<" iU2"<<"           U2df        "
////                    <<"            U2g       |"<<'\n';
////   for(int iU2= 0;iU2<oU2;iU2++){
////      double zz=( vv.U2df(iU2) -vv.U2g(iU2))/
////                ( std::abs( vv.U2g(iU2)) +( 1.00e-10));
////      out.FILE1<< std::setw( 4)<<iU2
////               << std::setw(23)<<vv.U2df(iU2)
////               << std::setw(23)<<vv.U2g(iU2)
////               << std::setw(23)<<zz<<'\n';
////   }
////   out.FILE1<<" iU2"<<" jU2"<<"         U2U2dg        "
////                            <<"          U2U2a       |"<<'\n';
////   for(int iU2= 0;iU2<oU2;iU2++){
////      for(int jU2= 0;jU2<oU2;jU2++){
////         double zz=( vv.U2U2dg(iU2,jU2) -vv.U2U2a(iU2,jU2))/
////                   ( std::abs( vv.U2U2a(iU2,jU2)) +( 1.00e-10));
////         out.FILE1<< std::setw( 4)<<iU2<< std::setw( 4)<<jU2
////                  << std::setw(23)<<vv.U2U2dg(iU2,jU2)
////                  << std::setw(23)<<vv.U2U2a(iU2,jU2)
////                  << std::setw(23)<<zz<<'\n';
////      }
////   }
////   for(int iU2= 0;iU2<oU2;iU2++){
////      int i=(iU2%6);
////      if( i<3 ){
////         out.FILE1<< std::setw( 4)<<iU2
////                  << std::fixed<< std::setprecision( 8)
////                  << std::setw(13)<<enq.U2chi(iU2)
////                  <<'\n';
////      }else{
////         out.FILE1<< std::setw( 4)<<iU2
////                  << std::fixed<< std::setprecision( 8)
////                  << std::setw(13)<<(enq.U2chi(iU2)/physics_consts.RAD)
////                  <<'\n';
////      }
////   }
//// }
////   out.FILE1.close();
   return false;
}
