#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>
#include <cmath>

class MEM_igo_sco3_w2 {
public:
   std::vector<int> o_Z9E9;     //region of proto elem
   std::vector<int> o_Z9F9;     //bounds of proto elem
   std::vector<char> o_Z9X;     //x position in config
   std::vector<float> o_Z9e;    //energy of alignment resolved wrt bod
   std::vector<short> o_Z9A;    //patch +direction in dock to previous x
   std::vector<short> o_Z9B;    //patch +direction in dock to following x
   std::vector<bool> o_R0sub;   //subset of residues
   std::vector<int> o_XZ9;      //inverse map of Z9X
   std::vector<int> o_Z9Z9;     //map of subset of bods to current set
   std::vector<int> o_Z9S9;     //map of subset to full set
   std::vector<int> o_Z9sub;    //map of current -subset to full set
public:
   MEM_igo_sco3_w2(int z,int r):
      o_Z9E9(z),
      o_Z9F9(z),
      o_Z9X(z),
      o_Z9e(z),
      o_Z9A(z),
      o_Z9B(z),
      o_R0sub(r, false),
      o_XZ9(z),
      o_Z9Z9(z),
      o_Z9S9(z),
      o_Z9sub(z)
   {
   }
   int& Z9E9(int i){
      return o_Z9E9.at( i);  }
   int& Z9F9(int i){
      return o_Z9F9.at( i);  }
   char& Z9X(int i){
      return o_Z9X.at( i);  }
   float& Z9e(int i){
      return o_Z9e.at( i);  }
   short& Z9A(int i){
      return o_Z9A.at( i);  }
   short& Z9B(int i){
      return o_Z9B.at( i);  }
   void R0sub(int i,bool a){
      o_R0sub[ i]=a;  }
   bool R0sub(int i){
      return o_R0sub[ i];  }
   int& XZ9(int i){
      return o_XZ9.at( i);  }
   int& Z9Z9(int i){
      return o_Z9Z9.at( i);  }
   int& Z9S9(int i){
      return o_Z9S9.at( i);  }
   int& Z9sub(int i){
      return o_Z9sub.at( i);  }
};

bool Igor_Model::IGO_SCO3_W2(const DAT_PHYSICS_CONSTS& physics_consts,
                             const DAT_ARRAY_CONSTS& array_consts,
                             const DAT_IGOR_DATA& igor_data,
                             Output_Streams& out){
//
//
// for each oZ-bod subsystem
//
   if( NATIVE ){
      out.FILE3<<std::setw( 2)<<pU9<<"-BOD CONFIGS\n";
   }
   MEM_igo_sco3_w2 vv(pU9,oR0);
   oI9=U9[pU9].oY9;
   I9.clear();
   I9.resize(oI9);
   int jI9=-1;
   int qU9=(pU9- 1);
   int xD9=( pU9== 3 )? 144: 512;
   bool EMPTY=true;
   oY9=U9[qU9].oY9;
   for(int iY9= 0;iY9<(oY9- 1);iY9++){
      for(int jY9=(iY9+ 1);jY9<oY9;jY9++){
         {
            int n=0;
            for(int iZ9= 0;iZ9<qU9;iZ9++){
               for(int jZ9= 0;jZ9<qU9;jZ9++){
                  if( U9[qU9].Y9[jY9].Z9[jZ9].S9==
                      U9[qU9].Y9[iY9].Z9[iZ9].S9 )n++;
               }
            }
            if( n<(qU9- 1) )continue;
         }
         {
            int pZ9=-1;
            for(int iZ9= 0;iZ9<qU9;iZ9++){
               bool MATCH=false;
               for(int jZ9= 0;jZ9<qU9&&(!MATCH);jZ9++){
                  if( U9[qU9].Y9[jY9].Z9[jZ9].S9==
                      U9[qU9].Y9[iY9].Z9[iZ9].S9 )MATCH=true;
               }
               if( !MATCH ){
                  pZ9=iZ9;
                  break;
               }
            }
            if( pZ9<(qU9- 1) )continue;
         }
         jI9++;
         I9[jI9].oZ9=pU9;
//
//       out.FILE3<<"GROUP OF "
//                <<std::setw( 2)<<qU9
//                <<"-BOD SUBSYSTEMS=(";
//       for(int jZ9= 0;jZ9<pU9;jZ9++){
//          out.FILE3<<std::setw( 4)<<U9[pU9].Y9[jI9].Z9[jZ9].Y9
//                   <<(( jZ9<qU9 )? ',': ')');
//          }
//       }
//       out.FILE3<<'\n';
//
//
// restore from backup
//
         bool ADDRESSABLE=true;
         int ii=0;
         for(int iZ9= 0;iZ9<pU9&&( ADDRESSABLE);iZ9++){
            int iS9=U9[pU9].Y9[jI9].Z9[iZ9].S9;
            int oK4=M9[ 0].S9[iS9].oK4;
            if( oK4> 1 ){
               ADDRESSABLE=false;
            }else{
               int iG7=M9[ 0].S9[iS9].K4[ 0].G7;
               int iR0=G7[iG7].mR0;
               int jR0=G7[iG7].nR0;
               int ihf=R0R0hf(iR0,jR0);
               if( ihf>-1 ){
                  vv.Z9E9(iZ9)=(ihf/oF9);
                  vv.Z9F9(iZ9)=(ihf%oF9);
                  if( iZ9> 0 ){
                     if( vv.Z9E9(iZ9   )>vv.Z9E9(iZ9- 1) ){
                        ii+=( vv.Z9F9(iZ9)<<(nF9*vv.Z9E9(iZ9)));
                     }else{
                        ADDRESSABLE=false;
                     }
                  }else{
                     ii+=( vv.Z9F9(iZ9)<<(nF9*vv.Z9E9(iZ9)));
                  }
               }else{
                  ADDRESSABLE=false;
               }
            }
         }
         if( ADDRESSABLE ){
            int pQ9=E9F9Q9(ii);
            if( pQ9>-1 ){
               I9[jI9]=Q9[pQ9];
               int oD9=I9[jI9].oD9;
               for(int iZ9= 0;iZ9<pU9;iZ9++){
                  int iS9=U9[pU9].Y9[jI9].Z9[iZ9].S9;
                  int iG7=M9[ 0].S9[iS9].K4[ 0].G7;
                  for(int iD9= 0;iD9<oD9;iD9++){
                     I9[jI9].D9[iD9].Z9[iZ9].K4[ 0].G7=iG7;
                  }
               }
               continue;
            }
         }
//
//
// for each pair from group of contained (pU- 1)-bod subsystems
//
         int oD9=-1;
         for(int aZ9= 0;aZ9<(pU9- 1);aZ9++){
            int aY9=U9[pU9].Y9[jI9].Z9[aZ9].Y9;
            int oaD9=Y9[aY9].oD9;
            if( oaD9== 0 )continue;
            for(int bZ9=(aZ9+ 1);bZ9<pU9;bZ9++){
               int bY9=U9[pU9].Y9[jI9].Z9[bZ9].Y9;
               int obD9=Y9[bY9].oD9;
               if( obD9== 0 )continue;
//
               int pZ9=(pU9- 1-bZ9);
               int lZ9=(pU9- 1-aZ9);
               int pS9=U9[pU9].Y9[jI9].Z9[pZ9].S9;
               int lS9=U9[pU9].Y9[jI9].Z9[lZ9].S9;
//
//
// merge configs, disallow inconsistency
//
               int nD9=0;
               for(int aD9= 0;aD9<oaD9;aD9++){
                  int aX=Y9[aY9].D9[aD9].Z9[pZ9   ].X;
                  if( (aX!= 0)&&(aX!=(qU9- 1)) )continue;
                  for(int bD9= 0;bD9<obD9;bD9++){
                     int bX=Y9[bY9].D9[bD9].Z9[lZ9- 1].X;
                     if( (bX!= 0)&&(bX!=(qU9- 1)) )continue;
//
                     if( (aD9+bD9)>xD9 )continue;
                     bool CONSISTENT=true;
                     double Fp= (0.00);
                     int iZ9=-1;
                     int jZ9=-1;
                     for(int gZ9= 0;gZ9<pU9;gZ9++){
                        int gS9=U9[pU9].Y9[jI9].Z9[gZ9].S9;
                        if      ( gZ9==(pZ9  ) ){
                           iZ9++;
                           if      ( (aX== 0)&&(bX== 0) ){
                              vv.Z9X(gZ9)= 0;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                              vv.Z9B(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                           }else if( (aX== 0)&&(bX==(qU9- 1)) ){
                              vv.Z9X(gZ9)= 0;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                              vv.Z9B(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                           }else if( (aX==(qU9- 1))&&(bX== 0) ){
                              vv.Z9X(gZ9)=qU9;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                              vv.Z9B(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                           }else if( (aX==(qU9- 1))&&(bX==(qU9- 1)) ){
                              vv.Z9X(gZ9)= 0;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                              vv.Z9B(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                           }
                           vv.Z9e(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].e;
//
                        }else if( gZ9==(lZ9  ) ){
                           jZ9++;
                           if      ( (aX== 0)&&(bX== 0) ){
                              vv.Z9X(gZ9)=qU9;
                              vv.Z9A(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                           }else if( (aX== 0)&&(bX==(qU9- 1)) ){
                              vv.Z9X(gZ9)=qU9;
                              vv.Z9A(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                           }else if( (aX==(qU9- 1))&&(bX== 0) ){
                              vv.Z9X(gZ9)= 0;
                              vv.Z9A(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                           }else if( (aX==(qU9- 1))&&(bX==(qU9- 1)) ){
                              vv.Z9X(gZ9)=qU9;
                              vv.Z9A(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                           }
                           vv.Z9e(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].e;
//
                        }else{
                           iZ9++;
                           jZ9++;
                           int iB4(-1),jB4(-1);
                           if      ( (aX== 0)&&(bX== 0) ){
                              int iX=Y9[aY9].D9[aD9].Z9[iZ9].X;
                              int jX=(qU9-Y9[bY9].D9[bD9].Z9[jZ9].X);
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 break;
                              }
                              if( iX> 1 ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].B!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].A ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              if( jX<(qU9- 1) ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].A!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].B ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              vv.Z9X(gZ9)=iX;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                              vv.Z9e(gZ9)= Y9[aY9].D9[aD9].Z9[iZ9].e;
                              if( pU9== 3 ){
                                 vv.Z9e(gZ9)+=Y9[bY9].D9[bD9].Z9[jZ9].e;
                                 iB4=(Y9[aY9].D9[aD9].Z9[pZ9   ].B/256);
                                 jB4=(Y9[bY9].D9[bD9].Z9[lZ9- 1].B/256);
                              }else if( iX==(qU9- 1) ){
                                 vv.Z9e(gZ9)= Y9[bY9].D9[bD9].Z9[jZ9].e;
                              }
                           }else if( (aX== 0)&&(bX==(qU9- 1)) ){
                              int iX=Y9[aY9].D9[aD9].Z9[iZ9].X;
                              int jX=Y9[bY9].D9[bD9].Z9[jZ9].X+ 1;
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 break;
                              }
                              if( iX> 1 ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].A!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].A ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              if( jX<(qU9- 1) ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].B!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].B ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              vv.Z9X(gZ9)=iX;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].A;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                              vv.Z9e(gZ9)= Y9[aY9].D9[aD9].Z9[iZ9].e;
                              if( pU9== 3 ){
                                 vv.Z9e(gZ9)+=Y9[bY9].D9[bD9].Z9[jZ9].e;
                                 iB4=(Y9[aY9].D9[aD9].Z9[pZ9   ].B/256);
                                 jB4=(Y9[bY9].D9[bD9].Z9[lZ9- 1].A/256);
                              }else if( iX==(qU9- 1) ){
                                 vv.Z9e(gZ9)= Y9[bY9].D9[bD9].Z9[jZ9].e;
                              }
                           }else if( (aX==(qU9- 1))&&(bX== 0) ){
                              int iX=Y9[aY9].D9[aD9].Z9[iZ9].X+ 1;
                              int jX=Y9[bY9].D9[bD9].Z9[jZ9].X;
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 break;
                              }
                              if( jX> 1 ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].A!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].A ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              if( iX<(qU9- 1) ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].B!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].B ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              vv.Z9X(gZ9)=jX;
                              vv.Z9A(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].A;
                              vv.Z9B(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                              vv.Z9e(gZ9)= Y9[bY9].D9[bD9].Z9[jZ9].e;
                              if( pU9== 3 ){
                                 vv.Z9e(gZ9)+=Y9[aY9].D9[aD9].Z9[iZ9].e;
                                 jB4=(Y9[aY9].D9[aD9].Z9[pZ9   ].A/256);
                                 iB4=(Y9[bY9].D9[bD9].Z9[lZ9- 1].B/256);
                              }else if( jX==(qU9- 1) ){
                                 vv.Z9e(gZ9)= Y9[aY9].D9[aD9].Z9[iZ9].e;
                              }
                           }else if( (aX==(qU9- 1))&&(bX==(qU9- 1)) ){
                              int iX=((qU9- 1)-Y9[aY9].D9[aD9].Z9[iZ9].X);
                              int jX=Y9[bY9].D9[bD9].Z9[jZ9].X+ 1;
                              if( jX!=iX ){
                                 CONSISTENT=false;
                                 break;
                              }
                              if( iX> 1 ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].A!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].B ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              if( jX<(qU9- 1) ){
                                 if( Y9[bY9].D9[bD9].Z9[jZ9].B!=
                                     Y9[aY9].D9[aD9].Z9[iZ9].A ){
                                    CONSISTENT=false;
                                    break;
                                 }
                              }
                              vv.Z9X(gZ9)=iX;
                              vv.Z9A(gZ9)=Y9[aY9].D9[aD9].Z9[iZ9].B;
                              vv.Z9B(gZ9)=Y9[bY9].D9[bD9].Z9[jZ9].B;
                              vv.Z9e(gZ9)= Y9[aY9].D9[aD9].Z9[iZ9].e;
                              if( pU9== 3 ){
                                 vv.Z9e(gZ9)+=Y9[bY9].D9[bD9].Z9[jZ9].e;
                                 iB4=(Y9[aY9].D9[aD9].Z9[pZ9   ].A/256);
                                 jB4=(Y9[bY9].D9[bD9].Z9[lZ9- 1].A/256);
                              }else if( iX==(qU9- 1) ){
                                 vv.Z9e(gZ9)= Y9[bY9].D9[bD9].Z9[jZ9].e;
                              }
                           }
////
//                         if( pU9== 3 ){
//                            int iW4=M9[ 0].S9[gS9].B4[iB4].W4;
//                            int jW4=M9[ 0].S9[gS9].B4[jB4].W4;
//                            bool SHEET=( W4[iW4].O1> 3);
//                            if( SHEET ){
//                               bool iUP=( W4[iW4].N< 4 );
//                               bool jUP=( W4[jW4].N< 4 );
//                               if( iUP==jUP ){
//                                  CONSISTENT=false;
//                                  break;
//                               }
//                            }else{
//                               int m=W4[iW4].oJ4;
//                               int n=W4[jW4].oJ4;
//                               for(int iJ4=0;iJ4<m;iJ4++){
//                                  vv.R0sub(W4[iW4].J4[iJ4].R0,true);
//                               }
//                               int k=0;
//                               for(int jJ4=0;jJ4<n;jJ4++){
//                                  if( vv.R0sub(W4[jW4].J4[jJ4].R0) )k++;
//                               }
//                               for(int iJ4=0;iJ4<m;iJ4++){
//                                  vv.R0sub(W4[iW4].J4[iJ4].R0,false);
//                               }
//                               if( k>2 ){
//                                  CONSISTENT=false;
//                                  break;
//                               }
//                            }
//                         }
////
                        }
                        Fp+=vv.Z9e(gZ9);
                     }
                     if( !CONSISTENT )continue;
//
                     for(int gZ9= 0;gZ9<pU9;gZ9++){
                        vv.XZ9(vv.Z9X(gZ9))=gZ9;
                     }
//
//                   if( NATIVE ){
//                      out.FILE3<<"COMPATIBLE CONFIGS\n";
//                      out.FILE3<<"  Y9  D9  Y9  D9\n";
//                      out.FILE3<<std::setw( 4)<<aY9
//                               <<std::setw( 4)<<aD9
//                               <<std::setw( 4)<<bY9
//                               <<std::setw( 4)<<bD9<<'\n';
//                   }
//
//
// endpoints of elements, chain connectivity contraint
//
                     Coordinates t,u;
                     Rotation_Matrix r;
//
// t= pos of local axes for shared bod of (pU-1)-bod config a
// u=                   for                          config b
// b= local axes for shared bod of (pU-1)-bod config a
// c=            for                          config b
// r= b=r*c 
//
//// if( (aY9!=0)||(aD9!= 2)||(bY9!=1)||(bD9!=56) )continue;
                     if( IGO_SCO3_W2DOC(physics_consts,igor_data,out,
                                        jI9,
                                        aY9,aD9,bY9,bD9,
                                        pZ9,lZ9,
                                        pS9,lS9,
                                        aX,bX,
                                        vv.o_XZ9,vv.o_Z9A,vv.o_Z9B,
                                        vv.o_Z9e,Fp,
                                        t,u,r)
                         )continue;
//
//
// backbone of elements, overlap constraint
//
                     if( IGO_SCO3_WOLP(physics_consts,out,
                                       pZ9,lZ9)
                         )continue;
//
//
// remainder of backbone, calc Fh and Fm of config
//
                     double Fh( 0.00),Fm( 0.00);
                     if( IGO_SCO3_WPOL(physics_consts,igor_data,out,
                                       Fm,Fh)
                         )continue;
                     double e=( ( .35)*Fp +( .65)*Fh +Fm);
//
//
// characterization of packed config
//
                     if( e<( 0.00) )continue;
                     nD9++;
                     if( oD9<511 ){
                        I9[jI9].D9.push_back( tY9::tY9D9());
                        oD9++;
                        I9[jI9].D9[oD9].Z9.resize(pU9);
                     }else{
                        if( e<=I9[jI9].D9[oD9].e[ 0] )continue;
                     }
                     I9[jI9].D9[oD9].e[ 0]= e;
                     I9[jI9].D9[oD9].e[ 1]= Fp;
                     I9[jI9].D9[oD9].e[ 2]= Fh;
                     I9[jI9].D9[oD9].e[ 3]= Fm;
                     for(int gZ9= 0;gZ9<pU9;gZ9++){
                        I9[jI9].D9[oD9].Z9[gZ9].X=vv.Z9X(gZ9);
                        I9[jI9].D9[oD9].Z9[gZ9].e= vv.Z9e(gZ9);
                        I9[jI9].D9[oD9].Z9[gZ9].A=vv.Z9A(gZ9);
                        I9[jI9].D9[oD9].Z9[gZ9].B=vv.Z9B(gZ9);
                        int oK4=Z9[gZ9].oK4;
                        I9[jI9].D9[oD9].Z9[gZ9].K4.resize(oK4);
                        for(int iK4= 0;iK4<oK4;iK4++){
                           I9[jI9].D9[oD9].Z9[gZ9].K4[iK4].G7=
                                           Z9[gZ9].K4[iK4].G7;
                           I9[jI9].D9[oD9].Z9[gZ9].K4[iK4].X=Z9[gZ9].K4[iK4].X;
                           I9[jI9].D9[oD9].Z9[gZ9].K4[iK4].Y=Z9[gZ9].K4[iK4].Y;
                           I9[jI9].D9[oD9].Z9[gZ9].K4[iK4].sgnx=
                                           Z9[gZ9].K4[iK4].sgnx;
                           I9[jI9].D9[oD9].Z9[gZ9].K4[iK4].sgny=
                                           Z9[gZ9].K4[iK4].sgny;
                           I9[jI9].D9[oD9].Z9[gZ9].K4[iK4].u=Z9[gZ9].K4[iK4].u;
                           I9[jI9].D9[oD9].Z9[gZ9].K4[iK4].v=Z9[gZ9].K4[iK4].v;
                           I9[jI9].D9[oD9].Z9[gZ9].K4[iK4].r=Z9[gZ9].K4[iK4].r;
                        }
                        I9[jI9].D9[oD9].Z9[gZ9].c=Z9[gZ9].c;
                        I9[jI9].D9[oD9].Z9[gZ9].t=Z9[gZ9].t;
                     }
                     Coordinates t0= Z9[vv.XZ9( 0)].t;
                     Coordinates t1= Z9[vv.XZ9( 1)].t;
                     Coordinates t2= Z9[vv.XZ9(pU9- 2)].t;
                     Coordinates t3= Z9[vv.XZ9(pU9- 1)].t;
                     Coordinates r0,r1,r2,r3;
                     for(int i=0;i<3;i++){
                        r0(i)= Z9[vv.XZ9( 0)].c(i,0);
                        r1(i)= Z9[vv.XZ9( 1)].c(i,0);
                        r2(i)= Z9[vv.XZ9(pU9- 2)].c(i,0);
                        r3(i)= Z9[vv.XZ9(pU9- 1)].c(i,0);
                     }
                     Rotation_Matrix p0=transpose(Rotation_Matrix(r0));
                     Rotation_Matrix p1=transpose(Rotation_Matrix(r1));
                     Rotation_Matrix p2=transpose(Rotation_Matrix(r2));
                     Rotation_Matrix p3=transpose(Rotation_Matrix(r3));
                     double the= Z9[vv.XZ9( 1)].c(0,2);
                     double Cthe= std::cos(the);
                     double Sthe= std::sin(the);
                     Rotation_Matrix T;
                     T(0,0)= Cthe;
                     T(1,0)= Sthe;
                     T(2,0)=( 0.00);
                     T(0,1)=-Sthe;
                     T(1,1)= Cthe;
                     T(2,1)=( 0.00);
                     T(0,2)=( 0.00);
                     T(1,2)=( 0.00);
                     T(2,2)=( 1.00);
                     double dy= Z9[vv.XZ9( 1)].c(1,2);
                     double dz= Z9[vv.XZ9( 1)].c(2,2);
                     for(int i=0;i<3;i++){
                        t1(i)+=( p1(i,1)*dy +p1(i,2)*dz);
                     }
                     I9[jI9].D9[oD9].Q[ 0].r=p0;
                     I9[jI9].D9[oD9].Q[ 1].r=p1*T;
                     I9[jI9].D9[oD9].Q[ 2].r=p2;
                     I9[jI9].D9[oD9].Q[ 3].r=p3;
                     I9[jI9].D9[oD9].Q[ 0].t=t0;
                     I9[jI9].D9[oD9].Q[ 1].t=t1;
                     I9[jI9].D9[oD9].Q[ 2].t=t2;
                     I9[jI9].D9[oD9].Q[ 3].t=t3;
//
//
// maintain order
//
                     for(int jD9=oD9;jD9> 0;jD9--){
                        if( I9[jI9].D9[jD9   ].e[ 0]<=
                            I9[jI9].D9[jD9- 1].e[ 0] )break;
                        I9[jI9].D9[jD9   ].swap(
                        I9[jI9].D9[jD9- 1]);
                     }
//
                  }
               }
//
               if( NATIVE ){
                  out.FILE3<<"PAIR OF SUBSETS=(";
                  for(int jZ9= 0;jZ9<qU9;jZ9++){
                     out.FILE3<<std::setw( 2)<<U9[qU9].Y9[aY9].Z9[jZ9].S9
                              <<(( jZ9<(qU9- 1) )? ',': ')');
                  }
                  out.FILE3<<'(';
                  for(int jZ9= 0;jZ9<qU9;jZ9++){
                     out.FILE3<<std::setw( 2)<<U9[qU9].Y9[bY9].Z9[jZ9].S9
                              <<(( jZ9<(qU9- 1) )? ',': ')');
                  }
                  out.FILE3<<" PASS="<<std::setw( 7)<<nD9<<'\n';
               }
//
//
//
//
            }
         }
         oD9++;
         I9[jI9].oD9=oD9;
         if( oD9> 0 ){
            EMPTY=false;
         }else{
            continue;
         }
//
//
// diagnostic output
//
         if( NATIVE ){
            out.FILE3<<"UNION SUBSYSTEM=(";
            for(int jZ9= 0;jZ9<pU9;jZ9++){
               out.FILE3<<std::setw( 2)<<U9[pU9].Y9[jI9].Z9[jZ9].S9
                        <<(( jZ9<(pU9- 1) )? ',': ')');
            }
            out.FILE3<<'\n';
            out.FILE3<<"  I9  oD9\n";
            out.FILE3<<std::setw( 4)<<jI9
                     <<std::setw( 5)<<oD9<<'\n';
            out.FILE3<<"  D9   e       Fp    Fh     Fm  "
                       " Z9  X S9  W4  W4  C8 D   e   \n";
            out.FILE3<<std::fixed<<std::setprecision( 3);
//          if( oD9> 8 )oD9= 8;
            for(int jD9= 0;jD9<oD9;jD9++){
               for(int jZ9= 0;jZ9<pU9;jZ9++){
                  vv.XZ9(I9[jI9].D9[jD9].Z9[jZ9].X)=jZ9;
               }
               for(int jZ9= 0;jZ9<pU9;jZ9++){
                  int jS9=U9[pU9].Y9[jI9].Z9[jZ9].S9;
                  int jX=I9[jI9].D9[jD9].Z9[jZ9].X;
                  int iW4(-1),jW4(-1),iC8(-1),iD(-1);
                  if( jX<(pU9- 1) ){
                     int iZ9=vv.XZ9(jX+ 1);
                     int iS9=U9[pU9].Y9[jI9].Z9[iZ9].S9;
                     int iB4=(I9[jI9].D9[jD9].Z9[jZ9].B/256);
                     int jB4=(I9[jI9].D9[jD9].Z9[iZ9].A/256);
                     iC8=(I9[jI9].D9[jD9].Z9[jZ9].B%256)/2;
                     iD=(I9[jI9].D9[jD9].Z9[jZ9].B%2);
                     iW4=M9[ 0].S9[iS9].B4[iB4].W4;
                     jW4=M9[ 0].S9[jS9].B4[jB4].W4;
                  }
                  if( jZ9== 0 ){
                     out.FILE3<<std::setw( 4)<<jD9
                              <<std::setw( 7)<<I9[jI9].D9[jD9].e[ 0]
                              <<std::setw( 7)<<I9[jI9].D9[jD9].e[ 1]
                              <<std::setw( 7)<<I9[jI9].D9[jD9].e[ 2]
                              <<std::setw( 7)<<I9[jI9].D9[jD9].e[ 3];
                  }else{
                     out.FILE3<<"                                ";
                  }
                     out.FILE3<<std::setw( 3)<<jZ9
                              <<std::setw( 3)<<jX
                              <<std::setw( 3)<<jS9
                              <<std::setw( 4)<<jW4
                              <<std::setw( 4)<<iW4
                              <<std::setw( 4)<<iC8
                              <<std::setw( 2)<<iD
                              <<std::setw( 7)<<I9[jI9].D9[jD9].Z9[jZ9].e<<'\n';
               }
            }
         }
//
//
// backup
//
         if( ADDRESSABLE ){
            E9F9Q9(ii)=oQ9;
            Q9.push_back( tQ9());
            Q9[oQ9]=I9[jI9];
            oQ9++;
         }
      }
   }
//
//
// transfer I9 from Y9 to enable recursion
//
   Y9.clear();
   Y9.resize(oI9);
   for(int jI9= 0;jI9<oI9;jI9++){
      Y9[jI9]=I9[jI9];
   }
   oY9=oI9;
//
//
// partial config backup
//
   for(int iY9= 0;iY9<oY9;iY9++){
      if( Y9[iY9].oD9>0 ){
         U9[pU9].Y9[iY9]=Y9[iY9].D9[ 0];
      }else{
      }
   }
//
//
// factorization
//
   if( NATIVE ){
      out.FILE3<<"FACTORIZATION\n";
   }
   int oS9=M9[ 0].oS9;
   for(int pY9= 0;pY9<oY9;pY9++){
      if( !U9[pU9].Y9[pY9].STABLE )continue;
      double e= U9[pU9].Y9[pY9].e[ 0];
      double zde( 0.00);
      int aU9(-1),aY9(-1),bU9(-1),bY9(-1);
      for(int iU9= 2;iU9<=(pU9/2);iU9++){
         int jU9=(pU9-iU9);
         int iZ9= 0;
         vv.Z9Z9(iZ9)=-1;
         while( true ){
            vv.Z9Z9(iZ9)++;
            if( vv.Z9Z9(iZ9)>(jU9+iZ9) ){
               if( iZ9== 0 ){
                  break;
               }else{
                  iZ9--;
                  continue;
               }
//
            }else{
               vv.Z9S9(iZ9)=U9[pU9].Y9[pY9].Z9[vv.Z9Z9(iZ9)].S9;
               if( iZ9==(iU9- 1) ){
//
//
// indexes of iU and jU-bod subsystems
//
                  int iY9=(U9[iU9].oY9- 1);
                  int jY9=(U9[jU9].oY9- 1);
                  for(int jZ9= 0;jZ9<pU9;jZ9++){
                     vv.Z9sub(jZ9)=U9[pU9].Y9[pY9].Z9[jZ9].S9;
                  }
                  for(int jZ9= 0;jZ9<iU9;jZ9++){
                     vv.Z9sub(vv.Z9Z9(jZ9))=-1;
                     int n=(oS9- 1-vv.Z9S9(jZ9));
                     int i=(iU9-jZ9);
                     if( i>n )continue;
                     iY9-=( array_consts.FAC[n  ]/
                           (array_consts.FAC[n-i]*array_consts.FAC[i  ])
                            );
                  }
                  if( !U9[iU9].Y9[iY9].STABLE )continue;
                  int jZ9=-1;
                  for(int kZ9= 0;kZ9<pU9;kZ9++){
                     if( vv.Z9sub(kZ9)==-1 )continue;
                     jZ9++;
                     int n=(oS9- 1-vv.Z9sub(kZ9));
                     int i=(jU9-jZ9);
                     if( i>n )continue;
                     jY9-=( array_consts.FAC[n  ]/
                           (array_consts.FAC[n-i]*array_consts.FAC[i  ])
                            );
                  }
                  if( !U9[jU9].Y9[jY9].STABLE )continue;
//
//
// maintain optimal partition
//
                  double de=( ( .40)*U9[iU9].Y9[iY9].e[ 0]
                             +( .40)*U9[jU9].Y9[jY9].e[ 0]
                             -e);
                  if( de>zde ){
                     zde= de;
                     aU9=iU9;
                     aY9=iY9;
                     bU9=jU9;
                     bY9=jY9;
                  }
               }else{
                  iZ9++;
                  vv.Z9Z9(iZ9   )=vv.Z9Z9(iZ9- 1);
               }
//
            }
         }
      }
//
//
// diagnostic output
//
      if( aU9>-1 ){
         U9[pU9].Y9[pY9].STABLE=false;
         Y9[pY9].oD9=0;
         U9[aU9].Y9[aY9].FACTOR=true;
         U9[bU9].Y9[bY9].FACTOR=true;
         if( NATIVE ){
            out.FILE3<<std::fixed<<std::setprecision( 3);
            out.FILE3<<'(';
            for(int jZ9= 0;jZ9<pU9;jZ9++){
               out.FILE3<<std::setw( 2)<<U9[pU9].Y9[pY9].Z9[jZ9].S9
                        <<(( jZ9<(pU9- 1) )? ',': ')');
            }
            out.FILE3<<std::setw( 7)<<U9[pU9].Y9[pY9].e[ 0]<<"->(";
            for(int jZ9= 0;jZ9<aU9;jZ9++){
               out.FILE3<<std::setw( 2)<<U9[aU9].Y9[aY9].Z9[jZ9].S9
                        <<(( jZ9<(aU9- 1) )? ',': ')');
            }
            out.FILE3<<std::setw( 7)<<U9[aU9].Y9[aY9].e[ 0]<<'(';
            for(int jZ9= 0;jZ9<bU9;jZ9++){
               out.FILE3<<std::setw( 2)<<U9[bU9].Y9[bY9].Z9[jZ9].S9
                        <<(( jZ9<(bU9- 1) )? ',': ')');
            }
            out.FILE3<<std::setw( 7)<<U9[bU9].Y9[bY9].e[ 0]<<'\n';
         }
      }
   }
   return EMPTY;
}
