#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Config_Merge.hh"
#include "../igo/Igor_Model.hh"
#include "../igo/Target_Surf.hh"
#include "../phi/Coordinates.hh"
#include "../phi/Rotation_Matrix.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>
#include <cmath>
//
//
// dock of 2 1-bod subsystems
//
bool Igor_Model::IGO_SCO3_W1DOC(const DAT_PHYSICS_CONSTS& physics_consts,
                                const DAT_IGOR_DATA& igor_data,
                                Output_Streams& out,
                                int iW4,int jW4,int iC8,
                                double& Fp,
                                bool OPTIMIZE){
   Z9.clear();
   Z9.resize( 2);
   int iO1=W4[iW4].O1;
   int iP3=W4[iW4].P3;
   int jO1=W4[jW4].O1;
   int jP3=W4[jW4].P3;
//
//
// angle, range=[   0, 180), to z axis of bod 1 from z axis of bod 2
//
   double bet=( igor_data.O1[iO1].P3[iP3].bet
               +igor_data.O1[jO1].P3[jP3].bet)
             +( igor_data.C8[iC8].N2[ 0].the
               -igor_data.C8[iC8].N2[ 1].the);
   bet-=(floor( bet/physics_consts.PI)*physics_consts.PI);
   if      ( bet<(( .01)*physics_consts.PI) ){
      bet= (( .01)*physics_consts.PI);
   }else if( bet>(( .99)*physics_consts.PI) ){
      bet= (( .99)*physics_consts.PI);
   }
   double Cbet= std::cos( bet);
   double Sbet= std::sin( bet);
//
//
// angle, range=none, to z axis of bods 1 and 2 from z axis of pack config
//
   double nu0=( igor_data.C8[iC8].N2[ 0].the
               +igor_data.O1[iO1].P3[iP3].bet
               -( .50)*physics_consts.PI);
   double Cnu0= std::cos( nu0);
   double Snu0= std::sin( nu0);
   double nu1=( igor_data.C8[iC8].N2[ 1].the
               -igor_data.O1[jO1].P3[jP3].bet
               -( .50)*physics_consts.PI);
   double Cnu1= std::cos( nu1);
   double Snu1= std::sin( nu1);
//
//
// displacement of patch 2 wrt 1 in local coord systems of bods 1 and 2
//
   double y0=( Cnu0*igor_data.C8[iC8].dy
              +Snu0*igor_data.C8[iC8].dz)*( .50);
   double z0=(-Snu0*igor_data.C8[iC8].dy
              +Cnu0*igor_data.C8[iC8].dz)*( .50);
   double y1=(-Cnu1*igor_data.C8[iC8].dy
              -Snu1*igor_data.C8[iC8].dz)*( .50);
   double z1=(-Snu1*igor_data.C8[iC8].dy
              +Cnu1*igor_data.C8[iC8].dz)*( .50);
//
//
// 1st bod
//
   {
      const Rotation_Matrix& r=igor_data.O1[iO1].P3[iP3].C8[iC8].N2[ 0].r;
      const double& dx= igor_data.O1[iO1].P3[iP3].dx;
      int oK4=W4[iW4].oK4;
      Z9[ 0].K4.resize(oK4);
      Z9[ 0].oK4=oK4;
      if( iO1< 4 ){
         Z9[ 0].K4[ 0].G7=W4[iW4].K4[ 0].G7;
         Z9[ 0].K4[ 0].X=W4[iW4].K4[ 0].X;
         Z9[ 0].K4[ 0].Y=W4[iW4].K4[ 0].Y;
         Z9[ 0].K4[ 0].sgnx=W4[iW4].K4[ 0].sgnx;
         Z9[ 0].K4[ 0].sgny=W4[iW4].K4[ 0].sgny;
         int iG7=W4[iW4].K4[ 0].G7;
         double gam=( igor_data.O1[iO1].P3[iP3].gam
                     -y0/(4.278));
         double dz=( igor_data.O1[iO1].P3[iP3].dz
                    -z0);
//
//
// endpoints of helix in local system
//
         Coordinates u,v;
         double dR0= double( G7[iG7].mR0-W4[iW4].R0);
         double eta=( gam +dR0*physics_consts.PI/(1.80));
         double Ceta= std::cos( eta);
         double Seta= std::sin( eta);
         Rotation_Matrix c;
         c(0,0)= Ceta;
         c(1,0)= Seta;
         c(2,0)=( 0.00);
         c(0,1)=-Seta;
         c(1,1)= Ceta;
         c(2,1)=( 0.00);
         c(0,2)=( 0.00);
         c(1,2)=( 0.00);
         c(2,2)=( 1.00);
         u(0)=(-dx +(2.278)*Ceta);
         u(1)= (2.278)*Seta;
         u(2)=( dz +dR0*(1.50));
         dR0= double( G7[iG7].nR0-W4[iW4].R0);
         eta=( gam +dR0*physics_consts.PI/(1.80));
         Ceta= std::cos( eta);
         Seta= std::sin( eta);
         v(0)=(-dx +(2.278)*Ceta);
         v(1)= (2.278)*Seta;
         v(2)=( dz +dR0*(1.50));
//
//
// rotation to pack config
//
         Z9[ 0].K4[ 0].u=r*u;
         Z9[ 0].K4[ 0].v=r*v;
         Z9[ 0].K4[ 0].r=r*c;
//
//
// position and axes of helix cylinder in pack config
//
         Z9[ 0].c.zero();
         Coordinates x= transpose(r).euler();
         for(int i=0;i<3;i++){
            Z9[ 0].c(i,0)= x(i);
         }
         for(int i=0;i<3;i++){
            Z9[ 0].t(i)=-dx*r(i,0);
         }
      }else{
//
//
// angle, range=[   0, 180), of pattern axis to sheet axis
//
         double omi= igor_data.O1[iO1].P3[iP3].bet;
         omi-=(floor( omi/physics_consts.PI)*physics_consts.PI);
         if      ( omi<(( .01)*physics_consts.PI) ){
            omi= (( .01)*physics_consts.PI);
         }else if( omi>(( .99)*physics_consts.PI) ){
            omi= (( .99)*physics_consts.PI);
         }
         double Comi= std::cos( omi);
         double Somi= std::sin( omi);
//
//
// filter for productive pack
//
         double del=( omi -bet);
         if      ( bet<( omi -( .50)*physics_consts.PI) ){
            omi-=physics_consts.PI;
            del=( bet -omi);
         }else if( bet>( omi +( .50)*physics_consts.PI) ){ //left twist
            return true;
         }else if( bet<( omi +( .05)*physics_consts.PI) ){
         }else if( bet>( omi +( .45)*physics_consts.PI) ){
         }else{ //left twist
            return true;
         }
         double Cdel= std::cos( del);
         double Sdel= std::sin( del);
//
//
// sheet twist
//
         double R= ( 8.75);
         if( W4[iW4].PAR )R+=( 2.00);
         if( jO1> 3 )R+=( 2.00);
         double alp= ( 5.00)*Sdel/(R*Somi);
         double d= ( 5.00)*Cdel/Somi;
         if( d< ( .25) )return true;
//
//
// endpoints of sheet strands
//
         int iX=(W4[iW4].R0/W4[iW4].oY);
         int iY=(W4[iW4].R0%W4[iW4].oY);
         for(int iK4= 0;iK4<oK4;iK4++){
            Z9[ 0].K4[iK4].G7=W4[iW4].K4[iK4].G7;
            Z9[ 0].K4[iK4].X=W4[iW4].K4[iK4].X;
            Z9[ 0].K4[iK4].Y=W4[iW4].K4[iK4].Y;
            Z9[ 0].K4[iK4].sgnx=W4[iW4].K4[iK4].sgnx;
            Z9[ 0].K4[iK4].sgny=W4[iW4].K4[iK4].sgny;
            int iG7=W4[iW4].K4[iK4].G7;
            double i= double( W4[iW4].K4[iK4].X-iX)
                     +igor_data.O1[iO1].P3[iP3].dy/(5.)
                     -y0/(5.);
            double z= double( W4[iW4].K4[iK4].Y-iY)*(3.)
                     +igor_data.O1[iO1].P3[iP3].dz
                     -z0
                     +i*( R*alp -(5.)*Cbet)/Sbet;
            double Cialp= std::cos( i*alp);
            double Sialp= std::sin( i*alp);
            double dR0= double( G7[iG7].nR0 -G7[iG7].mR0)*(3.);
//
//
// position and direction of strand contact to packed bod cylinder
//
            Coordinates t;
            t(0)=( -dx +R*( (1.) -Cialp));
            t(1)=( i*d*Sbet +R*Cbet*Sialp);
            t(2)=( i*d*Cbet -R*Sbet*Sialp);
            Rotation_Matrix c;
            Coordinates c0,c1,c2;
            c2(0)= -Sbet*Sialp;
            c2(1)=( Cbet*Sbet*( (1.) -Cialp));
            c2(2)=( Cbet*Cbet +Sbet*Sbet*Cialp);
            c1(0)=( 0.00);
            c1(1)= Sbet;
            c1(2)= Cbet;
            double f= dot(c1,c2);
            c1-=f*c2;
            c1.normalize();
            c0=cross(c1,c2);
            for(int i=0;i<3;i++){
               c(i,0)= c0(i);
               c(i,1)= c1(i);
               c(i,2)= c2(i);
            }
//
//
// endpoints of strand in sheet local system
//
            Coordinates u,v;
            u=( t +z*c2);
            v=( u +(dR0*W4[iW4].K4[iK4].sgny)*c2);
//
//
// rotation to pack config
//
            Z9[ 0].K4[iK4].u=r*u;
            Z9[ 0].K4[iK4].v=r*v;
            Z9[ 0].K4[iK4].r=r*c;
         }
//
//
// position and axes of sheet plane in pack config
//
         Z9[ 0].c.zero();
         Coordinates x= transpose(r).euler();
         for(int i=0;i<3;i++){
            Z9[ 0].c(i,0)= x(i);
         }
         for(int i=0;i<3;i++){
            Z9[ 0].t(i)=-dx*r(i,0);
         }
      }
   }
//
//
// 2nd bod
//
   {
      const Rotation_Matrix& r=igor_data.O1[jO1].P3[jP3].C8[iC8].N2[ 1].r;
      const double& dx= igor_data.O1[jO1].P3[jP3].dx;
      int oK4=W4[jW4].oK4;
      Z9[ 1].K4.resize(oK4);
      Z9[ 1].oK4=oK4;
      if( jO1< 4 ){
         Z9[ 1].K4[ 0].G7=W4[jW4].K4[ 0].G7;
         Z9[ 1].K4[ 0].X=W4[jW4].K4[ 0].X;
         Z9[ 1].K4[ 0].Y=W4[jW4].K4[ 0].Y;
         Z9[ 1].K4[ 0].sgnx=W4[jW4].K4[ 0].sgnx;
         Z9[ 1].K4[ 0].sgny=W4[jW4].K4[ 0].sgny;
         int iG7=W4[jW4].K4[ 0].G7;
         double gam=( igor_data.O1[jO1].P3[jP3].gam
                     +y1/(4.278));
         double dz=( igor_data.O1[jO1].P3[jP3].dz
                    +z1);
//
//
// endpoints of helix in local system
//
         Coordinates u,v;
         double dR0= double( G7[iG7].mR0-W4[jW4].R0);
         double eta=( gam +dR0*physics_consts.PI/(1.80));
         double Ceta= std::cos( eta);
         double Seta= std::sin( eta);
         Rotation_Matrix c;
         c(0,0)= Ceta;
         c(1,0)= Seta;
         c(2,0)=( 0.00);
         c(0,1)=-Seta;
         c(1,1)= Ceta;
         c(2,1)=( 0.00);
         c(0,2)=( 0.00);
         c(1,2)=( 0.00);
         c(2,2)=( 1.00);
         u(0)=(-dx +(2.278)*Ceta);
         u(1)= (2.278)*Seta;
         u(2)=( dz +dR0*(1.50));
         dR0= double( G7[iG7].nR0-W4[jW4].R0);
         eta=( gam +dR0*physics_consts.PI/(1.80));
         Ceta= std::cos( eta);
         Seta= std::sin( eta);
         v(0)=(-dx +(2.278)*Ceta);
         v(1)= (2.278)*Seta;
         v(2)=( dz +dR0*(1.50));
//
//
// rotation to pack config
//
         Z9[ 1].K4[ 0].u=r*u;
         Z9[ 1].K4[ 0].v=r*v;
         Z9[ 1].K4[ 0].r=r*c;
//
//
// position and axes of helix cylinder in pack config
//
         Z9[ 1].c.zero();
         Coordinates x= transpose(r).euler();
         for(int i=0;i<3;i++){
            Z9[ 1].c(i,0)= x(i);
         }
         for(int i=0;i<3;i++){
            Z9[ 1].t(i)=-dx*r(i,0);
         }
      }else{
//
//
// angle, range=[   0, 180), of pattern axis to sheet axis
//
         double omi= igor_data.O1[jO1].P3[jP3].bet;
         omi-=(floor( omi/physics_consts.PI)*physics_consts.PI);
         if      ( omi<(( .01)*physics_consts.PI) ){
            omi= (( .01)*physics_consts.PI);
         }else if( omi>(( .99)*physics_consts.PI) ){
            omi= (( .99)*physics_consts.PI);
         }
         double Comi= std::cos( omi);
         double Somi= std::sin( omi);
//
//
// filter for productive pack
//
         double del=( omi -bet);
         if      ( bet<( omi -( .50)*physics_consts.PI) ){
            omi-=physics_consts.PI;
            del=( bet -omi);
         }else if( bet>( omi +( .50)*physics_consts.PI) ){ //left twist
            return true;
         }else if( bet<( omi +( .05)*physics_consts.PI) ){
         }else if( bet>( omi +( .45)*physics_consts.PI) ){
         }else{ //left twist
            return true;
         }
         double Cdel= std::cos( del);
         double Sdel= std::sin( del);
//
//
// sheet twist
//
         double R= ( 8.75);
         if( W4[jW4].PAR )R+=( 2.00);
         if( iO1> 3 )R+=( 2.00);
         double alp= ( 5.00)*Sdel/(R*Somi);
         double d= ( 5.00)*Cdel/Somi;
         if( d< ( .25) )return true;
//
//
// endpoints of sheet strands
//
         int iX=(W4[jW4].R0/W4[jW4].oY);
         int iY=(W4[jW4].R0%W4[jW4].oY);
         for(int jK4= 0;jK4<oK4;jK4++){
            Z9[ 1].K4[jK4].G7=W4[jW4].K4[jK4].G7;
            Z9[ 1].K4[jK4].X=W4[jW4].K4[jK4].X;
            Z9[ 1].K4[jK4].Y=W4[jW4].K4[jK4].Y;
            Z9[ 1].K4[jK4].sgnx=W4[jW4].K4[jK4].sgnx;
            Z9[ 1].K4[jK4].sgny=W4[jW4].K4[jK4].sgny;
            int iG7=W4[jW4].K4[jK4].G7;
            double i= double( W4[jW4].K4[jK4].X-iX)
                     +igor_data.O1[jO1].P3[jP3].dy/(5.)
                     +y1/(5.);
            double z= double( W4[jW4].K4[jK4].Y-iY)*(3.)
                     +igor_data.O1[jO1].P3[jP3].dz
                     +z1
                     +i*( R*alp -(5.)*Cbet)/Sbet;
            double Cialp= std::cos( i*alp);
            double Sialp= std::sin( i*alp);
            double dR0= double( G7[iG7].nR0 -G7[iG7].mR0)*(3.);
//
//
// position and direction of strand contact to packed bod cylinder
//
            Coordinates t;
            t(0)=( -dx +R*( (1.) -Cialp));
            t(1)=( i*d*Sbet +R*Cbet*Sialp);
            t(2)=( i*d*Cbet -R*Sbet*Sialp);
            Rotation_Matrix c;
            Coordinates c0,c1,c2;
            c2(0)= -Sbet*Sialp;
            c2(1)=( Cbet*Sbet*( (1.) -Cialp));
            c2(2)=( Cbet*Cbet +Sbet*Sbet*Cialp);
            c1(0)=( 0.00);
            c1(1)= Sbet;
            c1(2)= Cbet;
            double f= dot(c1,c2);
            c1-=f*c2;
            c1.normalize();
            c0=cross(c1,c2);
            for(int i=0;i<3;i++){
               c(i,0)= c0(i);
               c(i,1)= c1(i);
               c(i,2)= c2(i);
            }
//
//
// endpoints of strand in sheet local system
//
            Coordinates u,v;
            u=( t +z*c2);
            v=( u +(dR0*W4[jW4].K4[jK4].sgny)*c2);
//
//
// rotation to pack config
//
            Z9[ 1].K4[jK4].u=r*u;
            Z9[ 1].K4[jK4].v=r*v;
            Z9[ 1].K4[jK4].r=r*c;
         }
//
//
// position and axes of sheet plane in pack config
//
         Z9[ 1].c.zero();
         Coordinates x= transpose(r).euler();
         for(int i=0;i<3;i++){
            Z9[ 1].c(i,0)= x(i);
         }
         for(int i=0;i<3;i++){
            Z9[ 1].t(i)=-dx*r(i,0);
         }
      }
   }
//
//
// initiate target func surface
//
   if( OPTIMIZE ){
      int oU2=( 6*2);
      Target_Surf enq(oU2,2);
      {
         int iU2=0;
         for(int iX=0;iX<2;iX++){
            int iZ9=iX;
            enq.XU2(iX)=iU2;
            enq.XZ9(iX)=iZ9;
            for(int i=0;i<3;i++){
               enq.U2chi(iU2  +i)= Z9[iZ9].t(i);
               enq.U2chi(iU2+3+i)= Z9[iZ9].c(i,0);
               enq.U2uca(iU2  +i)= (1.00);
               enq.U2uca(iU2+3+i)= (1.00);
            }
            iU2+=6;
            enq.Xdgam(iX)= (0.00);
            enq.Xdy(iX)= (0.00);
            enq.Xdz(iX)= (0.00);
         }
         {
            double d= (0.00);
            d+=( Z9[ 0].oK4> 1 )?( 5.00):( 3.75);
            d+=( Z9[ 1].oK4> 1 )?( 5.00):( 3.75);
            enq.Xr( 0)= d;
            Coordinates zi,zj;
            double alp= Z9[ 0].c(0,0);
            double bet= Z9[ 0].c(1,0);
            double Calp= std::cos( alp);
            double Salp= std::sin( alp);
            double Cbet= std::cos( bet);
            double Sbet= std::sin( bet);
            zi(0)= Calp*Sbet;
            zi(1)= Salp*Sbet;
            zi(2)= Cbet;
            alp= Z9[ 1].c(0,0);
            bet= Z9[ 1].c(1,0);
            Calp= std::cos( alp);
            Salp= std::sin( alp);
            Cbet= std::cos( bet);
            Sbet= std::sin( bet);
            zj(0)= Calp*Sbet;
            zj(1)= Salp*Sbet;
            zj(2)= Cbet;
            double Cthe= dot(zi,zj);
            enq.Xthe( 0)= std::acos( Cthe)/physics_consts.RAD;
         }
         for(int iX=0;iX<2;iX++){
            int iZ9=iX;
            double alp= Z9[iZ9].c(0,0);
            double bet= Z9[iZ9].c(1,0);
            double gam= Z9[iZ9].c(2,0);
            Rotation_Matrix r=Rotation_Matrix(alp,bet,gam);
            Coordinates t=Z9[iZ9].t;
            int oK4=Z9[iZ9].oK4;
            for(int iK4= 0;iK4<oK4;iK4++){
               enq.XK4u(iX,iK4)=r*( Z9[iZ9].K4[iK4].u -t);
               enq.XK4v(iX,iK4)=r*( Z9[iZ9].K4[iK4].v- t);
            }
         }
      }
//
//
// initiate local minimization of target func
//
      int oM2= 256;
      Config_Merge loq(oM2,oU2);
//
//
// local minimization
//
// out.FILE3<<"________________________________________"
//            "________________________________________\n";
      loq.IGO_LOQ(physics_consts,out,enq,G7,Z9, 0);
//    loq.IGO_LOQ_WRT(physics_consts,out,enq);
////   out.FILE3<< std::fixed<< std::setprecision(3);
////   out.FILE3<<"[iW4,jW4,iC8]=["
////            << std::setw( 3)<<iW4
////            << std::setw( 3)<<jW4
////            << std::setw( 4)<<iC8<<']'
////            << std::setw( 8)<<enq.Fa
////            << std::setw( 8)<<enq.Fb
////            << std::setw( 8)<<enq.Fc
////            << std::setw( 8)<<enq.Fd
////            << std::setw( 8)<<enq.Fe
////            << std::setw( 8)<<enq.Ff
////            << std::setw( 8)<<enq.Fg<<'\n';
//
//
// update config
//
      if( enq.Ff>( 1.00) ){
//       if( NATIVE ){
//          out.FILE3<<"CHAIN CONNECTIVITY FAIL\n";
//       }
         return true;
      }
      Fp-=enq.Ff;
      if( enq.Fg>( .10) ){
         return true;
      }
      Fp-=(( 1.00)*enq.Fg);
      for(int iX=0;iX<2;iX++){
         int iZ9=iX;
         Coordinates ti,ri;
         for(int i=0;i<3;i++){
            ti(i)= Z9[iZ9].t(i);
            ri(i)= Z9[iZ9].c(i,0);
         }
         Rotation_Matrix pi=Rotation_Matrix(ri);
         Coordinates tj,rj;
         int iU2=enq.XU2(iX);
         for(int i=0;i<3;i++){
            tj(i)= enq.U2chi(iU2  +i);
            rj(i)= enq.U2chi(iU2+3+i);
         }
         Rotation_Matrix pj=Rotation_Matrix(rj);
//
         Rotation_Matrix p=transpose(pj)*pi;
         int oK4=Z9[iZ9].oK4;
         for(int iK4= 0;iK4<oK4;iK4++){
            Z9[iZ9].K4[iK4].u=( tj +p*( Z9[iZ9].K4[iK4].u -ti));
            Z9[iZ9].K4[iK4].v=( tj +p*( Z9[iZ9].K4[iK4].v -ti));
            Z9[iZ9].K4[iK4].r=p*Z9[iZ9].K4[iK4].r;
         }
         for(int i=0;i<3;i++){
            Z9[iZ9].t(i)= tj(i);
            Z9[iZ9].c(i,0)= rj(i);
         }
      }
   }else{
      Fp-=( 1.00);
   }
   return false;
}
