#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>

class MEM_igo_sco3_w1 {
private:
   std::vector<int> o_Z9E9;     //region of proto elem
   std::vector<int> o_Z9F9;     //bounds of proto elem
   std::vector<char> o_XYlnk;   //amino acids populating dock config
public:
   MEM_igo_sco3_w1(int z):
      o_Z9E9(z),
      o_Z9F9(z),
      o_XYlnk(9*8, ' ')
   {
   }
   int& Z9E9(int i){
      return o_Z9E9.at( i);  }
   int& Z9F9(int i){
      return o_Z9F9.at( i);  }
   char& XYlnk(int i,int j){
      return o_XYlnk.at( i*8 +j);  }
};

bool Igor_Model::IGO_SCO3_W1(const DAT_PHYSICS_CONSTS& physics_consts,
                             const DAT_IGOR_DATA& igor_data,
                             Output_Streams& out){
//
//
// 2-bod docking energies
//
   MEM_igo_sco3_w1 vv( 2);
   if( NATIVE ){
      out.FILE3<<"2-BOD CONFIGS\n";
   }
   oY9=U9[ 2].oY9;
   Y9.clear();
   Y9.resize(oY9);
   for(int iY9= 0;iY9<oY9;iY9++){
      Y9[iY9].oZ9=2;
//
//
// restore from backup
//
      bool ADDRESSABLE=true;
      int ii=0;
      for(int iZ9= 0;iZ9< 2&&( ADDRESSABLE);iZ9++){
         int iS9=U9[ 2].Y9[iY9].Z9[iZ9].S9;
         int oK4=M9[ 0].S9[iS9].oK4;
         if( oK4> 1 ){
            ADDRESSABLE=false;
         }else{
            int iG7=M9[ 0].S9[iS9].K4[ 0].G7;
            int iR0=G7[iG7].mR0;
            int jR0=G7[iG7].nR0;
            int ihf=R0R0hf(iR0,jR0);
            if( ihf>-1 ){
               vv.Z9E9(iZ9)=(ihf/oF9);
               vv.Z9F9(iZ9)=(ihf%oF9);
               if( iZ9> 0 ){
                  if( vv.Z9E9(iZ9   )>vv.Z9E9(iZ9- 1) ){
                     ii+=( vv.Z9F9(iZ9)<<(nF9*vv.Z9E9(iZ9)));
                  }else{
                     ADDRESSABLE=false;
                  }
               }else{
                  ii+=( vv.Z9F9(iZ9)<<(nF9*vv.Z9E9(iZ9)));
               }
            }else{
               ADDRESSABLE=false;
            }
         }
      }
      if( ADDRESSABLE ){
         int pQ9=E9F9Q9(ii);
         if( pQ9>-1 ){
            Y9[iY9]=Q9[pQ9];
            int oD9=Y9[iY9].oD9;
            for(int iZ9= 0;iZ9< 2;iZ9++){
               int iS9=U9[ 2].Y9[iY9].Z9[iZ9].S9;
               int iG7=M9[ 0].S9[iS9].K4[ 0].G7;
               for(int iD9= 0;iD9<oD9;iD9++){
                  Y9[iY9].D9[iD9].Z9[iZ9].K4[ 0].G7=iG7;
               }
            }
            continue;
         }
      }
//
//
//
//
      int iS9=U9[ 2].Y9[iY9].Z9[ 0].S9;
      int jS9=U9[ 2].Y9[iY9].Z9[ 1].S9;
      bool OPTIMIZE=false;
      {
         int oiK4=M9[ 0].S9[iS9].oK4;
         int ojK4=M9[ 0].S9[jS9].oK4;
         for(int iK4= 0;iK4<oiK4;iK4++){
            int iG7=M9[ 0].S9[iS9].K4[iK4].G7;
            for(int jK4= 0;jK4<ojK4;jK4++){
               int jG7=M9[ 0].S9[jS9].K4[jK4].G7;
               if      ( jG7==(iG7+ 2) ){
                  OPTIMIZE=true;
               }else if( jG7==(iG7- 2) ){
                  OPTIMIZE=true;
               }
            }
         }
      }
      if( NATIVE ){
         out.FILE3<<"PAIR OF BODS=("
                  <<std::setw( 2)<<iS9<<','
                  <<std::setw( 2)<<jS9<<")\n";
      }
      int oiB4=M9[ 0].S9[iS9].oB4;
      int ojB4=M9[ 0].S9[jS9].oB4;
      int oD9=-1;
//
//
// iterate over pairs of patches and elem orientation
//
//    if( NATIVE ){
//       out.FILE3<<"PATCH PAIR DOCK COMPATIBILITY\n";
//    }
      for(int iB4= 0;iB4<oiB4;iB4++){
         int iW4=M9[ 0].S9[iS9].B4[iB4].W4;
         int iO1=W4[iW4].O1;
         int iP3=W4[iW4].P3;
         int iN=W4[iW4].N;
         int m=W4[iW4].oJ4;
         int iL=W4[iW4].L;
         int oiK4=W4[iW4].oK4;
         for(int jB4= 0;jB4<ojB4;jB4++){
            int jW4=M9[ 0].S9[jS9].B4[jB4].W4;
            int jO1=W4[jW4].O1;
            int jP3=W4[jW4].P3;
            int jN=W4[jW4].N;
            int n=W4[jW4].oJ4;
            int jL=W4[jW4].L;
            int ojK4=W4[jW4].oK4;
            if( !igor_data.O1O1b(iO1,jO1) )continue;
            int iLL=igor_data.J4J4LL(m,n);
            if( iLL==-1 )continue;
            for(int iD=0;iD<2;iD++){
               int iC8min=igor_data.LL[iLL].DC8a[iD];
               int iC8max=(iC8min+igor_data.LL[iLL].DcC8[iD]);
               for(int iC8=iC8min;iC8<iC8max;iC8++){
                  int ipck=(igor_data.C8[iC8].LLe(iL,jL)-64);
                  double Fp= ( .50)*double( ipck);
//
//
// modify energy of patch crosslink
//
                  if( (m==5)&&(n==5) ){
                     if( (W4[iW4].J4[ 1].a1=='G')||
                         (W4[jW4].J4[ 1].a1=='G') ){
                        Fp+=(2.50);
                     }
                  }
                  if( Fp>( 0.00) ){
                     Fp+=double( W4[iW4].pen +W4[jW4].pen);
                  }
//
//
// endpoints of elements, chain connectivity contraint
//
                  if( IGO_SCO3_W1DOC(physics_consts,igor_data,out,
                                     iW4,jW4,iC8,
                                     Fp,
                                     OPTIMIZE)
                      )continue;
//
//
// backbone of elements, overlap constraint
//
                  int pZ9= 0;
                  int lZ9= 1;
                  if( IGO_SCO3_WOLP(physics_consts,out,
                                    pZ9,lZ9)
                      )continue;
//
//
// remainder of backbone, calc Fh and Fm of config
//
                  double Fh( 0.00),Fm( 0.00);
                  if( IGO_SCO3_WPOL(physics_consts,igor_data,out,
                                    Fm,Fh)
                      )continue;
                  double e=( ( .35)*Fp +( .65)*Fh +Fm);
//
//
// potential disulfide crosslink
//
                  for(int iJ4=0;iJ4<m;iJ4++){
                     if( W4[iW4].J4[iJ4].a1!='C' )continue;
                     for(int jJ4=0;jJ4<n;jJ4++){
                        if( W4[jW4].J4[jJ4].a1!='C' )continue;
                        int i=(igor_data.C8[iC8].N2[ 1].J4[jJ4].X
                              -igor_data.C8[iC8].N2[ 0].J4[iJ4].X);
                        int j=(igor_data.C8[iC8].N2[ 1].J4[jJ4].Y
                              -igor_data.C8[iC8].N2[ 0].J4[iJ4].Y);
                        if( ((i==-1)||(i== 1))&&
                            ((j==-1)||(j== 1)) ){
                           e+=( 16.00);
                        }
                     }
                  }
//
//
// characterization of docked config
//
                  if( oD9<255 ){
                     Y9[iY9].D9.push_back( tY9::tY9D9());
                     oD9++;
                     Y9[iY9].D9[oD9].Z9.resize( 2);
                     Y9[iY9].D9[oD9].Z9[ 0].K4.resize(oiK4);
                     Y9[iY9].D9[oD9].Z9[ 1].K4.resize(ojK4);
                  }else{
                     if( e<=Y9[iY9].D9[oD9].e[ 0] )continue;
                  }
                  Y9[iY9].D9[oD9].e[ 0]= e;
                  Y9[iY9].D9[oD9].e[ 1]= Fp;
                  Y9[iY9].D9[oD9].e[ 2]= Fh;
                  Y9[iY9].D9[oD9].e[ 3]= Fm;
                  Y9[iY9].D9[oD9].Z9[ 0].X=0;
                  Y9[iY9].D9[oD9].Z9[ 1].X=1;
                  Y9[iY9].D9[oD9].Z9[ 0].e= ( .50)*Fp;
                  Y9[iY9].D9[oD9].Z9[ 1].e= ( .50)*Fp;
                  Y9[iY9].D9[oD9].Z9[ 0].A=-1;
                  Y9[iY9].D9[oD9].Z9[ 1].A=( iB4*256 +iC8*2 +iD);
                  Y9[iY9].D9[oD9].Z9[ 0].B=( jB4*256 +iC8*2 +iD);
                  Y9[iY9].D9[oD9].Z9[ 1].B=-1;
                  for(int iZ9=0;iZ9<2;iZ9++){
                     int oK4=Z9[iZ9].oK4;
                     for(int iK4= 0;iK4<oK4;iK4++){
                        Y9[iY9].D9[oD9].Z9[iZ9].K4[iK4].G7=
                                        Z9[iZ9].K4[iK4].G7;
                        Y9[iY9].D9[oD9].Z9[iZ9].K4[iK4].X=Z9[iZ9].K4[iK4].X;
                        Y9[iY9].D9[oD9].Z9[iZ9].K4[iK4].Y=Z9[iZ9].K4[iK4].Y;
                        Y9[iY9].D9[oD9].Z9[iZ9].K4[iK4].sgnx=
                                        Z9[iZ9].K4[iK4].sgnx;
                        Y9[iY9].D9[oD9].Z9[iZ9].K4[iK4].sgny=
                                        Z9[iZ9].K4[iK4].sgny;
                        Y9[iY9].D9[oD9].Z9[iZ9].K4[iK4].u=Z9[iZ9].K4[iK4].u;
                        Y9[iY9].D9[oD9].Z9[iZ9].K4[iK4].v=Z9[iZ9].K4[iK4].v;
                        Y9[iY9].D9[oD9].Z9[iZ9].K4[iK4].r=Z9[iZ9].K4[iK4].r;
                     }
                     Y9[iY9].D9[oD9].Z9[iZ9].c=Z9[iZ9].c;
                     Y9[iY9].D9[oD9].Z9[iZ9].t=Z9[iZ9].t;
                  }
                  Coordinates r0,r1;
                  for(int i=0;i<3;i++){
                     Y9[iY9].D9[oD9].Q[ 0].t(i)= Z9[ 0].t(i);
                     r0(i)= Z9[ 0].c(i,0);
                     Y9[iY9].D9[oD9].Q[ 1].t(i)= Z9[ 1].t(i);
                     r1(i)= Z9[ 1].c(i,0);
                  }
                  Y9[iY9].D9[oD9].Q[ 0].r=transpose(Rotation_Matrix(r0));
                  Y9[iY9].D9[oD9].Q[ 1].r=transpose(Rotation_Matrix(r1));
                  Y9[iY9].D9[oD9].Q[ 2].t=Y9[iY9].D9[oD9].Q[ 0].t;
                  Y9[iY9].D9[oD9].Q[ 3].t=Y9[iY9].D9[oD9].Q[ 1].t;
                  Y9[iY9].D9[oD9].Q[ 2].r=Y9[iY9].D9[oD9].Q[ 0].r;
                  Y9[iY9].D9[oD9].Q[ 3].r=Y9[iY9].D9[oD9].Q[ 1].r;
//
//
// diagnostic output
//
//                if( NATIVE ){
//                   out.FILE3<<"  Y9  D9  W4  W4 N N O O  P  P  C8 D"
//                              "    e      Fp     Fh     Fm\n";
//                   out.FILE3<<std::fixed<<std::setprecision( 3);
//                   out.FILE3<<std::setw( 4)<<iY9
//                            <<std::setw( 4)<<oD9
//                            <<std::setw( 4)<<iW4
//                            <<std::setw( 4)<<jW4
//                            <<std::setw( 2)<<iN
//                            <<std::setw( 2)<<jN
//                            <<std::setw( 2)<<iO1
//                            <<std::setw( 2)<<jO1
//                            <<std::setw( 3)<<iP3
//                            <<std::setw( 3)<<jP3
//                            <<std::setw( 4)<<iC8
//                            <<std::setw( 2)<<iD
//                            <<std::setw( 7)<<e
//                            <<std::setw( 7)<<Fp
//                            <<std::setw( 7)<<Fh
//                            <<std::setw( 7)<<Fm<<'\n';
//                   for(int i=0;i<9;i++){
//                      for(int j=0;j<8;j++){
//                         vv.XYlnk(i,j)=' ';
//                      }
//                   }
//                   int imin=8;
//                   int imax=0;
//                   int jmin=7;
//                   int jmax=0;
//                   for(int iJ4=0;iJ4<m;iJ4++){
//                      int i=igor_data.C8[iC8].N2[ 0].J4[iJ4].X;
//                      int j=igor_data.C8[iC8].N2[ 0].J4[iJ4].Y;
//                      vv.XYlnk(i,j)=W4[iW4].J4[iJ4].a1;
//                      if( i<imin )imin=i;
//                      if( i>imax )imax=i;
//                      if( j<jmin )jmin=j;
//                      if( j>jmax )jmax=j;
//                   }
//                   for(int jJ4=0;jJ4<n;jJ4++){
//                      int i=igor_data.C8[iC8].N2[ 1].J4[jJ4].X;
//                      int j=igor_data.C8[iC8].N2[ 1].J4[jJ4].Y;
//                      vv.XYlnk(i,j)=W4[jW4].J4[jJ4].a1;
//                      if( i<imin )imin=i;
//                      if( i>imax )imax=i;
//                      if( j<jmin )jmin=j;
//                      if( j>jmax )jmax=j;
//                   }
//                   for(int j=jmax;j>=jmin;j--){
//                      for(int i=imin;i<=imax;i++){
//                         out.FILE3<<vv.XYlnk(i,j);
//                      }
//                      out.FILE3<<'\n';
//                   }
//                   out.FILE3<<" Z9 K4          u         "
//                                    "          v         \n";
//                   out.FILE3<<std::fixed<<std::setprecision( 1);
//                   for(int iZ9=0;iZ9<2;iZ9++){
//                      int oK4=Z9[iZ9].oK4;
//                      for(int iK4= 0;iK4<oK4;iK4++){
//                         out.FILE3<<std::setw( 3)<<iZ9
//                                  <<std::setw( 3)<<iK4<<'[';
//                         for(int i=0;i<3;i++){
//                            out.FILE3<<std::setw( 6)<<Z9[iZ9].K4[iK4].u(i);
//                         }
//                         out.FILE3<<"][";
//                         for(int i=0;i<3;i++){
//                            out.FILE3<<std::setw( 6)<<Z9[iZ9].K4[iK4].v(i);
//                         }
//                         out.FILE3<<"]\n";
//                      }
//                   }
//                }
//
//
// maintain order
//
                  for(int jD9=oD9;jD9> 0;jD9--){
                     if( Y9[iY9].D9[jD9   ].e[ 0]<=
                         Y9[iY9].D9[jD9- 1].e[ 0] )break;
                     Y9[iY9].D9[jD9   ].swap(
                     Y9[iY9].D9[jD9- 1]);
                  }
//
               }
            }
         }
      }
      oD9++;
      Y9[iY9].oD9=oD9;
//
//
// diagnostic output
//
      if( NATIVE ){
         out.FILE3<<"  Y9 oD9\n";
         out.FILE3<<std::setw( 4)<<iY9
                  <<std::setw( 4)<<oD9<<'\n';
         out.FILE3<<"DOCKED CONFIGS\n";
         out.FILE3<<std::fixed<<std::setprecision( 3);
         out.FILE3<<"  D9 S9[ O  P N  W4] S9[ O  P N  W4]  C8 D"
                    "    e      Fp     Fh     Fm \n";
//       if( oD9> 8 )oD9= 8;
         for(int iD9= 0;iD9<oD9;iD9++){
            int iB4=(Y9[iY9].D9[iD9].Z9[ 1].A/256);
            int jB4=(Y9[iY9].D9[iD9].Z9[ 0].B/256);
            int iW4=M9[ 0].S9[iS9].B4[iB4].W4;
            int jW4=M9[ 0].S9[jS9].B4[jB4].W4;
            int iC8=(Y9[iY9].D9[iD9].Z9[ 1].A%256)/2;
            int iD=(Y9[iY9].D9[iD9].Z9[ 1].A%2);
            out.FILE3<<std::setw( 4)<<iD9
                     <<std::setw( 3)<<iS9<<'['
                     <<std::setw( 2)<<W4[iW4].O1
                     <<std::setw( 3)<<W4[iW4].P3
                     <<std::setw( 2)<<W4[iW4].N
                     <<std::setw( 4)<<iW4<<']'
                     <<std::setw( 3)<<jS9<<'['
                     <<std::setw( 2)<<W4[jW4].O1
                     <<std::setw( 3)<<W4[jW4].P3
                     <<std::setw( 2)<<W4[jW4].N
                     <<std::setw( 4)<<jW4<<']'
                     <<std::setw( 4)<<iC8
                     <<std::setw( 2)<<iD
                     <<std::setw( 7)<<Y9[iY9].D9[iD9].e[ 0]
                     <<std::setw( 7)<<Y9[iY9].D9[iD9].e[ 1]
                     <<std::setw( 7)<<Y9[iY9].D9[iD9].e[ 2]
                     <<std::setw( 7)<<Y9[iY9].D9[iD9].e[ 3]<<'\n';
         }
      }
//
//
// backup
//
      if( ADDRESSABLE ){
         E9F9Q9(ii)=oQ9;
         Q9.push_back( tQ9());
         Q9[oQ9]=Y9[iY9];
         oQ9++;
      }
   }
//
//
// partial config backup
//
   bool EMPTY=true;
   for(int iY9= 0;iY9<oY9;iY9++){
      if( Y9[iY9].oD9>0 ){
         U9[ 2].Y9[iY9]=Y9[iY9].D9[ 0];
         EMPTY=false;
      }else{
      }
   }
   return EMPTY;
}
