#include "../dat/DAT_ARRAY_CONSTS.hh"
#include "../dat/DAT_IGOR_DATA.hh"
#include "../dat/DAT_PHYSICS_CONSTS.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <vector>
#include <iomanip>

class MEM_igo_sco3_w {
private:
   std::vector<int> o_Z9Y9;     //group of n (n-1)-bod subsystems
   std::vector<int> o_Z9S9;     //map of position in subsystem to bod
   std::vector<bool> o_S9sub;   //subset of bods
public:
   MEM_igo_sco3_w(int s):
      o_Z9Y9(s),
      o_Z9S9(s),
      o_S9sub(s, false)
   {
   }
   int& Z9Y9(int i){
      return o_Z9Y9.at( i);  }
   int& Z9S9(int i){
      return o_Z9S9.at( i);  }
   void S9sub(int i,bool a){
      o_S9sub[ i]=a;  }
   bool S9sub(int i){
      return o_S9sub[ i];  }
};

void Igor_Model::IGO_SCO3_W(const DAT_PHYSICS_CONSTS& physics_consts,
                            const DAT_ARRAY_CONSTS& array_consts,
                            const DAT_IGOR_DATA& igor_data,
                            Output_Streams& out){
//
//
// pairs of bods
//
   int oS9=M9[ 0].oS9;
   oU9=(oS9+ 1);
   U9.clear();
   U9.resize(oU9);
   pU9=2;
   oY9=oS9*(oS9- 1)/2;
   U9[pU9].Y9.resize(oY9);
   int iY9=0;
   for(int iS9= 0;iS9<(oS9- 1);iS9++){
      for(int jS9=(iS9+ 1);jS9<oS9;jS9++){
         U9[pU9].Y9[iY9].Z9.resize( 2);
         U9[pU9].Y9[iY9].Z9[ 0].S9=iS9;
         U9[pU9].Y9[iY9].Z9[ 1].S9=jS9;
         U9[pU9].Y9[iY9].STABLE=false;
         U9[pU9].Y9[iY9].FACTOR=false;
         iY9++;
      }
   }
   U9[pU9].oY9=iY9;
//
//
// 2-bod docking energies
//
   bool EMPTY=IGO_SCO3_W1(physics_consts,igor_data,out);
   if( EMPTY ){
      SCORE3b= (0.00);
      SCORE3c= (0.00);
      oU9=0;
      oT9=0;
      return;
   }
//
//
// recursive growth of subsystems from (pU-1)-bod to pU-bod
//
   MEM_igo_sco3_w vv(oS9);
   for(int iU9= 3;iU9<oU9;iU9++){
      pU9=iU9;
      int qU9=(pU9- 1);
      int jI9=0;
      int iZ9=0;
      vv.Z9Y9(iZ9)=-1;
      while( true ){
         vv.Z9Y9(iZ9)++;
         if( vv.Z9Y9(iZ9)>(U9[qU9].oY9-pU9+iZ9) ){
            if( iZ9== 0 ){
               break;
            }else{
               iZ9--;
               continue;
            }
//
         }else{
            if      ( iZ9== 1 ){
               int n=0;
               for(int aZ9= 0;aZ9<qU9;aZ9++){
                  for(int bZ9= 0;bZ9<qU9;bZ9++){
                     if( U9[qU9].Y9[vv.Z9Y9( 1)].Z9[bZ9].S9==
                         U9[qU9].Y9[vv.Z9Y9( 0)].Z9[aZ9].S9 )n++;
                  }
               }
               if( n<(qU9- 1) )continue;
               int pZ9=-1;
               for(int aZ9= 0;aZ9<qU9;aZ9++){
                  bool MATCH=false;
                  for(int bZ9= 0;bZ9<qU9&&(!MATCH);bZ9++){
                     if( U9[qU9].Y9[vv.Z9Y9( 1)].Z9[bZ9].S9==
                         U9[qU9].Y9[vv.Z9Y9( 0)].Z9[aZ9].S9 )MATCH=true;
                  }
                  if( !MATCH ){
                     pZ9=aZ9;
                     break;
                  }
               }
               if( pZ9<(qU9- 1) )continue;
               U9[pU9].Y9.push_back( tU9::tU9Y9());
               for(int aZ9= 0;aZ9<qU9;aZ9++){
                  vv.Z9S9(aZ9)=U9[qU9].Y9[vv.Z9Y9( 0)].Z9[aZ9].S9;
               }
               vv.Z9S9(qU9)=U9[qU9].Y9[vv.Z9Y9( 1)].Z9[qU9- 1].S9;
//             {
//                out.FILE3<<"SUBSET OF BODS=("
//                for(int jZ9= 0;jZ9<pU9;jZ9++){
//                   out.FILE3<<std::setw( 2)<<vv.Z9S9(jZ9)
//                            <<(( jZ9<qU9 )? ',': ')');
//                }
//                out.FILE3<<'\n';
//             }
            }else if( iZ9> 1 ){
               bool INGROUP=true;
               for(int aZ9= 0;aZ9<qU9&&( INGROUP);aZ9++){
                  bool MATCH=false;
                  for(int jZ9= 0;jZ9<pU9&&(!MATCH);jZ9++){
                     if( vv.Z9S9(jZ9)==
                         U9[qU9].Y9[vv.Z9Y9(iZ9)].Z9[aZ9].S9 )MATCH=true;
                  }
                  if( !MATCH )INGROUP=false;
               }
               if( !INGROUP )continue;
            }
            if( iZ9==(pU9- 1) ){
//             {
//                out.FILE3<<"SEQUENCE OF "
//                         <<std::setw( 2)<<qU9
//                         <<"-BOD SUBSYSTEMS=(";
//                for(int jZ9= 0;jZ9<pU9;jZ9++){
//                   out.FILE3<<std::setw( 4)<<vv.Z9Y9(jZ9)
//                            <<(( jZ9<qU9 )? ',': ')');
//                }
//                out.FILE3<<'\n';
//             }
               U9[pU9].Y9[jI9].Z9.resize(pU9);
               for(int jZ9= 0;jZ9<pU9;jZ9++){
                  U9[pU9].Y9[jI9].Z9[jZ9].S9=vv.Z9S9(jZ9);
                  U9[pU9].Y9[jI9].Z9[jZ9].Y9=vv.Z9Y9(jZ9);
               }
               U9[pU9].Y9[jI9].STABLE=false;
               U9[pU9].Y9[jI9].FACTOR=false;
               jI9++;
            }else{
               iZ9++;
               vv.Z9Y9(iZ9)=vv.Z9Y9(iZ9- 1);
            }
//
         }
      }
      U9[pU9].oY9=jI9;
//
//
// pU-bod packing energies
//
      EMPTY=IGO_SCO3_W2(physics_consts,array_consts,igor_data,out);
//
//
// condition for continued recursion
//
      if( EMPTY ){
         pU9--;
         break;
      }
   }
//
//
// a full config is optimal
//
   oY9=U9[pU9].oY9;
   for(int iY9= 0;iY9<oY9;iY9++){
      if( U9[pU9].Y9[iY9].STABLE ){
         U9[pU9].Y9[iY9].FACTOR=true;
      }
   }
//
//
// remove non-factor sub configs
//
   for(int iU9= 2;iU9<=pU9;iU9++){
      oY9=U9[iU9].oY9;
      for(int iY9= 0;iY9<oY9;iY9++){
         if( !U9[iU9].Y9[iY9].FACTOR ){
            U9[iU9].Y9[iY9].STABLE=false;
         }
      }
   }
//
//
// order factor sub configs
//
   T9.clear();
   oT9=0;
   for(int iU9=pU9;iU9>=2;iU9--){
      oY9=U9[iU9].oY9;
      for(int iY9= 0;iY9<oY9;iY9++){
         if( !U9[iU9].Y9[iY9].STABLE )continue;
         T9.push_back( tT9());
         for(int i=0;i<4;i++){
            T9[oT9].e[ i]= U9[iU9].Y9[iY9].e[ i];
         }
         T9[oT9].U9=iU9;
         T9[oT9].Y9=iY9;
         oT9++;
      }
   }
   for(int jT9max=(oT9-1);jT9max> 0;jT9max--){
      bool ORDERED=true;
      double e1= T9[ 0].e[ 0];
      for(int jT9= 1;jT9<=jT9max;jT9++){
         double e2= T9[jT9].e[ 0];
         if( e2>e1 ){
            T9[jT9  ].swap(
            T9[jT9-1]);
            ORDERED=false;
         }else{
            e1=e2;
         }
      }
      if( ORDERED )break;
   }
//
//
// optimize partition
//
   double Fp( 0.00),Fh( 0.00),Fm( 0.00);
   double z= ( 0.00);
   for(int iT9= 0;iT9<oT9;iT9++){
      int iU9=T9[iT9].U9;
      int iY9=T9[iT9].Y9;
      bool DISJOINT=true;
      for(int iZ9= 0;iZ9<iU9&&( DISJOINT);iZ9++){
         int iS9=U9[iU9].Y9[iY9].Z9[iZ9].S9;
         if( vv.S9sub(iS9) )DISJOINT=false;
      }
      if( DISJOINT ){
         for(int iZ9= 0;iZ9<iU9;iZ9++){
            int iS9=U9[iU9].Y9[iY9].Z9[iZ9].S9;
            vv.S9sub(iS9,true);
         }
         Fp+=U9[iU9].Y9[iY9].e[ 1];
         Fh+=U9[iU9].Y9[iY9].e[ 2];
         Fm+=U9[iU9].Y9[iY9].e[ 3];
         T9[iT9].sub=true;
         z+=( 1.00);
      }else{
         T9[iT9].sub=false;
      }
   }
   Fp/=z;
   Fh/=z;
   Fm/=z;
//
//
// func value
//
   if( oT9> 0 ){
      SCORE3b=( ( .35)*Fp +( .65)*Fh);
      SCORE3c= Fm;
   }else{
      SCORE3b= (0.00);
      SCORE3c= (0.00);
   }
//
//
// diagnostic output
//
   if( NATIVE ){
      out.FILE3<<"oS9\n";
      out.FILE3<<std::setw( 3)<<oS9<<'\n';
      out.FILE3<<U9;
      out.FILE3<<T9;
      out.FILE3<<"ENERGY OF PACKING BODS\n";
      out.FILE3<<std::setprecision( 3);
      out.FILE3<<std::setw( 7)<<( ( .35)*Fp +( .65)*Fh +Fm)<<'\n';
   }
   return;
}
