#include "../dat/DAT_IGOR_DATA.hh"
#include "../igo/Igor_Model.hh"
#include <vector>

class MEM_igo_sco3_optw {
private:
   std::vector<int> o_O1hp;             //most hydrophob patch for twist
   std::vector<int> o_O1P3;             //pattern
   std::vector<int> o_O1R0;             //start of enclosing res subset
   std::vector<int> o_O1alt;            //alt surf over patch
   int oR0;                             //
   std::vector<bool> o_O1R0sub;         //included in patch for twist
public:
   MEM_igo_sco3_optw(int o,int r):
      o_O1hp(o, -9),
      o_O1P3(o, -1),
      o_O1R0(o, -1),
      o_O1alt(o, -1),
      oR0(r),
      o_O1R0sub(o*r, false)
   {
   }
   int& O1hp(int i){
      return o_O1hp.at( i);  }
   int& O1P3(int i){
      return o_O1P3.at( i);  }
   int& O1R0(int i){
      return o_O1R0.at( i);  }
   int& O1alt(int i){
      return o_O1alt.at( i);  }
   void O1R0sub(int i,int j,bool a){
      o_O1R0sub[ i*oR0 +j]=a;  }
   bool O1R0sub(int i,int j){
      return o_O1R0sub[ i*oR0 +j];  }
};

void Igor_Model::IGO_SCO3_OPTW(const DAT_IGOR_DATA& igor_data,
                               int iM8,int iU8,int iY8,
                               int lX,int uX,int lY,int uY,
                               int lYup,int sgn,int upen){
//
//
// for each twist, find optimal hydrophobic patches
//
   MEM_igo_sco3_optw vv(  8,oR0);
   for(int iTER=0;iTER<4;iTER++){
      int iXmin=lX;
      int iYmin=lYup;
      for(int iO1= 4;iO1< 8;iO1++){
         int oP3=igor_data.O1[iO1].oP3;
         for(int iP3= 0;iP3<oP3;iP3++){
            int oR4=igor_data.O1[iO1].P3[iP3].oR4;
            int pX=((oR4- 1)/5);
            int pY=((oR4- 1)%5)*2;
            int iXmax=(uX-pX);
            int iYmax=(uY-pY);
            for(int iX=iXmin;iX<=iXmax;iX++){
               for(int iY=iYmin;iY<=iYmax;iY+=2){
                  int ihp=0;
                  int ialt=0;
                  int nJ4=0;
                  int n=0;
                  for(int iZ8= 0;iZ8<iU8;iZ8++){
                     int iS8=U8[iU8].Y8[iY8].Z8[iZ8].S8;
                     int iG7=M8[iM8].S8[iS8].G7;
                     int mR0=G7[iG7].mR0;
                     int nR0=G7[iG7].nR0;
                     for(int iR0=mR0;iR0<=nR0;iR0++){
                        int jR0=(iR0-mR0);
                        if( Z8[iZ8].R0[jR0].sgnx
                           *Z8[iZ8].R0[jR0].sgny==sgn ){
                           int gX=Z8[iZ8].R0[jR0].X*sgn;
                           int gY=Z8[iZ8].R0[jR0].Y;
                           if( gX<iX )continue;
                           if( gX>(iX+pX) )continue;
                           if( gY<iY )continue;
                           if( gY>(iY+pY) )continue;
                           int i=(gX-iX);
                           int j=((gY-iY)/2);
                           int iR4=( i*5 +j);
                           int iJ4=igor_data.O1[iO1].P3[iP3].R4J4[iR4];
                           if( iJ4>-1 ){
                              int iL1=R0[iR0].L1;
                              ihp+=igor_data.L1[iL1].doc;
                              i=igor_data.L1[iL1].alt;
                              if( i<0 )i=0;
                              j=(iJ4*2);
                              ialt+=(i<<j);
                              nJ4++;
                              if( vv.O1R0sub(iO1,iR0) )n++;
                           }
                        }
                     }
                  }
                  if( nJ4<igor_data.O1[iO1].P3[iP3].oJ4 )continue;
                  if( n>(igor_data.O1[iO1].P3[iP3].oJ4-2) )continue;
                  if( ihp>vv.O1hp(iO1) ){
                     vv.O1hp(iO1)=ihp;
                     vv.O1P3(iO1)=iP3;
                     vv.O1R0(iO1)=( (iX-lX)*(uY-lY+ 1) +(iY-lY));
                     vv.O1alt(iO1)=ialt;
                  }
               }
            }
         }
         if( vv.O1hp(iO1)< 5 )continue;
//
         int iP3=vv.O1P3(iO1);
         int ialt=vv.O1alt(iO1);
         int oJ4=igor_data.O1[iO1].P3[iP3].oJ4;
         int iL=0;
         int fac=1;
         for(int i=0;i<oJ4;i++){
            iL+=(ialt% 4)*fac;
            ialt>>=2;
            fac*=3;
         }
//
         W4.push_back( tW4());
         W4[oW4].N=iTER+(1-sgn)*2;
         W4[oW4].J4.resize(oJ4);
         W4[oW4].oJ4=oJ4;
         W4[oW4].K4.resize(iU8);
         W4[oW4].oK4=iU8;
         int oR4=igor_data.O1[iO1].P3[iP3].oR4;
         int pX=((oR4- 1)/5);
         int pY=((oR4- 1)%5)*2;
         int iX=( lX +(vv.O1R0(iO1)/(uY-lY+ 1)));
         int iY=( lY +(vv.O1R0(iO1)%(uY-lY+ 1)));
         for(int iZ8= 0;iZ8<iU8;iZ8++){
            int iS8=U8[iU8].Y8[iY8].Z8[iZ8].S8;
            int iG7=M8[iM8].S8[iS8].G7;
            int mR0=G7[iG7].mR0;
            int nR0=G7[iG7].nR0;
            for(int iR0=mR0;iR0<=nR0;iR0++){
               int jR0=(iR0-mR0);
               if( Z8[iZ8].R0[jR0].sgnx
                  *Z8[iZ8].R0[jR0].sgny==sgn ){
                  int gX=Z8[iZ8].R0[jR0].X*sgn;
                  int gY=Z8[iZ8].R0[jR0].Y;
                  if( gX<iX )continue;
                  if( gX>(iX+pX) )continue;
                  if( gY<iY )continue;
                  if( gY>(iY+pY) )continue;
                  int i=(gX-iX);
                  int j=((gY-iY)/2);
                  int iR4=( i*5 +j);
                  int iJ4=igor_data.O1[iO1].P3[iP3].R4J4[iR4];
                  if( iJ4>-1 ){
                     W4[oW4].J4[iJ4].R0=iR0;
                     W4[oW4].J4[iJ4].a1=igor_data.L1[ R0[iR0].L1].a1;
                     vv.O1R0sub(iO1,iR0,true);
                  }
               }
            }
            W4[oW4].K4[iZ8].G7=iG7;
            W4[oW4].K4[iZ8].X=(Z8[iZ8].R0[ 0].X*sgn-lX);
            W4[oW4].K4[iZ8].Y=(Z8[iZ8].R0[ 0].Y-lY);
            W4[oW4].K4[iZ8].sgnx=Z8[iZ8].R0[ 0].sgnx*sgn;
            W4[oW4].K4[iZ8].sgny=Z8[iZ8].R0[ 0].sgny;
         }
         W4[oW4].O1=iO1;
         W4[oW4].hp=vv.O1hp(iO1);
         W4[oW4].P3=vv.O1P3(iO1);
         W4[oW4].R0=vv.O1R0(iO1);
         W4[oW4].L=iL;
         W4[oW4].h= h*double( sgn);
         W4[oW4].PAR=PARALLEL;
         W4[oW4].oX=(uX-lX+ 1);
         W4[oW4].oY=(uY-lY+ 1);
         W4[oW4].pen=upen;
         oW4++;
//
         vv.O1hp(iO1)=-9;
         vv.O1P3(iO1)=-1;
         vv.O1R0(iO1)=-1;
         vv.O1alt(iO1)=-1;
      }
   }
   return;
}
