#include "../dat/DAT_IGOR_DATA.hh"
#include "../igo/Igor_Model.hh"
#include "../str/Output_Streams.hh"
#include <iomanip>

void Igor_Model::IGO_SCO3_OPTV(const DAT_IGOR_DATA& igor_data,
                               Output_Streams& out,
                               int iM8,int iU8,int iY8,
                               int lX,int uX,int lY,int uY){
//
//
// visualize sheet
//
   V8.push_back( tV8());
   V8[oV8].lX=(lX- 1);
   V8[oV8].uX=uX;
   V8[oV8].lY=lY;
   V8[oV8].uY=uY;
   V8[oV8].o_X.resize((uX-lX+ 2));
   V8[oV8].o_XY.resize((uX-lX+ 2)*(uY-lY+ 1));
   if( NATIVE ){
      out.FILE3<<"   h   \n";
      out.FILE3<<std::fixed<<std::setprecision( 3);
      out.FILE3<<std::setw( 7)<<h<<'\n';
   }
   for(int iZ8= 0;iZ8<iU8;iZ8++){
      int iX=Z8[iZ8].R0[ 0].X;
      int iS8=U8[iU8].Y8[iY8].Z8[iZ8].S8;
      int iG7=M8[iM8].S8[iS8].G7;
      int mR0=G7[iG7].mR0;
      int nR0=G7[iG7].nR0;
      for(int iR0=mR0;iR0<=nR0;iR0++){
         int jR0=(iR0-mR0);
         char a1=igor_data.L1[ R0[iR0].L1].a1;
         int iY=Z8[iZ8].R0[jR0].Y;
         V8[oV8].XY(iX,iY).alp[0]=a1;
         if( Z8[iZ8].R0[jR0].sgnx== 1 ){
            V8[oV8].XY(iX,iY).alp[1]='=';
         }else{
            V8[oV8].XY(iX,iY).alp[1]=' ';
            if( iX==lX ){
               V8[oV8].XY(iX- 1,iY).alp[1]='=';
            }
         }
      }
      char a1=( iS8<10 )? ' ': '1';
      char a0=char('0'+(iS8%10));
      V8[oV8].X(iX).head0[0]=a1;
      V8[oV8].X(iX).head0[1]=a0;
      if( Z8[iZ8].R0[ 0].sgny== 1 ){
         V8[oV8].X(iX).head2="__";
      }else{
         V8[oV8].X(iX).head1="__";
      }
   }
   if( NATIVE ){
      out.FILE3<<"SHEET CONFIG\n";
      for(int iX=(lX- 1);iX<=uX;iX++){
         out.FILE3<<V8[oV8].X(iX).head0;
      }
      out.FILE3<<'\n';
      for(int iX=(lX- 1);iX<=uX;iX++){
         out.FILE3<<V8[oV8].X(iX).head1;
      }
      out.FILE3<<'\n';
      for(int iY=uY;iY>=lY;iY--){
         for(int iX=(lX- 1);iX<=uX;iX++){
            out.FILE3<<V8[oV8].XY(iX,iY).alp;
         }
         out.FILE3<<'\n';
      }
      for(int iX=(lX- 1);iX<=uX;iX++){
         out.FILE3<<V8[oV8].X(iX).head2;
      }
      out.FILE3<<'\n';
   }
   return;
}
